/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlpull.lib.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReaderFactory;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriter;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriterFactory;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;
import org.gvsig.xmlpull.lib.impl.CreateXmlStreamReaderException;
import org.gvsig.xmlpull.lib.impl.CreateXmlStreamWriterException;
import org.gvsig.xmlpull.lib.spi.XmlPullProviderManager;

public class DefaultXmlPullProviderManager
implements XmlPullProviderManager {
    private List xmlStreamReaderFactories = Collections.synchronizedList(new ArrayList());
    private List xmlStreamWriterFactories = Collections.synchronizedList(new ArrayList());

    public IXmlStreamReader createStreamReader(String mimeType, InputStream is) {
        for (IXmlStreamReaderFactory xmlStreamReaderFactory : this.xmlStreamReaderFactories) {
            if (!xmlStreamReaderFactory.canParse(mimeType)) continue;
            try {
                return xmlStreamReaderFactory.createParser(mimeType, is);
            }
            catch (Exception e) {
                throw new CreateXmlStreamReaderException(mimeType, e);
            }
        }
        throw new IllegalArgumentException("There is not a XMLStreamReader for the mimetype " + mimeType);
    }

    public void registerXMLStreamReaderFactory(IXmlStreamReaderFactory xmlStreamReaderFactory) {
        this.xmlStreamReaderFactories.add(xmlStreamReaderFactory);
    }

    public IXmlStreamWriter createStreamWriter(String mimeType, OutputStream os) throws XmlStreamException, IllegalArgumentException {
        for (IXmlStreamWriterFactory xmlStreamWriterFactory : this.xmlStreamWriterFactories) {
            if (!xmlStreamWriterFactory.canWrite(mimeType)) continue;
            try {
                return xmlStreamWriterFactory.createWriter(mimeType, os);
            }
            catch (Exception e) {
                throw new CreateXmlStreamWriterException(mimeType, e);
            }
        }
        throw new IllegalArgumentException("There is not a XMLStreamWriter for the mimetype " + mimeType);
    }

    public void registerXMLStreamWriterFactory(IXmlStreamWriterFactory xmlStreamWriterFactory) {
        this.xmlStreamWriterFactories.add(xmlStreamWriterFactory);
    }
}

