/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.taskplanning.retrieving;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.TreeMap;
import org.gvsig.remoteclient.taskplanning.IQueue;
import org.gvsig.remoteclient.taskplanning.retrieving.RetrieveEvent;
import org.gvsig.remoteclient.taskplanning.retrieving.RetrieveListener;
import org.gvsig.remoteclient.taskplanning.retrieving.RetrieveQueue;
import org.gvsig.remoteclient.taskplanning.retrieving.URLRequest;
import org.gvsig.remoteclient.taskplanning.retrieving.URLRetrieveTask;

public class RequestManager {
    private boolean debug = true;
    private static RequestManager instance;
    private TreeMap serversTable = new TreeMap();
    private Hashtable downloadedFiles;
    private final String tempDirectoryPath = System.getProperty("java.io.tmpdir") + "tmp-andami";

    private RequestManager() {
    }

    public static RequestManager getInstance() {
        if (instance == null) {
            instance = new RequestManager();
        }
        return instance;
    }

    public URLRetrieveTask addURLRequest(URLRequest request, RetrieveListener listener) {
        block9: {
            try {
                String fileNamePrefix;
                File f = this.getPreviousDownloadedURLRequest(request);
                if (f != null) {
                    request.setFileName(f.getAbsolutePath());
                    System.out.println(request.getUrl() + " is cached at '" + f.getAbsolutePath() + "'");
                    RetrieveQueue serverQueue = (RetrieveQueue)this.getQueue(request.getHost());
                    URLRetrieveTask workingTask = serverQueue.getURLPreviousRequest(request);
                    if (workingTask == null) {
                        if (this.debug) {
                            System.err.println("done job found: " + request.getUrl());
                        }
                        RetrieveEvent event = new RetrieveEvent();
                        event.setType(3);
                        listener.transferEventReceived(event);
                    } else {
                        if (this.debug) {
                            System.err.println("working job found: " + request.getUrl());
                        }
                        workingTask.addRetrieveListener(listener);
                    }
                    break block9;
                }
                String host = request.getHost();
                String fileName = request.getFileName();
                File tempDir = new File(this.tempDirectoryPath);
                if (!tempDir.exists()) {
                    tempDir.mkdir();
                }
                if (fileName.startsWith(fileNamePrefix = this.tempDirectoryPath + File.separator + host + "-")) {
                    fileName = fileName.substring(fileNamePrefix.length(), fileName.length());
                }
                RetrieveQueue serverQueue = (RetrieveQueue)this.getQueue(request.getHost());
                fileName = fileNamePrefix + fileName;
                request.setFileName(fileName);
                URLRetrieveTask task = new URLRetrieveTask(request, listener);
                return (URLRetrieveTask)serverQueue.put(task);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private IQueue getQueue(String hostName) {
        RetrieveQueue queue = null;
        queue = this.serversTable.containsKey(hostName) ? (RetrieveQueue)this.serversTable.get(hostName) : new RetrieveQueue(hostName);
        return queue;
    }

    public void removeURLRequest(URLRequest request) {
        if (this.downloadedFiles != null && this.downloadedFiles.containsKey(request)) {
            this.downloadedFiles.remove(request);
        }
    }

    protected void addDownloadedURLRequest(URLRequest request, String filePath) {
        File f;
        String fileName;
        if (this.downloadedFiles == null) {
            this.downloadedFiles = new Hashtable();
        }
        if ((fileName = this.downloadedFiles.put(request, filePath)) != null && (f = new File(fileName)).exists()) {
            f.delete();
        }
    }

    private File getPreviousDownloadedURLRequest(URLRequest request) {
        File f = null;
        if (this.downloadedFiles != null && this.downloadedFiles.containsKey(request)) {
            String filePath = (String)this.downloadedFiles.get(request);
            f = new File(filePath);
        }
        return f;
    }
}

