/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class PropertyManager {
    public static final String LOGGER_PROPERTIES = "org/gvsig/remoteClient/conf/logger.properties";
    private static final String[] s_propertyFileNames = new String[]{"org/gvsig/remoteClient/conf/logger.properties"};
    private static Hashtable s_propertyFiles = null;

    public static Properties getProperties(String propertyFileName) throws IOException {
        if (s_propertyFiles == null) {
            PropertyManager.loadProperties();
        }
        return (Properties)s_propertyFiles.get(propertyFileName);
    }

    private static synchronized void loadProperties() throws IOException {
        s_propertyFiles = new Hashtable(s_propertyFileNames.length);
        ClassLoader loader = PropertyManager.class.getClassLoader();
        for (int i = 0; i < s_propertyFileNames.length; ++i) {
            try {
                InputStream input = loader.getResourceAsStream(s_propertyFileNames[i]);
                Properties props = new Properties();
                props.load(input);
                s_propertyFiles.put(s_propertyFileNames[i], props);
                continue;
            }
            catch (Exception e) {
                System.err.println("\n[PropertyManager] ERROR - Failed to read properties file \"" + s_propertyFileNames[i] + "\": " + e.getMessage());
            }
        }
    }
}

