/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coordinatecalculator;

import java.awt.geom.Point2D;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.coordinatecalculator.CoordinateCalculatorView;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class CoordinateCalculator
extends CoordinateCalculatorView {
    private static final String DEGREES_FORMAT = "%-%d\u00b0 %m\u2032 %.2s\u2033";
    private static final String DECIMAL_LABEL = "_Decimal";
    private static final int DECIMAL_VALUE = 0;
    private static final String DMS_LABEL = "_Degrees_minutes_and_seconds";
    private static final int DMS_VALUE = 1;
    private ProjectionPickerController sourcePicker;
    private ProjectionPickerController targetPicker;

    public CoordinateCalculator() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.sourcePicker = dataSwingManager.createProjectionPickerController(this.txtSourceProjection, this.btnSourceProjection);
        this.targetPicker = dataSwingManager.createProjectionPickerController(this.txtTargetProjection, this.btnTargetProjection);
        this.sourcePicker.addChangeListener(e -> this.doChangeSource());
        this.targetPicker.addChangeListener(e -> this.doChangeTarget());
        this.cboSourceFormat.addItemListener(e -> this.doChangeSourceFormat());
        this.cboTargetFormat.addItemListener(e -> this.doChangeTargetFormat());
        this.cboSourceFormat.setModel(this.createFormatComboModel());
        this.cboTargetFormat.setModel(this.createFormatComboModel());
        this.txtSourceX.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CoordinateCalculator.this.doChangeSourceCoordinates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CoordinateCalculator.this.doChangeSourceCoordinates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CoordinateCalculator.this.doChangeSourceCoordinates();
            }
        });
        this.txtSourceY.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CoordinateCalculator.this.doChangeSourceCoordinates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CoordinateCalculator.this.doChangeSourceCoordinates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CoordinateCalculator.this.doChangeSourceCoordinates();
            }
        });
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.addClearButton((JTextComponent)this.txtSourceX);
        toolsSwingManager.addClearButton((JTextComponent)this.txtSourceY);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtSourceX);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtSourceY);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtTargetX);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtTargetY);
        this.btnCalculate.addActionListener(e -> this.doCalculate());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)9, (int)80);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblSource);
        swingManager.translate(this.lblSourceFormat);
        swingManager.translate(this.lblSourceX);
        swingManager.translate(this.lblSourceY);
        swingManager.translate(this.lblTarget);
        swingManager.translate(this.lblTargetFormat);
        swingManager.translate(this.lblTargetX);
        swingManager.translate(this.lblTargetY);
        swingManager.translate((AbstractButton)this.btnCalculate);
    }

    private ICoordTrans getTransform() {
        IProjection source = (IProjection)this.sourcePicker.get();
        if (source == null) {
            return null;
        }
        IProjection target = (IProjection)this.targetPicker.get();
        if (target == null) {
            return null;
        }
        return source.getCT(target);
    }

    private void doChangeSource() {
        IProjection source = (IProjection)this.sourcePicker.get();
        if (source == null) {
            return;
        }
        if (source.isProjected()) {
            ComboBoxModel model = this.cboSourceFormat.getModel();
            model.setSelectedItem(model.getElementAt(0));
            this.cboSourceFormat.setEnabled(false);
        } else {
            ComboBoxModel model = this.cboSourceFormat.getModel();
            model.setSelectedItem(model.getElementAt(1));
            this.cboSourceFormat.setEnabled(true);
        }
    }

    private void doChangeTarget() {
        IProjection target = (IProjection)this.targetPicker.get();
        if (target == null) {
            return;
        }
        if (target.isProjected()) {
            ComboBoxModel model = this.cboTargetFormat.getModel();
            model.setSelectedItem(model.getElementAt(0));
            this.cboTargetFormat.setEnabled(false);
        } else {
            ComboBoxModel model = this.cboTargetFormat.getModel();
            model.setSelectedItem(model.getElementAt(1));
            this.cboTargetFormat.setEnabled(true);
        }
    }

    private void doChangeSourceFormat() {
        LabeledValue sourceFormat = (LabeledValue)this.cboTargetFormat.getSelectedItem();
        this.txtTargetX.setText("");
        this.txtTargetY.setText("");
    }

    private void doChangeTargetFormat() {
        this.txtTargetX.setText("");
        this.txtTargetY.setText("");
    }

    private void doChangeSourceCoordinates() {
        this.txtTargetX.setText("");
        this.txtTargetY.setText("");
    }

    private ComboBoxModel createFormatComboModel() {
        I18nManager I18n = ToolsLocator.getI18nManager();
        DefaultComboBoxModel<LabeledValueImpl> formatsComboModel = new DefaultComboBoxModel<LabeledValueImpl>();
        formatsComboModel.addElement(new LabeledValueImpl(I18n.getTranslation(DECIMAL_LABEL), (Object)0));
        formatsComboModel.addElement(new LabeledValueImpl(I18n.getTranslation(DMS_LABEL), (Object)1));
        return formatsComboModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCalculate() {
        Double sourceX = null;
        try {
            sourceX = this.getSourceX();
        }
        catch (Exception ex) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("_The_value_for_longitude_slash_X_is_not_valid", "_Coordinate_calculator", 2);
        }
        if (sourceX == null) {
            return;
        }
        Double sourceY = null;
        try {
            sourceY = this.getSourceY();
        }
        catch (Exception ex) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("_The_value_for_latitude_slash_Y_is_not_valid", "_Coordinate_calculator", 2);
        }
        if (sourceY == null) {
            return;
        }
        Point2D.Double sourcePoint = new Point2D.Double(sourceX, sourceY);
        Point2D.Double targetPoint = null;
        ICoordTrans ct = this.getTransform();
        if (ct == null) {
            if (this.sourcePicker.get() != this.targetPicker.get()) return;
            targetPoint = sourcePoint;
        } else {
            try {
                targetPoint = (Point2D.Double)ct.convert((Point2D)sourcePoint, null);
            }
            catch (Exception ex) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog("_The_conversion_of_values_could_not_be_performed_Please_check_the_input_values", "_Coordinate_calculator", 2);
            }
        }
        if (targetPoint == null) {
            return;
        }
        LabeledValue targetFormat = (LabeledValue)this.cboTargetFormat.getSelectedItem();
        if ((Integer)targetFormat.getValue() == 1) {
            this.txtTargetX.setText(String.valueOf(GeometryUtils.formatCoordinate((String)DEGREES_FORMAT, (double)targetPoint.getX())));
            this.txtTargetY.setText(String.valueOf(GeometryUtils.formatCoordinate((String)DEGREES_FORMAT, (double)targetPoint.getY())));
            return;
        } else {
            this.txtTargetX.setText(String.valueOf(targetPoint.getX()));
            this.txtTargetY.setText(String.valueOf(targetPoint.getY()));
        }
    }

    private Double getSourceX() {
        String s = this.txtSourceX.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        LabeledValue sourceFormat = (LabeledValue)this.cboSourceFormat.getSelectedItem();
        double v = (Integer)sourceFormat.getValue() == 1 ? GeometryUtils.parseCoordinate((String)s) : Double.valueOf(s);
        if (!((IProjection)this.sourcePicker.get()).isProjected() && Math.abs(v) > 180.0) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("_Longitude_overflow", "_Coordinate_calculator", 2);
        }
        return v;
    }

    private Double getSourceY() {
        String s = this.txtSourceY.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        LabeledValue sourceFormat = (LabeledValue)this.cboSourceFormat.getSelectedItem();
        double v = (Integer)sourceFormat.getValue() == 1 ? GeometryUtils.parseCoordinate((String)s) : Double.valueOf(s);
        if (!((IProjection)this.sourcePicker.get()).isProjected() && Math.abs(v) > 90.0) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("_Latitude_overflow", "_Coordinate_calculator", 2);
        }
        return v;
    }
}

