/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.splitline.operation;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperation;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperationUtils;

public class SplineSplitLineOperation
implements SplitLineOperation {
    @Override
    public Curve[] split(Geometry geometry, Point projectedPoint) throws LocatorException, GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        Spline splineToSplit = (Spline)geometry;
        Line lineToSplit = (Line)((Spline)geometry).toLines().getPrimitiveAt(0);
        int subtype = geometry.getGeometryType().getSubType();
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        Spline splittedLine1 = (Spline)GeometryLocator.getGeometryManager().create(14, subtype);
        int index = 0;
        Point originalVertex = splineToSplit.getVertex(index);
        for (int pointer = 0; pointer < lineToSplit.getNumVertices() - 1; ++pointer) {
            Point vertex = lineToSplit.getVertex(pointer);
            if (vertex.equals(originalVertex)) {
                splittedLine1.addVertex(vertex);
                originalVertex = splineToSplit.getVertex(++index);
            }
            Line segment = geoManager.createLine(subtype);
            segment.setPoints(lineToSplit.getVertex(pointer), lineToSplit.getVertex(pointer + 1));
            if (!SplitLineOperationUtils.intersects((Curve)segment, projectedPoint)) continue;
            splittedLine1.addVertex(projectedPoint);
            ++pointer;
            break;
        }
        Spline splittedLine2 = (Spline)GeometryLocator.getGeometryManager().create(14, subtype);
        splittedLine2.addVertex(projectedPoint);
        while (index < splineToSplit.getNumVertices()) {
            splittedLine2.addVertex(splineToSplit.getVertex(index));
            ++index;
        }
        return new Curve[]{splittedLine1, splittedLine2};
    }
}

