/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wcs;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.gvsig.remoteclient.wcs.WCSProtocolHandler;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WCSProtocolHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(WCSProtocolHandlerFactory.class);
    public WCSProtocolHandler wCSProtocolHandler;
    private static ArrayList supportedVersions = new ArrayList();

    private static String getDriverVersion(String version, Iterator clients) throws InstantiationException, IllegalAccessException {
        while (clients.hasNext()) {
            String clientVersion = (String)clients.next();
            int ret = version.compareTo(clientVersion);
            if (ret < 0) continue;
            return clientVersion;
        }
        return null;
    }

    public static WCSProtocolHandler negotiate(String host) throws ConnectException, IOException {
        if (supportedVersions.size() == 0) {
            return null;
        }
        try {
            String highestVersionSupportedByServer = WCSProtocolHandlerFactory.getSuitableWCSVersion(host, "");
            if (supportedVersions.contains(highestVersionSupportedByServer)) {
                return WCSProtocolHandlerFactory.createVersionDriver(highestVersionSupportedByServer);
            }
            Iterator iVersion = supportedVersions.iterator();
            while (iVersion.hasNext()) {
                String gvSIGVersion = (String)iVersion.next();
                String wcsVersion = WCSProtocolHandlerFactory.getSuitableWCSVersion(host, gvSIGVersion);
                int res = wcsVersion.compareTo(gvSIGVersion);
                if (res == 0) {
                    return WCSProtocolHandlerFactory.createVersionDriver(gvSIGVersion);
                }
                if (res > 0) {
                    throw new Exception("Server Version too high: " + wcsVersion);
                }
                String lowerVersion = WCSProtocolHandlerFactory.getDriverVersion(wcsVersion, iVersion);
                if (lowerVersion == null) {
                    throw new Exception("Lowest server version is " + wcsVersion);
                }
                if (!lowerVersion.equals(wcsVersion)) continue;
                return WCSProtocolHandlerFactory.createVersionDriver(lowerVersion);
            }
            return null;
        }
        catch (ConnectException conEx) {
            throw conEx;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getSuitableWCSVersion(String host, String _version) throws ConnectException, IOException {
        int[] sizes = new int[]{1024, 10240, 51200, 102400};
        XmlPullParserException xmlEx = null;
        for (int i = 0; i < sizes.length; ++i) {
            try {
                String version = WCSProtocolHandlerFactory.getSuitableWCSVersion(host, _version, sizes[i]);
                return version;
            }
            catch (XmlPullParserException ex) {
                xmlEx = ex;
                continue;
            }
        }
        logger.warn("Can't determine server version", xmlEx);
        return "";
    }

    private static String getSuitableWCSVersion(String host, String _version, int size) throws ConnectException, IOException, XmlPullParserException {
        String request = WCSProtocolHandler.buildCapabilitiesSuitableVersionRequest(host, _version);
        String version = new String();
        StringReader reader = null;
        FilterInputStream dis = null;
        try {
            URL url = new URL(request);
            byte[] buffer = new byte[size];
            dis = new DataInputStream(url.openStream());
            ((DataInputStream)dis).readFully(buffer);
            reader = new StringReader(new String(buffer));
            KXmlParser kxmlParser = null;
            kxmlParser = new KXmlParser();
            kxmlParser.setInput((Reader)reader);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1 && kxmlParser.getName().compareTo("WCS_Capabilities") == 0) {
                version = kxmlParser.getAttributeValue("", "version");
            }
            reader.close();
            dis.close();
            String string = version;
            return string;
        }
        catch (ConnectException conEx) {
            throw new ConnectException(conEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new IOException(ioEx.getMessage());
        }
        catch (XmlPullParserException xmlEx) {
            throw xmlEx;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static WCSProtocolHandler createVersionDriver(String version) {
        try {
            version = version.replace('.', '_');
            Class<?> driver = Class.forName("org.gvsig.remoteclient.wcs.wcs_" + version + ".WCSProtocolHandler" + version);
            return (WCSProtocolHandler)((Object)driver.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        supportedVersions.add("1.0.0");
    }
}

