/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.PulseTracker;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.SubstanceSpinnerButton;
import org.jvnet.substance.Utilities;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceBackgroundDelegate {
    private static Map<String, BufferedImage> roundBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> regularBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> scrollBarBackgrounds = new HashMap<String, BufferedImage>();

    static synchronized void reset() {
        regularBackgrounds.clear();
        scrollBarBackgrounds.clear();
        roundBackgrounds.clear();
    }

    private static synchronized BufferedImage getBackground(AbstractButton button, int width, int height, boolean isRoundCorners) {
        Map<String, BufferedImage> backgrounds;
        JButton jb;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        if (button instanceof JButton && (jb = (JButton)button).isDefaultButton() && state != ComponentState.PRESSED_SELECTED && state != ComponentState.PRESSED_UNSELECTED && (cyclePos = (int)(PulseTracker.getCycles(jb) % 20L)) > 10) {
            cyclePos = 19 - cyclePos;
        }
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                colorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        String key = width + ":" + height + ":" + kind.name() + ":" + cyclePos + ":" + button.getClass().getName();
        Map<String, BufferedImage> map = backgrounds = isRoundCorners ? roundBackgrounds : regularBackgrounds;
        if (!backgrounds.containsKey(key)) {
            int radius = isRoundCorners ? height / 2 : 2;
            SubstanceImageCreator.Side side = null;
            if (button instanceof SubstanceComboBoxButton) {
                side = SubstanceImageCreator.Side.LEFT;
            }
            BufferedImage newBackground = SubstanceImageCreator.getRoundedBackground(width, height, radius, colorSchemeEnum, cyclePos, side);
            backgrounds.put(key, newBackground);
        }
        return backgrounds.get(key);
    }

    private static synchronized BufferedImage getPairwiseBackground(AbstractButton button, int width, int height, SubstanceImageCreator.Side side) {
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                colorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        String key = width + ":" + height + ":" + side.toString() + ":" + cyclePos + ":" + colorSchemeEnum.name() + ":" + button.getClass().getName();
        if (!scrollBarBackgrounds.containsKey(key)) {
            BufferedImage newBackground = null;
            int radius = 0;
            switch (side) {
                case TOP: 
                case BOTTOM: {
                    newBackground = SubstanceImageCreator.getFlipRoundedButton(width, height, radius, colorSchemeEnum, cyclePos, side, true);
                    break;
                }
                case RIGHT: 
                case LEFT: {
                    newBackground = SubstanceImageCreator.getRoundedBackground(width, height, radius, colorSchemeEnum, cyclePos, side, true);
                }
            }
            scrollBarBackgrounds.put(key, newBackground);
        }
        return scrollBarBackgrounds.get(key);
    }

    public void updateBackground(Graphics g, AbstractButton button, long cycleCount) {
        boolean isRoundCorners;
        button.setOpaque(false);
        Graphics2D graphics = (Graphics2D)g;
        int width = button.getWidth();
        int height = button.getHeight();
        boolean bl = isRoundCorners = !Utilities.isComboBoxButton(button) && !Utilities.isScrollButton(button) && Utilities.hasText(button);
        if (Utilities.isScrollButton(button)) {
            SubstanceScrollButton ssbButton = (SubstanceScrollButton)button;
            graphics.drawImage((Image)SubstanceBackgroundDelegate.getPairwiseBackground(button, width, height, ssbButton.getSide()), 0, 0, null);
        } else if (Utilities.isSpinnerButton(button)) {
            SubstanceSpinnerButton ssbButton = (SubstanceSpinnerButton)button;
            graphics.drawImage((Image)SubstanceBackgroundDelegate.getPairwiseBackground(button, width, height, ssbButton.getSide()), 0, 0, null);
        } else {
            graphics.drawImage((Image)SubstanceBackgroundDelegate.getBackground(button, width, height, isRoundCorners), 0, 0, null);
        }
    }
}

