/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.jvnet.substance.SubstanceImageCreator;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private JButton button;
    private JLabel label;
    private TitleListener titleListener;
    private int width;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String title = this.frame.getTitle();
        this.button = new JButton(title, icon);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubstanceDesktopIconUI.this.deiconize();
            }
        });
        this.button.setFont(this.desktopIcon.getFont());
        int buttonH = this.button.getPreferredSize().height;
        this.desktopIcon.setLayout(new BorderLayout(4, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        if (buttonH != 0) {
            ImageIcon dragIcon = new ImageIcon(SubstanceImageCreator.getDragImage((int)(0.5 * (double)buttonH), buttonH));
            this.label = new JLabel(dragIcon);
            this.label.setBorder(new EmptyBorder(0, 3, 0, 2));
            this.desktopIcon.add((Component)this.label, "West");
        }
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        if (this.label != null) {
            this.desktopIcon.remove(this.label);
        }
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
    }

    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    class TitleListener
    implements PropertyChangeListener {
        TitleListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("title")) {
                SubstanceDesktopIconUI.this.button.setText((String)e.getNewValue());
            }
            if (e.getPropertyName().equals("frameIcon")) {
                SubstanceDesktopIconUI.this.button.setIcon((Icon)e.getNewValue());
            }
        }
    }
}

