/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import org.jvnet.substance.FocusBorderListener;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceDropShadowBorder
implements Border {
    private Insets insets;
    private static Map<String, BufferedImage> borders = new HashMap<String, BufferedImage>();

    public SubstanceDropShadowBorder() {
        this.insets = new Insets(2, 2, 4, 4);
    }

    public SubstanceDropShadowBorder(int gap) {
        this.insets = new Insets(1 + gap, 1 + gap, 3 + gap, 3 + gap);
    }

    static synchronized void reset() {
        borders.clear();
    }

    private static synchronized BufferedImage getBorder(Component c, int width, int height, boolean isEnabled, boolean hasFocus, boolean isRound) {
        String key = width + ":" + height + ":" + isEnabled + ":" + hasFocus + ":" + isRound + ":" + c.getClass().getName();
        if (!borders.containsKey(key)) {
            HashSet<SubstanceImageCreator.Corner> corners = new HashSet<SubstanceImageCreator.Corner>();
            if (isRound) {
                corners.add(SubstanceImageCreator.Corner.TOP_LEFT);
                corners.add(SubstanceImageCreator.Corner.TOP_RIGHT);
            }
            ColorSchemeEnum borderSchemeEnum = hasFocus ? SubstanceLookAndFeel.getColorScheme() : (isEnabled ? ColorSchemeEnum.METALLIC : ColorSchemeEnum.LIGHT_GRAY);
            BufferedImage newBorder = SubstanceImageCreator.getBorder(width, height, borderSchemeEnum, corners, true);
            borders.put(key, newBorder);
        }
        return borders.get(key);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean isRound = false;
        if (c instanceof JComboBox) {
            isRound = true;
        }
        BufferedImage border = SubstanceDropShadowBorder.getBorder(c, width, height, c.isEnabled(), FocusBorderListener.isFocused(c), isRound);
        g.drawImage(border, x, y, null);
    }

    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

