/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.ColorSchemeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubstanceImageCreator {
    public static final int ICON_DIMENSION = 16;
    public static final int ARROW_WIDTH = 9;
    public static final int ARROW_HEIGHT = 6;
    public static final int DRAG_BUMP_DIAMETER = 2;

    public static BufferedImage getBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.setComposite(AlphaComposite.Src);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return image;
    }

    private static Color getInterpolatedColor(Color color1, Color color2, double color1Likeness) {
        int lr = color1.getRed();
        int lg = color1.getGreen();
        int lb = color1.getBlue();
        int dr = color2.getRed();
        int dg = color2.getGreen();
        int db = color2.getBlue();
        int r = (int)(color1Likeness * (double)lr + (1.0 - color1Likeness) * (double)dr);
        int g = (int)(color1Likeness * (double)lg + (1.0 - color1Likeness) * (double)dg);
        int b = (int)(color1Likeness * (double)lb + (1.0 - color1Likeness) * (double)db);
        r = Math.min(255, r);
        g = Math.min(255, g);
        b = Math.min(255, b);
        r = Math.max(0, r);
        g = Math.max(0, g);
        b = Math.max(0, b);
        return new Color(r, g, b);
    }

    public static BufferedImage getBorder(int width, int height, ColorSchemeEnum borderSchemeEnum, Set<Corner> roundedCorners, boolean hasDropShadow) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                image.setRGB(col, row, 0);
            }
        }
        ColorScheme borderScheme = borderSchemeEnum.getColorScheme();
        Color topBorderColor = borderScheme.getDarkColor();
        Color bottomBorderColor = borderScheme.getMidColor();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height - 1, bottomBorderColor);
        graphics.setPaint(gradient);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        if (hasDropShadow) {
            width -= 2;
            height -= 2;
        }
        Polygon border = new Polygon();
        if (roundedCorners.contains((Object)Corner.TOP_LEFT)) {
            border.addPoint(0, 1);
            border.addPoint(1, 0);
        } else {
            border.addPoint(0, 0);
        }
        if (roundedCorners.contains((Object)Corner.TOP_RIGHT)) {
            border.addPoint(width - 2, 0);
            border.addPoint(width - 1, 1);
        } else {
            border.addPoint(width - 1, 0);
        }
        if (roundedCorners.contains((Object)Corner.BOTTOM_RIGHT)) {
            border.addPoint(width - 1, height - 2);
            border.addPoint(width - 2, height - 1);
        } else {
            border.addPoint(width - 1, height - 1);
        }
        if (roundedCorners.contains((Object)Corner.BOTTOM_LEFT)) {
            border.addPoint(1, height - 1);
            border.addPoint(0, height - 2);
        } else {
            border.addPoint(0, height - 1);
        }
        graphics.drawPolygon(border);
        if (hasDropShadow) {
            ColorScheme borderShadowScheme = ColorSchemeEnum.METALLIC.getColorScheme();
            Color topShadowBorderColor = borderShadowScheme.getUltraDarkColor();
            Color bottomShadowBorderColor = borderShadowScheme.getMidColor();
            Color topShadow2BorderColor = new Color(topShadowBorderColor.getRed(), topShadowBorderColor.getGreen(), topShadowBorderColor.getBlue(), 40);
            Color bottomShadow2BorderColor = new Color(bottomShadowBorderColor.getRed(), bottomShadowBorderColor.getGreen(), bottomShadowBorderColor.getBlue(), 100);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            GradientPaint gradientShadow2 = new GradientPaint(0.0f, 0.0f, topShadow2BorderColor, 0.0f, height - 1, bottomShadow2BorderColor);
            graphics.setPaint(gradientShadow2);
            graphics.setStroke(new BasicStroke(1.5f, 1, 1));
            Polygon borderShadow2 = new Polygon();
            borderShadow2.addPoint(width + 1, 2);
            borderShadow2.addPoint(width + 1, height);
            borderShadow2.addPoint(width, height);
            borderShadow2.addPoint(width, height + 1);
            borderShadow2.addPoint(2, height + 1);
            graphics.drawPolyline(borderShadow2.xpoints, borderShadow2.ypoints, borderShadow2.npoints);
            Color topShadow1BorderColor = new Color(topShadowBorderColor.getRed(), topShadowBorderColor.getGreen(), topShadowBorderColor.getBlue(), 100);
            Color bottomShadow1BorderColor = new Color(bottomShadowBorderColor.getRed(), bottomShadowBorderColor.getGreen(), bottomShadowBorderColor.getBlue(), 200);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            GradientPaint gradientShadow1 = new GradientPaint(0.0f, 0.0f, topShadow1BorderColor, 0.0f, height - 1, bottomShadow1BorderColor);
            graphics.setPaint(gradientShadow1);
            graphics.setStroke(new BasicStroke(1.0f, 1, 1));
            Polygon borderShadow1 = new Polygon();
            if (roundedCorners.contains((Object)Corner.TOP_RIGHT)) {
                borderShadow1.addPoint(width - 1, 1);
                borderShadow1.addPoint(width, 2);
            } else {
                borderShadow1.addPoint(width, 1);
            }
            if (roundedCorners.contains((Object)Corner.BOTTOM_RIGHT)) {
                borderShadow1.addPoint(width, height - 1);
                borderShadow1.addPoint(width - 1, height);
            } else {
                borderShadow1.addPoint(width, height);
            }
            if (roundedCorners.contains((Object)Corner.BOTTOM_LEFT)) {
                borderShadow1.addPoint(2, height);
                borderShadow1.addPoint(1, height - 1);
            } else {
                borderShadow1.addPoint(1, height);
            }
            graphics.drawPolyline(borderShadow1.xpoints, borderShadow1.ypoints, borderShadow1.npoints);
        }
        return image;
    }

    private static BufferedImage getCheckMark(int dimension, boolean isEnabled, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage result = new BufferedImage(dimension, dimension, 2);
        for (int col = 0; col < dimension; ++col) {
            for (int row = 0; row < dimension; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(SubstanceImageCreator.getDarkerColor(colorSchemeEnum.getColorScheme().getUltraDarkColor(), 0.5));
        BasicStroke stroke = new BasicStroke(0.15f * (float)dimension, 1, 1);
        graphics.setStroke(stroke);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.25f * (float)dimension, 0.5f * (float)dimension);
        path.quadTo(0.4f * (float)dimension, 0.6f * (float)dimension, 0.5f * (float)dimension, 0.8f * (float)dimension);
        path.quadTo(0.55f * (float)dimension, 0.5f * (float)dimension, 0.85f * (float)dimension, 0.0f);
        graphics.draw(path);
        return result;
    }

    public static Icon getArrowIcon(int width, int height, int direction) {
        BufferedImage downArrowImage = new BufferedImage(width, height, 2);
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                downArrowImage.setRGB(col, row, 0);
            }
        }
        Graphics2D graphics = (Graphics2D)downArrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.black);
        BasicStroke stroke = new BasicStroke(2.0f, 0, 0);
        graphics.setStroke(stroke);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.5f * (float)(width - 1), height - 2);
        gp.lineTo(width - 1, 0.0f);
        graphics.draw(gp);
        int quadrantCounterClockwise = 0;
        switch (direction) {
            case 1: {
                quadrantCounterClockwise = 2;
                break;
            }
            case 7: {
                quadrantCounterClockwise = 1;
                break;
            }
            case 5: {
                quadrantCounterClockwise = 0;
                break;
            }
            case 3: {
                quadrantCounterClockwise = 3;
            }
        }
        BufferedImage arrowImage = SubstanceImageCreator.getRotated(downArrowImage, quadrantCounterClockwise);
        return new ImageIcon(arrowImage);
    }

    public static BufferedImage getRotated(BufferedImage bi, int quadrantClockwise) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        if ((quadrantClockwise %= 4) == 1 || quadrantClockwise == 3) {
            width = bi.getHeight();
            height = bi.getWidth();
        }
        BufferedImage biRot = SubstanceImageCreator.getBlankImage(width, height);
        switch (quadrantClockwise) {
            case 0: {
                return bi;
            }
            case 1: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(row, width - col - 1));
                    }
                }
                return biRot;
            }
            case 2: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(width - col - 1, height - row - 1));
                    }
                }
                return biRot;
            }
            case 3: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(height - row - 1, col));
                    }
                }
                return biRot;
            }
        }
        return null;
    }

    public static Icon toGreyscale(Icon icon) {
        int row;
        int col;
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int color = result.getRGB(col, row);
                int transp = color >>> 24 & 0xFF;
                int oldR = color >>> 16 & 0xFF;
                int oldG = color >>> 8 & 0xFF;
                int oldB = color >>> 0 & 0xFF;
                int newComp = (222 * oldR + 707 * oldG + 71 * oldB) / 1000;
                int newColor = transp << 24 | newComp << 16 | newComp << 8 | newComp;
                result.setRGB(col, row, newColor);
            }
        }
        return new ImageIcon(result);
    }

    public static Icon makeTransparent(Icon icon, double alpha) {
        int row;
        int col;
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int color = result.getRGB(col, row);
                int transp = (int)(alpha * (double)(color >>> 24 & 0xFF));
                int r = color >>> 16 & 0xFF;
                int g = color >>> 8 & 0xFF;
                int b = color >>> 0 & 0xFF;
                int newColor = transp << 24 | r << 16 | g << 8 | b;
                result.setRGB(col, row, newColor);
            }
        }
        return new ImageIcon(result);
    }

    private static int[][] getFuzzyOvalOpacity(int width, int height, int cornerRadius, Side side) {
        int[][] result = new int[width][height];
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                result[col][row] = 0;
            }
        }
        double ellipseHeight = (double)height / 2.0 - 1.0;
        double ellipseMidY = 2.0 + ellipseHeight / 2.0;
        double sliceWidth = width;
        if (ellipseMidY < (double)cornerRadius) {
            double dx = Math.sqrt(2.0 * (double)cornerRadius * ellipseMidY - ellipseMidY * ellipseMidY);
            double delta = (double)cornerRadius - dx;
            sliceWidth = width;
            if (side != Side.LEFT) {
                sliceWidth -= delta;
            }
            if (side != Side.RIGHT) {
                sliceWidth -= delta;
            }
        }
        double ellipseWidth = Math.max(0.8 * sliceWidth, sliceWidth - 10.0);
        double ellipseMidX = (double)width / 2.0;
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                image.setRGB(col, row, 0);
            }
        }
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.black);
        int oxLeft = (int)(ellipseMidX - ellipseWidth / 2.0);
        int oxRight = (int)(ellipseMidX + ellipseWidth / 2.0);
        int oyTop = (int)(ellipseMidY - ellipseHeight / 2.0);
        int oyBottom = (int)(ellipseMidY + ellipseHeight / 2.0);
        int obLeft = (int)((double)oxLeft + ellipseHeight / 2.0);
        int obRight = (int)((double)oxRight - ellipseHeight / 2.0);
        graphics.fillRect(obLeft, oyTop, obRight - obLeft + 1, oyBottom - oyTop);
        graphics.fillArc(oxLeft, oyTop, (int)ellipseHeight, (int)ellipseHeight, 90, 180);
        graphics.fillArc(oxRight - (int)ellipseHeight, oyTop, (int)ellipseHeight, (int)ellipseHeight, 270, 180);
        int[][] temporary = new int[width][height];
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                int transp;
                int color = image.getRGB(col, row);
                temporary[col][row] = transp = color >>> 24 & 0xFF;
            }
        }
        int maxFuzziness = height / 5;
        int minFuzziness = 1;
        for (int row = 0; row < height; ++row) {
            int fuzziness = minFuzziness + (maxFuzziness - minFuzziness) * row / height;
            int sy = Math.max(0, row - fuzziness);
            int ey = Math.min(height - 1, row + fuzziness);
            for (int col = 0; col < width; ++col) {
                int pixCount = 0;
                int transpSum = 0;
                int sx = Math.max(0, col - fuzziness);
                int ex = Math.min(width - 1, col + fuzziness);
                for (int colPix = sx; colPix <= ex; ++colPix) {
                    for (int rowPix = sy; rowPix <= ey; ++rowPix) {
                        ++pixCount;
                        transpSum += temporary[colPix][rowPix];
                    }
                }
                result[col][row] = transpSum / pixCount;
            }
        }
        return result;
    }

    public static BufferedImage getRoundedBackground(int width, int height, int cornerRadius, ColorSchemeEnum colorSchemeEnum, int cyclePos, Side side) {
        return SubstanceImageCreator.getRoundedBackground(width, height, cornerRadius, colorSchemeEnum, colorSchemeEnum, cyclePos, side, false, true);
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState) {
        return SubstanceImageCreator.getRadioButton(dimension, componentState, 0);
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState, int offsetX) {
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        int cyclePos = componentState.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                colorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        BufferedImage background = SubstanceImageCreator.getRoundedBackground(dimension, dimension, dimension / 2, colorSchemeEnum, colorSchemeEnum, cyclePos, null, false, true);
        BufferedImage offBackground = SubstanceImageCreator.getBlankImage(dimension + offsetX, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.drawImage((Image)background, offsetX, 0, null);
        if (componentState.isSelected()) {
            int rc = dimension / 2;
            Color markColor = SubstanceImageCreator.getDarkerColor(colorSchemeEnum.getColorScheme().getUltraDarkColor(), 0.5);
            graphics.translate(offsetX, 0);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(markColor);
            graphics.fillOval(rc - dimension / 5, rc - dimension / 5, 2 * dimension / 5, 2 * dimension / 5);
            graphics.translate(-offsetX, 0);
        }
        return offBackground;
    }

    public static BufferedImage getCheckBox(int dimension, ComponentState componentState) {
        int offset = 2;
        int cornerRadius = 2;
        if (dimension <= 10) {
            offset = 1;
            cornerRadius = 2;
        }
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        int cyclePos = componentState.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                colorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        BufferedImage background = SubstanceImageCreator.getRoundedBackground(dimension - offset, dimension - offset, cornerRadius, colorSchemeEnum, colorSchemeEnum, cyclePos, null, false, true);
        BufferedImage offBackground = SubstanceImageCreator.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.drawImage((Image)background, offset, offset, null);
        if (componentState.isSelected()) {
            BufferedImage checkMark = SubstanceImageCreator.getCheckMark(dimension - offset, componentState.isEnabled(), colorSchemeEnum);
            graphics.drawImage((Image)checkMark, offset, 0, null);
        }
        return offBackground;
    }

    public static BufferedImage getRoundedBackground(int width, int height, int cornerRadius, ColorSchemeEnum colorSchemeEnum, int cyclePos, Side side, boolean isSideOpen) {
        return SubstanceImageCreator.getRoundedBackground(width, height, cornerRadius, colorSchemeEnum, colorSchemeEnum, cyclePos, side, isSideOpen, true);
    }

    public static BufferedImage getFlipRoundedButton(int width, int height, int cornerRadius, ColorSchemeEnum colorSchemeEnum, int cyclePos, Side side, boolean isSideOpen) {
        BufferedImage bi = SubstanceImageCreator.getRoundedBackground(height, width, cornerRadius, colorSchemeEnum, cyclePos, side.getAdjacentSide(), isSideOpen);
        return SubstanceImageCreator.getRotated(bi, 3);
    }

    public static BufferedImage getCompositeRoundedBackground(int width, int height, int cornerRadius, ComponentState compDecrState, ComponentState compIncrState, boolean flipSides) {
        ComponentState.ColorSchemeKind decrKind = compDecrState.getColorSchemeKind();
        int decrCyclePos = compDecrState.getCycleCount();
        ColorSchemeEnum decrColorSchemeEnum = null;
        switch (decrKind) {
            case CURRENT: {
                decrColorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                decrColorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                decrColorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        BufferedImage decrLayer = SubstanceImageCreator.getRoundedBackground(width, height, 0, decrColorSchemeEnum, decrColorSchemeEnum, decrCyclePos, flipSides ? Side.RIGHT : Side.LEFT, true, false);
        ComponentState.ColorSchemeKind incrKind = compIncrState.getColorSchemeKind();
        int incrCyclePos = compIncrState.getCycleCount();
        ColorSchemeEnum incrColorSchemeEnum = null;
        switch (incrKind) {
            case CURRENT: {
                incrColorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                incrColorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                incrColorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        BufferedImage incrLayer = SubstanceImageCreator.getRoundedBackground(width, height, 0, incrColorSchemeEnum, incrColorSchemeEnum, incrCyclePos, flipSides ? Side.LEFT : Side.RIGHT, true, false);
        BufferedImage mainLayer = SubstanceImageCreator.getRoundedBackground(width, height, cornerRadius, ColorSchemeEnum.LIGHT_GRAY, ColorSchemeEnum.LIGHT_GRAY, 0, null, false, true);
        BufferedImage result = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        if (!flipSides) {
            graphics.drawImage(decrLayer, 0, 0, width / 2, height, 0, 0, width / 2, height, null);
            graphics.drawImage(incrLayer, width / 2, 0, width, height, width / 2, 0, width, height, null);
        } else {
            graphics.drawImage(incrLayer, 0, 0, width / 2, height, 0, 0, width / 2, height, null);
            graphics.drawImage(decrLayer, width / 2, 0, width, height, width / 2, 0, width, height, null);
        }
        graphics.drawImage((Image)mainLayer, 0, 0, null);
        return result;
    }

    public static BufferedImage getRoundedBackground(int width, int height, int cornerRadius, ColorSchemeEnum borderSchemeEnum, ColorSchemeEnum fillSchemeEnum, int cyclePos, Side side, boolean isSideOpen, boolean hasShine) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean hasBorder = borderSchemeEnum != null;
        ColorScheme borderScheme = hasBorder ? borderSchemeEnum.getColorScheme() : null;
        ColorScheme fillScheme = fillSchemeEnum.getColorScheme();
        Color topBorderColor = hasBorder ? borderScheme.getUltraDarkColor() : null;
        Color midBorderColor = hasBorder ? borderScheme.getDarkColor() : null;
        Color bottomBorderColor = hasBorder ? borderScheme.getMidColor() : null;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getDarkColor(), fillScheme.getLightColor(), cycleCoef);
        Color midFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getMidColor(), fillScheme.getLightColor(), cycleCoef);
        Color bottomFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), Color.white, cycleCoef);
        Color topShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), Color.white, cycleCoef);
        Color bottomShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getLightColor(), fillScheme.getUltraLightColor(), cycleCoef);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, topFillColor, 0.0f, height / 2, midFillColor);
        graphics.setPaint(gradient);
        int vStripeLeft = side == Side.LEFT ? 0 : cornerRadius;
        int vStripeRight = side == Side.RIGHT ? width : width - 1 - cornerRadius;
        int vStripeWidth = vStripeRight - vStripeLeft + 1;
        int hStripeTop = side == Side.TOP ? 0 : cornerRadius;
        int hStripeBottom = side == Side.BOTTOM ? height : height - cornerRadius;
        int hStripeHeight = hStripeBottom - hStripeTop;
        graphics.fillRect(0, hStripeTop, width, height / 2 - hStripeTop);
        graphics.fillRect(vStripeLeft, 0, vStripeWidth, height / 2);
        if (side != Side.TOP && side != Side.LEFT) {
            graphics.fillArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
        }
        if (side != Side.TOP && side != Side.RIGHT) {
            graphics.fillArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
        }
        GradientPaint gradient2 = new GradientPaint(0.0f, height / 2, midFillColor, 0.0f, height - 2, bottomFillColor);
        graphics.setPaint(gradient2);
        graphics.fillRect(0, height / 2, width, hStripeBottom - height / 2);
        graphics.fillRect(vStripeLeft, height / 2, vStripeWidth, 1 + height / 2);
        if (side != Side.BOTTOM && side != Side.LEFT) {
            graphics.fillArc(0, height - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 180, 90);
        }
        if (side != Side.BOTTOM && side != Side.RIGHT) {
            graphics.fillArc(width - 1 - 2 * cornerRadius, height - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 270, 90);
        }
        if (hasShine) {
            int tsr = topShineColor.getRed();
            int tsg = topShineColor.getGreen();
            int tsb = topShineColor.getBlue();
            int bsr = bottomShineColor.getRed();
            int bsg = bottomShineColor.getGreen();
            int bsb = bottomShineColor.getBlue();
            int[][] fuzzyOval = SubstanceImageCreator.getFuzzyOvalOpacity(width, height, cornerRadius, side);
            int row = 0;
            while ((double)row < (double)height / 2.4) {
                double coef = Math.min(1.0, (double)row / ((double)height / 2.4));
                int sr = (int)((double)tsr + coef * (double)(bsr - tsr));
                int sg = (int)((double)tsg + coef * (double)(bsg - tsg));
                int sb = (int)((double)tsb + coef * (double)(bsb - tsb));
                for (int col = 0; col < width; ++col) {
                    int transp = fuzzyOval[col][row];
                    graphics.setColor(new Color(sr, sg, sb, transp));
                    graphics.drawLine(col, row, col, row);
                }
                ++row;
            }
        }
        if (hasBorder) {
            boolean toDrawBottomSideFull;
            boolean toDrawTopSideFull;
            boolean toDrawRightSideFull;
            boolean toDrawLeftSideFull;
            GradientPaint gradient3 = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradient3);
            boolean toDrawLeftSide = side != Side.LEFT || side == Side.LEFT && !isSideOpen;
            boolean bl = toDrawLeftSideFull = side == Side.LEFT && !isSideOpen;
            if (toDrawLeftSide) {
                if (toDrawLeftSideFull) {
                    graphics.drawLine(0, 0, 0, height / 2);
                } else {
                    graphics.drawLine(0, hStripeTop, 0, hStripeTop + hStripeHeight / 2);
                }
            }
            boolean toDrawRightSide = side != Side.RIGHT || side == Side.RIGHT && !isSideOpen;
            boolean bl2 = toDrawRightSideFull = side == Side.RIGHT && !isSideOpen;
            if (toDrawRightSide) {
                if (toDrawRightSideFull) {
                    graphics.drawLine(width - 1, 0, width - 1, height / 2);
                } else {
                    graphics.drawLine(width - 1, hStripeTop, width - 1, hStripeTop + hStripeHeight / 2);
                }
            }
            boolean toDrawTopSide = side != Side.TOP || side == Side.TOP && !isSideOpen;
            boolean bl3 = toDrawTopSideFull = side == Side.TOP && !isSideOpen;
            if (toDrawTopSide) {
                if (toDrawTopSideFull) {
                    graphics.drawLine(0, 0, width, 0);
                } else {
                    graphics.drawLine(vStripeLeft, 0, vStripeRight, 0);
                }
            }
            if (side != Side.TOP && side != Side.LEFT) {
                graphics.drawArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
            }
            if (side != Side.TOP && side != Side.RIGHT) {
                graphics.drawArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
            }
            GradientPaint gradient4 = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradient4);
            if (toDrawLeftSide) {
                if (toDrawLeftSideFull) {
                    graphics.drawLine(0, height / 2, 0, height);
                } else {
                    graphics.drawLine(0, hStripeTop + hStripeHeight / 2, 0, hStripeBottom);
                }
            }
            if (toDrawRightSide) {
                if (toDrawRightSideFull) {
                    graphics.drawLine(width - 1, height / 2, width - 1, height);
                } else {
                    graphics.drawLine(width - 1, hStripeTop + hStripeHeight / 2, width - 1, hStripeBottom);
                }
            }
            boolean toDrawBottomSide = side != Side.BOTTOM || side == Side.BOTTOM && !isSideOpen;
            boolean bl4 = toDrawBottomSideFull = side == Side.BOTTOM && !isSideOpen;
            if (toDrawBottomSide) {
                if (toDrawBottomSideFull) {
                    graphics.drawLine(0, height - 1, width, height - 1);
                } else {
                    graphics.drawLine(vStripeLeft, height - 1, vStripeRight, height - 1);
                }
            }
            if (side != Side.BOTTOM && side != Side.LEFT) {
                graphics.drawArc(0, height - 1 - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 180, 90);
            }
            if (side != Side.BOTTOM && side != Side.RIGHT) {
                graphics.drawArc(width - 1 - 2 * cornerRadius, height - 1 - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 270, 90);
            }
        }
        return image;
    }

    public static BufferedImage getRoundedTriangleBackground(int width, int height, int cornerRadius, ComponentState componentState) {
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        int cyclePos = componentState.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = ColorSchemeEnum.METALLIC;
                break;
            }
            case DISABLED: {
                colorSchemeEnum = ColorSchemeEnum.LIGHT_GRAY;
            }
        }
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean hasBorder = colorSchemeEnum != null;
        ColorScheme borderScheme = hasBorder ? colorSchemeEnum.getColorScheme() : null;
        ColorScheme fillScheme = colorSchemeEnum.getColorScheme();
        Color topBorderColor = hasBorder ? borderScheme.getUltraDarkColor() : null;
        Color midBorderColor = hasBorder ? borderScheme.getDarkColor() : null;
        Color bottomBorderColor = hasBorder ? borderScheme.getMidColor() : null;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getDarkColor(), fillScheme.getLightColor(), cycleCoef);
        Color midFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getMidColor(), fillScheme.getLightColor(), cycleCoef);
        Color bottomFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), Color.white, cycleCoef);
        Color topShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), Color.white, cycleCoef);
        Color bottomShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getLightColor(), fillScheme.getUltraLightColor(), cycleCoef);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, topFillColor, 0.0f, height / 2, midFillColor);
        graphics.setPaint(gradient);
        int vStripeLeft = cornerRadius;
        int vStripeRight = width - 1 - cornerRadius;
        int vStripeWidth = vStripeRight - vStripeLeft + 1;
        int hStripeTop = cornerRadius;
        int hStripeBottom = height / 2;
        int hStripeHeight = hStripeBottom - hStripeTop;
        graphics.fillRect(0, hStripeTop, width, hStripeHeight);
        graphics.fillRect(vStripeLeft, 0, vStripeWidth, height / 2);
        graphics.fillArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
        graphics.fillArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
        GradientPaint gradient2 = new GradientPaint(0.0f, height / 2, midFillColor, 0.0f, height - 2, bottomFillColor);
        graphics.setPaint(gradient2);
        Polygon triangle = new Polygon();
        triangle.addPoint(0, hStripeBottom);
        triangle.addPoint(width - 1, hStripeBottom);
        triangle.addPoint((width - 1) / 2, height - 1);
        graphics.fillPolygon(triangle);
        int tsr = topShineColor.getRed();
        int tsg = topShineColor.getGreen();
        int tsb = topShineColor.getBlue();
        int bsr = bottomShineColor.getRed();
        int bsg = bottomShineColor.getGreen();
        int bsb = bottomShineColor.getBlue();
        int[][] fuzzyOval = SubstanceImageCreator.getFuzzyOvalOpacity(width, height, cornerRadius, null);
        int row = 0;
        while ((double)row < (double)height / 2.4) {
            double coef = Math.min(1.0, (double)row / ((double)height / 2.4));
            int sr = (int)((double)tsr + coef * (double)(bsr - tsr));
            int sg = (int)((double)tsg + coef * (double)(bsg - tsg));
            int sb = (int)((double)tsb + coef * (double)(bsb - tsb));
            for (int col = 0; col < width; ++col) {
                int transp = fuzzyOval[col][row];
                graphics.setColor(new Color(sr, sg, sb, transp));
                graphics.drawLine(col, row, col, row);
            }
            ++row;
        }
        if (hasBorder) {
            GradientPaint gradient3 = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradient3);
            graphics.drawLine(0, hStripeTop, 0, hStripeBottom - 1);
            graphics.drawLine(width - 1, hStripeTop, width - 1, hStripeBottom - 1);
            graphics.drawLine(vStripeLeft, 0, vStripeRight, 0);
            graphics.drawArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
            graphics.drawArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
            GradientPaint gradient4 = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradient4);
            graphics.drawLine(0, hStripeBottom, (width - 1) / 2, height - 1);
            graphics.drawLine(width - 1, hStripeBottom, (width - 1) / 2, height - 1);
        }
        return image;
    }

    private static Color getLighterColor(Color color, double diff) {
        int r = color.getRed() + (int)(diff * (double)(255 - color.getRed()));
        int g = color.getGreen() + (int)(diff * (double)(255 - color.getGreen()));
        int b = color.getBlue() + (int)(diff * (double)(255 - color.getBlue()));
        return new Color(r, g, b);
    }

    private static Color getDarkerColor(Color color, double diff) {
        int r = (int)((1.0 - diff) * (double)color.getRed());
        int g = (int)((1.0 - diff) * (double)color.getGreen());
        int b = (int)((1.0 - diff) * (double)color.getBlue());
        return new Color(r, g, b);
    }

    private static BufferedImage getOneLineGradient(int width, Color colorLeft, Color colorRight, Map<Integer, Color> waypoints) {
        BufferedImage image = new BufferedImage(width, 1, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ArrayList<Integer> waypointMarkers = new ArrayList<Integer>();
        for (Integer marker : waypoints.keySet()) {
            waypointMarkers.add(marker);
        }
        Collections.sort(waypointMarkers);
        int[] markers = new int[waypointMarkers.size() + 2];
        Color[] colors = new Color[waypointMarkers.size() + 2];
        markers[0] = 0;
        colors[0] = colorLeft;
        int index = 1;
        for (Integer marker : waypointMarkers) {
            markers[index] = marker;
            colors[index] = waypoints.get(marker);
            ++index;
        }
        markers[index] = width - 1;
        colors[index] = colorRight;
        for (int i = 0; i < markers.length - 1; ++i) {
            GradientPaint gradient = new GradientPaint(markers[i], 0.0f, colors[i], markers[i + 1], 0.0f, colors[i + 1]);
            graphics.setPaint(gradient);
            graphics.fillRect(markers[i], 0, markers[i + 1] - markers[i], 1);
        }
        return image;
    }

    public static BufferedImage getGradientCubesImage(Component component, int width, int height, ColorSchemeEnum colorSchemeEnum, int leftTransitionStart, int leftTransitionEnd, int rightTransitionStart, int rightTransitionEnd) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        HashMap<Integer, Color> evenWaypoints = new HashMap<Integer, Color>();
        Color evenExtralight = colorScheme.getExtraLightColor();
        Color evenLight = colorScheme.getLightColor();
        Color evenDark = colorScheme.getDarkColor();
        Color evenUltradark = colorScheme.getUltraDarkColor();
        evenWaypoints.put(leftTransitionStart, evenLight);
        evenWaypoints.put(leftTransitionEnd, evenUltradark);
        evenWaypoints.put(rightTransitionStart, evenDark);
        evenWaypoints.put(rightTransitionEnd, evenLight);
        BufferedImage lineEven = SubstanceImageCreator.getOneLineGradient(width, evenExtralight, evenExtralight, evenWaypoints);
        double lightnessCoef = 0.1;
        HashMap<Integer, Color> oddWaypoints = new HashMap<Integer, Color>();
        Color oddUltralight = SubstanceImageCreator.getDarkerColor(colorScheme.getUltraLightColor(), 0.4 * lightnessCoef);
        Color oddLight = SubstanceImageCreator.getDarkerColor(colorScheme.getLightColor(), 0.4 * lightnessCoef);
        Color oddDark = SubstanceImageCreator.getLighterColor(colorScheme.getDarkColor(), lightnessCoef);
        Color oddUltradark = SubstanceImageCreator.getLighterColor(colorScheme.getUltraDarkColor(), lightnessCoef);
        oddWaypoints.put(leftTransitionStart, oddLight);
        oddWaypoints.put(leftTransitionEnd, oddUltradark);
        oddWaypoints.put(rightTransitionStart, oddDark);
        oddWaypoints.put(rightTransitionEnd, oddLight);
        BufferedImage lineOdd = SubstanceImageCreator.getOneLineGradient(width, oddUltralight, oddUltralight, oddWaypoints);
        for (int row = 0; row < height; ++row) {
            BufferedImage line = row % 2 == 0 ? lineEven : lineOdd;
            graphics.drawImage((Image)line, 0, row, null);
        }
        return image;
    }

    private static void overlayEcho(BufferedImage image, ColorSchemeEnum colorSchemeEnum, int offsetX, int offsetY) {
        int transp;
        int color;
        int row;
        int col;
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage echo = SubstanceImageCreator.getBlankImage(width, height);
        int echoColor = colorSchemeEnum.getColorScheme().getUltraLightColor().getRGB();
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int newY;
                int newX;
                color = image.getRGB(col, row);
                transp = color >>> 24 & 0xFF;
                if (transp != 255 || (newX = col + offsetX) < 0 || newX >= width || (newY = row + offsetY) < 0 || newY >= height) continue;
                echo.setRGB(newX, newY, echoColor);
            }
        }
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                color = image.getRGB(col, row);
                transp = color >>> 24 & 0xFF;
                if (transp == 255) continue;
                image.setRGB(col, row, echo.getRGB(col, row));
            }
        }
    }

    public static Icon getMinimizeIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 2;
        int end = 11;
        int size = end - start - 3;
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.fillRect(start + 2, end - 2, size, 3);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static Icon getRestoreIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 2;
        int end = 11;
        int size = end - start - 3;
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.drawRect(start, end - size + 1, size, size);
        graphics.drawLine(start, end - size + 2, start + size, end - size + 2);
        graphics.fillRect(end - size, start + 1, size + 1, 2);
        graphics.drawLine(end, start + 1, end, start + size + 1);
        graphics.drawLine(start + size + 2, start + size + 1, end, start + size + 1);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static Icon getMaximizeIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 3;
        int end = 12;
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.drawRect(start, start, end - start, end - start);
        graphics.drawLine(start, start + 1, end - start + 2, start + 1);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static Icon getCloseIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int start = 4;
        int end = 15;
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        graphics.setStroke(stroke);
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.drawLine(start, start, end - start, end - start);
        graphics.drawLine(start, end - start, end - start, start);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static BufferedImage getRectangularBackground(int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
        gradColors.put((int)(0.4 * (double)height), colorScheme.getLightColor());
        gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
        BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getUltraLightColor(), colorScheme.getUltraLightColor(), gradColors);
        BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
        for (int col = 0; col < width; ++col) {
            graphics.drawImage((Image)verLine, col, 0, null);
        }
        if (hasDarkBorder) {
            graphics.setColor(colorScheme.getMidColor());
            graphics.drawLine(0, 0, width, 0);
            graphics.drawLine(0, 0, 0, height);
            graphics.drawLine(0, height - 1, width, height - 1);
            graphics.drawLine(width - 1, 0, width - 1, height);
        }
        return image;
    }

    private static void addSpot(BufferedImage image, int spotCenter, int spotRadius, Color spotColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int spotColorRGB = spotColor.getRGB();
        int darkR = spotColorRGB >>> 16 & 0xFF;
        int darkG = spotColorRGB >>> 8 & 0xFF;
        int darkB = spotColorRGB >>> 0 & 0xFF;
        int sr2 = spotRadius * spotRadius;
        int xc = spotCenter - spotRadius;
        int xe = spotCenter + spotRadius;
        xc = Math.max(0, xc);
        xe = Math.min(width - 1, xe);
        for (int x = xc + 2; x <= xe - 2; ++x) {
            int dx = x - spotCenter;
            int dx2 = dx * dx;
            for (int y = 0; y < height; ++y) {
                int dy = y - spotRadius;
                int dy2 = dy * dy;
                double coef = (double)(dx2 + dy2) / (1.5 * (double)sr2);
                coef = Math.min(1.0, coef);
                coef = 1.0 - coef;
                if (dy < 0) {
                    coef *= coef;
                }
                coef *= coef;
                coef *= 0.24;
                int color = image.getRGB(x, y);
                int transp = color >>> 24 & 0xFF;
                int oldR = color >>> 16 & 0xFF;
                int oldG = color >>> 8 & 0xFF;
                int oldB = color >>> 0 & 0xFF;
                int newR = oldR + (int)(coef * (double)(darkR - oldR));
                int newG = oldG + (int)(coef * (double)(darkG - oldG));
                int newB = oldB + (int)(coef * (double)(darkB - oldB));
                int newColor = transp << 24 | newR << 16 | newG << 8 | newB;
                image.setRGB(x, y, newColor);
            }
        }
    }

    public static BufferedImage getRectangularSpottedBackground(int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasSpots, BufferedImage stripeImage, int stripeOffset) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
        gradColors.put((int)(0.2 * (double)height), colorScheme.getLightColor());
        gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
        gradColors.put((int)(0.8 * (double)height), colorScheme.getLightColor());
        BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getDarkColor(), colorScheme.getDarkColor(), gradColors);
        BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
        for (int col = 0; col < width; ++col) {
            graphics.drawImage((Image)verLine, col, 0, null);
        }
        Color spotColor = colorScheme.getDarkColor();
        int spotRadius = height / 2;
        if (hasSpots && stripeImage == null) {
            int spotCount = 1 + width / height;
            for (int spot = 0; spot < spotCount; ++spot) {
                int spotCenter = spot * height + spotRadius;
                SubstanceImageCreator.addSpot(image, spotCenter, spotRadius, spotColor);
            }
        }
        if (stripeImage != null) {
            int stripeWidth = stripeImage.getWidth();
            int stripeSize = stripeImage.getHeight();
            int stripeCount = width / stripeSize;
            stripeOffset %= 2 * stripeSize;
            for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                int stripePos = stripe * stripeSize + stripeOffset;
                int spotCenterX = stripePos + stripeWidth + (2 * stripeSize - stripeWidth) / 2;
                if (hasSpots) {
                    SubstanceImageCreator.addSpot(image, spotCenterX, spotRadius, spotColor);
                }
                for (int x = 0; x < stripeWidth; ++x) {
                    int xReal = x + stripePos;
                    if (xReal < 0 || xReal >= width) continue;
                    for (int y = 0; y < height; ++y) {
                        int color = image.getRGB(xReal, y);
                        int transp = color >>> 24 & 0xFF;
                        int r = color >>> 16 & 0xFF;
                        int g = color >>> 8 & 0xFF;
                        int b = color >>> 0 & 0xFF;
                        int stripeTransp = stripeImage.getRGB(x, y) >>> 24 & 0xFF;
                        int newTransp = transp * (255 - stripeTransp) / 255;
                        int newColor = newTransp << 24 | r << 16 | g << 8 | b;
                        image.setRGB(xReal, y, newColor);
                    }
                }
            }
        }
        return image;
    }

    public static BufferedImage getStripe(int baseSize) {
        int width = (int)(1.8 * (double)baseSize);
        int height = baseSize;
        BufferedImage result = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(width - 1 - baseSize, 0);
        polygon.addPoint(width - 1, height - 1);
        polygon.addPoint(baseSize, height - 1);
        graphics.setColor(Color.white);
        graphics.fillPolygon(polygon);
        graphics.drawPolygon(polygon);
        float[] BLUR = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.3f, 0.1f, 0.1f, 0.1f, 0.1f};
        ConvolveOp vBlurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurred = vBlurOp.filter(result, null);
        return blurred;
    }

    public static BufferedImage getDragImage(int width, int height) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        int bumpCellSize = 4;
        int bumpRows = height / bumpCellSize;
        int bumpColumns = (width - 2) / bumpCellSize;
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            boolean isEvenCol = col % 2 == 0;
            int offsetY = isEvenCol ? 0 : 2;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = offsetY + bumpRowOffset + row * bumpCellSize;
                graphics.setColor(colorScheme.getLightColor());
                graphics.fillOval(cx + 1, cy + 1, 2, 2);
                graphics.setColor(colorScheme.getDarkColor());
                graphics.fillOval(cx, cy, 2, 2);
            }
        }
        return result;
    }

    public static BufferedImage getTreeIcon(boolean isCollapsed) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(10, 10);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Polygon pol = new Polygon();
        pol.addPoint(2, 1);
        pol.addPoint(8, 1);
        pol.addPoint(9, 2);
        pol.addPoint(9, 8);
        pol.addPoint(8, 9);
        pol.addPoint(2, 9);
        pol.addPoint(1, 8);
        pol.addPoint(1, 2);
        ColorScheme colorScheme = ColorSchemeEnum.METALLIC.getColorScheme();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 9.0f, 9.0f, colorScheme.getLightColor()));
        graphics.fillPolygon(pol);
        graphics.setColor(colorScheme.getMidColor());
        graphics.drawPolygon(pol);
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawLine(3, 5, 7, 5);
        if (isCollapsed) {
            graphics.drawLine(5, 3, 5, 7);
        }
        return result;
    }

    public static BufferedImage getTreeNodeIcon(TreeIcon treeIconKind) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        Polygon backFolder = new Polygon();
        backFolder.addPoint(2, 3);
        backFolder.addPoint(7, 3);
        backFolder.addPoint(8, 4);
        backFolder.addPoint(14, 4);
        backFolder.addPoint(15, 5);
        backFolder.addPoint(15, 13);
        backFolder.addPoint(14, 14);
        backFolder.addPoint(2, 14);
        backFolder.addPoint(1, 13);
        backFolder.addPoint(1, 4);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillPolygon(backFolder);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawPolygon(backFolder);
        switch (treeIconKind) {
            case CLOSED: {
                Polygon closedFolder = new Polygon();
                closedFolder.addPoint(1, 8);
                closedFolder.addPoint(9, 8);
                closedFolder.addPoint(10, 7);
                closedFolder.addPoint(15, 7);
                closedFolder.addPoint(15, 13);
                closedFolder.addPoint(14, 14);
                closedFolder.addPoint(2, 14);
                closedFolder.addPoint(1, 13);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getLightColor(), 15.0f, 0.0f, colorScheme.getMidColor()));
                graphics.fillPolygon(closedFolder);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 15.0f, 15.0f, colorScheme.getUltraDarkColor()));
                graphics.drawPolygon(closedFolder);
                break;
            }
            case OPENED: {
                Polygon openedFolder = new Polygon();
                openedFolder.addPoint(2, 13);
                openedFolder.addPoint(5, 7);
                openedFolder.addPoint(11, 7);
                openedFolder.addPoint(12, 8);
                openedFolder.addPoint(17, 8);
                openedFolder.addPoint(14, 14);
                openedFolder.addPoint(2, 14);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getLightColor(), 15.0f, 0.0f, colorScheme.getMidColor()));
                graphics.fillPolygon(openedFolder);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 15.0f, 15.0f, colorScheme.getUltraDarkColor()));
                graphics.drawPolygon(openedFolder);
                break;
            }
            case UP: {
                Polygon arrow = new Polygon();
                arrow.addPoint(6, 14);
                arrow.addPoint(6, 10);
                arrow.addPoint(5, 10);
                arrow.addPoint(8, 7);
                arrow.addPoint(11, 10);
                arrow.addPoint(10, 10);
                arrow.addPoint(10, 14);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 15.0f, 0.0f, colorScheme.getUltraLightColor()));
                graphics.fillPolygon(arrow);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 15.0f, 15.0f, colorScheme.getUltraDarkColor()));
                graphics.drawPolygon(arrow);
                break;
            }
            case NONE: {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setStroke(new BasicStroke(1.2f));
                graphics.drawLine(5, 9, 11, 9);
                graphics.drawLine(8, 6, 8, 12);
                graphics.drawLine(6, 7, 10, 11);
                graphics.drawLine(6, 11, 10, 7);
            }
        }
        return result;
    }

    public static BufferedImage getTreeLeafIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(16, 20);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        Polygon polygon = new Polygon();
        polygon.addPoint(13, 8);
        polygon.addPoint(13, 16);
        polygon.addPoint(12, 17);
        polygon.addPoint(3, 17);
        polygon.addPoint(2, 16);
        polygon.addPoint(2, 3);
        polygon.addPoint(3, 2);
        polygon.addPoint(9, 2);
        polygon.addPoint(13, 8);
        polygon.addPoint(6, 5);
        polygon.addPoint(9, 2);
        graphics.setClip(2, 2, 12, 16);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillPolygon(polygon);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawPolygon(polygon);
        return result;
    }

    public static BufferedImage getHomeIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        Polygon outline = new Polygon();
        outline.addPoint(4, 16);
        outline.addPoint(4, 8);
        outline.addPoint(9, 2);
        outline.addPoint(12, 6);
        outline.addPoint(12, 2);
        outline.addPoint(14, 2);
        outline.addPoint(14, 16);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillPolygon(outline);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawPolygon(outline);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawLine(3, 9, 9, 2);
        graphics.drawLine(9, 2, 15, 9);
        graphics.setStroke(new BasicStroke(1.2f));
        graphics.drawLine(7, 16, 7, 10);
        graphics.drawLine(7, 10, 11, 10);
        graphics.drawLine(11, 16, 11, 10);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.drawRect(8, 6, 2, 2);
        return result;
    }

    public static BufferedImage getComputerIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRect(1, 4, 4, 11);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawRect(1, 4, 4, 11);
        graphics.drawLine(2, 6, 4, 6);
        graphics.drawLine(2, 8, 4, 8);
        graphics.drawLine(3, 12, 3, 12);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRoundRect(8, 4, 9, 8, 2, 2);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawRoundRect(7, 4, 9, 8, 2, 2);
        graphics.drawRoundRect(9, 6, 5, 4, 2, 2);
        graphics.fillRect(11, 12, 2, 3);
        graphics.drawLine(9, 15, 14, 15);
        float[] BLUR = new float[]{0.03f, 0.03f, 0.03f, 0.03f, 0.86f, 0.03f, 0.03f, 0.03f, 0.03f};
        ConvolveOp vBlurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurred = vBlurOp.filter(result, null);
        return blurred;
    }

    public static BufferedImage getDiskIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRect(3, 4, 10, 10);
        graphics.fillArc(3, 2, 10, 4, 0, 180);
        graphics.fillArc(3, 12, 10, 4, 180, 180);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawOval(3, 2, 10, 4);
        graphics.drawArc(3, 12, 10, 4, 180, 180);
        graphics.drawArc(3, 9, 10, 4, 180, 180);
        graphics.drawArc(3, 6, 10, 4, 180, 180);
        graphics.drawLine(3, 4, 3, 14);
        graphics.drawLine(13, 4, 13, 14);
        return result;
    }

    public static BufferedImage getFloppyIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon outline = new Polygon();
        outline.addPoint(3, 3);
        outline.addPoint(13, 3);
        outline.addPoint(14, 4);
        outline.addPoint(14, 15);
        outline.addPoint(2, 15);
        outline.addPoint(2, 4);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillPolygon(outline);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawPolygon(outline);
        graphics.drawRect(5, 3, 6, 3);
        graphics.fillRect(9, 3, 3, 3);
        graphics.drawRect(4, 9, 8, 6);
        graphics.drawLine(6, 11, 10, 11);
        graphics.drawLine(6, 13, 10, 13);
        return result;
    }

    public static BufferedImage getLonghornProgressBar(int width, int height, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getRectangularBackground(width, height, colorSchemeEnum, true);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        int startY = (int)Math.floor(0.45 * (double)height);
        int endY = (int)Math.ceil(0.67 * (double)height);
        Color ud = colorScheme.getMidColor();
        int rUd = ud.getRed();
        int gUd = ud.getGreen();
        int bUd = ud.getBlue();
        int tUd = 255;
        int xs = (int)(0.1 * (double)(width - 2));
        int xe = (int)(0.9 * (double)(width - 2));
        int fx = (width - 2) / 2 - xs + 1;
        int dfx = fx / 4;
        for (int y = startY; y < endY; ++y) {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put(xs, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
            gradColors.put(xe, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
            int dx = dfx + (y - startY) * (fx - dfx) / (endY - startY);
            gradColors.put(xs + dx, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
            gradColors.put(xe - dx, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(width, new Color(rUd, gUd, bUd, tUd), new Color(rUd, gUd, bUd, tUd), gradColors);
            graphics.drawImage((Image)horLine, 0, y, null);
        }
        return image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TreeIcon {
        CLOSED,
        OPENED,
        UP,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT{

            public Side getAdjacentSide() {
                return TOP;
            }
        }
        ,
        RIGHT{

            public Side getAdjacentSide() {
                return BOTTOM;
            }
        }
        ,
        TOP{

            public Side getAdjacentSide() {
                return RIGHT;
            }
        }
        ,
        BOTTOM{

            public Side getAdjacentSide() {
                return LEFT;
            }
        };


        public abstract Side getAdjacentSide();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

