/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceCheckBoxUI;
import org.jvnet.substance.SubstanceDropShadowBorder;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceProgressBarUI;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.color.ColorSchemeEnum;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceBrownTheme;
import org.jvnet.substance.theme.SubstanceLimeGreenTheme;
import org.jvnet.substance.theme.SubstanceOrangeTheme;
import org.jvnet.substance.theme.SubstancePurpleTheme;
import org.jvnet.substance.theme.SubstanceTheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceLookAndFeel
extends MetalLookAndFeel {
    public SubstanceLookAndFeel() {
        String paramTheme = null;
        try {
            paramTheme = System.getProperty("substancelaf.theme");
        }
        catch (Exception exc) {
            // empty catch block
        }
        boolean isSet = false;
        if (paramTheme != null) {
            isSet = SubstanceLookAndFeel.setCurrentTheme(paramTheme);
        }
        if (!isSet) {
            SubstanceLookAndFeel.setCurrentTheme(new SubstanceAquaTheme());
        }
    }

    static ColorSchemeEnum getColorScheme() {
        MetalTheme theme = MetalLookAndFeel.getCurrentTheme();
        if (!(theme instanceof SubstanceTheme)) {
            return ColorSchemeEnum.AQUA;
        }
        return ((SubstanceTheme)theme).getColorSchemeEnum();
    }

    public static boolean setCurrentTheme(String themeClassName) {
        try {
            Class<?> themeClass = Class.forName(themeClassName);
            if (themeClass == null) {
                return false;
            }
            Object obj = themeClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceTheme)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentTheme(SubstanceTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        SubstanceIconFactory.reset();
        SubstanceBackgroundDelegate.reset();
        SubstanceBorder.reset();
        SubstanceCheckBoxUI.reset();
        SubstanceDropShadowBorder.reset();
        SubstanceGradientBackgroundDelegate.reset();
        SubstanceProgressBarUI.reset();
        SubstanceRadioButtonUI.reset();
        SubstanceScrollBarUI.reset();
        SubstanceTabbedPaneUI.reset();
        return true;
    }

    public static String getCurrentThemeName() {
        return SubstanceLookAndFeel.getColorScheme().name();
    }

    public static Map<String, String> enumerateThemes() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ColorSchemeEnum.AQUA.name(), SubstanceAquaTheme.class.getName());
        result.put(ColorSchemeEnum.LIME_GREEN.name(), SubstanceLimeGreenTheme.class.getName());
        result.put(ColorSchemeEnum.BROWN.name(), SubstanceBrownTheme.class.getName());
        result.put(ColorSchemeEnum.ORANGE.name(), SubstanceOrangeTheme.class.getName());
        result.put(ColorSchemeEnum.PURPLE.name(), SubstancePurpleTheme.class.getName());
        return result;
    }

    @Override
    public String getDescription() {
        return "Substance look and feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return "Substance";
    }

    @Override
    public String getName() {
        return "Substance";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String UI_CLASSNAME_PREFIX = "org.jvnet.substance.Substance";
        Object[] uiDefaults = new Object[]{"PanelUI", UI_CLASSNAME_PREFIX + "PanelUI", "InternalFrameUI", UI_CLASSNAME_PREFIX + "InternalFrameUI", "CheckBoxUI", UI_CLASSNAME_PREFIX + "CheckBoxUI", "RadioButtonUI", UI_CLASSNAME_PREFIX + "RadioButtonUI", "FileChooserUI", UI_CLASSNAME_PREFIX + "FileChooserUI", "ButtonUI", UI_CLASSNAME_PREFIX + "ButtonUI", "ToggleButtonUI", UI_CLASSNAME_PREFIX + "ToggleButtonUI", "RootPaneUI", UI_CLASSNAME_PREFIX + "RootPaneUI", "TabbedPaneUI", UI_CLASSNAME_PREFIX + "TabbedPaneUI", "ScrollBarUI", UI_CLASSNAME_PREFIX + "ScrollBarUI", "SplitPaneUI", UI_CLASSNAME_PREFIX + "SplitPaneUI", "MenuUI", UI_CLASSNAME_PREFIX + "MenuUI", "MenuItemUI", UI_CLASSNAME_PREFIX + "MenuItemUI", "CheckBoxMenuItemUI", UI_CLASSNAME_PREFIX + "CheckBoxMenuItemUI", "RadioButtonMenuItemUI", UI_CLASSNAME_PREFIX + "RadioButtonMenuItemUI", "OptionPaneUI", UI_CLASSNAME_PREFIX + "OptionPaneUI", "PasswordFieldUI", UI_CLASSNAME_PREFIX + "PasswordFieldUI", "TableHeaderUI", UI_CLASSNAME_PREFIX + "TableHeaderUI", "ListUI", UI_CLASSNAME_PREFIX + "ListUI", "SliderUI", UI_CLASSNAME_PREFIX + "SliderUI", "ProgressBarUI", UI_CLASSNAME_PREFIX + "ProgressBarUI", "DesktopIconUI", UI_CLASSNAME_PREFIX + "DesktopIconUI", "SpinnerUI", UI_CLASSNAME_PREFIX + "SpinnerUI", "ToolTipUI", UI_CLASSNAME_PREFIX + "ToolTipUI", "ToolBarUI", UI_CLASSNAME_PREFIX + "ToolBarUI", "TextFieldUI", UI_CLASSNAME_PREFIX + "TextFieldUI", "TextAreaUI", UI_CLASSNAME_PREFIX + "TextAreaUI", "TextPaneUI", UI_CLASSNAME_PREFIX + "TextPaneUI", "ComboBoxUI", UI_CLASSNAME_PREFIX + "ComboBoxUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Object[] defaults = new Object[]{"OptionPane.errorIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/Error.png"), "OptionPane.informationIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/Inform.png"), "OptionPane.warningIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/Warn.png"), "OptionPane.questionIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/Question.png"), "FileView.computerIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/Computer.gif"), "FileView.directoryIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "FileView.fileIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/File.gif"), "FileView.floppyDriveIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.gif"), "FileView.hardDriveIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.gif"), "FileChooser.homeFolderIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.gif"), "FileChooser.newFolderIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.gif"), "FileChooser.upFolderIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.gif"), "Tree.closedIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "Tree.openIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.gif"), "Tree.leafIcon", SubstanceLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.gif")};
        table.putDefaults(defaults);
        Font tahomaFont = new Font("Tahoma", 0, 11);
        Font tahomaBigFont = new Font("Tahoma", 0, 12);
        if (tahomaFont != null) {
            Object[] fontDefaults = new Object[]{"Button.font", tahomaFont, "CheckBox.font", tahomaFont, "ColorChooser.font", tahomaFont, "ComboBox.font", tahomaFont, "EditorPane.font", tahomaFont, "FormattedTextField.font", tahomaFont, "Label.font", tahomaFont, "List.font", tahomaFont, "Panel.font", tahomaFont, "PasswordField.font", tahomaFont, "ProgressBar.font", tahomaFont, "RadioButton.font", tahomaFont, "ScrollPane.font", tahomaFont, "Spinner.font", tahomaFont, "TabbedPane.font", tahomaFont, "Table.font", tahomaFont, "TableHeader.font", tahomaFont, "TextField.font", tahomaFont, "TextPane.font", tahomaFont, "ToolBar.font", tahomaFont, "ToggleButton.font", tahomaFont, "Tree.font", tahomaFont, "Viewport.font", tahomaFont, "InternalFrame.titleFont", tahomaBigFont, "OptionPane.font", tahomaFont, "OptionPane.messageFont", tahomaFont, "OptionPane.buttonFont", tahomaFont, "Spinner.font", tahomaFont, "TextArea.font", tahomaFont, "TitledBorder.font", tahomaBigFont, "ToolTip.font", tahomaFont, "CheckBoxMenuItem.font", tahomaFont, "CheckBoxMenuItem.acceleratorFont", tahomaFont, "Menu.font", tahomaFont, "Menu.acceleratorFont", tahomaFont, "MenuBar.font", tahomaFont, "MenuItem.font", tahomaFont, "MenuItem.acceleratorFont", tahomaFont, "PopupMenu.font", tahomaFont, "RadioButtonMenuItem.font", tahomaFont, "RadioButtonMenuItem.acceleratorFont", tahomaFont};
            table.putDefaults(fontDefaults);
        }
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        Icon disIcon = super.getDisabledIcon(component, icon);
        return SubstanceImageCreator.toGreyscale(disIcon);
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        Icon disIcon = super.getDisabledSelectedIcon(component, icon);
        return SubstanceImageCreator.toGreyscale(disIcon);
    }

    @Override
    protected void createDefaultTheme() {
    }
}

