/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceProgressBarUI
extends MetalProgressBarUI {
    private static Map<String, BufferedImage> stripeMap = new HashMap<String, BufferedImage>();
    private int animationIndex;

    static synchronized void reset() {
        stripeMap.clear();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceProgressBarUI();
    }

    private static synchronized BufferedImage getStripe(int baseSize) {
        String key = "" + baseSize;
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getStripe(baseSize);
            stripeMap.put(key, result);
        }
        return result;
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            graphics.drawImage((Image)SubstanceImageCreator.getRectangularSpottedBackground(barRectWidth, barRectHeight + 1, ColorSchemeEnum.LIGHT_GRAY, false, null, 0), b.left, b.top, null);
        } else {
            graphics.drawImage((Image)SubstanceImageCreator.getRotated(SubstanceImageCreator.getRectangularSpottedBackground(barRectHeight, barRectWidth + 1, ColorSchemeEnum.LIGHT_GRAY, false, null, 0), 3), b.left, b.top, null);
        }
        if (amountFull > 0) {
            ColorSchemeEnum fillColorSchemeEnum;
            ColorSchemeEnum colorSchemeEnum = fillColorSchemeEnum = this.progressBar.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
            if (this.progressBar.getOrientation() == 0) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    graphics.drawImage((Image)SubstanceImageCreator.getLonghornProgressBar(amountFull, barRectHeight, fillColorSchemeEnum), b.left, b.top, null);
                } else {
                    graphics.drawImage((Image)SubstanceImageCreator.getLonghornProgressBar(amountFull, barRectHeight, fillColorSchemeEnum), barRectWidth + b.left, b.top, null);
                }
            } else {
                graphics.drawImage((Image)SubstanceImageCreator.getRotated(SubstanceImageCreator.getLonghornProgressBar(amountFull, barRectWidth, fillColorSchemeEnum), 1), b.left, b.top, null);
            }
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        ColorSchemeEnum fillColorSchemeEnum;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int valComplete = this.animationIndex;
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            graphics.drawImage((Image)SubstanceImageCreator.getRectangularSpottedBackground(barRectWidth, barRectHeight + 1, ColorSchemeEnum.LIGHT_GRAY, false, null, 0), b.left, b.top, null);
        } else {
            graphics.drawImage((Image)SubstanceImageCreator.getRotated(SubstanceImageCreator.getRectangularSpottedBackground(barRectHeight, barRectWidth + 1, ColorSchemeEnum.LIGHT_GRAY, false, null, 0), 3), b.left, b.top, null);
        }
        ColorSchemeEnum colorSchemeEnum = fillColorSchemeEnum = this.progressBar.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
        if (this.progressBar.getOrientation() == 0) {
            graphics.drawImage((Image)SubstanceImageCreator.getRectangularSpottedBackground(barRectWidth, barRectHeight + 1, fillColorSchemeEnum, true, SubstanceProgressBarUI.getStripe(barRectHeight + 1), valComplete), b.left, b.top, null);
        } else {
            graphics.drawImage((Image)SubstanceImageCreator.getRotated(SubstanceImageCreator.getRectangularSpottedBackground(barRectHeight, barRectWidth + 1, fillColorSchemeEnum, true, SubstanceProgressBarUI.getStripe(barRectWidth + 1), valComplete), 1), b.left - 1, b.top, null);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, barRectWidth, b);
        }
    }

    protected void incrementAnimationIndex() {
        int newValue = this.animationIndex + 1;
        Insets b = this.progressBar.getInsets();
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int threshold = 0;
        threshold = this.progressBar.getOrientation() == 0 ? 2 * barRectHeight + 1 : 2 * barRectWidth + 1;
        this.animationIndex = newValue % threshold;
        this.progressBar.repaint();
    }
}

