/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Insets;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JSpinner;
import org.jvnet.substance.SubstanceImageCreator;

public class SubstanceSpinnerButton
extends JButton {
    private int orientation;

    public SubstanceSpinnerButton(JSpinner spinner, Icon spinnerIcon, int orientation) {
        this.setModel(new DefaultButtonModel(){

            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.setEnabled(spinner.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(0, 0, 0, 2));
        this.setBorder(null);
        this.orientation = orientation;
        this.setIcon(spinnerIcon);
        this.setDisabledIcon(SubstanceImageCreator.makeTransparent(spinnerIcon, 0.8));
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public SubstanceImageCreator.Side getSide() {
        switch (this.orientation) {
            case 1: {
                return SubstanceImageCreator.Side.BOTTOM;
            }
            case 7: {
                return SubstanceImageCreator.Side.RIGHT;
            }
            case 5: {
                return SubstanceImageCreator.Side.TOP;
            }
            case 3: {
                return SubstanceImageCreator.Side.LEFT;
            }
        }
        return null;
    }
}

