/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceSplitPaneDivider
extends BasicSplitPaneDivider {
    private int inset = 2;

    public SubstanceSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
    }

    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Insets insets = this.getInsets();
        g.setColor(ColorSchemeEnum.METALLIC.getColorScheme().getExtraLightColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        Dimension size = this.getSize();
        size.width -= this.inset * 2;
        size.height -= this.inset * 2;
        int drawX = this.inset;
        int drawY = this.inset;
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            drawX += insets.left;
            drawY += insets.top;
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){
            Icon verticalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 1);
            Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 7);

            public void setBorder(Border b) {
            }

            public void paint(Graphics g) {
                JSplitPane splitPane = SubstanceSplitPaneDivider.this.getSplitPaneFromSuper();
                if (splitPane != null) {
                    int orientation = SubstanceSplitPaneDivider.this.getOrientationFromSuper();
                    if (orientation == 0) {
                        this.verticalSplit.paintIcon(splitPane, g, 1, 1);
                    } else {
                        this.horizontalSplit.paintIcon(splitPane, g, 1, 1);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setOpaque(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){
            Icon verticalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 5);
            Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 3);

            public void setBorder(Border border) {
            }

            public void paint(Graphics g) {
                JSplitPane splitPane = SubstanceSplitPaneDivider.this.getSplitPaneFromSuper();
                if (splitPane != null) {
                    int orientation = SubstanceSplitPaneDivider.this.getOrientationFromSuper();
                    if (orientation == 0) {
                        this.verticalSplit.paintIcon(splitPane, g, 1, 1);
                    } else {
                        this.horizontalSplit.paintIcon(splitPane, g, 1, 1);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        b.setOpaque(false);
        return b;
    }

    private int getOrientationFromSuper() {
        return this.orientation;
    }

    private JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }
}

