/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import org.jvnet.substance.RolloverButtonListener;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.Utilities;

public class SubstanceToggleButtonUI
extends MetalToggleButtonUI {
    private static final SubstanceToggleButtonUI INSTANCE = new SubstanceToggleButtonUI();
    private SubstanceBackgroundDelegate delegate = new SubstanceBackgroundDelegate();

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        b.setRolloverEnabled(true);
        return new RolloverButtonListener(b);
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        this.delegate.updateBackground(g, button, 0L);
        this.paint(g, c);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (!model.isEnabled() && model.isSelected()) {
            JComponent jComponent = c;
            synchronized (jComponent) {
                Color oldBack = b.getBackground();
                b.setBackground(this.disabledTextColor);
                super.paintText(g, c, textRect, text);
                b.setBackground(oldBack);
            }
        } else {
            super.paintText(g, c, textRect, text);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension baseDimension;
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        AbstractButton button = (AbstractButton)c;
        Icon icon = button.getIcon();
        boolean hasIcon = Utilities.hasIcon(button);
        boolean hasText = Utilities.hasText(button);
        Dimension result = baseDimension = super.getPreferredSize(c);
        if (hasText) {
            int baseWidth = baseDimension.width;
            if (baseWidth < 70) {
                baseWidth = 70;
            }
            result = new Dimension(baseWidth, baseDimension.height);
            int baseHeight = result.height;
            if (baseHeight < 20) {
                baseHeight = 20;
            }
            result = new Dimension(result.width, baseHeight);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - 6.0) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - 6.0) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (Utilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + 6, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + 6);
        }
        return result;
    }
}

