/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.MessageStatus;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLayerToProjectController
implements ChangeListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddLayerToProjectController.class);
    public static final int MODE_DO_NOTHING = 0;
    public static final int MODE_ADD_LAYER = 1;
    public static final int MODE_ADD_TABLE = 2;
    private final JRadioButton rdbDontAddToProject;
    private final JRadioButton rdbAddLayerToView;
    private final JRadioButton rdbAddTableToProject;
    private final JComboBox cboView;
    private MessageStatus message;
    private final ChangeListenerHelper changeListenerHelper;

    public AddLayerToProjectController(JRadioButton rdbDontAddToProject, JRadioButton rdbAddLayerToView, JRadioButton rdbAddTableToProject, JComboBox cboView, MessageStatus message) {
        this.cboView = cboView;
        this.rdbAddLayerToView = rdbAddLayerToView;
        this.rdbAddTableToProject = rdbAddTableToProject;
        this.rdbDontAddToProject = rdbDontAddToProject;
        this.message = message;
        this.changeListenerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.initComponents();
    }

    private void initComponents() {
        OnlineSwingServices onlineServices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        ComboBoxModel viewDocumentsModel = onlineServices.getViewDocumentsComboBoxModel();
        this.cboView.setModel(viewDocumentsModel);
        this.cboView.addActionListener(e -> this.changeListenerHelper.fireEvent());
        this.rdbDontAddToProject.addActionListener(e -> {
            this.doUpdateComponents();
            this.changeListenerHelper.fireEvent();
        });
        this.rdbAddLayerToView.addActionListener(e -> {
            this.doUpdateComponents();
            this.changeListenerHelper.fireEvent();
        });
        this.rdbAddTableToProject.addActionListener(e -> {
            this.doUpdateComponents();
            this.changeListenerHelper.fireEvent();
        });
        this.rdbDontAddToProject.setSelected(true);
    }

    private void doUpdateComponents() {
        this.cboView.setEnabled(this.rdbAddLayerToView.isSelected());
    }

    public void setEnabled(List<OnlineLayer> layers) {
        OnlineSwingServices onlineServices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        IProjection layersProjection = this.getLayersProjection(layers);
        LabeledValue mapControl = onlineServices.getActiveMapControl();
        if (layersProjection == null || mapControl == null || mapControl.getValue() == null || !Objects.equals(((MapControl)mapControl.getValue()).getProjection(), layersProjection)) {
            this.rdbDontAddToProject.setSelected(true);
            this.rdbAddLayerToView.setSelected(false);
            this.rdbAddTableToProject.setSelected(false);
            this.rdbDontAddToProject.setEnabled(true);
            this.rdbAddLayerToView.setEnabled(false);
            this.rdbAddTableToProject.setEnabled(false);
            this.cboView.setEnabled(false);
            return;
        }
        this.rdbDontAddToProject.setEnabled(true);
        this.rdbAddLayerToView.setEnabled(true);
        this.rdbAddTableToProject.setEnabled(true);
        this.cboView.setEnabled(true);
    }

    private IProjection getLayersProjection(List<OnlineLayer> layers) {
        if (layers == null) {
            return null;
        }
        IProjection proj = null;
        for (OnlineLayer layer : layers) {
            IProjection curproj = layer.getProjection();
            if (proj == null) {
                proj = curproj;
                continue;
            }
            if (proj.equals(curproj)) continue;
            return null;
        }
        return proj;
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListenerHelper.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListenerHelper.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    public int getMode() {
        if (this.rdbAddLayerToView.isSelected()) {
            return 1;
        }
        if (this.rdbAddTableToProject.isSelected()) {
            return 0;
        }
        return 0;
    }

    public LabeledValue getView() {
        return (LabeledValue)this.cboView.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void process(OnlineWorkingcopy ws, OnlineLayer layer) {
        services = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        store = null;
        switch (this.getMode()) {
            case 1: {
                try {
                    store = ws.openFeatureStore(layer.getName(), false);
                    view = this.getView();
                    if (view == null) ** GOTO lbl11
                    layerName = layer.getLabel();
                    services.addLayerToView(store, view, null, layerName, false);
                }
                catch (Exception ex) {
                    try {
                        AddLayerToProjectController.LOGGER.warn("Can't add table +'" + layer.getName() + "' to project", (Throwable)ex);
                    }
                    catch (Throwable var7_9) {
                        DisposeUtils.disposeQuietly(store);
                        throw var7_9;
                    }
                    DisposeUtils.disposeQuietly((Disposable)store);
                    break;
                }
lbl11:
                // 2 sources

                DisposeUtils.disposeQuietly((Disposable)store);
                break;
            }
            case 2: {
                try {
                    store = ws.openFeatureStore(layer.getName(), false);
                    services.addTableToProject(ws, store);
                }
                catch (Exception ex) {
                    try {
                        AddLayerToProjectController.LOGGER.warn("Can't add table +'" + layer.getName() + "' to project", (Throwable)ex);
                    }
                    catch (Throwable var8_10) {
                        DisposeUtils.disposeQuietly(store);
                        throw var8_10;
                    }
                    DisposeUtils.disposeQuietly((Disposable)store);
                    break;
                }
                DisposeUtils.disposeQuietly((Disposable)store);
                break;
            }
        }
    }
}

