/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.online.swing.api.MessageStatus;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;

public class MessageStatusImpl
implements MessageStatus {
    private final Timer timerClearMsg;
    private final JLabel lblMessages;
    private final JLabel lblCaption;
    private final JProgressBar pbStatus;
    private final TaskStatusController taskStatusController;

    public MessageStatusImpl(JLabel lblCaption, JProgressBar pbStatus, JLabel lblMessages) {
        this.lblMessages = lblMessages;
        this.lblCaption = lblCaption;
        this.pbStatus = pbStatus;
        this.timerClearMsg = new Timer(20000, e -> this.clear());
        this.timerClearMsg.setRepeats(false);
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblCaption, this.lblMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        SwingUtilities.invokeLater(() -> this.setVisible(false));
    }

    public void clear() {
        this.lblMessages.setText("");
    }

    public void alert(boolean doAlert, String s) {
        if (doAlert) {
            this.alert(s);
        }
    }

    public void alert(String msg) {
        if (StringUtils.startsWith((CharSequence)msg, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            msg = i18n.getTranslation(msg);
        }
        this.message(OnlineSwingCommons.getHTMLColorTag(Color.red.darker(), msg));
    }

    public void message(boolean doMessage, String s) {
        if (doMessage) {
            this.message(s);
        }
    }

    public void message(String msg) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.message(msg))) {
            return;
        }
        String message = msg;
        this.timerClearMsg.stop();
        if (StringUtils.startsWith((CharSequence)message, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            message = i18n.getTranslation(message);
        }
        this.lblMessages.setVisible(true);
        this.lblMessages.setText(message);
        this.timerClearMsg.start();
    }

    public void setVisible(boolean visible) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisible(visible))) {
            return;
        }
        this.lblCaption.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblMessages.setVisible(true);
    }

    public SimpleTaskStatus createTaskStatus(String title) {
        if (StringUtils.startsWith((CharSequence)title, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            title = i18n.getTranslation(title);
        }
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(title);
        this.taskStatusController.bind((TaskStatus)status);
        return status;
    }
}

