/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.net.URISyntaxException;
import java.net.URL;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSMUtils.class);
    private static final String FIELD_URI = "uri";
    private static final String FIELD_SUFFIX = "suffix";
    private static final String FIELD_MAX_RES_LEVEL = "maxResolutionLevel";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PARAMETERS = "parameters";
    private static final String FIELD_DELETECACHE = "deletecache";

    public static FLayer createOSMLayer() {
        try {
            DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
            DataStoreParameters parameters = dataman.createStoreParameters("OSM Raster");
            URL selectedURL = new URL("https://tile.openstreetmap.org/");
            try {
                parameters.setDynValue(FIELD_URI, (Object)selectedURL.toURI());
            }
            catch (URISyntaxException e1) {
                LOGGER.warn("Can't convert URI from " + selectedURL.toString(), (Throwable)e1);
                throw new InitializeException((Throwable)e1);
            }
            parameters.setDynValue(FIELD_SUFFIX, (Object)"png");
            parameters.setDynValue(FIELD_NAME, (Object)"Mapnik");
            try {
                parameters.setDynValue(FIELD_MAX_RES_LEVEL, (Object)18);
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            DataStoreParameters tileParams = dataman.createStoreParameters("Tile Store");
            tileParams.setDynValue(FIELD_PARAMETERS, (Object)parameters);
            tileParams.setDynValue(FIELD_DELETECACHE, (Object)false);
            DataStore store = dataman.openStore("Tile Store", tileParams);
            MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
            FLayer layer = mapContextManager.createLayer("Mapnik", store);
            return layer;
        }
        catch (Throwable ex) {
            LOGGER.warn("Can't create OSM layer", ex);
            return null;
        }
    }
}

