/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineEntitySelectorController;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineEntitySelectorControllerJComboBox
extends AbstractDisposable
implements OnlineEntitySelectorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineEntitySelectorControllerJComboBox.class);
    private final JComboBox cboTables;
    private final ActionListenerSupport actionListeners;
    private final ChangeListenerHelper changeListeners;
    private OnlineWorkingcopy workingcopy;
    private boolean processing;
    private boolean enabled;
    private ArrayList<OnlineEntity> entities;
    private Predicate<OnlineEntity> viewFilter;
    private Predicate<OnlineEntity> filter;
    private Thread lastThread;
    private Function<OnlineEntity, String> labelEntityFormatter;

    public OnlineEntitySelectorControllerJComboBox(JComboBox cboTables) {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.viewFilter = ALL_ENTITIES;
        this.filter = ALL_ENTITIES;
        this.cboTables = cboTables;
        this.processing = false;
        this.actionListeners = toolsSwingManager.createActionListenerSupport();
        this.changeListeners = toolsSwingManager.createChangeListenerHelper();
        this.initComponents();
    }

    private void initComponents() {
        this.cboTables.addItemListener(new ItemListener(){
            boolean alreadyInEvent = false;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        this.alreadyInEvent = true;
                        OnlineEntitySelectorControllerJComboBox.this.fireChangeEvent();
                        OnlineEntitySelectorControllerJComboBox.this.fireActionEvent(new ActionEvent(this, 0, "select"));
                    }
                    finally {
                        this.alreadyInEvent = false;
                    }
                }
            }
        });
        this.cboTables.setRenderer(new ListCellRenderer(){
            JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof OnlineEntity && OnlineEntitySelectorControllerJComboBox.this.workingcopy != null) {
                    this.label.setText(OnlineEntitySelectorControllerJComboBox.this.workingcopy.formatEntityLabel((OnlineEntity)value));
                } else {
                    this.label.setText(Objects.toString(value, null));
                }
                return this.label;
            }
        });
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public OnlineEntity getSelectedEntity() {
        if (this.workingcopy == null) {
            return null;
        }
        LabeledValue selected = (LabeledValue)this.cboTables.getSelectedItem();
        if (selected == null) {
            return null;
        }
        OnlineEntity entity = (OnlineEntity)selected.getValue();
        if (!this.filter.test(entity)) {
            return null;
        }
        return entity;
    }

    public void setSelectedEntity(OnlineEntity entity) {
        if (this.workingcopy == null) {
            return;
        }
        ComboBoxModel model = this.cboTables.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            OnlineEntity value = (OnlineEntity)((LabeledValue)model.getElementAt(i)).getValue();
            if (!StringUtils.equals((CharSequence)entity.getEntityCode(), (CharSequence)value.getEntityCode())) continue;
            this.cboTables.setSelectedIndex(i);
            return;
        }
    }

    public List<OnlineEntity> getCheckedEntities() {
        return Collections.EMPTY_LIST;
    }

    public void setWorkspace(OnlineWorkingcopy workspace) {
        DisposeUtils.disposeQuietly((Disposable)workspace);
        this.workingcopy = workspace;
        DisposeUtils.bind((Disposable)this.workingcopy);
        this.reloadEntities();
    }

    public OnlineWorkingcopy getWorkspace() {
        return this.workingcopy;
    }

    public void reloadEntities() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.cboTables.setModel(model);
        if (this.workingcopy == null) {
            return;
        }
        Thread task = new Thread(() -> this.reloadTables(this.workingcopy), "OnlineEntitySelectorComboReloadEntities");
        task.start();
        this.lastThread = task;
    }

    private boolean isCancelled() {
        return Thread.currentThread() != this.lastThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTables(OnlineWorkingcopy workspace) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            this.fireActionEvent(new ActionEvent((Object)this, 3, "begin_processing"));
            this.processing = true;
            this.doUpdateComponents();
            ArrayList<LabeledValue<OnlineEntity>> theEntities = new ArrayList<LabeledValue<OnlineEntity>>();
            List localEntities = workspace.getWorkspaceEntities();
            for (OnlineEntity localEntity : localEntities) {
                if (!this.isCancelled()) continue;
                return;
            }
            Collections.sort(theEntities, (o1, o2) -> StringUtils.compareIgnoreCase((String)((OnlineEntity)o1.getValue()).getLabelOrName(), (String)((OnlineEntity)o2.getValue()).getLabelOrName()));
            if (!this.isCancelled()) {
                this.postReloadTables(theEntities);
            }
        }
        catch (Exception e) {
            LOGGER.warn("_Cant_retrieve_entities_from_repository", (Throwable)e);
            if (!this.isCancelled()) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_entities_from_repository") + "\n" + e.getMessage(), i18n.getTranslation("_Online_Checkout"), 2);
            }
        }
        finally {
            if (!this.isCancelled()) {
                this.processing = false;
                this.doUpdateComponents();
                this.fireActionEvent(new ActionEvent((Object)this, 4, "end_processing"));
            }
        }
    }

    private void postReloadTables(List<LabeledValue<OnlineEntity>> entities) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.postReloadTables(entities))) {
            return;
        }
        this.entities = new ArrayList();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(new LabeledValueImpl("", null));
        for (LabeledValue<OnlineEntity> entity : entities) {
            if (entity == null) continue;
            this.entities.add((OnlineEntity)entity.getValue());
            model.addElement(entity);
        }
        this.cboTables.setModel(model);
        this.processing = false;
        this.fireActionEvent(new ActionEvent((Object)this, 2, "reload"));
    }

    public Collection<OnlineEntity> getEntities() {
        return this.entities;
    }

    private void doUpdateComponents() {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        this.cboTables.setEnabled(this.enabled && !this.processing);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.doUpdateComponents();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setChecksEnabled(boolean enabled) {
    }

    public boolean isChecksEnabled() {
        return false;
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.addActionListener(al);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.removeActionListener(al);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent ae) {
        this.actionListeners.fireActionEvent(ae);
    }

    private void fireChangeEvent() {
        this.changeListeners.fireEvent();
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    public void setViewFilter(Predicate<OnlineEntity> viewFilter) {
        this.viewFilter = viewFilter;
        this.reloadEntities();
    }

    public void setFilter(Predicate<OnlineEntity> filter) {
        this.filter = filter;
        this.reloadEntities();
    }

    public void check(OnlineEntity entity) {
    }

    public void unCheck(OnlineEntity entity) {
    }

    public void clearChecks() {
    }

    public void setCheck(Collection<String> entityCodes, boolean check) {
    }

    public void checkAll() {
    }

    public void clear() {
        this.setWorkspace(null);
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workingcopy);
    }

    private String getLabelOfEntity(OnlineEntity entity) {
        if (this.labelEntityFormatter == null) {
            return entity.getLabelOrName();
        }
        return this.labelEntityFormatter.apply(entity);
    }

    public void setLabelEntityFormatter(Function<OnlineEntity, String> formatter) {
        this.labelEntityFormatter = formatter;
    }

    public String getCategory(OnlineEntity entity) {
        String category = entity.getFirstCategory();
        return category;
    }

    public void collapseAll() {
    }

    public void expandAll() {
    }
}

