/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineEntitySelectorController;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineEntitySelectorControllerJList
extends AbstractDisposable
implements OnlineEntitySelectorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineEntitySelectorControllerJList.class);
    private final JTextComponent txtFilter;
    private final JList lstTables;
    private JListWithCheckbox lstTablesWithCheckbox;
    private final JButton btnTable;
    private FilteredListController filteredList;
    private ActionListenerSupport actionListeners;
    private ChangeListenerHelper changeListeners;
    private OnlineWorkingcopy workspace;
    private boolean processing;
    private boolean enabled;
    private Predicate<OnlineEntity> viewFilter = ALL_ENTITIES;
    private Predicate<OnlineEntity> filter = ALL_ENTITIES;
    private JButton btnCheckAll;
    private JButton btnUnCheckAll;
    private ArrayList<OnlineEntity> entities;
    private Thread lastThread;
    private Function<OnlineEntity, String> labelEntityFormatter;

    public OnlineEntitySelectorControllerJList(JList lstTables) {
        this(lstTables, null, null, null, null);
    }

    public OnlineEntitySelectorControllerJList(JList lstTables, JTextComponent txtFilter, JButton btnTable, JButton btnCheckAll, JButton btnUnCheckAll) {
        this.lstTables = lstTables;
        this.lstTablesWithCheckbox = null;
        this.txtFilter = txtFilter == null ? new JTextField() : txtFilter;
        this.btnTable = btnTable == null ? new JButton() : btnTable;
        this.btnCheckAll = btnCheckAll == null ? new JButton() : btnCheckAll;
        this.btnUnCheckAll = btnUnCheckAll == null ? new JButton() : btnUnCheckAll;
        this.lstTables.setCellRenderer(new ListCellRenderer(){
            JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof OnlineEntity && OnlineEntitySelectorControllerJList.this.workspace != null) {
                    this.label.setText(OnlineEntitySelectorControllerJList.this.workspace.formatEntityLabel((OnlineEntity)value));
                } else {
                    this.label.setText(value.toString());
                }
                return this.label;
            }
        });
        this.processing = false;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.actionListeners = toolsSwingManager.createActionListenerSupport();
        this.changeListeners = toolsSwingManager.createChangeListenerHelper();
        this.btnTable.setCursor(Cursor.getPredefinedCursor(12));
        this.lstTables.setSelectionMode(0);
        this.lstTables.addListSelectionListener(new ListSelectionListener(){
            boolean alreadyInEvent = false;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || this.alreadyInEvent) {
                    return;
                }
                try {
                    this.alreadyInEvent = true;
                    OnlineEntitySelectorControllerJList.this.fireActionEvent(new ActionEvent(this, 0, "select"));
                }
                finally {
                    this.alreadyInEvent = false;
                }
            }
        });
        this.btnCheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineEntitySelectorControllerJList.this.checkAll();
            }
        });
        this.btnUnCheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineEntitySelectorControllerJList.this.clearChecks();
            }
        });
        this.lstTables.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                OnlineEntitySelectorControllerJList.this.doMouseMoved(OnlineEntitySelectorControllerJList.this.lstTables.locationToIndex(e.getPoint()));
            }
        });
        this.filteredList = toolsSwingManager.createFilteredListController(this.lstTables, this.txtFilter, this.btnTable);
        this.lstTables.setSelectionMode(0);
    }

    private void doMouseMoved(int rowindex) {
        if (rowindex < 0) {
            return;
        }
        Object x = this.lstTables.getModel().getElementAt(rowindex);
        if (!(x instanceof LabeledValue)) {
            this.lstTables.setToolTipText("");
            return;
        }
        LabeledValue lv = (LabeledValue)x;
        if (lv.getValue() instanceof OnlineEntity) {
            OnlineEntity entity = (OnlineEntity)lv.getValue();
            OnlineEntity lentity = this.workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            String s = OnlineSwingCommons.getStateDescription(lentity == null ? 32 : lentity.getState());
            s = StringUtils.equalsIgnoreCase((CharSequence)entity.getEntityCode(), (CharSequence)entity.getLabel()) ? "<html>" + entity.getLabelOrName() + "<br>" + s + "</html>" : "<html>" + entity.getLabel() + "<br>" + entity.getEntityName() + "<br>" + s + "</html>";
            this.lstTables.setToolTipText(s);
        } else {
            this.lstTables.setToolTipText("");
        }
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public OnlineEntity getSelectedEntity() {
        if (this.workspace == null) {
            return null;
        }
        LabeledValue selected = (LabeledValue)this.lstTables.getSelectedValue();
        if (selected == null) {
            return null;
        }
        OnlineEntity entity = (OnlineEntity)selected.getValue();
        if (!this.filter.test(entity)) {
            return null;
        }
        return entity;
    }

    public void setSelectedEntity(OnlineEntity entity) {
        if (this.workspace == null) {
            return;
        }
        ListModel model = this.lstTables.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            OnlineEntity value = (OnlineEntity)((LabeledValue)model.getElementAt(i)).getValue();
            if (!StringUtils.equals((CharSequence)entity.getEntityCode(), (CharSequence)value.getEntityCode())) continue;
            this.lstTables.setSelectedIndex(i);
            return;
        }
    }

    public List<OnlineEntity> getCheckedEntities() {
        if (this.lstTablesWithCheckbox == null) {
            OnlineEntity entity = this.getSelectedEntity();
            if (entity == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singletonList(this.getSelectedEntity());
        }
        ArrayList<OnlineEntity> checkedEntities = new ArrayList<OnlineEntity>();
        ListSelectionModel checkedModel = this.lstTablesWithCheckbox.getCheckedModel();
        ListModel model = this.lstTablesWithCheckbox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!checkedModel.isSelectedIndex(i)) continue;
            checkedEntities.add((OnlineEntity)((LabeledValue)model.getElementAt(i)).getValue());
        }
        return checkedEntities;
    }

    public void setWorkspace(OnlineWorkingcopy workspace) {
        DisposeUtils.disposeQuietly((Disposable)workspace);
        this.workspace = workspace;
        DisposeUtils.bind((Disposable)this.workspace);
        this.reloadEntities(true);
    }

    public OnlineWorkingcopy getWorkspace() {
        return this.workspace;
    }

    public void reloadEntities() {
        this.reloadEntities(true);
    }

    private void reloadEntities(boolean forceUpdateEntities) {
        this.filteredList.getModel().clear();
        if (this.workspace == null) {
            this.postReloadTables(Collections.EMPTY_LIST);
            return;
        }
        Thread task = new Thread(() -> this.reloadTables(this.workspace, forceUpdateEntities), "OnlineEntitySelectorListReloadEntities");
        task.start();
        this.lastThread = task;
    }

    private boolean isCancelled() {
        return Thread.currentThread() != this.lastThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTables(OnlineWorkingcopy workspace, boolean forceUpdateEntities) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            this.fireActionEvent(new ActionEvent((Object)this, 3, "begin_processing"));
            this.processing = true;
            this.doUpdateComponents();
            ArrayList<LabeledValue<OnlineEntity>> entities = new ArrayList<LabeledValue<OnlineEntity>>();
            List localEntities = workspace.getWorkspaceEntities();
            for (OnlineEntity localEntity : localEntities) {
                if (!this.isCancelled()) continue;
                return;
            }
            Collections.sort(entities, (o1, o2) -> StringUtils.compareIgnoreCase((String)((OnlineEntity)o1.getValue()).getLabelOrName(), (String)((OnlineEntity)o2.getValue()).getLabelOrName()));
            if (!this.isCancelled()) {
                this.postReloadTables(entities);
            }
        }
        catch (Exception e) {
            LOGGER.warn("_Cant_retrieve_entities_from_repository", (Throwable)e);
            if (!this.isCancelled()) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_entities_from_repository") + "\n" + e.getMessage(), i18n.getTranslation("_Online_Checkout"), 2);
            }
        }
        finally {
            if (!this.isCancelled()) {
                this.processing = false;
                this.doUpdateComponents();
                this.fireActionEvent(new ActionEvent((Object)this, 4, "end_processing"));
            }
        }
    }

    private void postReloadTables(List<LabeledValue<OnlineEntity>> entities) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.postReloadTables(entities))) {
            return;
        }
        this.entities = new ArrayList();
        FilteredListModel model = this.filteredList.getModel();
        HashSet<String> checkeds = new HashSet<String>();
        ListSelectionModel checkedModel = null;
        if (this.lstTablesWithCheckbox != null) {
            checkedModel = this.lstTablesWithCheckbox.getCheckedModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!checkedModel.isSelectedIndex(i)) continue;
                checkeds.add(((OnlineEntity)model.getElementAt(i).getValue()).getEntityCode());
            }
            checkedModel.clearSelection();
        }
        model.clear();
        this.lstTables.getSelectionModel().clearSelection();
        for (LabeledValue<OnlineEntity> labeledValue : entities) {
            if (labeledValue == null) continue;
            this.entities.add((OnlineEntity)labeledValue.getValue());
            model.addElement(labeledValue);
        }
        if (checkedModel != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                OnlineEntity onlineEntity = (OnlineEntity)model.getElementAt(i).getValue();
                if (!checkeds.contains(onlineEntity.getEntityCode())) continue;
                checkedModel.addSelectionInterval(i, i);
            }
        }
        this.processing = false;
        this.fireActionEvent(new ActionEvent((Object)this, 2, "reload"));
    }

    public Collection<OnlineEntity> getEntities() {
        return this.entities;
    }

    private void doUpdateComponents() {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        this.txtFilter.setEnabled(this.enabled && !this.processing);
        this.btnTable.setEnabled(this.enabled && !this.processing);
        this.lstTables.setEnabled(this.enabled && !this.processing);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.doUpdateComponents();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setChecksEnabled(boolean enabled) {
        if (enabled) {
            this.lstTablesWithCheckbox = ToolsSwingLocator.getToolsSwingManager().createJListWithCheckbox(this.lstTables);
            this.lstTablesWithCheckbox.getCheckedModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
            });
        } else {
            this.lstTablesWithCheckbox = null;
        }
    }

    public boolean isChecksEnabled() {
        return this.lstTablesWithCheckbox != null;
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.addActionListener(al);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.removeActionListener(al);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent ae) {
        this.actionListeners.fireActionEvent(ae);
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    public void setViewFilter(Predicate<OnlineEntity> viewFilter) {
        this.viewFilter = viewFilter;
        this.reloadEntities(false);
    }

    public void setFilter(Predicate<OnlineEntity> filter) {
        this.filter = filter;
        this.reloadEntities(false);
    }

    public void check(OnlineEntity entity) {
        if (this.lstTablesWithCheckbox != null && entity != null) {
            FilteredListModel model = this.filteredList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LabeledValueImpl element = (LabeledValueImpl)model.getElementAt(i);
                OnlineEntity ent = (OnlineEntity)element.getValue();
                if (!StringUtils.equalsIgnoreCase((CharSequence)ent.getEntityCode(), (CharSequence)entity.getEntityCode())) continue;
                this.lstTablesWithCheckbox.getCheckedModel().addSelectionInterval(i, i);
                this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
                return;
            }
        }
    }

    public void unCheck(OnlineEntity entity) {
        if (this.lstTablesWithCheckbox != null && entity != null) {
            FilteredListModel model = this.filteredList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LabeledValueImpl element = (LabeledValueImpl)model.getElementAt(i);
                OnlineEntity ent = (OnlineEntity)element.getValue();
                if (!StringUtils.equalsIgnoreCase((CharSequence)ent.getEntityCode(), (CharSequence)entity.getEntityCode())) continue;
                this.lstTablesWithCheckbox.getCheckedModel().removeSelectionInterval(i, i);
                this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
                return;
            }
        }
    }

    public void clearChecks() {
        if (this.lstTablesWithCheckbox != null) {
            this.lstTablesWithCheckbox.getCheckedModel().clearSelection();
            this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
        }
    }

    public void checkAll() {
        this.lstTablesWithCheckbox.getCheckedModel().setSelectionInterval(0, this.lstTablesWithCheckbox.getModel().getSize());
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void setCheck(Collection<String> entityCodes, boolean check) {
        if (this.lstTablesWithCheckbox != null && !CollectionUtils.isEmpty(entityCodes)) {
            FilteredListModel model = this.filteredList.getModel();
            ListSelectionModel checkedModel = this.lstTablesWithCheckbox.getCheckedModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LabeledValueImpl element = (LabeledValueImpl)model.getElementAt(i);
                OnlineEntity ent = (OnlineEntity)element.getValue();
                if (!entityCodes.contains(ent.getEntityCode())) continue;
                if (check) {
                    checkedModel.addSelectionInterval(i, i);
                    continue;
                }
                checkedModel.removeSelectionInterval(i, i);
            }
            this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
        }
    }

    public void clear() {
        this.setWorkspace(null);
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
    }

    private String getLabelOfEntity(OnlineEntity entity) {
        if (this.labelEntityFormatter == null) {
            return this.workspace.formatEntityLabel(entity);
        }
        return this.labelEntityFormatter.apply(entity);
    }

    public void setLabelEntityFormatter(Function<OnlineEntity, String> formatter) {
        this.labelEntityFormatter = formatter;
    }

    public String getCategory(OnlineEntity entity) {
        String category = entity.getFirstCategory();
        return category;
    }

    public void collapseAll() {
    }

    public void expandAll() {
    }
}

