/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineEntitySelectorController;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.FilteredTreeController;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineEntitySelectorControllerJTree
extends AbstractDisposable
implements OnlineEntitySelectorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineEntitySelectorControllerJTree.class);
    private final JTextComponent txtFilter;
    private final JTree treeEntities;
    private Set<String> checkedEntityCodes;
    private Map<String, String> categoryOfCheckedEntity;
    private Map<String, OnlineEntity> entities;
    private final JButton btnEntities;
    private FilteredTreeController filteredTree;
    private ActionListenerSupport actionListeners;
    private ChangeListenerHelper changeListeners;
    private OnlineWorkingcopy workspace;
    private boolean processing;
    private boolean enabled;
    private Predicate<OnlineEntity> viewFilter = ALL_ENTITIES;
    private Predicate<OnlineEntity> filter = ALL_ENTITIES;
    private boolean checksEnabled;
    private JButton btnCheckAll;
    private JButton btnUnCheckAll;
    private Thread lastThread;
    private Function<OnlineEntity, String> labelEntityFormatter;

    public OnlineEntitySelectorControllerJTree(JTree treeEntities) {
        this(treeEntities, null, null, null, null);
    }

    public OnlineEntitySelectorControllerJTree(JTree treeEntities, JTextComponent txtFilter, JButton btnTable, JButton btnCheckAll, JButton btnUnCheckAll) {
        this.treeEntities = treeEntities;
        this.checkedEntityCodes = new HashSet<String>();
        this.categoryOfCheckedEntity = new HashMap<String, String>();
        this.entities = new HashMap<String, OnlineEntity>();
        this.txtFilter = txtFilter == null ? new JTextField() : txtFilter;
        this.btnEntities = btnTable == null ? new JButton() : btnTable;
        this.btnCheckAll = btnCheckAll == null ? new JButton() : btnCheckAll;
        this.btnUnCheckAll = btnUnCheckAll == null ? new JButton() : btnCheckAll;
        this.processing = false;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.actionListeners = toolsSwingManager.createActionListenerSupport();
        this.changeListeners = toolsSwingManager.createChangeListenerHelper();
        this.btnEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.treeEntities.getSelectionModel().setSelectionMode(1);
        this.treeEntities.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)e.getPath().getParentPath().getLastPathComponent();
                    DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    if (parent != null) {
                        String category = (String)parent.getUserObject();
                        OnlineEntity entity = (OnlineEntity)((LabeledValue)current.getUserObject()).getValue();
                        if (entity != null) {
                            OnlineEntitySelectorControllerJTree.this.categoryOfCheckedEntity.put(entity.getEntityCode(), category);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't set category for current entity", (Throwable)ex);
                }
                OnlineEntitySelectorControllerJTree.this.fireActionEvent(new ActionEvent(this, 0, "select"));
            }
        });
        this.treeEntities.setRootVisible(false);
        this.treeEntities.setShowsRootHandles(true);
        this.filteredTree = toolsSwingManager.createFilteredTreeController(this.treeEntities, this.txtFilter, this.btnEntities);
        this.filteredTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        EntityCellRenderer cellRenderer = new EntityCellRenderer();
        this.treeEntities.setCellRenderer(cellRenderer);
        this.setChecksEnabled(true);
        this.btnCheckAll.addActionListener(e -> this.checkAll());
        this.btnUnCheckAll.addActionListener(e -> this.clearChecks());
        this.treeEntities.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = OnlineEntitySelectorControllerJTree.this.treeEntities.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    OnlineEntitySelectorControllerJTree.this.treeEntities.startEditingAtPath(path);
                }
            }
        });
        this.treeEntities.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                TreePath path = OnlineEntitySelectorControllerJTree.this.treeEntities.getPathForLocation(e.getX(), e.getY());
                OnlineEntitySelectorControllerJTree.this.doMouseMoved(path);
            }
        });
    }

    private void doMouseMoved(TreePath path) {
        if (path == null) {
            return;
        }
        Object x = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (!(x instanceof LabeledValue)) {
            this.treeEntities.setToolTipText("");
            return;
        }
        LabeledValue lv = (LabeledValue)x;
        if (lv.getValue() instanceof OnlineEntity) {
            OnlineEntity entity = (OnlineEntity)lv.getValue();
            OnlineEntity lentity = this.workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            String s = OnlineSwingCommons.getStateDescription(lentity == null ? 32 : lentity.getState());
            s = StringUtils.equalsIgnoreCase((CharSequence)entity.getEntityCode(), (CharSequence)entity.getLabel()) ? "<html>" + entity.getLabelOrName() + "<br>" + s + "</html>" : "<html>" + entity.getLabel() + "<br>" + entity.getEntityName() + "<br>" + s + "</html>";
            this.treeEntities.setToolTipText(s);
        } else {
            this.treeEntities.setToolTipText("");
        }
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public OnlineEntity getSelectedEntity() {
        if (this.workspace == null) {
            return null;
        }
        TreePath path = this.treeEntities.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode lastComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = lastComponent.getUserObject();
        if (userObject == null || !(userObject instanceof LabeledValue)) {
            return null;
        }
        LabeledValue selected = (LabeledValue)userObject;
        OnlineEntity entity = (OnlineEntity)selected.getValue();
        if (!this.filter.test(entity)) {
            return null;
        }
        return entity;
    }

    public void setSelectedEntity(OnlineEntity entity) {
        if (this.workspace == null) {
            return;
        }
        for (int i = 0; i < this.treeEntities.getRowCount(); ++i) {
            TreePath path = this.treeEntities.getPathForRow(i);
            DefaultMutableTreeNode lc = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object x = lc.getUserObject();
            if (!(x instanceof LabeledValue)) continue;
            OnlineEntity value = (OnlineEntity)((LabeledValue)x).getValue();
            if (!StringUtils.equals((CharSequence)entity.getEntityCode(), (CharSequence)value.getEntityCode())) continue;
            this.treeEntities.setSelectionPath(path);
            return;
        }
    }

    public String getCategory(OnlineEntity entity) {
        String category = this.categoryOfCheckedEntity.get(entity.getEntityCode());
        if (StringUtils.isBlank((CharSequence)category)) {
            category = entity.getFirstCategory();
        }
        return category;
    }

    public List<OnlineEntity> getCheckedEntities() {
        ArrayList<OnlineEntity> checkedEntities = new ArrayList<OnlineEntity>();
        for (String entityCode : this.checkedEntityCodes) {
            OnlineEntity entity = this.entities.get(entityCode);
            if (entity == null) continue;
            checkedEntities.add(entity);
        }
        Collections.sort(checkedEntities, new CompareUtils.NullSafeComparator<OnlineEntity>(){

            public int safeCompare(OnlineEntity o1, OnlineEntity o2) {
                return StringUtils.compare((String)o1.getLabelOrName(), (String)o2.getLabelOrName(), (boolean)true);
            }
        });
        return checkedEntities;
    }

    public void setWorkspace(OnlineWorkingcopy workspace) {
        this.checkedEntityCodes.clear();
        this.categoryOfCheckedEntity.clear();
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        this.workspace = workspace;
        DisposeUtils.bind((Disposable)this.workspace);
        this.reloadEntities();
    }

    public OnlineWorkingcopy getWorkspace() {
        return this.workspace;
    }

    public void reloadEntities() {
        this.entities.clear();
        if (this.workspace == null) {
            this.filteredTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
            return;
        }
        if (this.processing) {
            LOGGER.info("Reentrada");
            return;
        }
        Thread task = new Thread(() -> this.reloadEntities(this.workspace), "OnlineEntitySelectorTreeReloadEntities");
        task.start();
        this.lastThread = task;
    }

    private boolean isCancelled() {
        return Thread.currentThread() != this.lastThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadEntities(OnlineWorkingcopy workspace) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            this.fireActionEvent(new ActionEvent((Object)this, 3, "begin_processing"));
            SwingUtilities.invokeLater(() -> this.treeEntities.setCursor(Cursor.getPredefinedCursor(3)));
            this.processing = true;
            this.doUpdateComponents();
            List localEntities = workspace.getWorkspaceEntities();
            TreeMap<String, DefaultMutableTreeNode> theEntityNodes = new TreeMap<String, DefaultMutableTreeNode>((o1, o2) -> StringUtils.compare((String)o1, (String)o2, (boolean)false));
            HashMap<String, OnlineEntity> theEntities = new HashMap<String, OnlineEntity>();
            for (OnlineEntity entity : localEntities) {
                if (this.isCancelled()) {
                    return;
                }
                OnlineEntity lentity = workspace.getWorkspaceEntityByCode(entity.getEntityCode());
                String s = OnlineSwingCommons.getHTMLColorTag(lentity == null ? 32 : lentity.getState(), this.getLabelOfEntity(entity));
                if (lentity != null && this.viewFilter.test(lentity)) {
                    entity = lentity;
                } else if (!this.viewFilter.test(entity)) {
                    entity = null;
                }
                if (entity == null) continue;
                theEntities.put(entity.getEntityCode(), entity);
                LabeledValueImpl entry = new LabeledValueImpl(s, (Object)entity);
                this.addNodeEntity(theEntityNodes, null, (LabeledValue)entry);
            }
            this.entities = theEntities;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (DefaultMutableTreeNode node : theEntityNodes.values()) {
                if (this.isCancelled()) {
                    return;
                }
                root.add(node);
            }
            if (!this.isCancelled()) {
                this.postReloadEntities(root);
            }
        }
        catch (Exception e) {
            LOGGER.warn("_Cant_retrieve_entities_from_repository", (Throwable)e);
            if (!this.isCancelled()) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_entities_from_repository") + "\n" + e.getMessage(), i18n.getTranslation("_Online_Checkout"), 2);
            }
        }
        finally {
            SwingUtilities.invokeLater(() -> this.treeEntities.setCursor(Cursor.getPredefinedCursor(0)));
            if (!this.isCancelled()) {
                this.processing = false;
                this.doUpdateComponents();
                this.fireActionEvent(new ActionEvent((Object)this, 4, "end_processing"));
            }
        }
    }

    private String getLabelOfEntity(OnlineEntity entity) {
        String s;
        if (entity == null) {
            return null;
        }
        if (this.labelEntityFormatter == null) {
            return this.workspace.formatEntityLabel(entity);
        }
        try {
            s = this.labelEntityFormatter.apply(entity);
        }
        catch (Exception ex) {
            s = entity.getLabelOrName();
        }
        return s;
    }

    public void setLabelEntityFormatter(Function<OnlineEntity, String> formatter) {
        this.labelEntityFormatter = formatter;
    }

    public Collection<OnlineEntity> getEntities() {
        return this.entities.values();
    }

    private void addNodeEntity(Map<String, DefaultMutableTreeNode> theEntityNodes, String category, LabeledValue entry) {
        DefaultMutableTreeNode branch = theEntityNodes.get(category);
        if (branch == null) {
            branch = new DefaultMutableTreeNode(category, true);
            theEntityNodes.put(category, branch);
        }
        branch.add(new DefaultMutableTreeNode(entry, false));
    }

    private void postReloadEntities(DefaultMutableTreeNode entities) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.postReloadEntities(entities))) {
            return;
        }
        this.filteredTree.setModel((TreeModel)new DefaultTreeModel(entities));
        this.expandAllNodes(this.treeEntities);
        this.processing = false;
        this.fireActionEvent(new ActionEvent((Object)this, 2, "reload"));
    }

    private void doUpdateComponents() {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        this.txtFilter.setEnabled(this.enabled && !this.processing);
        this.btnEntities.setEnabled(this.enabled && !this.processing);
        this.treeEntities.setEnabled(this.enabled && !this.processing);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.treeEntities.setEditable(enabled);
        this.doUpdateComponents();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setChecksEnabled(boolean enabled) {
        this.checksEnabled = enabled;
        if (enabled) {
            this.treeEntities.setCellEditor(new EntityCellEditor());
        } else {
            this.treeEntities.setCellEditor(null);
        }
        this.treeEntities.setEditable(enabled);
    }

    public boolean isChecksEnabled() {
        return this.checksEnabled;
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.addActionListener(al);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.removeActionListener(al);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent ae) {
        this.actionListeners.fireActionEvent(ae);
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    public void setViewFilter(Predicate<OnlineEntity> viewFilter) {
        this.viewFilter = viewFilter;
    }

    public void setFilter(Predicate<OnlineEntity> filter) {
        this.filter = filter;
    }

    public void check(OnlineEntity entity) {
        this.checkedEntityCodes.add(entity.getEntityCode());
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void setCheck(Collection<String> entityCodes, boolean check) {
        if (CollectionUtils.isEmpty(entityCodes)) {
            return;
        }
        for (String entityCode : entityCodes) {
            if (check) {
                this.checkedEntityCodes.add(entityCode);
                continue;
            }
            this.checkedEntityCodes.remove(entityCode);
        }
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void unCheck(OnlineEntity entity) {
        this.checkedEntityCodes.remove(entity.getEntityCode());
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void checkAll() {
        for (Map.Entry<String, OnlineEntity> entry : this.entities.entrySet()) {
            this.checkedEntityCodes.add(entry.getValue().getEntityCode());
        }
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void clearChecks() {
        this.checkedEntityCodes.clear();
        this.treeEntities.stopEditing();
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    private void expandAllNodes(JTree tree) {
        int j = tree.getRowCount();
        for (int i = 0; i < j; ++i) {
            tree.expandRow(i);
            j = tree.getRowCount();
        }
    }

    public void clear() {
        this.setWorkspace(null);
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
    }

    public void collapseAll() {
        TreeModel model = this.treeEntities.getModel();
        Object root = model.getRoot();
        for (int i = 0; i < model.getChildCount(root); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(root, i);
            TreePath path = new TreePath(node.getPath());
            this.treeEntities.collapsePath(path);
        }
    }

    public void expandAll() {
        this.expandAllNodes(this.treeEntities);
    }

    private class EntityCellRenderer
    extends DefaultTreeCellRenderer {
        private final JCheckBox check = new JCheckBox();
        private final JPanel panel;
        private final JLabel label = new JLabel();

        public EntityCellRenderer() {
            this.panel = new JPanel();
            this.label.setOpaque(true);
            this.panel.setOpaque(false);
            this.check.setOpaque(false);
            this.panel.setLayout(new FlowLayout(2, 2, 1));
            this.panel.add(this.check);
            this.panel.add(this.label);
            this.setLeafIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Color backgroundColor = UIManager.getColor("Tree.textBackground");
            Color foregroundColor = UIManager.getColor("Tree.textForeground");
            if (selected) {
                backgroundColor = UIManager.getColor("Tree.selectionBackground");
                foregroundColor = UIManager.getColor("Tree.selectionForeground");
            }
            this.label.setBackground(backgroundColor);
            this.label.setForeground(foregroundColor);
            this.label.setText(Objects.toString(value));
            if (OnlineEntitySelectorControllerJTree.this.checksEnabled) {
                this.check.setVisible(true);
                this.check.setForeground(foregroundColor);
                this.check.setBackground(backgroundColor);
                this.check.setEnabled(false);
                this.check.setSelected(false);
                if (value instanceof DefaultMutableTreeNode) {
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof LabeledValue) {
                        OnlineEntity entity = (OnlineEntity)((LabeledValue)userObject).getValue();
                        if (entity != null) {
                            this.check.setEnabled(true);
                            this.check.setSelected(OnlineEntitySelectorControllerJTree.this.checkedEntityCodes.contains(entity.getEntityCode()));
                        }
                    } else if (userObject instanceof String || userObject == null) {
                        this.check.setEnabled(true);
                        if (StringUtils.isBlank((CharSequence)((String)userObject))) {
                            I18nManager i18n = ToolsLocator.getI18nManager();
                            this.label.setText(i18n.getTranslation("_Others"));
                        } else {
                            this.label.setText((String)userObject);
                        }
                    }
                }
            } else {
                Object userObject;
                this.check.setVisible(false);
                if (value instanceof DefaultMutableTreeNode && ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String || userObject == null)) {
                    if (StringUtils.isBlank((CharSequence)((String)userObject))) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        this.label.setText(i18n.getTranslation("_Others"));
                    } else {
                        this.label.setText((String)userObject);
                    }
                }
            }
            return this.panel;
        }

        protected JCheckBox getCheckBox() {
            return this.check;
        }
    }

    private class EntityCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final JCheckBox check = new JCheckBox();
        private final JPanel panel;
        private final JLabel label = new JLabel();
        private Object currentUserObject;
        private TreePath currentRow;

        public EntityCellEditor() {
            this.panel = new JPanel();
            this.label.setOpaque(true);
            this.panel.setOpaque(false);
            this.check.setOpaque(false);
            this.panel.setLayout(new FlowLayout(2, 2, 1));
            this.panel.add(this.check);
            this.panel.add(this.label);
            this.currentUserObject = null;
            this.currentRow = null;
            this.check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EntityCellEditor.this.currentUserObject == null) {
                        EntityCellEditor.this.postCheck();
                        return;
                    }
                    OnlineEntity entity = (OnlineEntity)((LabeledValue)EntityCellEditor.this.currentUserObject).getValue();
                    if (entity == null) {
                        return;
                    }
                    String entityCode = entity.getEntityCode();
                    if (EntityCellEditor.this.check.isSelected()) {
                        OnlineEntitySelectorControllerJTree.this.checkedEntityCodes.add(entityCode);
                        OnlineEntitySelectorControllerJTree.this.categoryOfCheckedEntity.put(entityCode, EntityCellEditor.this.getCategoryFromCurrentRow());
                    } else {
                        OnlineEntitySelectorControllerJTree.this.checkedEntityCodes.remove(entityCode);
                        OnlineEntitySelectorControllerJTree.this.categoryOfCheckedEntity.remove(entityCode);
                    }
                    EntityCellEditor.this.postCheck();
                }
            });
        }

        private String getCategoryFromCurrentRow() {
            try {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.currentRow.getParentPath().getLastPathComponent();
                if (parent == null) {
                    return null;
                }
                return (String)parent.getUserObject();
            }
            catch (Exception ex) {
                return null;
            }
        }

        private void postCheck() {
            this.stopCellEditing();
            OnlineEntitySelectorControllerJTree.this.treeEntities.repaint();
            OnlineEntitySelectorControllerJTree.this.fireActionEvent(new ActionEvent(this, 1, "check"));
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentUserObject;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Color backgroundColor = UIManager.getColor("Tree.textBackground");
            Color foregroundColor = UIManager.getColor("Tree.textForeground");
            if (selected) {
                backgroundColor = UIManager.getColor("Tree.selectionBackground");
                foregroundColor = UIManager.getColor("Tree.selectionForeground");
            }
            this.label.setBackground(backgroundColor);
            this.label.setForeground(foregroundColor);
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (OnlineEntitySelectorControllerJTree.this.checksEnabled) {
                this.check.setVisible(true);
                this.check.setEnabled(false);
                this.check.setSelected(false);
                if (value instanceof DefaultMutableTreeNode) {
                    OnlineEntity entity;
                    this.currentUserObject = ((DefaultMutableTreeNode)value).getUserObject();
                    this.currentRow = tree.getPathForRow(row);
                    if (this.currentUserObject instanceof LabeledValue && (entity = (OnlineEntity)((LabeledValue)this.currentUserObject).getValue()) != null) {
                        this.check.setEnabled(true);
                        this.check.setSelected(OnlineEntitySelectorControllerJTree.this.checkedEntityCodes.contains(entity.getEntityCode()));
                        this.label.setText(((LabeledValue)this.currentUserObject).getLabel());
                    }
                }
            } else {
                this.check.setVisible(false);
            }
            return this.panel;
        }
    }
}

