/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.OnlineRuntimeException;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineSwingCommons {
    public static final String BOOKMARKSANDHISTORY_SITE_URL = "OnlineSiteURL";
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineSwingCommons.class);
    private static final String ID_COLOR_LOCAL_NEW = "COLOR_LOCAL_NEW";
    private static final String ID_COLOR_LOCAL_MODIFIED = "COLOR_LOCAL_MODIFIED";
    private static final String ID_COLOR_LOCAL_UNMODIFIED = "COLOR_LOCAL_UNMODIFIED";
    private static final String ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED = "COLOR_LOCAL_AND_REPOSITORY_MODIFIED";
    private static final String ID_COLOR_REPOSITORY_NEW = "COLOR_REPOSITORY_NEW";
    private static final String ID_COLOR_REPOSITORY_MODIFIED = "COLOR_REPOSITORY_MODIFIED";
    private static final String ID_COLOR_CONFLICT = "COLOR_CONFLICT";
    private static final String ID_COLOR_UNKNOWN_STATE = "COLOR_UNKNOWN_STATE";
    private static final String ID_COLOR_DISCONNECTED_STATE = "COLOR_DISCONNETED_STATE";
    private static final Color COLOR_LOCAL_NEW = Color.GREEN.darker();
    private static final Color COLOR_LOCAL_MODIFIED = Color.BLUE.darker();
    private static final Color COLOR_LOCAL_UNMODIFIED = Color.BLACK;
    private static final Color COLOR_LOCAL_AND_REPOSITORY_MODIFIED = Color.RED.brighter();
    private static final Color COLOR_REPOSITORY_NEW = Color.ORANGE.darker().darker();
    private static final Color COLOR_REPOSITORY_MODIFIED = Color.MAGENTA.darker();
    private static final Color COLOR_CONFLICT = Color.RED;
    private static final Color COLOR_UNKNOWN_STATE = Color.LIGHT_GRAY;
    private static final Color COLOR_DISCONNECTED_STATE = Color.DARK_GRAY;
    private static final Map<Integer, String> OPERATION_LABELS_UI = new MapBuilder().add((Object)0, (Object)"_Online_operation_delete").add((Object)1, (Object)"_Online_operation_update").add((Object)2, (Object)"_Online_operation_insert").build();
    private static Map<String, Color> entityColors = null;

    public static String getHTMLColorTag(Color color, String text) {
        return OnlineSwingCommons.getHTMLColorTag(color, false, text);
    }

    public static String getHTMLColorTag(Color color, boolean bold, String text) {
        return OnlineSwingCommons.getHTMLColorTag(color, bold, false, text);
    }

    public static String getHTMLColorTag(Color color, boolean bold, boolean strikethrough, String text) {
        String pattern = bold && strikethrough ? "<html><font color='rgb(%s, %s, %s)'><b><s>%s</b></s></font></html>" : (bold ? "<html><font color='rgb(%s, %s, %s)'><b>%s</b></font></html>" : (strikethrough ? "<html><font color='rgb(%s, %s, %s)'><s>%s</s></font></html>" : "<html><font color='rgb(%s, %s, %s)'>%s</font></html>"));
        String tag = String.format(pattern, color.getRed(), color.getGreen(), color.getBlue(), StringUtils.replace((String)text, (String)"\n", (String)"<br>"));
        return tag;
    }

    public static String getHTMLFontColorTag(Color color, boolean bold, boolean strikethrough, String text) {
        String pattern = bold && strikethrough ? "<font color='rgb(%s, %s, %s)'><b><s>%s</b></s></font>" : (bold ? "<font color='rgb(%s, %s, %s)'><b>%s</b></font>" : (strikethrough ? "<font color='rgb(%s, %s, %s)'><s>%s</s></font>" : "<font color='rgb(%s, %s, %s)'>%s</font>"));
        String tag = String.format(pattern, color.getRed(), color.getGreen(), color.getBlue(), StringUtils.replace((String)text, (String)"\n", (String)"<br>"));
        return tag;
    }

    public static String getHTMLColorTag(int state, String text) {
        switch (state) {
            case 256: 
            case 384: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_DISCONNECTED_STATE), false, true, text);
            }
            case 128: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_DISCONNECTED_STATE), false, text);
            }
            case 1: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_UNMODIFIED), false, text);
            }
            case 2: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_NEW), false, text);
            }
            case 4: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_MODIFIED), false, text);
            }
            case 6: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_REPOSITORY_MODIFIED), false, text);
            }
            case 8: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED), false, text);
            }
            case 16: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_CONFLICT), false, text);
            }
            case 32: {
                return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_REPOSITORY_NEW), false, text);
            }
        }
        return OnlineSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_UNKNOWN_STATE), false, text);
    }

    public static String getHTMLColorTag(OnlineWorkingcopy workspace, String entityName) {
        if (workspace == null) {
            return entityName;
        }
        OnlineEntity lentity = workspace.getWorkspaceEntity(entityName);
        if (lentity == null) {
            return OnlineSwingCommons.getHTMLColorTag(32, entityName);
        }
        return OnlineSwingCommons.getHTMLColorTag(lentity.getState(), entityName);
    }

    public static String getStateDescription(OnlineWorkingcopy workspace, String entityName) {
        if (workspace == null) {
            return OnlineSwingCommons.getStateDescription(0);
        }
        OnlineEntity lentity = workspace.getWorkspaceEntity(entityName);
        if (lentity == null) {
            return OnlineSwingCommons.getStateDescription(32);
        }
        return OnlineSwingCommons.getStateDescription(lentity.getState());
    }

    public static String getStateDescription(int state) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        switch (state) {
            case 128: {
                return i18n.getTranslation("_Disconnected");
            }
            case 256: {
                return i18n.getTranslation("_Corrupt");
            }
            case 384: {
                return i18n.getTranslation("_Corrupt") + "/" + i18n.getTranslation("_Disconnected");
            }
            case 1: {
                return i18n.getTranslation("_Unmodified_locally");
            }
            case 2: {
                return i18n.getTranslation("_New_locally");
            }
            case 4: {
                return i18n.getTranslation("_Modified_locally");
            }
            case 6: {
                return i18n.getTranslation("_Modified_in_the_remote");
            }
            case 8: {
                return i18n.getTranslation("_Modified_in_the_remote_and_locally");
            }
            case 16: {
                return i18n.getTranslation("_Conflict");
            }
            case 32: {
                return i18n.getTranslation("_New_in_the_remote");
            }
            case 64: {
                return i18n.getTranslation("_It_is_not_in_local_or_in_the_remote");
            }
        }
        return i18n.getTranslation("_Unknow_state");
    }

    public static void setColorCompoment(Component c, Color color, boolean bold) {
        OnlineSwingCommons.setColorCompoment(c, color, bold, false);
    }

    public static void setColorCompoment(Component c, Color color, boolean bold, boolean strikethrough) {
        if (bold) {
            Font f = c.getFont();
            Map<TextAttribute, ?> attributes = f.getAttributes();
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            c.setFont(c.getFont().deriveFont(attributes));
        }
        c.setForeground(color);
    }

    public static void setColorCompoment(Component c, int state) {
        switch (state) {
            case 256: 
            case 384: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_DISCONNECTED_STATE), false, true);
                break;
            }
            case 128: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_DISCONNECTED_STATE), false);
                break;
            }
            case 1: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_UNMODIFIED), false);
                break;
            }
            case 2: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_NEW), false);
                break;
            }
            case 4: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_MODIFIED), false);
                break;
            }
            case 6: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_REPOSITORY_MODIFIED), false);
                break;
            }
            case 8: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED), false);
                break;
            }
            case 16: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_CONFLICT), false);
                break;
            }
            case 32: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_REPOSITORY_NEW), false);
                break;
            }
            default: {
                OnlineSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_UNKNOWN_STATE), false);
            }
        }
    }

    public static boolean notInSwingThreadInvokeLater(Runnable x) {
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        SwingUtilities.invokeLater(x);
        return true;
    }

    public static void cleanHighligthed() {
        OnlineManager manager = OnlineLocator.getOnlineManager();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        swingManager.getDefaultServices().cleanHighligthed();
    }

    public static void refreshDocumentByParams(JDBCStoreParameters params) {
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        swingManager.getDefaultServices().refreshDocumentByParams(params);
    }

    public static void refreshDocumentByParams(Set<JDBCStoreParameters> params) {
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        swingManager.getDefaultServices().refreshDocumentByParams(params);
    }

    public static Geometry createBBox(Geometry geom1, Geometry geom2) {
        if (geom1 == null && geom2 == null) {
            return null;
        }
        Envelope env = GeometryUtils.createEnvelope((int)0);
        if (geom1 != null) {
            env.add(geom1);
        }
        if (geom2 != null) {
            env.add(geom2);
        }
        return env.getGeometry();
    }

    public static boolean showAuthenticationErrors(String title, OnlineRuntimeException ex) {
        return OnlineSwingCommons.showAuthenticationErrors(title, ex.getErrnum(), ex.getMessage());
    }

    public static boolean showAuthenticationErrors(String title, int errNum) {
        return OnlineSwingCommons.showAuthenticationErrors(title, errNum, null);
    }

    public static boolean showAuthenticationErrors(String title, int errNum, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            message = OnlineLocator.getOnlineManager().getErrorMessage(errNum);
        }
        switch (errNum) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                I18nManager i18n = ToolsLocator.getI18nManager();
                dialogs.messageDialog("[" + errNum + "] " + message, i18n.getTranslation(title), 2);
                return true;
            }
        }
        return false;
    }

    public static boolean showAuthenticationRequiredMessage(String title) {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        dialogs.messageDialog(i18n.getTranslation("_Authorization_required_for_this_operation"), i18n.getTranslation(title), 2);
        return true;
    }

    private static void loadColors() {
        entityColors = new HashMap<String, Color>();
        entityColors.put(ID_COLOR_LOCAL_NEW, COLOR_LOCAL_NEW);
        entityColors.put(ID_COLOR_LOCAL_MODIFIED, COLOR_LOCAL_MODIFIED);
        entityColors.put(ID_COLOR_LOCAL_UNMODIFIED, COLOR_LOCAL_UNMODIFIED);
        entityColors.put(ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED, COLOR_LOCAL_AND_REPOSITORY_MODIFIED);
        entityColors.put(ID_COLOR_REPOSITORY_NEW, COLOR_REPOSITORY_NEW);
        entityColors.put(ID_COLOR_REPOSITORY_MODIFIED, COLOR_REPOSITORY_MODIFIED);
        entityColors.put(ID_COLOR_CONFLICT, COLOR_CONFLICT);
        entityColors.put(ID_COLOR_UNKNOWN_STATE, COLOR_UNKNOWN_STATE);
        entityColors.put(ID_COLOR_DISCONNECTED_STATE, COLOR_DISCONNECTED_STATE);
        InputStream x = OnlineSwingCommons.class.getClassLoader().getResourceAsStream("/OnlineEntityColors.properties");
        Coercion toColor = ToolsLocator.getDataTypesManager().getCoercion(96);
        if (x != null) {
            try {
                Properties prop = new Properties();
                prop.load(x);
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    try {
                        entityColors.put((String)entry.getKey(), (Color)toColor.coerce(entry.getValue()));
                    }
                    catch (CoercionException ex) {
                        LOGGER.trace("Can't parse color " + Objects.toString(entry.getKey()), (Throwable)ex);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.trace("Can't load colors.", (Throwable)ex);
            }
        }
    }

    public static boolean hasConflictTheDatamodelWithOtherModelAlreadyRegistered(OnlineWorkingcopy workspace, String dataModelName) {
        DataManager dataManager = DALLocator.getDataManager();
        String wsUrl = workspace.getExplorerParameters().getUrl();
        StoresRepository globalRepository = dataManager.getStoresRepository();
        for (OnlineEntity entity : workspace.getWorkspaceEntities()) {
            String registeredUrl;
            DataStoreParameters params;
            List entityModels = entity.getDataModelsAsList();
            if (!entityModels.contains(dataModelName) || !((params = (DataStoreParameters)globalRepository.get((Object)entity.getEntityName())) instanceof JDBCStoreParameters) || StringUtils.equals((CharSequence)wsUrl, (CharSequence)(registeredUrl = ((JDBCStoreParameters)params).getUrl()))) continue;
            return true;
        }
        return false;
    }

    public static ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = OnlineSwingCommons.class.getResource("images/" + name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static String getOperationLabel(int operation) {
        return OPERATION_LABELS_UI.getOrDefault(operation, "unknown");
    }

    static {
        OnlineSwingCommons.loadColors();
    }
}

