/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseWheelBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.PanListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomInListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomOutListenerImpl;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.swing.impl.OSMUtils;
import org.gvsig.online.swing.impl.SelectAreaPanelView;
import org.gvsig.online.swing.impl.WMSUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAreaPanel
extends SelectAreaPanelView {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectAreaPanel.class);
    private MapControl mapControl;
    private final MapContext mapContext;
    private JLabel lblMessages;

    public SelectAreaPanel() {
        this.translate();
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        this.mapContext = mapContextManager.createMapContext();
        this.initComponents();
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnZoomMinus);
        swingManager.translate((AbstractButton)this.btnZoomPlus);
    }

    public void configure(FLayer previewLayer, Envelope bbox) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.configure(previewLayer, bbox));
            return;
        }
        this.mapContext.setProjection(CRSFactory.getCRS((String)"EPSG:3857"));
        FLayer baseLayer = this.getBaseLayer();
        if (baseLayer != null) {
            this.mapContext.getLayers().add(baseLayer);
        }
        if (previewLayer != null) {
            this.mapContext.getLayers().add(previewLayer);
        }
        this.btnZoomMinus.setEnabled(true);
        this.btnZoomPlus.setEnabled(true);
        this.mapControl.getViewPort().setEnvelope(bbox);
        this.containerMapControl.setEnabled(true);
        this.containerMapControl.add((Component)this.mapControl, "Center");
        this.containerMapControl.revalidate();
        this.containerMapControl.repaint();
    }

    public void abort(String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.abort(msg));
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        dialogs.messageDialog(msg, i18n.getTranslation("_Select_working_area"), 2);
        this.setVisible(false);
    }

    private void initComponents() {
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
            this.mapControl = mapControlManager.createJMapControlPanel(this.mapContext);
            this.mapControl.setMapControlDrawer(mapControlManager.createDefaultMapControlDrawer());
            ZoomOutListenerImpl zoomOutListener = new ZoomOutListenerImpl(this.mapControl);
            this.mapControl.addBehavior("zoomOut", (Behavior)new PointBehavior((PointListener)zoomOutListener));
            ZoomInListenerImpl zoomInListener = new ZoomInListenerImpl(this.mapControl);
            this.mapControl.addBehavior("zoomIn", new Behavior[]{new RectangleBehavior((RectangleListener)zoomInListener), new PointBehavior((PointListener)zoomOutListener, 4)});
            PanListenerImpl panListener = new PanListenerImpl(this.mapControl);
            this.mapControl.addBehavior("pan", (Behavior)new MoveBehavior((PanListener)panListener, 1));
            this.mapControl.addCombinedBehavior((Behavior)new MouseWheelBehavior());
            this.mapControl.addCombinedBehavior((Behavior)new MoveBehavior((PanListener)panListener, 2));
            this.mapControl.setTool("pan");
            this.containerMapControl.setLayout(new BorderLayout(10, 10));
            this.lblMessages = new JLabel(i18n.getTranslation("_Loading%ellipsis%"), 0);
            this.containerMapControl.add((Component)this.lblMessages, "Center");
            this.containerMapControl.setEnabled(false);
            this.btnZoomPlus.addActionListener(e -> this.doZoomPlus());
            this.btnZoomMinus.addActionListener(e -> this.doZoomMinus());
            this.btnZoomMinus.setEnabled(false);
            this.btnZoomPlus.setEnabled(false);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't initilize area selector", (Throwable)ex);
        }
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)60, (int)20, (int)100);
    }

    private void doZoomPlus() {
        this.mapControl.zoomIn();
    }

    private void doZoomMinus() {
        this.mapControl.zoomOut();
    }

    public Envelope getSelectedArea() {
        return this.mapControl.getViewPort().getEnvelope();
    }

    private FLayer getBaseLayer() {
        return OSMUtils.createOSMLayer();
    }

    public static Envelope getWorkingArea(OnlineSite site, final List<OnlineLayer> selectedLayers) {
        if (selectedLayers.isEmpty()) {
            return null;
        }
        final I18nManager i18n = ToolsLocator.getI18nManager();
        final IProjection targetProjection = CRSFactory.getCRS((String)"EPSG:3857");
        final MutableObject areaProjection = new MutableObject();
        MutableObject area = new MutableObject();
        final MutableBoolean cancelled = new MutableBoolean(false);
        final String processing_msg = i18n.getTranslation("_Processing%ellipsis%");
        final SelectAreaPanel selectAreaPanel = new SelectAreaPanel();
        WindowManager_v2 winmager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final Dialog selectAreaDialog = winmager.createDialog((JComponent)selectAreaPanel, i18n.getTranslation("_Select_working_area"), "", 3);
        selectAreaDialog.addActionListener(e -> {
            switch (selectAreaDialog.getAction()) {
                case 1: {
                    try {
                        area.setValue((Object)selectAreaPanel.getSelectedArea());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't get working area");
                    }
                    break;
                }
                case 2: {
                    cancelled.setValue(true);
                }
            }
        });
        selectAreaDialog.setButtonEnabled(1, false);
        selectAreaDialog.setButtonEnabled(2, true);
        Thread task = new Thread(new Runnable(){

            @Override
            public void run() {
                URL wms_url = null;
                Envelope envelope = null;
                ArrayList<String> layerNames = new ArrayList<String>();
                for (OnlineLayer layer : selectedLayers) {
                    if (cancelled.getValue().booleanValue()) {
                        LOGGER.info("Select working area cancelled by user");
                        return;
                    }
                    try {
                        selectAreaPanel.message(processing_msg + " (" + layer.getName() + ")");
                        IProjection layerProjection = layer.getProjection();
                        if (areaProjection.getValue() == null) {
                            areaProjection.setValue((Object)layerProjection);
                        }
                        Envelope layerEnvelope = layer.getEnvelope();
                        if (layerProjection != null && !layerProjection.equals(targetProjection)) {
                            ICoordTrans ct = layerProjection.getCT(targetProjection);
                            Geometry geom = layerEnvelope.getGeometry();
                            geom.reProject(ct);
                            layerEnvelope = geom.getEnvelope();
                        }
                        if (envelope == null) {
                            envelope = layerEnvelope;
                        } else {
                            envelope.add(layerEnvelope);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't calculate envelope of layer " + layer.getName() + ", skip layer.", (Throwable)ex);
                    }
                    if (cancelled.getValue().booleanValue()) {
                        LOGGER.info("Select working area cancelled by user");
                        return;
                    }
                    try {
                        URL layer_wms_url = layer.getWMSUrl();
                        if (layer_wms_url == null) continue;
                        if (wms_url == null) {
                            wms_url = layer_wms_url;
                            layerNames.add(layer.getName());
                            continue;
                        }
                        if (!wms_url.equals(layer_wms_url)) continue;
                        layerNames.add(layer.getName());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't calculate visibility of layer " + layer.getName() + ", skip layer.", (Throwable)ex);
                    }
                }
                if (cancelled.getValue().booleanValue()) {
                    LOGGER.info("Select working area cancelled by user");
                    return;
                }
                FLayer previewLayer = null;
                if (!CollectionUtils.isEmpty(layerNames) && areaProjection.getValue() != null) {
                    selectAreaPanel.message(i18n.getTranslation("_Building_WMS%ellipsis%"));
                    try {
                        previewLayer = WMSUtils.createWMSLayer("Preview", wms_url, String.join((CharSequence)",", layerNames), "EPSG:3857");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't create WMS layer", (Throwable)ex);
                    }
                }
                if (cancelled.getValue().booleanValue()) {
                    LOGGER.info("Select working area cancelled by user");
                    return;
                }
                selectAreaPanel.message(i18n.getTranslation("_Loading%ellipsis%"));
                if (areaProjection.getValue() == null) {
                    I18nManager i18n2 = ToolsLocator.getI18nManager();
                    selectAreaPanel.abort(i18n2.getTranslation("_The_projection_of_the_selected_layers_could_not_be_obtained"));
                } else {
                    selectAreaDialog.setButtonEnabled(1, true);
                    selectAreaDialog.setButtonEnabled(2, true);
                    selectAreaPanel.configure(previewLayer, envelope);
                }
            }
        }, "InitializeAreaSelector");
        task.start();
        selectAreaDialog.show(WindowManager.MODE.DIALOG);
        if (cancelled.getValue().booleanValue()) {
            LOGGER.info("Select working area cancelled by user");
            return null;
        }
        if (area.getValue() == null) {
            return null;
        }
        if (((Envelope)area.getValue()).getProjection().equals(areaProjection.getValue())) {
            return (Envelope)area.getValue();
        }
        ICoordTrans ct = targetProjection.getCT((IProjection)areaProjection.getValue());
        if (ct == null) {
            return null;
        }
        Geometry geom = ((Envelope)area.getValue()).getGeometry();
        geom.reProject(ct);
        return geom.getEnvelope();
    }

    protected void message(String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.message(msg));
            return;
        }
        this.lblMessages.setText(msg);
    }
}

