/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl;

import java.net.URL;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorer_v2;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSUtils {
    private static final String WMS_PROVIDER_NAME = "Wms Store";
    private static final String FIELD_XYAXISORDER = "xyaxisorder";
    private static final String FIELD_HOST = "host";
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_INFOFORMAT = "infoformat";
    private static final String FIELD_LAYERQUERY = "layer_query";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SRSSTR = "srsstr";
    private static final String FIELD_TRANSPARENCY = "transparency";
    private static final String FIELD_INFOLAYERQUERY = "infolayerquery";
    private static final String FIELD_QUERYABLE = "queryable";
    private static final String FIELD_OVERRIDE = "override";
    private static final String FIELD_STYLES = "styles";
    private static final String FIELD_DIMENSIONS = "dimensions";
    private static final String FIELD_ONLINERESOURC = "onlineresources";
    private static final String FIELD_FIXEDSIZE = "fixedsize";
    private static final String FIELD_EXTENT = "extent";
    private static final String FIELD_WIDTH = "width";
    private static final String FIELD_HEIGHT = "height";
    private static final String FIELD_DELETECACHE = "deletecache";
    private static final String FIELD_ASSUMEXYAXISORDER = "assumeXY";
    private static final Logger LOGGER = LoggerFactory.getLogger(WMSUtils.class);

    public static FLayer createWMSLayer(String name, URL host, String layers, String srs) {
        try {
            DataManager datamanager = DALLocator.getDataManager();
            String providerName = WMS_PROVIDER_NAME;
            DataServerExplorerParameters explorerParams = datamanager.createServerExplorerParameters(providerName);
            explorerParams.setDynValue(FIELD_XYAXISORDER, (Object)false);
            explorerParams.setDynValue(FIELD_HOST, (Object)host.toString());
            DataServerExplorer_v2 explorer = (DataServerExplorer_v2)datamanager.openServerExplorer(providerName, explorerParams);
            explorer.open();
            DataStoreParameters par = explorer.get(layers);
            par.setDynValue(FIELD_FORMAT, (Object)"image/png");
            par.setDynValue(FIELD_INFOFORMAT, (Object)"text/plain");
            par.setDynValue(FIELD_INFOLAYERQUERY, null);
            par.setDynValue(FIELD_SRSSTR, (Object)srs);
            par.setDynValue(FIELD_TRANSPARENCY, (Object)true);
            par.setDynValue(FIELD_STYLES, null);
            par.setDynValue(FIELD_DIMENSIONS, null);
            par.setDynValue(FIELD_ONLINERESOURC, explorer.getProperty("OnlineResources"));
            par.setDynValue(FIELD_FIXEDSIZE, null);
            par.setDynValue(FIELD_QUERYABLE, (Object)false);
            par.setDynValue(FIELD_NAME, (Object)name);
            par.setDynValue(FIELD_XYAXISORDER, (Object)false);
            DataStore store = explorer.open(par);
            MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
            FLayer layer = mapContextManager.createLayer(name, store);
            return layer;
        }
        catch (Throwable ex) {
            LOGGER.warn("Can't create WMS layer", ex);
            return null;
        }
    }
}

