/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.authentication.online;

import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationRequester;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.spi.AbstractDownloaderAuthenticationRequester;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.swing.impl.authentication.online.DownloaderOnlineAuthenticationConfig;
import org.gvsig.online.swing.impl.authentication.online.DownloaderOnlineCredentials;
import org.gvsig.online.swing.impl.loggin.LogginDialog;

public class DownloaderOnlineAuthenticationRequester
extends AbstractDownloaderAuthenticationRequester
implements DownloaderAuthenticationRequester {
    private DownloaderOnlineCredentials credentials = null;

    public DownloaderOnlineAuthenticationRequester(DownloaderOnlineAuthenticationConfig config) {
        super((DownloaderAuthenticationConfig)config);
    }

    public boolean requestAuthorization(Executor executor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                MutableBoolean r = new MutableBoolean();
                executor.execute(() -> r.setValue(this.requestAuthorization(executor)));
                return r.booleanValue();
            }
            catch (Exception ex) {
                return false;
            }
        }
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        DownloaderOnlineCredentials theCredentials = (DownloaderOnlineCredentials)downloader.getCredentials(this.getConfig().getServiceUrl());
        LogginDialog logginDialog = theCredentials != null ? new LogginDialog(theCredentials.getUserid(), theCredentials.getPassword()) : new LogginDialog();
        logginDialog.addActionListener(e -> {
            OnlineManager manager = OnlineLocator.getOnlineManager();
            String authorization = manager.authenticate(this.config.getServiceUrl(), logginDialog.getUserId(), logginDialog.getPassword());
            this.credentials = new DownloaderOnlineCredentials(this.getConfig().getServiceUrl(), this.config, logginDialog.getName(), logginDialog.getPassword(), authorization);
        });
        if (!logginDialog.showDialog()) {
            return false;
        }
        return this.credentials != null;
    }

    public DownloaderOnlineCredentials getCredentials() {
        return this.credentials;
    }
}

