/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.authentication.online;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.spi.AbstractDownloaderCredentials;
import org.gvsig.online.swing.impl.authentication.online.DownloaderOnlineAuthenticationConfig;

public class DownloaderOnlineCredentials
extends AbstractDownloaderCredentials
implements DownloaderCredentials {
    private final String userid;
    private final String password;
    private final String token;
    private final DownloaderAuthenticationConfig config;

    public DownloaderOnlineCredentials(String serviceUrl, DownloaderAuthenticationConfig config, String userid, String password, String token) {
        super("gvSIG Online", serviceUrl);
        this.config = config;
        this.userid = userid;
        this.password = password;
        this.token = token;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAuthorizationToken() {
        return this.token;
    }

    public String getUserid() {
        return this.userid;
    }

    public DownloaderCredentials createCredentials(String serviceUrl) {
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return null;
        }
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        DownloaderAuthenticationConfig theConfig = downloader.getAuthenticationConfigurationService(serviceUrl);
        if (theConfig == null) {
            theConfig = this.config.createAuthenticationConfig(serviceUrl);
        }
        return new DownloaderOnlineCredentials(serviceUrl, theConfig, this.getUserid(), this.getPassword(), this.getAuthorizationToken());
    }

    public DownloaderCredentials createCredentials(DownloaderAuthenticationConfig config) {
        if (!(config instanceof DownloaderOnlineAuthenticationConfig)) {
            return null;
        }
        return new DownloaderOnlineCredentials(config.getServiceUrl(), config, this.getUserid(), this.getPassword(), this.getAuthorizationToken());
    }
}

