/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.changes;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.JsonObject;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.online.lib.api.OnlineRuntimeException;
import org.gvsig.online.lib.api.workingcopy.OnlineChange;
import org.gvsig.online.lib.api.workingcopy.OnlineChanges;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyChange;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.online.swing.impl.changes.LocalChangesTableModel;
import org.gvsig.online.swing.impl.changes.OnlineJChangesImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalChangesController
extends AbstractDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalChangesController.class);
    private static final int MAX_SELECTED_ROWS_TO_SHOW_GEOMETRIES = 200;
    private final JTable tblLocalChanges;
    private final JButton btnLocalCheckAll;
    private final JButton btnLocalUnCheckAll;
    private final JButton btnLocalShowForm;
    private final JButton btnLocalRefresh;
    private final JButton btnLocalUpload;
    private final JButton btnLocalRevert;
    private final PickerController<OnlineWorkingcopy> workspacePicker;
    private final OnlineJChangesImpl context;
    private final JButton btnLocalZoom;
    private final JButton btnLocalCenter;
    private final JButton btnLocalHighlight;
    private final JLabel lblLocalChangesCount;
    private OnlineChanges<OnlineWorkingcopyChange> changes;
    private List<OnlineEntity> entitiesWithSelectedChanges = null;
    private final Set<String> entitiesToUnCheckAll;
    private TableModelListener tableModelListener;
    private boolean dissabledUncheckAllByEntities = false;
    private final JButton btnLocalCleanHighlighted;
    private boolean isSelectionFromEntitiesEmpty;

    public LocalChangesController(OnlineJChangesImpl context, PickerController<OnlineWorkingcopy> workspacePicker, JTable tblLocalChanges, JButton btnLocalCheckAll, JButton btnLocalUnCheckAll, JButton btnLocalShowForm, JButton btnLocalRefresh, JButton btnLocalUpload, JButton btnLocalRevert, JButton btnLocalZoom, JButton btnLocalCenter, JButton btnLocalHighlight, JButton btnLocalCleanHighlighted, JLabel lblLocalChangesCount, JTextField txtLocalTablesFilter, JButton btnLocalTable) {
        this.context = context;
        this.workspacePicker = workspacePicker;
        this.tblLocalChanges = tblLocalChanges;
        this.btnLocalCheckAll = btnLocalCheckAll;
        this.btnLocalUpload = btnLocalUpload;
        this.btnLocalRefresh = btnLocalRefresh;
        this.btnLocalRevert = btnLocalRevert;
        this.btnLocalShowForm = btnLocalShowForm;
        this.btnLocalUnCheckAll = btnLocalUnCheckAll;
        this.btnLocalZoom = btnLocalZoom;
        this.btnLocalCenter = btnLocalCenter;
        this.btnLocalHighlight = btnLocalHighlight;
        this.btnLocalCleanHighlighted = btnLocalCleanHighlighted;
        this.lblLocalChangesCount = lblLocalChangesCount;
        this.entitiesToUnCheckAll = new HashSet<String>();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        OnlineSwingManager onlineSwingManager = OnlineSwingLocator.getOnlineSwingManager();
        this.translate();
        this.btnLocalCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalUpload.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalRefresh.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalRevert.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalShowForm.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalUnCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalZoom.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCenter.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalHighlight.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCleanHighlighted.setCursor(Cursor.getPredefinedCursor(12));
        this.tblLocalChanges.setModel(new LocalChangesTableModel());
        this.tblLocalChanges.getSelectionModel().setSelectionMode(2);
        this.tblLocalChanges.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    LocalChangesController.this.doToggleSelection();
                }
            }
        });
        this.tblLocalChanges.getSelectionModel().addListSelectionListener(e -> {
            this.doUpdateEntitiesWithSelectedChanges();
            this.doUpdateIsSelectionFromEntitiesEmpty();
            this.context.doUpdateComponents();
        });
        this.btnLocalCheckAll.addActionListener(e -> {
            if (this.changes != null) {
                this.doCheckAll();
                this.doUpdateTableLocalChanges();
            }
        });
        this.btnLocalUnCheckAll.addActionListener(e -> {
            if (this.changes != null) {
                this.doUnCheckAll();
                this.doUpdateTableLocalChanges();
            }
        });
        this.btnLocalShowForm.addActionListener(e -> this.doShowForm());
        this.btnLocalUpload.addActionListener(e -> this.doUpload());
        this.btnLocalRevert.addActionListener(e -> this.doRevert());
        this.btnLocalRefresh.addActionListener(e -> this.doUpdateTableLocalChanges());
        this.btnLocalZoom.addActionListener(e -> this.doZoomToSelectedChange());
        this.btnLocalCenter.addActionListener(e -> this.doCenterToSelectedChange());
        this.btnLocalHighlight.addActionListener(e -> this.doHighLightSelectedChange());
        this.btnLocalCleanHighlighted.addActionListener(e -> OnlineSwingCommons.cleanHighligthed());
        this.context.doUpdateComponents();
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnLocalCheckAll);
        swingManager.translate((AbstractButton)this.btnLocalUpload);
        swingManager.translate((AbstractButton)this.btnLocalRefresh);
        swingManager.translate((AbstractButton)this.btnLocalRevert);
        swingManager.translate((AbstractButton)this.btnLocalShowForm);
        swingManager.translate((AbstractButton)this.btnLocalUnCheckAll);
        swingManager.translate((AbstractButton)this.btnLocalCenter);
        swingManager.translate((AbstractButton)this.btnLocalHighlight);
        swingManager.translate((AbstractButton)this.btnLocalZoom);
        swingManager.translate((AbstractButton)this.btnLocalCleanHighlighted);
    }

    private Iterator<Long> getSelectionIterator() {
        final ListSelectionModel selection = this.tblLocalChanges.getSelectionModel();
        return new Iterator<Long>(){
            long n;
            {
                this.n = selection.getMinSelectionIndex();
            }

            @Override
            public boolean hasNext() {
                while (this.n <= (long)selection.getMaxSelectionIndex()) {
                    if (selection.isSelectedIndex((int)this.n)) {
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }

            @Override
            public Long next() {
                if (this.n > (long)selection.getMaxSelectionIndex()) {
                    throw new IllegalStateException();
                }
                return this.n++;
            }
        };
    }

    private void doToggleSelection() {
        this.context.startProcess(() -> {
            try {
                Iterator<Long> rows = this.getSelectionIterator();
                this.changes.process(rows, change -> {
                    change.setSelected(!change.isSelected());
                    return true;
                });
                if (!this.entitiesToUnCheckAll.isEmpty()) {
                    this.doUnCheckAllByEntities();
                }
            }
            finally {
                this.doUpdateEntitiesWithSelectedChanges();
                this.doUpdateIsSelectionFromEntitiesEmpty();
            }
        }, "OnlineToggleSelectionLocalChanges", null);
    }

    private Iterator<Long> getRowsByEntitiesToUnCheckIterator() {
        final long size = this.changes.size64();
        TableModel model = this.tblLocalChanges.getModel();
        return new Iterator<Long>(){
            long n = 0L;

            @Override
            public boolean hasNext() {
                while (this.n < size) {
                    OnlineWorkingcopyChange row = (OnlineWorkingcopyChange)LocalChangesController.this.changes.get64(this.n);
                    if (LocalChangesController.this.entitiesToUnCheckAll.contains(row.getEntityCode())) {
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }

            @Override
            public Long next() {
                return this.n++;
            }
        };
    }

    private void doUnCheckAllByEntities() {
        if (this.dissabledUncheckAllByEntities) {
            return;
        }
        this.context.startProcess(() -> {
            try {
                if (!this.entitiesToUnCheckAll.isEmpty()) {
                    Iterator<Long> rows = this.getRowsByEntitiesToUnCheckIterator();
                    this.changes.process(rows, change -> true);
                    this.entitiesToUnCheckAll.clear();
                }
            }
            finally {
                this.doUpdateEntitiesWithSelectedChanges();
            }
        }, "OnlineUnCheckAllByEntitiesLocalChanges", null);
    }

    private Iterator<Long> getRowsIterator() {
        final long size = this.changes.size64();
        return new Iterator<Long>(){
            long n = 0L;

            @Override
            public boolean hasNext() {
                return this.n < size;
            }

            @Override
            public Long next() {
                return this.n++;
            }
        };
    }

    private void doCheckAll() {
        this.context.startProcess(() -> {
            try {
                this.dissabledUncheckAllByEntities = true;
                this.doUpdateComponents();
                this.changes.setSelectionAll();
            }
            finally {
                this.dissabledUncheckAllByEntities = false;
            }
        }, "OnlineCheckAllLocalChanges", null);
    }

    private void doUnCheckAll() {
        this.context.startProcess(() -> {
            try {
                this.dissabledUncheckAllByEntities = true;
                this.doUpdateComponents();
                this.changes.clearSelection();
            }
            finally {
                this.dissabledUncheckAllByEntities = false;
            }
        }, "OnlineUncheckAllLocalChanges", null);
    }

    private OnlineWorkingcopy getUndisposableWorkspace() {
        OnlineWorkingcopy ws = this.getWorkspace();
        DisposeUtils.disposeQuietly((Disposable)ws);
        return ws;
    }

    private OnlineWorkingcopy getWorkspace() {
        OnlineWorkingcopy ws = this.context.getWorkspace();
        return ws;
    }

    void doUpdateComponents() {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateComponents())) {
            return;
        }
        try {
            boolean changesIsEmpty = this.changes == null || this.changes.isEmpty();
            this.context.setVisibleStatus(this.context.isProcessing());
            OnlineWorkingcopy ws = this.getUndisposableWorkspace();
            this.context.btnClose.setEnabled(!this.context.isProcessing());
            this.workspacePicker.setEnabled(!this.context.isProcessing());
            this.btnLocalCheckAll.setEnabled(!this.context.isProcessing() && !changesIsEmpty);
            this.btnLocalUnCheckAll.setEnabled(!this.context.isProcessing() && !changesIsEmpty);
            List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
            this.btnLocalRefresh.setEnabled(!this.context.isProcessing() && this.changes != null && CollectionUtils.isNotEmpty((Collection)checkedEntities));
            this.btnLocalRevert.setEnabled(ws != null && !this.context.isProcessing() && !changesIsEmpty && CollectionUtils.isNotEmpty((Collection)checkedEntities) && this.entitiesWithSelectedChanges != null && !this.entitiesWithSelectedChanges.isEmpty() && !this.isSelectionFromEntitiesEmpty);
            this.btnLocalRevert.setVisible(true);
            if (!(ws == null || this.context.isProcessing() || changesIsEmpty || this.changes.isSelectionEmpty() || !CollectionUtils.isNotEmpty((Collection)checkedEntities) || this.entitiesWithSelectedChanges == null || this.entitiesWithSelectedChanges.isEmpty() || this.isSelectionFromEntitiesEmpty)) {
                MutableObject msg = new MutableObject();
                if (this.areConflictCheckedEntities()) {
                    this.context.alert("_There_are_selected_entities_that_have_conflicts");
                    this.btnLocalUpload.setEnabled(false);
                    LOGGER.info("Can't enable upload (1.2). There are selected entities that have conflicts.");
                } else if (this.areCorruptOrDisconnectedEntities(checkedEntities)) {
                    this.context.alert("_There_are_selected_corrupted_or_disconnected_entities");
                    this.btnLocalUpload.setEnabled(false);
                    LOGGER.info("Can't enable upload (1.2). There are selected corrputed or diconnected entities.");
                } else if (!ws.canUpload(msg, this.getEntityCodes(checkedEntities))) {
                    this.context.alert((String)msg.getValue());
                    this.btnLocalUpload.setEnabled(false);
                    LOGGER.info("Can't enable upload (1). " + (String)msg.getValue());
                } else {
                    this.btnLocalUpload.setEnabled(true);
                }
            } else {
                try {
                    if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                        this.context.message("_Select_tables_to_view_changes");
                        LOGGER.info("Can't enable upload (2).");
                    } else if (changesIsEmpty || this.changes.isSelectionEmpty()) {
                        this.context.message("_Select_the_changes_to_upload");
                        LOGGER.info("Can't enable upload (3).");
                    } else if (this.entitiesWithSelectedChanges == null || this.entitiesWithSelectedChanges.isEmpty()) {
                        this.context.message("_Cant_locate_the_tables_related_to_changes");
                        LOGGER.info("Can't enable upload (4).");
                    } else if (this.isSelectionFromEntitiesEmpty) {
                        this.context.message("_Cant_locate_changes_in_selected_tables");
                        LOGGER.info("Can't enable upload (5).");
                    } else {
                        LOGGER.info("Can't enable upload (6).");
                    }
                }
                catch (Exception ex) {
                    LOGGER.info("Can't enable upload (7).");
                }
                this.btnLocalUpload.setEnabled(false);
            }
            boolean enableShowForm = false;
            int row = this.tblLocalChanges.getSelectedRow();
            if (!this.context.isProcessing() && row >= 0) {
                enableShowForm = true;
            }
            this.btnLocalShowForm.setEnabled(!this.context.isProcessing() && enableShowForm);
            this.tblLocalChanges.setEnabled(!this.context.isProcessing());
            this.workspacePicker.setEnabled(!this.context.isProcessing());
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            this.btnLocalCenter.setEnabled(!this.context.isProcessing() && (geom != null || originalGeom != null));
            this.btnLocalHighlight.setEnabled(!this.context.isProcessing() && (geom != null || originalGeom != null));
            this.btnLocalZoom.setEnabled(!this.context.isProcessing() && (geom != null || originalGeom != null));
            this.btnLocalCleanHighlighted.setEnabled(!this.context.isProcessing());
        }
        catch (OnlineRuntimeException e1) {
            LOGGER.warn("Can't updating components.", (Throwable)e1);
            if (OnlineSwingCommons.showAuthenticationErrors("_Online_Changes", e1)) {
                this.workspacePicker.set(null);
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't updating components.", (Throwable)e2);
        }
    }

    public void doUpdateEntitiesWithSelectedChanges() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws != null) {
            this.entitiesWithSelectedChanges = ws.getEntitiesWithSelectedChanges();
        }
    }

    private void doUpdateIsSelectionFromEntitiesEmpty() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws != null) {
            List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
            this.isSelectionFromEntitiesEmpty = this.changes.isSelectionFromEntitiesEmpty(checkedEntities);
        }
    }

    public void doUpdateTableLocalChanges() {
        if (this.context.isProcessing()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws != null) {
            this.doUpdateEntitiesWithSelectedChanges();
            List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
            if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                LocalChangesTableModel localChangesTableModel = new LocalChangesTableModel(ws);
                this.tblLocalChanges.setModel(localChangesTableModel);
                return;
            }
            this.changes = ws.getLocalChanges(checkedEntities);
            LocalChangesTableModel localChangesTableModel = new LocalChangesTableModel(this.changes, ws);
            this.tblLocalChanges.setModel(localChangesTableModel);
            int columns = this.tblLocalChanges.getColumnModel().getColumnCount();
            for (int i = 1; i < columns; ++i) {
                this.tblLocalChanges.getColumnModel().getColumn(i).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        OnlineChange changeRow = (OnlineChange)LocalChangesController.this.changes.get64((long)row);
                        OnlineSwingCommons.setColorCompoment(c, changeRow.getStatus());
                        return c;
                    }
                });
            }
            this.tableModelListener = null;
            localChangesTableModel.addTableModelListener(this.getTableModelListener());
            this.context.message(i18n.getTranslation("_Workingcopy_changes_list_updated", new String[]{String.valueOf(this.changes.size64())}));
            this.lblLocalChangesCount.setText(String.valueOf(this.changes.size64()));
        }
        this.doUpdateIsSelectionFromEntitiesEmpty();
        this.context.doUpdateComponents();
    }

    private TableModelListener getTableModelListener() {
        if (this.tableModelListener == null) {
            this.tableModelListener = e -> {
                if (e.getType() == 0) {
                    TableModel model = (TableModel)e.getSource();
                    OnlineWorkingcopyChange onlineWorkingcopyChange = (OnlineWorkingcopyChange)this.changes.get64((long)e.getFirstRow());
                }
            };
        }
        return this.tableModelListener;
    }

    private void doShowForm() {
        int row = this.tblLocalChanges.getSelectedRow();
        OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)row);
        if (change.getOperation() == 0) {
            return;
        }
        Feature feature = change.getRelatedFeature();
        if (feature == null) {
            return;
        }
        try {
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            JFeatureForm form = dataSwingManager.createJFeatureForm(feature);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            form.asJComponent().setPreferredSize(new Dimension(400, 200));
            winManager.showWindow(form.asJComponent(), "Local change: " + change.getLabel(), WindowManager.MODE.WINDOW);
        }
        catch (CreateJFeatureFormException ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
    }

    private void doUpload() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            LOGGER.warn("Can't do upload action because can't get undisposable workingcopy");
            return;
        }
        List entities = this.context.getEntitySelector().getCheckedEntities();
        List<String> entityCodes = this.getEntityCodes(entities);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        for (OnlineEntity entity : entities) {
            int n;
            if (!ws.isSynchOutdated(entity)) continue;
            String lastSyncStr = i18n.getTranslation("_Unknown_date");
            LocalDateTime lastSync = ws.getLastSync(entity);
            if (lastSync.compareTo(LocalDateTime.MIN) > 0) {
                lastSyncStr = lastSync.toString();
            }
            if ((n = dialogs.confirmDialog(i18n.getTranslation("_Outdated_synchronization") + "\n" + i18n.getTranslation("_The_date_of_the_last_synchronization_of_the_XentityX_entity_was_XdateX", new String[]{entity.getEntityName(), lastSyncStr}) + "\n" + i18n.getTranslation("_It_is_recommended_to_synchronize") + "\n" + i18n.getTranslation("_Do_you_want_to_continue_anyway"), i18n.getTranslation("_Upload"), 0, 3)) == 0) continue;
            return;
        }
        MutableObject message = new MutableObject();
        if (!ws.canUpload(message, entityCodes)) {
            dialogs.messageDialog(i18n.getTranslation("_Cant_upload") + "\n" + (String)message.getValue(), i18n.getTranslation("_Upload"), 2);
            return;
        }
        this.tblLocalChanges.setModel(new LocalChangesTableModel(ws));
        SimpleTaskStatus status = this.context.getTaskStatus();
        status.setTitle(i18n.getTranslation("_Sending"));
        MutableInt r = new MutableInt(0);
        this.context.startProcess(() -> r.setValue(ws.upload(entityCodes, status)), "OnlineUpload", () -> this.doPostUpload(r.getValue(), entityCodes, status));
    }

    private void doPostUpload(int uploadStatus, List<String> entityCodes, SimpleTaskStatus status) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostUpload(uploadStatus, entityCodes, status))) {
            return;
        }
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            LOGGER.warn("Can't do post upload action because can't get undisposable workingcopy");
            return;
        }
        HashSet<JDBCStoreParameters> params = new HashSet<JDBCStoreParameters>();
        for (String entityCode : entityCodes) {
            params.add(ws.getFeatureStoreParameters(ws.getEntity(entityCode).getEntityName()));
        }
        OnlineSwingLocator.getOnlineSwingManager().getDefaultServices().refreshDocumentByParams(params);
        switch (uploadStatus) {
            case 0: {
                this.context.setVisibleStatus(false);
                this.context.getTaskStatus().terminate();
                status.message("_Online_upload_finished");
                break;
            }
            default: {
                this.context.getTaskStatus().abort();
                OnlineSwingCommons.showAuthenticationErrors("_Online_Upload", uploadStatus);
            }
        }
        this.context.getEntitySelector().reloadEntities();
        this.context.updateLocalChangesTable();
        OnlineSwingCommons.cleanHighligthed();
    }

    private void doRevert() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        MutableInt r = new MutableInt(0);
        ArrayList entities = new ArrayList();
        this.context.startProcess(() -> {
            block4: {
                try {
                    entities.addAll(ws.getEntitiesWithSelectedChanges());
                    List<String> selectedEntityCodes = this.getEntityCodes(this.context.getEntitySelector().getCheckedEntities());
                    r.setValue(0);
                    if (entities.isEmpty() || !CollectionUtils.isNotEmpty(selectedEntityCodes)) break block4;
                    for (OnlineEntity entity : entities) {
                        if (selectedEntityCodes.contains(entity.getEntityCode())) {
                            r.setValue(ws.revert(entity.getEntityCode(), this.context.getTaskStatusController().getSimpleTaskStatus()));
                        }
                        if (r.getValue() == 0) continue;
                        break;
                    }
                }
                catch (UserCancelTaskException ex) {
                    LOGGER.warn("User cancelled");
                }
            }
        }, "OnlineRevert", () -> this.doPostRevert(r.getValue(), entities));
    }

    private void doPostRevert(int revertStatus, List<OnlineEntity> entities) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostRevert(revertStatus, entities))) {
            return;
        }
        if (revertStatus == 0) {
            this.context.setVisibleStatus(false);
            this.context.getTaskStatus().terminate();
        } else {
            this.context.getTaskStatus().abort();
        }
        for (OnlineEntity entity : entities) {
            JDBCStoreParameters params = this.getUndisposableWorkspace().getFeatureStoreParameters(entity.getEntityName());
            OnlineSwingCommons.refreshDocumentByParams(params);
        }
        this.context.updateLocalChangesTable();
        OnlineSwingCommons.cleanHighligthed();
    }

    private Geometry getBBoxOfSelectedChanges() {
        int[] selecteds = this.tblLocalChanges.getSelectedRows();
        if (selecteds != null && selecteds.length >= 0) {
            Envelope env = GeometryUtils.createEnvelope((int)0);
            for (int i = 0; i < selecteds.length; ++i) {
                int selected = selecteds[i];
                OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selected);
                try {
                    Feature feature = change.getRelatedFeature();
                    Geometry geom = feature.getDefaultGeometry();
                    env.add(geom);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!env.isEmpty()) {
                return env.getBox2D();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Geometry getOriginalBBoxOfSelectedChanges() {
        int[] selecteds = this.tblLocalChanges.getSelectedRows();
        if (selecteds != null && selecteds.length >= 0) {
            Envelope env = GeometryUtils.createEnvelope((int)0);
            HashMap<String, FeatureStore> stores = new HashMap<String, FeatureStore>();
            try {
                for (int i = 0; i < selecteds.length; ++i) {
                    int selected = selecteds[i];
                    OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selected);
                    FeatureStore store = null;
                    try {
                        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
                        if (ws == null) continue;
                        JsonObject json = change.getDataAsJson();
                        String entityCode = change.getEntityCode();
                        OnlineEntity entity = ws.getEntity(entityCode);
                        store = (FeatureStore)stores.get(entity.getEntityName());
                        if (store == null) {
                            store = ws.openFeatureStore(entity.getEntityName(), false);
                            stores.put(entity.getEntityName(), store);
                        }
                        EditableFeature feature = store.createNewFeature(json);
                        Geometry geom = feature.getDefaultGeometry();
                        env.add(geom);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                for (FeatureStore value : stores.values()) {
                    DisposeUtils.disposeQuietly((Disposable)value);
                }
                stores = null;
            }
            if (!env.isEmpty()) {
                return env.getBox2D();
            }
        }
        return null;
    }

    private Geometry getGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            if (this.tblLocalChanges.getSelectedRowCount() > 1 && this.tblLocalChanges.getSelectedRowCount() < 200) {
                for (int selectedRow : this.tblLocalChanges.getSelectedRows()) {
                    OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selectedRow);
                    Feature feature = change.getRelatedFeature();
                    Geometry currentGeom = feature.getDefaultGeometry();
                    if (currentGeom == null) continue;
                    if (geom == null) {
                        int type = currentGeom.getType();
                        if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                        } else {
                            return geom;
                        }
                    }
                    ((MultiPrimitive)geom).addPrimitives(currentGeom);
                }
            } else {
                int selected = this.tblLocalChanges.getSelectedRow();
                if (selected >= 0) {
                    OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selected);
                    try {
                        Feature feature = change.getRelatedFeature();
                        geom = feature.getDefaultGeometry();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Geometry getOriginalGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            if (this.tblLocalChanges.getSelectedRowCount() > 1 && this.tblLocalChanges.getSelectedRowCount() < 200) {
                int[] nArray = this.tblLocalChanges.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectedRow = nArray[n2];
                    OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selectedRow);
                    try {
                        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
                        if (ws != null) {
                            JsonObject json = change.getDataAsJson();
                            String entityCode = change.getEntityCode();
                            OnlineEntity entity = ws.getEntity(entityCode);
                            FeatureStore store = ws.openFeatureStore(entity.getEntityName(), false);
                            EditableFeature feature = store.createNewFeature(json);
                            Geometry currentGeom = feature.getDefaultGeometry();
                            if (currentGeom != null) {
                                if (geom == null) {
                                    int type = currentGeom.getType();
                                    if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                                        geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                                    } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                                        geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                                    } else {
                                        if (!GeometryUtils.isSubtype((int)3, (int)type)) {
                                            if (!GeometryUtils.isSubtype((int)9, (int)type)) return geom;
                                        }
                                        geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                                    }
                                }
                                ((MultiPrimitive)geom).addPrimitives(currentGeom);
                            }
                        }
                    }
                    catch (Exception ws) {
                        // empty catch block
                    }
                    ++n2;
                }
                return geom;
            }
            int selected = this.tblLocalChanges.getSelectedRow();
            if (selected < 0) return geom;
            OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selected);
            try {
                OnlineWorkingcopy ws = this.getUndisposableWorkspace();
                if (ws == null) return geom;
                JsonObject json = change.getDataAsJson();
                String entityCode = change.getEntityCode();
                OnlineEntity entity = ws.getEntity(entityCode);
                FeatureStore store = ws.openFeatureStore(entity.getEntityName(), false);
                EditableFeature feature = store.createNewFeature(json);
                return feature.getDefaultGeometry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    private Envelope getEnvelopeOfAllLocalChanges() {
        Envelope env = GeometryUtils.createEnvelope((int)0);
        try {
            OnlineWorkingcopy ws = this.getUndisposableWorkspace();
            int i = 0;
            while ((long)i < this.changes.size64()) {
                OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)i);
                Geometry currentGeom = change.getRelatedFeature().getDefaultGeometry();
                env.add(currentGeom);
                if (ws != null) {
                    try {
                        JsonObject json = change.getDataAsJson();
                        String entityCode = change.getEntityCode();
                        OnlineEntity entity = ws.getEntity(entityCode);
                        FeatureStore store = ws.openFeatureStore(entity.getEntityName(), false);
                        EditableFeature feature = store.createNewFeature(json);
                        Geometry originalGeom = feature.getDefaultGeometry();
                        env.add(originalGeom);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return env;
        }
        catch (Exception ex) {
            return env;
        }
    }

    private FeatureStore getStoreOfSelectedChange() {
        FeatureStore store = null;
        int selected = this.tblLocalChanges.getSelectedRow();
        if (selected >= 0) {
            OnlineWorkingcopyChange change = (OnlineWorkingcopyChange)this.changes.get64((long)selected);
            try {
                OnlineWorkingcopy ws = this.getUndisposableWorkspace();
                if (ws != null) {
                    String entityCode = change.getEntityCode();
                    OnlineEntity entity = ws.getEntity(entityCode);
                    store = ws.openFeatureStore(entity.getEntityName(), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return store;
    }

    private void doZoomToSelectedChange() {
        OnlineSwingCommons.cleanHighligthed();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        if (this.tblLocalChanges.getSelectionModel().isSelectionEmpty()) {
            FeatureStore store = this.context.getWorkspaceStoreOfSelectedEntity();
            if (store == null) {
                return;
            }
            Envelope env = this.getEnvelopeOfAllLocalChanges();
            services.zoomViewsHavingAStoreToGeometry(store, env.getBox2D());
            return;
        }
        FeatureStore store = this.getStoreOfSelectedChange();
        if (this.tblLocalChanges.getSelectedRowCount() > 200) {
            Geometry geom = this.getBBoxOfSelectedChanges();
            Geometry originalGeom = this.getOriginalBBoxOfSelectedChanges();
            services.zoomViewsHavingAStoreToGeometry(store, OnlineSwingCommons.createBBox(geom, originalGeom));
            this.context.message("_Too_many_items_selected");
        } else {
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            services.zoomViewsHavingAStoreToGeometry(store, OnlineSwingCommons.createBBox(geom, originalGeom));
            if (geom != null) {
                services.highlight(2, geom, store);
            }
            if (originalGeom != null) {
                services.highlight(3, originalGeom, store);
            }
        }
    }

    private void doCenterToSelectedChange() {
        OnlineSwingCommons.cleanHighligthed();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        if (this.tblLocalChanges.getSelectionModel().isSelectionEmpty()) {
            FeatureStore store = this.context.getWorkspaceStoreOfSelectedEntity();
            if (store == null) {
                return;
            }
            Envelope env = this.getEnvelopeOfAllLocalChanges();
            services.centerViewsHavingAStoreToGeometry(store, env.getBox2D());
            return;
        }
        FeatureStore store = this.getStoreOfSelectedChange();
        if (this.tblLocalChanges.getSelectedRowCount() > 200) {
            Geometry geom = this.getBBoxOfSelectedChanges();
            Geometry originalGeom = this.getOriginalBBoxOfSelectedChanges();
            services.centerViewsHavingAStoreToGeometry(store, OnlineSwingCommons.createBBox(geom, originalGeom));
            this.context.message("_Too_many_items_selected");
        } else {
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            services.centerViewsHavingAStoreToGeometry(store, OnlineSwingCommons.createBBox(geom, originalGeom));
            if (geom != null) {
                services.highlight(2, geom, store);
            }
            if (originalGeom != null) {
                services.highlight(3, originalGeom, store);
            }
        }
    }

    private void doHighLightSelectedChange() {
        OnlineSwingCommons.cleanHighligthed();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getStoreOfSelectedChange();
        if (this.tblLocalChanges.getSelectedRowCount() > 200) {
            this.context.message("_Too_many_items_selected");
        } else {
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            if (geom != null) {
                services.highlight(2, geom, store);
            }
            if (originalGeom != null) {
                services.highlight(3, originalGeom, store);
            }
        }
    }

    private List<String> getEntityCodes(List<OnlineEntity> entities) {
        ArrayList<String> res = new ArrayList<String>();
        for (OnlineEntity entity : entities) {
            res.add(entity.getEntityCode());
        }
        return res;
    }

    public void selectOnlyAEntity(OnlineEntity entity) {
        this.context.getEntitySelector().clearChecks();
        this.context.getEntitySelector().check(entity);
    }

    public void selectOnlyAEntity(List<OnlineEntity> entities) {
        this.context.getEntitySelector().clearChecks();
        for (OnlineEntity entity : entities) {
            this.context.getEntitySelector().check(entity);
        }
    }

    protected void doDispose() throws BaseException {
    }

    private void doCheckRecomendedEntities() {
        OnlineWorkingcopy workspace = this.getUndisposableWorkspace();
        if (workspace == null) {
            return;
        }
        HashSet<String> uploadEntities = new HashSet<String>();
        Collection entities = this.context.getEntitySelector().getEntities();
        for (OnlineEntity entity : entities) {
            if (!workspace.existsInWorkspace(entity)) continue;
            OnlineEntity lentity = workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            switch (lentity.getState()) {
                default: {
                    uploadEntities.add(entity.getEntityCode());
                }
                case 1: 
                case 6: 
                case 8: 
                case 16: 
                case 32: 
                case 128: 
                case 256: 
                case 384: 
            }
        }
        this.context.getEntitySelector().setCheck(uploadEntities, true);
    }

    private boolean areCorruptOrDisconnectedEntities(List<OnlineEntity> entities) {
        for (OnlineEntity entity : entities) {
            OnlineEntity lentity;
            int maskState;
            if (!(entity instanceof OnlineEntity) || ((maskState = (lentity = entity).getState()) & 0x80) != 128 && (maskState & 0x100) != 256) continue;
            return true;
        }
        return false;
    }

    private boolean areConflictCheckedEntities() {
        return this.context.hasRemotesChanges();
    }

    public int getSelectedRowCount() {
        return this.tblLocalChanges.getSelectedRowCount();
    }
}

