/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.changes;

import javax.swing.table.AbstractTableModel;
import org.gvsig.online.lib.api.workingcopy.OnlineChange;
import org.gvsig.online.lib.api.workingcopy.OnlineChanges;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class LocalChangesTableModel
extends AbstractTableModel {
    private final OnlineChanges<OnlineChange> changes;
    private final OnlineWorkingcopy ws;
    private static String[] columnNames;
    private static final Class<?>[] COLUMNCLASS;

    public LocalChangesTableModel() {
        this(null, null);
    }

    public LocalChangesTableModel(OnlineWorkingcopy ws) {
        this(null, ws);
    }

    public LocalChangesTableModel(OnlineChanges changes, OnlineWorkingcopy ws) {
        this.ws = ws;
        I18nManager i18n = ToolsLocator.getI18nManager();
        columnNames = new String[]{i18n.getTranslation("_Select"), i18n.getTranslation("_Table"), i18n.getTranslation("_Operation"), i18n.getTranslation("_Label"), i18n.getTranslation("_Code")};
        this.changes = changes;
        if (this.changes != null) {
            this.changes.addChangeListener(e -> this.fireTableDataChanged());
        }
    }

    @Override
    public int getRowCount() {
        if (this.changes == null) {
            return 0;
        }
        try {
            return (int)this.changes.size64();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.changes == null || this.ws == null) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineChange row = (OnlineChange)this.changes.get64((long)rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.isSelected();
            }
            case 1: {
                OnlineEntity entity = this.ws.getEntity(row.getEntityCode());
                if (entity == null) {
                    return "unknown (" + row.getEntityCode() + ")";
                }
                return this.ws.getEntity(row.getEntityCode()).getEntityName();
            }
            case 2: {
                int op = row.getOperation();
                return i18n.getTranslation(OnlineSwingCommons.getOperationLabel(op));
            }
            default: {
                return row.getLabel();
            }
            case 4: 
        }
        return row.getRelatedFeatureCode();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return;
        }
        OnlineChange row = (OnlineChange)this.changes.get64((long)rowIndex);
        switch (columnIndex) {
            case 0: {
                Boolean selected = (Boolean)aValue;
                if (selected.booleanValue()) {
                    this.changes.addSelected((long)rowIndex);
                    break;
                }
                this.changes.removeSelected((long)rowIndex);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNCLASS[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public boolean isEmpty() {
        return this.changes == null || this.changes.isEmpty();
    }

    static {
        COLUMNCLASS = new Class[]{Boolean.class, String.class, Integer.class, String.class, String.class};
    }
}

