/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.changes;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.OnlineRuntimeException;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.online.swing.api.OnlineEntitySelectorController;
import org.gvsig.online.swing.api.OnlineJChanges;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.online.swing.impl.OnlineSwingLibraryImpl;
import org.gvsig.online.swing.impl.OnlineSwingManagerImpl;
import org.gvsig.online.swing.impl.OnlineWorkingcopyPickerControllerImpl;
import org.gvsig.online.swing.impl.changes.LocalChangesController;
import org.gvsig.online.swing.impl.changes.LocalChangesTableModel;
import org.gvsig.online.swing.impl.changes.OnlineJChangesView;
import org.gvsig.online.swing.impl.changes.RemoteChangesController;
import org.gvsig.online.swing.impl.workingarea.WorkingAreaPickerControllerImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.IsEmpty;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineJChangesImpl
extends OnlineJChangesView
implements OnlineJChanges,
PropertiesSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineJChangesImpl.class);
    private static final int ZONE_ONLY_CHANGES = 0;
    private static final int ZONE_CHANGES_AND_WORKING_AREA = 1;
    public static final int NOTCLOSABLE = 64;
    public static final int RESIZABLE = 1;
    public static final int MAXIMIZABLE = 2;
    public static final int ICONIFIABLE = 4;
    public static final int LOCAL_TAB_INDEX = 0;
    public static final int REMOTE_TAB_INDEX = 1;
    private OnlineWorkingcopyPickerControllerImpl workspacePicker;
    private LocalChangesController localChangesController;
    private RemoteChangesController remoteChangesController;
    private boolean entitiesUpdateds;
    private OnlineWorkingcopy currentWorkingcopy;
    private TaskStatusController taskStatusController;
    private Timer timerClearMsg;
    private boolean processing;
    private JSplitPane splChanges;
    private SimpleTaskStatus taskStatus;
    private PropertiesSupportHelper propertiesSupport;
    private List<String> defaultTablesSelection;
    private OnlineEntitySelectorController entitySelector;
    private WorkingAreaPickerControllerImpl workingAreaPicker;
    private String currentProcessName;

    public OnlineJChangesImpl() {
        this(null, null, null, null);
    }

    public OnlineJChangesImpl(OnlineWorkingcopy workspace, List<String> tableNames, Timestamp efectivedate, String comment) {
        this.defaultTablesSelection = tableNames == null ? Collections.EMPTY_LIST : tableNames;
        this.processing = false;
        this.propertiesSupport = new PropertiesSupportHelper();
        this.propertiesSupport.setProperty("WindowInfo.Flags", (Object)71);
        this.initComponents();
        SwingUtilities.invokeLater(() -> this.workspacePicker.set(workspace));
    }

    public List<String> getDefaultTablesSelection() {
        return this.defaultTablesSelection;
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return OnlineSwingManagerImpl.loadImage(imageName);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate((AbstractButton)this.btnWorkspace);
        swingManager.translate((AbstractButton)this.btnClose);
        swingManager.translate(this.tabLocalAndRemote);
        swingManager.translate((AbstractButton)this.btnSynchronize);
        swingManager.translate((AbstractButton)this.btnLocalCheckRecomendedEntities);
        swingManager.translate((AbstractButton)this.btnLocalCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnLocalUnCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnLocalCollapseAllEntities);
        swingManager.translate((AbstractButton)this.btnLocalExpandAllEntities);
        swingManager.translate((AbstractButton)this.btnEntitiesReload);
        swingManager.translate(this.lblSynchorizationZone);
        swingManager.translate((JComponent)this.cboSynchorizationZone);
    }

    private void initComponents() {
        OnlineSwingManager onlineSwingManager = OnlineSwingLocator.getOnlineSwingManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        OnlineSwingServices onlineservices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                OnlineJChangesImpl.this.dispose();
            }
        });
        this.splChanges = ToolsSwingUtils.createHorizontalSplit((JPanel)this.gridChanges, (JPanel)this.gridWorkingCopyList, (boolean)false, (JPanel)this.gridTabs, (boolean)false);
        this.splChanges.setDividerLocation(ToolsSwingUtils.cols2px((int)45));
        this.timerClearMsg = new Timer(20000, e -> {
            if (!this.processing) {
                this.lblStatusMessages.setText("");
            }
        });
        this.timerClearMsg.setRepeats(false);
        this.translate();
        this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("");
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblStatusCaption, this.lblStatusMessages, this.pbStatus, this.btnStatusCancel, null);
        this.taskStatusController.setShowCancelButton(true);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind((TaskStatus)this.taskStatus);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = (OnlineWorkingcopyPickerControllerImpl)onlineSwingManager.createPickerWorkspaceController(this.cboWorkspace, this.btnWorkspace);
        this.workspacePicker.addChangeListener(e -> this.doChangeWorkspace());
        this.btnLocalCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalUnCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCheckAllEntities.addActionListener(e -> this.entitySelector.checkAll());
        this.btnLocalUnCheckAllEntities.addActionListener(e -> this.entitySelector.clearChecks());
        this.btnLocalCollapseAllEntities.addActionListener(e -> this.entitySelector.collapseAll());
        this.btnLocalExpandAllEntities.addActionListener(e -> this.entitySelector.expandAll());
        this.entitySelector = onlineSwingManager.createEntitySelectorController(this.treeLocalTables, (JTextComponent)this.txtLocalTablesFilter, this.btnLocalTable);
        this.entitySelector.setViewFilter(OnlineEntitySelectorController.LOCAL_ENTITIES);
        this.entitySelector.setFilter(OnlineEntitySelectorController.LOCAL_ENTITIES);
        this.entitySelector.setChecksEnabled(true);
        this.entitySelector.addChangeListener(e -> this.localChangesController.doUpdateTableLocalChanges());
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 0: {
                    this.doUpdateComponents();
                    break;
                }
                case 1: {
                    this.localChangesController.doUpdateTableLocalChanges();
                    this.remoteChangesController.doReloadChanges();
                    this.doUpdateComponents();
                    break;
                }
                case 2: {
                    this.localChangesController.doUpdateTableLocalChanges();
                    this.remoteChangesController.doReloadChanges();
                    this.doUpdateComponents();
                }
            }
        });
        this.workingAreaPicker = new WorkingAreaPickerControllerImpl(() -> this.getWorkspace().getSite(), this.txtWorkingAreaLabel, this.txtWorkingArea, this.btnWorkingAreaFromView, this.btnWorkingAreaDialog, this.btnWorkingAreaHistory, this.btnWorkingAreaBookmarks, () -> {
            LabeledValue n = onlineservices.getActiveMapControl();
            return n == null ? null : (MapControl)n.getValue();
        }, () -> {
            List<OnlineLayer> selectedLayers = this.getSelectedLayers();
            if (selectedLayers.isEmpty()) {
                return null;
            }
            return selectedLayers;
        });
        this.workingAreaPicker.addChangeListener(e -> this.doUpdateComponents());
        I18nManager i18n = ToolsLocator.getI18nManager();
        DefaultComboBoxModel<LabeledValueImpl> zoneModel = new DefaultComboBoxModel<LabeledValueImpl>();
        zoneModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Only_changes_zone"), (Object)0));
        zoneModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Changes_zone_and_working_area"), (Object)1));
        this.cboSynchorizationZone.setModel(zoneModel);
        this.cboSynchorizationZone.addActionListener(e -> this.doUpdateComponents());
        this.cboSynchorizationZone.setSelectedIndex(1);
        this.localChangesController = new LocalChangesController(this, (PickerController<OnlineWorkingcopy>)this.workspacePicker, this.tblLocalChanges, this.btnLocalCheckAll, this.btnLocalUnCheckAll, this.btnLocalShowForm, this.btnLocalRefresh, this.btnLocalUpload, this.btnLocalRevert, this.btnLocalZoom, this.btnLocalCenter, this.btnLocalHighlight, this.btnLocalCleanHighligthed, this.lblLocalChangesCount, this.txtLocalTablesFilter, this.btnLocalTable);
        this.remoteChangesController = new RemoteChangesController(this, (PickerController<OnlineWorkingcopy>)this.workspacePicker, this.tblRemoteChanges, this.btnRemoteCheckAll, this.btnRemoteUncheckAll, this.btnRemoteReloadChanges, this.btnRemoteCleanChanges, this.btnRemoteUpdate, this.btnRemoteMerge, this.btnRemoteShowForm, this.btnRemoteZoom, this.btnRemoteCenter, this.btnRemoteHighlight, this.btnRemoteCleanHighligthed, this.lblRemoteChangesCount);
        this.btnClose.addActionListener(e -> {
            if (this.processing) {
                return;
            }
            this.setVisible(false);
        });
        this.btnLocalCheckRecomendedEntities.addActionListener(e -> this.doCheckRecomendedEntities());
        this.btnEntitiesReload.addActionListener(e -> this.doReloadTables());
        this.btnSynchronize.addActionListener(e -> this.doSynchronize());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)14, (int)100);
        SwingUtilities.invokeLater(() -> this.message(""));
    }

    private List<OnlineLayer> getSelectedLayers() {
        List entities = this.getEntitySelector().getCheckedEntities();
        OnlineProject project = this.getWorkspace().getProject();
        ArrayList<OnlineLayer> result = new ArrayList<OnlineLayer>();
        for (OnlineEntity entity : entities) {
            OnlineLayer layer = project.getLayer(t -> StringUtils.equalsIgnoreCase((CharSequence)t.getName(), (CharSequence)entity.getEntityName()), null);
            result.add(layer);
        }
        return result;
    }

    void doUpdateComponents() {
        OnlineWorkingcopy ws;
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateComponents())) {
            return;
        }
        if (this.localChangesController != null) {
            this.localChangesController.doUpdateComponents();
        }
        if (this.remoteChangesController != null) {
            this.remoteChangesController.doUpdateComponents();
        }
        if ((ws = this.getWorkspace()) == null) {
            this.cboSynchorizationZone.setEnabled(false);
            this.workingAreaPicker.setEnabled(false);
            this.btnSynchronize.setEnabled(false);
            this.btnEntitiesReload.setEnabled(false);
            return;
        }
        LabeledValue zoneMode = (LabeledValue)this.cboSynchorizationZone.getSelectedItem();
        if (zoneMode == null) {
            this.workingAreaPicker.setEnabled(false);
            this.btnSynchronize.setEnabled(false);
            this.btnEntitiesReload.setEnabled(false);
            return;
        }
        List checkedEntities = this.getEntitySelector().getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            this.btnSynchronize.setEnabled(false);
            return;
        }
        this.cboSynchorizationZone.setEnabled(true);
        this.btnEntitiesReload.setEnabled(true);
        LocalChangesTableModel localChangesTableModel = (LocalChangesTableModel)this.tblLocalChanges.getModel();
        switch ((Integer)zoneMode.getValue()) {
            case 1: {
                this.workingAreaPicker.setEnabled(true);
                this.btnSynchronize.setEnabled(!localChangesTableModel.isEmpty() || !IsEmpty.isEmptyQuietly((IsEmpty)this.workingAreaPicker.get()));
                break;
            }
            default: {
                this.workingAreaPicker.setEnabled(false);
                boolean localChangesIsEmpty = localChangesTableModel.isEmpty();
                this.btnSynchronize.setEnabled(!localChangesIsEmpty);
                if (!localChangesIsEmpty) break;
                this.alert("_There_arent_local_changes_select_a_working_area");
            }
        }
    }

    public void updateLocalChangesTable() {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.updateLocalChangesTable())) {
            return;
        }
        this.entitySelector.reloadEntities();
    }

    public OnlineWorkingcopy getWorkspace() {
        OnlineWorkingcopy ws = this.workspacePicker.get();
        return ws;
    }

    private OnlineWorkingcopy getUndisposableWorkspace() {
        OnlineWorkingcopy ws = this.workspacePicker.get();
        DisposeUtils.disposeQuietly((Disposable)ws);
        LOGGER.info("ws.references = " + DisposeUtils.getReferences((Disposable)ws));
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeWorkspace() {
        OnlineWorkingcopy ws = null;
        try {
            ws = this.getWorkspace();
            if (ws != null) {
                ws.reloadWorkspaceEntities();
                this.entitySelector.setWorkspace(ws);
                for (String tableName : this.getDefaultTablesSelection()) {
                    OnlineEntity entity = ws.getWorkspaceEntity(tableName);
                    if (entity == null) continue;
                    this.entitySelector.check(entity);
                }
            } else {
                this.entitySelector.setWorkspace(ws);
                this.remoteChangesController.doReloadChanges();
            }
            this.remoteChangesController.doReloadChanges();
            this.workingAreaPicker.set(ws.getCurrentWorkingArea());
        }
        catch (OnlineRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (OnlineSwingCommons.showAuthenticationErrors("_Online_Changes", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)ws);
        }
    }

    boolean hasRemotesChanges() {
        if (this.remoteChangesController == null) {
            return false;
        }
        return this.remoteChangesController.hasChanges();
    }

    public void doReloadTables() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            this.entitySelector.setWorkspace(null);
            return;
        }
        this.entitySelector.reloadEntities();
    }

    private void doSynchronize() {
        Envelope env;
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            this.entitySelector.setWorkspace(null);
            return;
        }
        LabeledValue zoneMode = (LabeledValue)this.cboSynchorizationZone.getSelectedItem();
        int zone = 0;
        if (zoneMode != null) {
            zone = (Integer)zoneMode.getValue();
        }
        WorkingArea workingArea = this.workingAreaPicker.get();
        switch (zone) {
            case 1: {
                if (workingArea != null) {
                    env = (Envelope)workingArea.getValue();
                    break;
                }
                env = null;
                break;
            }
            default: {
                env = null;
            }
        }
        List checkedEntities = this.entitySelector.getCheckedEntities();
        MutableInt r = new MutableInt(25);
        this.startProcess(() -> r.setValue(ws.synchronize(checkedEntities, env, this.taskStatus)), "Online_synchronize", () -> this.postSynchronize(r.getValue()));
    }

    private void postSynchronize(int st) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.postSynchronize(st))) {
            return;
        }
        try {
            this.doReloadTables();
            this.localChangesController.doUpdateTableLocalChanges();
            this.remoteChangesController.doReloadChanges();
        }
        finally {
            if (st == 0) {
                this.taskStatus.terminate();
                this.message("_Synchronization_done");
            } else {
                this.taskStatus.abort();
            }
        }
    }

    public void updateEntitiesFromRepository(boolean forceUpdateEntities) {
        OnlineWorkingcopy ws = null;
        try {
            ws = this.getWorkspace();
            if (ws == null) {
                return;
            }
            if (!forceUpdateEntities && this.currentWorkingcopy == ws && this.entitiesUpdateds) {
                return;
            }
            this.setVisibleStatus(true);
            this.currentWorkingcopy = ws;
            this.entitiesUpdateds = true;
            this.setVisibleStatus(false);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)ws);
        }
    }

    public void alert(String msg) {
        if (StringUtils.startsWith((CharSequence)msg, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            msg = i18n.getTranslation(msg);
        }
        this.message(OnlineSwingCommons.getHTMLColorTag(Color.red.darker(), msg));
    }

    public void message(String msg) {
        if (this.isProcessing()) {
            return;
        }
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.message(msg))) {
            return;
        }
        this.timerClearMsg.stop();
        String message = msg;
        if (StringUtils.startsWith((CharSequence)message, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            message = i18n.getTranslation(message);
        }
        this.lblStatusMessages.setVisible(true);
        this.lblStatusMessages.setText(message);
        this.timerClearMsg.restart();
    }

    public void setVisibleStatus(boolean visible) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusCaption.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.btnStatusCancel.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public TaskStatusController getTaskStatusController() {
        return this.taskStatusController;
    }

    public SimpleTaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(OnlineSwingLibraryImpl.class, (String)"/org/gvsig/online/swing/impl/images", (String)"Online", (String[][])new String[][]{{"online", "online-upload-all", "online-changes"}, {"online", "online-revert", "online-changes"}, {"online", "online-show-local-changes", "online-changes"}, {"online", "online-checkout-overwrite", "online-changes"}, {"online", "online-remotechanges-clear", "online-changes"}, {"online", "online-remotechanges-download", "online-changes"}, {"online", "online-remotechanges-reload", "online-changes"}, {"online", "online-highlight-context", "online-changes"}, {"online", "online-update-all", "online-changes"}, {"online", "online-merge", "online-changes"}, {"online", "online-show-remote-changes", "online-changes"}, {"online", "online-center-context", "online-changes"}, {"online", "online-zoom-context", "online-changes"}, {"online", "online-clean-highlighted", "online-changes"}});
        ToolsSwingUtils.registerSubgroupIconScreenshot(OnlineSwingLibraryImpl.class, (String)"online", (String)"online-changes", (String)"/org/gvsig/online/swing/impl/screenshots/online-changes-local.png");
        ToolsSwingUtils.registerSubgroupIconScreenshot(OnlineSwingLibraryImpl.class, (String)"online", (String)"online-changes", (String)"/org/gvsig/online/swing/impl/screenshots/online-changes-remote.png");
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void startProcess(final Runnable task, String name, final Runnable postTask) {
        LOGGER.info("Start process. processing = " + this.processing);
        if (this.processing) {
            throw new IllegalStateException("A process already started (" + this.currentProcessName + ").");
        }
        this.currentProcessName = name;
        Thread t = new Thread(new Runnable(){

            private void terminate() {
                boolean aborted = OnlineJChangesImpl.this.taskStatus.isAborted();
                String msg = OnlineJChangesImpl.this.taskStatus.getLabel();
                LOGGER.info("End process. processing = " + OnlineJChangesImpl.this.processing + " aborted = " + aborted + " msg = " + msg);
                OnlineJChangesImpl.this.processing = false;
                OnlineJChangesImpl.this.doUpdateComponents();
                OnlineJChangesImpl.this.currentProcessName = null;
                if (aborted) {
                    SwingUtilities.invokeLater(() -> {
                        OnlineJChangesImpl.this.timerClearMsg.stop();
                        OnlineJChangesImpl.this.lblStatusMessages.setText(OnlineSwingCommons.getHTMLColorTag(Color.red.darker(), msg));
                    });
                } else {
                    OnlineJChangesImpl.this.timerClearMsg.restart();
                }
            }

            @Override
            public void run() {
                try {
                    OnlineJChangesImpl.this.processing = true;
                    OnlineJChangesImpl.this.taskStatus.restart();
                    OnlineJChangesImpl.this.timerClearMsg.stop();
                    OnlineJChangesImpl.this.doUpdateComponents();
                    task.run();
                }
                finally {
                    if (postTask == null) {
                        this.terminate();
                    } else {
                        SwingUtilities.invokeLater(() -> {
                            postTask.run();
                            this.terminate();
                        });
                    }
                }
            }
        }, name);
        t.start();
    }

    public void selectTab(int tab) {
        this.tabLocalAndRemote.setSelectedIndex(tab);
    }

    public void selectOnlyALocalEntity(OnlineEntity selectedTable) {
        this.localChangesController.selectOnlyAEntity(selectedTable);
    }

    public void selectOnlyALocalEntity(List<OnlineEntity> selectedTables) {
        this.localChangesController.selectOnlyAEntity(selectedTables);
    }

    public void setDialog(Dialog dialog) {
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.localChangesController);
        DisposeUtils.disposeQuietly((Disposable)this.remoteChangesController);
        DisposeUtils.disposeQuietly((Disposable)this.currentWorkingcopy);
        DisposeUtils.disposeQuietly((Object)this.entitySelector);
    }

    public void setTaskStatus(SimpleTaskStatus taskStatus) {
        this.taskStatusController.bind((TaskStatus)taskStatus);
    }

    public Object getProperty(String name) {
        return this.propertiesSupport.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesSupport.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesSupport.getProperties();
    }

    public OnlineEntitySelectorController getEntitySelector() {
        return this.entitySelector;
    }

    private void doCheckRecomendedEntities() {
        OnlineWorkingcopy workspace = this.getUndisposableWorkspace();
        if (workspace == null) {
            return;
        }
        HashSet<String> updateEntities = new HashSet<String>();
        Collection entities = this.entitySelector.getEntities();
        block3: for (OnlineEntity entity : entities) {
            if (!workspace.existsInWorkspace(entity)) continue;
            OnlineEntity lentity = workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            switch (lentity.getState()) {
                default: {
                    continue block3;
                }
                case 6: 
                case 8: 
                case 16: 
            }
            updateEntities.add(entity.getEntityCode());
        }
        this.entitySelector.setCheck(updateEntities, true);
    }

    protected FeatureStore getWorkspaceStoreOfSelectedEntity() {
        OnlineEntity entity = this.getEntitySelector().getSelectedEntity();
        FeatureStore store = null;
        if (entity != null) {
            OnlineWorkingcopy ws = this.getUndisposableWorkspace();
            store = ws.openFeatureStore(entity.getEntityName(), false);
        }
        return store;
    }
}

