/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.changes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonObject;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.online.lib.api.OnlineRuntimeException;
import org.gvsig.online.lib.api.workingcopy.OnlineChanges;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineRemoteChange;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.online.swing.impl.changes.OnlineJChangesImpl;
import org.gvsig.online.swing.impl.changes.RemoteChangesTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteChangesController
extends AbstractDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChangesController.class);
    private static final int MAX_SELECTED_ROWS_TO_SHOW_GEOMETRIES = 200;
    private final PickerController<OnlineWorkingcopy> workspacePicker;
    private final JTable tblRemoteChanges;
    private final JButton btnRemoteShowForm;
    private final JButton btnRemoteUpdate;
    private final JButton btnRemoteMerge;
    private final JButton btnRemoteReloadChanges;
    private final JButton btnRemoteCheckAll;
    private final JButton btnRemoteUnCheckAll;
    private final JButton btnRemoteCleanChanges;
    private final OnlineJChangesImpl context;
    private final JButton btnRemoteZoom;
    private final JButton btnRemoteCenter;
    private final JButton btnRemoteHighlight;
    private final JButton btnRemoteCleanHighligthed;
    private final JLabel lblRemoteChangesCount;

    public RemoteChangesController(OnlineJChangesImpl context, PickerController<OnlineWorkingcopy> workspacePicker, JTable tblRemoteChanges, JButton btnRemoteCheckAll, JButton btnRemoteUnCheckAll, JButton btnRemoteReloadChanges, JButton btnRemoteCleanChanges, JButton btnRemoteUpdate, JButton btnRemoteMerge, JButton btnRemoteShowForm, JButton btnRemoteZoom, JButton btnRemoteCenter, JButton btnRemoteHighlight, JButton btnRemoteCleanHighligthed, JLabel lblRemoteChangesCount) {
        this.context = context;
        this.workspacePicker = workspacePicker;
        this.tblRemoteChanges = tblRemoteChanges;
        this.btnRemoteCheckAll = btnRemoteCheckAll;
        this.btnRemoteUnCheckAll = btnRemoteUnCheckAll;
        this.btnRemoteCleanChanges = btnRemoteCleanChanges;
        this.btnRemoteReloadChanges = btnRemoteReloadChanges;
        this.btnRemoteUpdate = btnRemoteUpdate;
        this.btnRemoteMerge = btnRemoteMerge;
        this.btnRemoteShowForm = btnRemoteShowForm;
        this.btnRemoteZoom = btnRemoteZoom;
        this.btnRemoteCenter = btnRemoteCenter;
        this.btnRemoteHighlight = btnRemoteHighlight;
        this.btnRemoteCleanHighligthed = btnRemoteCleanHighligthed;
        this.lblRemoteChangesCount = lblRemoteChangesCount;
        this.initComponents();
    }

    public void alert(String msg) {
        this.context.alert(msg);
    }

    public void message(String msg) {
        this.context.message(msg);
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.btnRemoteCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCleanChanges.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteMerge.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteReloadChanges.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteShowForm.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteUnCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteUpdate.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteZoom.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCenter.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteHighlight.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCleanHighligthed.setCursor(Cursor.getPredefinedCursor(12));
        this.translate();
        this.tblRemoteChanges.getSelectionModel().setSelectionMode(2);
        this.tblRemoteChanges.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    RemoteChangesController.this.doToggleSelection();
                }
            }
        });
        this.tblRemoteChanges.getSelectionModel().addListSelectionListener(e -> {
            this.context.doUpdateComponents();
            this.doUpdateChangesCount();
        });
        this.btnRemoteCheckAll.addActionListener(e -> this.doCheckAll());
        this.btnRemoteUnCheckAll.addActionListener(e -> this.doUnCheckAll());
        this.btnRemoteReloadChanges.addActionListener(e -> this.doReloadChanges());
        this.btnRemoteCleanChanges.addActionListener(e -> this.doCleanChanges());
        this.btnRemoteUpdate.addActionListener(e -> this.doUpdate());
        this.btnRemoteMerge.addActionListener(e -> this.doMerge());
        this.btnRemoteShowForm.addActionListener(e -> this.doShowForm());
        this.btnRemoteZoom.addActionListener(e -> this.doZoomToSelectedChange());
        this.btnRemoteCenter.addActionListener(e -> this.doCenterToSelectedChange());
        this.btnRemoteHighlight.addActionListener(e -> this.doHighLightSelectedChange());
        this.btnRemoteCleanHighligthed.addActionListener(e -> OnlineSwingCommons.cleanHighligthed());
        this.context.doUpdateComponents();
        this.doUpdateComponents();
        SwingUtilities.invokeLater(() -> {
            this.doReloadChanges();
            this.message(i18n.getTranslation("_Ready"));
            this.lblRemoteChangesCount.setText("");
        });
    }

    public void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnRemoteCheckAll);
        swingManager.translate((AbstractButton)this.btnRemoteUpdate);
        swingManager.translate((AbstractButton)this.btnRemoteCleanChanges);
        swingManager.translate((AbstractButton)this.btnRemoteReloadChanges);
        swingManager.translate((AbstractButton)this.btnRemoteMerge);
        swingManager.translate((AbstractButton)this.btnRemoteShowForm);
        swingManager.translate((AbstractButton)this.btnRemoteUnCheckAll);
        swingManager.translate((AbstractButton)this.btnRemoteCenter);
        swingManager.translate((AbstractButton)this.btnRemoteHighlight);
        swingManager.translate((AbstractButton)this.btnRemoteZoom);
        swingManager.translate((AbstractButton)this.btnRemoteCleanHighligthed);
    }

    private OnlineWorkingcopy getUndisposableWorkspace() {
        OnlineWorkingcopy ws = this.context.getWorkspace();
        DisposeUtils.disposeQuietly((Disposable)ws);
        return ws;
    }

    boolean hasChanges() {
        try {
            RemoteChangesTableModel tableModel = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            return tableModel != null && !tableModel.isEmpty();
        }
        catch (Exception ex) {
            return false;
        }
    }

    void doUpdateComponents() {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateComponents())) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            try {
                RemoteChangesTableModel tableModel = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
                this.context.setVisibleStatus(this.context.isProcessing());
                this.context.btnClose.setEnabled(!this.context.isProcessing());
                OnlineWorkingcopy ws = this.getUndisposableWorkspace();
                List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
                this.btnRemoteCheckAll.setEnabled(!this.context.isProcessing() && !tableModel.isEmpty());
                this.btnRemoteUnCheckAll.setEnabled(!this.context.isProcessing() && !tableModel.isEmpty());
                this.btnRemoteReloadChanges.setEnabled(!this.context.isProcessing() && ws != null && CollectionUtils.isNotEmpty((Collection)checkedEntities));
                this.btnRemoteCleanChanges.setEnabled(!this.context.isProcessing() && ws != null && !tableModel.isEmpty());
                boolean enableShowForm = false;
                int row = this.tblRemoteChanges.getSelectedRow();
                if (row >= 0) {
                    enableShowForm = true;
                }
                this.btnRemoteShowForm.setEnabled(!this.context.isProcessing() && enableShowForm);
                this.context.getEntitySelector().setEnabled(!this.context.isProcessing());
                this.tblRemoteChanges.setEnabled(!this.context.isProcessing());
                this.workspacePicker.setEnabled(!this.context.isProcessing());
                if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                    this.btnRemoteMerge.setEnabled(false);
                    this.btnRemoteUpdate.setEnabled(false);
                } else if (tableModel.isEmpty()) {
                    this.btnRemoteMerge.setEnabled(false);
                    this.btnRemoteUpdate.setEnabled(false);
                } else {
                    OnlineEntity checkedEntity3;
                    MutableObject msg = new MutableObject();
                    Iterator iterator = checkedEntities.iterator();
                    while (iterator.hasNext() && ws.canUpdate(msg, (checkedEntity3 = (OnlineEntity)iterator.next()).getEntityName())) {
                    }
                    if (msg.getValue() != null) {
                        this.btnRemoteMerge.setEnabled(false);
                        this.btnRemoteUpdate.setEnabled(false);
                        this.alert((String)msg.getValue());
                    } else if (checkedEntities.size() == 1) {
                        OnlineEntity checkedEntity2 = (OnlineEntity)checkedEntities.get(0);
                        if (ws.updateNeedMerge(checkedEntity2.getEntityName())) {
                            this.btnRemoteMerge.setEnabled(!this.context.isProcessing());
                            this.btnRemoteUpdate.setEnabled(false);
                        } else {
                            this.btnRemoteMerge.setEnabled(false);
                            this.btnRemoteUpdate.setEnabled(!this.context.isProcessing() && !tableModel.isSelectionEmpty());
                        }
                    } else {
                        this.btnRemoteMerge.setEnabled(false);
                        this.btnRemoteUpdate.setEnabled(!this.context.isProcessing() && !tableModel.isSelectionEmpty());
                        for (OnlineEntity checkedEntity3 : checkedEntities) {
                            if (!ws.updateNeedMerge(checkedEntity3.getEntityName())) continue;
                            this.btnRemoteMerge.setEnabled(!this.context.isProcessing());
                            this.btnRemoteUpdate.setEnabled(false);
                            break;
                        }
                    }
                }
                Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
                Geometry wsGeom = this.getWorkspaceGeometryOfSelectedChange();
                Geometry bbox = OnlineSwingCommons.createBBox(repoGeom, wsGeom);
                this.btnRemoteZoom.setEnabled(!this.context.isProcessing() && bbox != null);
                this.btnRemoteCenter.setEnabled(!this.context.isProcessing() && bbox != null);
                this.btnRemoteHighlight.setEnabled(!this.context.isProcessing() && bbox != null);
                this.btnRemoteCleanHighligthed.setEnabled(!this.context.isProcessing());
                break;
            }
            catch (ConcurrentDataModificationException e3) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOGGER.info("Retrying doUpdateComponents " + i);
                continue;
            }
            catch (OnlineRuntimeException e1) {
                LOGGER.warn("Can't updating components.", (Throwable)e1);
                if (!OnlineSwingCommons.showAuthenticationErrors("_Online_Changes", e1)) break;
                this.workspacePicker.set(null);
                break;
            }
            catch (ClassCastException e2) {
                this.btnRemoteCheckAll.setEnabled(false);
                this.btnRemoteUnCheckAll.setEnabled(false);
                this.btnRemoteReloadChanges.setEnabled(false);
                this.btnRemoteCleanChanges.setEnabled(false);
                this.btnRemoteMerge.setEnabled(false);
                this.btnRemoteUpdate.setEnabled(false);
                this.btnRemoteHighlight.setEnabled(false);
                this.btnRemoteCenter.setEnabled(false);
                this.btnRemoteZoom.setEnabled(false);
                this.btnRemoteShowForm.setEnabled(false);
                this.btnRemoteCleanHighligthed.setEnabled(!this.context.isProcessing());
                break;
            }
            catch (Exception e3) {
                LOGGER.warn("Can't updating components.", (Throwable)e3);
                break;
            }
        }
    }

    private void doToggleSelection() {
        this.context.startProcess(() -> {
            ListSelectionModel selectionModel = this.tblRemoteChanges.getSelectionModel();
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            model.toggleSelection(selectionModel);
        }, "OnlineToggleSelectionRemoteChanges", null);
    }

    private void doCheckAll() {
        this.context.startProcess(() -> {
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            model.selectAll();
        }, "OnlineCheckAllRemoteChanges", null);
    }

    private void doUnCheckAll() {
        this.context.startProcess(() -> {
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            model.deselectAll();
        }, "OnlineCheckAllRemoteChanges", null);
    }

    private void doUpdate() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return;
        }
        this.tblRemoteChanges.setModel(this.createEmptyTableModel());
        SimpleTaskStatus taskStatus = this.context.getTaskStatus();
        I18nManager i18n = ToolsLocator.getI18nManager();
        taskStatus.setTitle(i18n.getTranslation("_Updating"));
        MutableInt r = new MutableInt(0);
        this.context.startProcess(() -> {
            try {
                taskStatus.setAutoremove(true);
                taskStatus.add();
                this.context.setTaskStatus(taskStatus);
                for (OnlineEntity checkedEntity : checkedEntities) {
                    r.setValue(ws.update(checkedEntity.getEntityName(), taskStatus));
                    if (r.getValue() == 0) continue;
                    break;
                }
                taskStatus.terminate();
            }
            catch (UserCancelTaskException ex) {
                LOGGER.warn("User cancelled");
                taskStatus.cancel();
            }
            catch (Exception ex) {
                taskStatus.abort();
            }
        }, "OnlineUpdate", () -> this.doPostUpdate(checkedEntities, r.getValue()));
    }

    private void doPostUpdate(List<OnlineEntity> checkedEntities, int updateStatus) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostUpdate(checkedEntities, updateStatus))) {
            return;
        }
        if (updateStatus == 0) {
            this.context.setVisibleStatus(false);
            this.context.getTaskStatus().terminate();
        } else {
            this.context.getTaskStatus().abort();
        }
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        this.doReloadChanges();
        for (OnlineEntity checkedEntity : checkedEntities) {
            JDBCStoreParameters params = ws.getFeatureStoreParameters(checkedEntity.getEntityName());
            OnlineSwingCommons.refreshDocumentByParams(params);
        }
        this.context.updateLocalChangesTable();
        OnlineSwingCommons.cleanHighligthed();
    }

    private void doMerge() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return;
        }
        this.tblRemoteChanges.setModel(this.createEmptyTableModel());
        SimpleTaskStatus status = this.context.getTaskStatus();
        I18nManager i18n = ToolsLocator.getI18nManager();
        status.setTitle(i18n.getTranslation("_Merging"));
        ArrayList entitiesWithLocalChanges = new ArrayList();
        MutableLong localChangesCreated = new MutableLong(0L);
        MutableInt r = new MutableInt(0);
        this.context.startProcess(() -> {
            try {
                for (OnlineEntity entity : checkedEntities) {
                    String tableName = entity.getEntityName();
                    long lchanges = localChangesCreated.getValue();
                    r.setValue(this.getUndisposableWorkspace().merge(tableName, localChangesCreated, status));
                    if (r.getValue() == 0) {
                        if (lchanges == localChangesCreated.getValue()) continue;
                        entitiesWithLocalChanges.add(entity);
                        continue;
                    }
                    break;
                }
            }
            catch (UserCancelTaskException ex) {
                LOGGER.warn("User cancelled");
            }
        }, "OnlineMerge", () -> this.doPostMerge(checkedEntities, entitiesWithLocalChanges, r.getValue(), localChangesCreated.getValue()));
    }

    private void doPostMerge(List<OnlineEntity> checkedEntities, List<OnlineEntity> entitiesWithLocalChanges, int mergeStatus, long localChangesCreated) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostMerge(checkedEntities, entitiesWithLocalChanges, mergeStatus, localChangesCreated))) {
            return;
        }
        if (mergeStatus == 0) {
            this.context.setVisibleStatus(false);
            this.context.getTaskStatus().terminate();
        } else {
            this.context.getTaskStatus().abort();
        }
        this.doReloadChanges();
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        for (OnlineEntity entity : checkedEntities) {
            JDBCStoreParameters params = ws.getFeatureStoreParameters(entity.getEntityName());
            OnlineSwingCommons.refreshDocumentByParams(params);
        }
        if (localChangesCreated > 0L) {
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            dialogsManager.messageDialog(i18n.getTranslation("_The_process_has_modified_local_changes_that_would_need_to_be_committed_to_the_repository"), null, i18n.getTranslation("_Online_Merge"), 1, "Online_merge_need_commit");
            this.context.selectTab(0);
            this.context.selectOnlyALocalEntity(entitiesWithLocalChanges);
        }
        this.context.doUpdateComponents();
        this.context.updateLocalChangesTable();
        OnlineSwingCommons.cleanHighligthed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowForm() {
        int row;
        RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
        OnlineRemoteChange change = model.getRow(row = this.tblRemoteChanges.getSelectedRow());
        if (change == null) {
            return;
        }
        if (change.getOperation() == 0) {
            return;
        }
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        OnlineEntity entity = ws.getWorkspaceEntityByCode(change.getEntityCode());
        if (entity == null) {
            OnlineEntity repoEntity = ws.getEntity(change.getEntityCode());
            FeatureType featureType = repoEntity.getFeatureType();
            JDynForm form = DynFormLocator.getDynFormManager().createJDynForm((DynStruct)featureType);
            DynObject values = ToolsLocator.getDynObjectManager().createDynObject((DynStruct)featureType);
            Json.addAll((DynObject)values, (JsonObject)change.getRelatedFeatureDataAsJson());
            form.setValues(values);
            form.setReadOnly(true);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            form.asJComponent().setPreferredSize(new Dimension(400, 200));
            winManager.showWindow(form.asJComponent(), "Remote change: " + change.getLabel(), WindowManager.MODE.WINDOW);
            return;
        }
        FeatureStore store = null;
        try {
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            store = ws.openFeatureStore(entity.getEntityName(), false);
            EditableFeature feature = store.createNewFeature(change.getRelatedFeatureDataAsJson());
            JFeatureForm form = dataSwingManager.createJFeatureForm((Feature)feature);
            form.getDynForm().setReadOnly(true);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            form.asJComponent().setPreferredSize(new Dimension(400, 200));
            winManager.showWindow(form.asJComponent(), "Remote change: " + change.getLabel(), WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't show form for change '" + change.getCode() + "'.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        DisposeUtils.disposeQuietly((Disposable)store);
    }

    protected void doReloadChanges() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        final RemoteChangesTableModel changesModel = this.createTableModel();
        this.tblRemoteChanges.setModel(changesModel);
        int columns = this.tblRemoteChanges.getColumnModel().getColumnCount();
        for (int i = 1; i < columns; ++i) {
            this.tblRemoteChanges.getColumnModel().getColumn(i).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    OnlineRemoteChange changeRow = null;
                    try {
                        changeRow = changesModel.getRow(row);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (changeRow != null) {
                        OnlineSwingCommons.setColorCompoment(c, changeRow.getStatus());
                    }
                    return c;
                }
            });
        }
        this.context.doUpdateComponents();
        this.doUpdateChangesCount();
        this.context.message(i18n.getTranslation("_Repository_changes_list_updated", new String[]{String.valueOf(changesModel.getRowCount())}));
    }

    private void doUpdateChangesCount() {
        TableModel model = this.tblRemoteChanges.getModel();
        int selectedCounts = this.tblRemoteChanges.getSelectedRowCount();
        if (selectedCounts < 1) {
            this.lblRemoteChangesCount.setText(String.valueOf(model.getRowCount()));
        } else if (selectedCounts < 200) {
            this.lblRemoteChangesCount.setText("<html>" + OnlineSwingCommons.getHTMLFontColorTag(Color.GREEN.darker(), true, false, String.valueOf(selectedCounts)) + "/" + model.getRowCount() + "</html>");
        } else {
            this.lblRemoteChangesCount.setText(selectedCounts + "/" + model.getRowCount());
        }
    }

    protected RemoteChangesTableModel createEmptyTableModel() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return null;
        }
        RemoteChangesTableModel changesModel = new RemoteChangesTableModel(ws);
        return changesModel;
    }

    protected RemoteChangesTableModel createTableModel() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return null;
        }
        List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return new RemoteChangesTableModel(ws);
        }
        this.message("Reloading list of remote changes...");
        OnlineChanges theChanges = ws.getRemoteChangesByEntity((String[])checkedEntities.stream().map(t -> t.getEntityName()).toArray(String[]::new));
        RemoteChangesTableModel changesModel = new RemoteChangesTableModel((OnlineChanges<OnlineRemoteChange>)theChanges, ws);
        changesModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RemoteChangesController.this.context.doUpdateComponents();
            }
        });
        return changesModel;
    }

    private List<OnlineEntity> getWorkspaceCheckedEntities() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return null;
        }
        List checkedEntities = this.context.getEntitySelector().getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return null;
        }
        ArrayList<OnlineEntity> workspaceCheckedEntities = new ArrayList<OnlineEntity>();
        for (OnlineEntity entity : checkedEntities) {
            if (ws.getWorkspaceEntityByCode(entity.getEntityCode()) == null) continue;
            workspaceCheckedEntities.add(entity);
        }
        if (CollectionUtils.isEmpty(workspaceCheckedEntities)) {
            return null;
        }
        return workspaceCheckedEntities;
    }

    private void doCleanChanges() {
        OnlineWorkingcopy ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List<OnlineEntity> entitiesToCleanChanges = this.getWorkspaceCheckedEntities();
        if (CollectionUtils.isEmpty(entitiesToCleanChanges)) {
            return;
        }
        this.context.startProcess(() -> {
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            for (OnlineEntity checkedEntity : entitiesToCleanChanges) {
                this.message("Removing list of remote changes from selected tables" + checkedEntity.getEntityName() + "...");
                model.removeRemoteChanges(checkedEntity.getEntityName());
            }
            this.message("Ready.");
        }, "OnlineUpdateClean", () -> this.context.doReloadTables());
    }

    public boolean isProcessing() {
        return this.context.isProcessing();
    }

    private Geometry getRepositoryGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            if (this.tblRemoteChanges.getSelectedRowCount() > 1 && this.tblRemoteChanges.getSelectedRowCount() < 200) {
                for (int selectedRow : this.tblRemoteChanges.getSelectedRows()) {
                    OnlineRemoteChange change = model.getRow(selectedRow);
                    Geometry currentGeom = change.getGeometry();
                    if (currentGeom == null) continue;
                    if (geom == null) {
                        int type = currentGeom.getType();
                        if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                        } else {
                            return geom;
                        }
                    }
                    ((MultiPrimitive)geom).addPrimitives(currentGeom);
                }
            } else {
                int selected = this.tblRemoteChanges.getSelectedRow();
                if (selected >= 0) {
                    OnlineRemoteChange change = model.getRow(selected);
                    geom = change.getGeometry();
                }
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    private Envelope getEnvelopeOfAllRepositoryChanges() {
        Envelope env = GeometryUtils.createEnvelope((int)0);
        try {
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            OnlineChanges<OnlineRemoteChange> changes = model.getChanges();
            int i = 0;
            while ((long)i < changes.size64()) {
                OnlineRemoteChange change = (OnlineRemoteChange)changes.get64((long)i);
                Geometry currentGeom = change.getGeometry();
                env.add(currentGeom);
                ++i;
            }
            return env;
        }
        catch (Exception ex) {
            return env;
        }
    }

    private Geometry getWorkspaceGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            OnlineWorkingcopy ws = this.getUndisposableWorkspace();
            RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
            if (this.tblRemoteChanges.getSelectedRowCount() > 1 && this.tblRemoteChanges.getSelectedRowCount() < 200) {
                for (int selectedRow : this.tblRemoteChanges.getSelectedRows()) {
                    Geometry currentGeom;
                    OnlineRemoteChange change = model.getRow(selectedRow);
                    Feature f = ws.getRelatedFeature(change);
                    if (f == null || (currentGeom = f.getDefaultGeometry()) == null) continue;
                    if (geom == null) {
                        int type = currentGeom.getType();
                        if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                        } else {
                            return geom;
                        }
                    }
                    ((MultiPrimitive)geom).addPrimitives(currentGeom);
                }
            } else {
                OnlineRemoteChange change;
                Feature f;
                int selected = this.tblRemoteChanges.getSelectedRow();
                if (selected >= 0 && (f = ws.getRelatedFeature(change = model.getRow(selected))) != null) {
                    geom = f.getDefaultGeometry();
                }
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    private FeatureStore getWorkspaceStoreOfSelectedChange() {
        FeatureStore store = null;
        int selected = this.tblRemoteChanges.getSelectedRow();
        RemoteChangesTableModel model = (RemoteChangesTableModel)this.tblRemoteChanges.getModel();
        if (selected >= 0) {
            OnlineRemoteChange change = model.getRow(selected);
            OnlineWorkingcopy ws = this.getUndisposableWorkspace();
            OnlineEntity entity = ws.getWorkspaceEntityByCode(change.getEntityCode());
            store = ws.openFeatureStore(entity.getEntityName(), false);
        }
        return store;
    }

    private void doZoomToSelectedChange() {
        OnlineSwingCommons.cleanHighligthed();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        if (this.tblRemoteChanges.getSelectionModel().isSelectionEmpty()) {
            FeatureStore store = this.context.getWorkspaceStoreOfSelectedEntity();
            if (store == null) {
                return;
            }
            Envelope env = this.getEnvelopeOfAllRepositoryChanges();
            services.zoomViewsHavingAStoreToGeometry(store, env.getBox2D());
            return;
        }
        FeatureStore store = this.getWorkspaceStoreOfSelectedChange();
        Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
        Geometry geom = this.getWorkspaceGeometryOfSelectedChange();
        services.zoomViewsHavingAStoreToGeometry(store, OnlineSwingCommons.createBBox(repoGeom, geom));
        if (repoGeom != null) {
            services.highlight(1, repoGeom, store);
        }
        if (geom != null) {
            services.highlight(2, geom, store);
        }
    }

    private void doCenterToSelectedChange() {
        OnlineSwingCommons.cleanHighligthed();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        if (this.tblRemoteChanges.getSelectionModel().isSelectionEmpty()) {
            FeatureStore store = this.context.getWorkspaceStoreOfSelectedEntity();
            if (store == null) {
                return;
            }
            Envelope env = this.getEnvelopeOfAllRepositoryChanges();
            services.centerViewsHavingAStoreToGeometry(store, env.getBox2D());
            return;
        }
        FeatureStore store = this.getWorkspaceStoreOfSelectedChange();
        Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
        Geometry geom = this.getWorkspaceGeometryOfSelectedChange();
        services.centerViewsHavingAStoreToGeometry(store, OnlineSwingCommons.createBBox(repoGeom, geom));
        if (repoGeom != null) {
            services.highlight(1, repoGeom, store);
        }
        if (geom != null) {
            services.highlight(2, geom, store);
        }
    }

    private void doHighLightSelectedChange() {
        OnlineSwingCommons.cleanHighligthed();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getWorkspaceStoreOfSelectedChange();
        Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
        Geometry geom = this.getWorkspaceGeometryOfSelectedChange();
        if (repoGeom != null) {
            services.highlight(1, repoGeom, store);
        }
        if (geom != null) {
            services.highlight(2, geom, store);
        }
    }

    protected void doDispose() throws BaseException {
    }
}

