/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.changes;

import java.util.Iterator;
import java.util.Objects;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.gvsig.online.lib.api.workingcopy.OnlineChanges;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineRemoteChange;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class RemoteChangesTableModel
extends AbstractTableModel {
    private static final int COLUMN_SELECT = 0;
    private static final int COLUMN_TABLE = 1;
    private static final int COLUMN_OPERATION = 2;
    private static final int COLUMN_LABEL = 3;
    private static final int COLUMN_REVNUM = 4;
    private static final int COLUMN_DATE = 5;
    private static final int COLUMN_CODE = 6;
    private static final ColumnDescriptor[] COLUMNS = new ColumnDescriptor[]{new ColumnDescriptor(Boolean.class, "_Select", true), new ColumnDescriptor(String.class, "_Table", false), new ColumnDescriptor(String.class, "_Operation", false), new ColumnDescriptor(String.class, "_Label", false), new ColumnDescriptor(Long.class, "_Rev_num", false), new ColumnDescriptor(String.class, "_Date", false), new ColumnDescriptor(String.class, "_Code", false)};
    private OnlineChanges<OnlineRemoteChange> changes;
    private final OnlineWorkingcopy ws;

    public RemoteChangesTableModel(OnlineWorkingcopy ws) {
        this(null, ws);
    }

    public RemoteChangesTableModel(OnlineChanges<OnlineRemoteChange> changes, OnlineWorkingcopy ws) {
        this.ws = ws;
        this.changes = changes;
        if (changes != null) {
            this.changes.addChangeListener(e -> this.fireTableDataChanged());
        }
    }

    @Override
    public int getRowCount() {
        if (this.changes == null) {
            return 0;
        }
        try {
            return (int)this.changes.size64();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNS[columnIndex].columnClass();
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column].label();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return COLUMNS[columnIndex].isEditable();
    }

    public OnlineRemoteChange getRow(int rowIndex) {
        OnlineRemoteChange row = null;
        try {
            row = (OnlineRemoteChange)this.changes.get64((long)rowIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return row;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineRemoteChange row = this.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return row.isSelected();
            }
            case 1: {
                OnlineEntity entity = this.ws.getEntity(row.getEntityCode());
                if (entity == null) {
                    return "unknown (" + row.getEntityCode() + ")";
                }
                return this.ws.getEntity(row.getEntityCode()).getEntityName();
            }
            case 2: {
                int op = row.getOperation();
                switch (op) {
                    case 2: {
                        return i18n.getTranslation("_Not_in_local");
                    }
                }
                return i18n.getTranslation(OnlineSwingCommons.getOperationLabel(op));
            }
            case 3: {
                return row.getLabel();
            }
            case 6: {
                return row.getRelatedFeatureCode();
            }
            case 4: {
                return row.getRevisionNumber();
            }
            case 5: {
                return Objects.toString(row.getRevisionDate(), "");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                Boolean selected = (Boolean)aValue;
                if (selected.booleanValue()) {
                    this.changes.addSelected((long)rowIndex);
                    break;
                }
                this.changes.removeSelected((long)rowIndex);
            }
        }
    }

    public synchronized void selectAll() {
        Iterator<Long> rows = this.getRowsIterator();
        this.changes.process(rows, change -> {
            change.setSelected(true);
            return true;
        });
        this.fireTableDataChanged();
    }

    public synchronized void deselectAll() {
        Iterator<Long> rows = this.getRowsIterator();
        this.changes.process(rows, change -> {
            change.setSelected(false);
            return true;
        });
        this.fireTableDataChanged();
    }

    public synchronized void toggleSelection(ListSelectionModel selectionModel) {
        Iterator<Long> rows = this.getRowsIterator(selectionModel);
        this.changes.process(rows, change -> {
            change.setSelected(!change.isSelected());
            return true;
        });
        this.fireTableDataChanged();
    }

    @Override
    public void fireTableDataChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteChangesTableModel.this.fireTableDataChanged();
                }
            });
            return;
        }
        super.fireTableDataChanged();
    }

    private Iterator<Long> getRowsIterator(final ListSelectionModel selectionModel) {
        final int size = Math.min((int)this.changes.size64(), selectionModel.getMaxSelectionIndex());
        return new Iterator<Long>(){
            int n;
            {
                this.n = selectionModel.getMinSelectionIndex();
            }

            @Override
            public boolean hasNext() {
                while (this.n <= size && !selectionModel.isSelectedIndex(this.n)) {
                    ++this.n;
                }
                return this.n <= size;
            }

            @Override
            public Long next() {
                if (!selectionModel.isSelectedIndex(this.n) && !this.hasNext()) {
                    return null;
                }
                return this.n++;
            }
        };
    }

    private Iterator<Long> getRowsIterator() {
        final long size = this.changes.size64();
        return new Iterator<Long>(){
            long n = 0L;

            @Override
            public boolean hasNext() {
                return this.n < size;
            }

            @Override
            public Long next() {
                return this.n++;
            }
        };
    }

    public OnlineChanges<OnlineRemoteChange> getChanges() {
        return this.changes;
    }

    public boolean isEmpty() {
        return this.changes == null || this.changes.isEmpty();
    }

    public boolean isSelectionEmpty() {
        return this.changes == null || this.changes.isSelectionEmpty();
    }

    public synchronized void removeRemoteChanges(String entityName) {
        this.ws.removeRemoteChanges(entityName);
        this.fireTableDataChanged();
    }

    private static class ColumnDescriptor {
        private final Class<?> columnClass;
        private final String name;
        private final boolean editable;

        public ColumnDescriptor(Class<?> columnClass, String name, boolean editable) {
            this.name = name;
            this.columnClass = columnClass;
            this.editable = editable;
        }

        public Class<?> columnClass() {
            return this.columnClass;
        }

        public String name() {
            return this.name;
        }

        public String label() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            return i18n.getTranslation(this.name);
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

