/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.online.swing.api.MessageStatus;
import org.gvsig.online.swing.api.OnlineJDownload;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.online.swing.impl.AddLayerToProjectController;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.online.swing.impl.OnlineWorkingcopyPickerControllerImpl;
import org.gvsig.online.swing.impl.download.OnlineJDownloadView;
import org.gvsig.online.swing.impl.initworkspace.LayersTableModel;
import org.gvsig.online.swing.impl.workingarea.WorkingAreaPickerControllerImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineJDownloadImpl
extends OnlineJDownloadView
implements Component,
OnlineJDownload {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineJDownloadImpl.class);
    private Dialog dialog;
    private WorkingAreaPickerControllerImpl workingAreaPicker;
    private TaskStatusController taskStatusController;
    private OnlineWorkingcopyPickerControllerImpl workingcopyPicker;
    private List<String> defaultTablesSelection;
    private boolean processing;
    private AddLayerToProjectController addLayerToProjectController;
    private MessageStatus message;

    public OnlineJDownloadImpl() {
        this.translate();
        this.initComponents();
    }

    public OnlineJDownloadImpl(OnlineWorkingcopy workspace, List<String> tableNames, Boolean overwrite) {
        this.processing = false;
        this.translate();
        this.defaultTablesSelection = tableNames == null ? Collections.EMPTY_LIST : tableNames;
        this.initComponents();
        SwingUtilities.invokeLater(() -> this.workingcopyPicker.set(workspace));
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices onlineServices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        this.message = swingManager.createMessageStatus(this.lblStatusTitle, this.pbStatus, this.lblStatusMessages);
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblStatusTitle, this.lblStatusMessages, this.pbStatus, this.btnStatusCancel, null);
        this.taskStatusController.setShowCancelButton(true);
        this.taskStatusController.setShowRemoveTaskButton(false);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.tblLayers.setModel(new LayersTableModel());
        this.workingcopyPicker = (OnlineWorkingcopyPickerControllerImpl)swingManager.createPickerWorkspaceController(this.cboWorkingcopy);
        this.workingcopyPicker.addChangeListener(e -> {
            this.message.clear();
            this.doChangeWorkingcopy();
        });
        this.txtWorkspaceName.setText("");
        this.txtWorkspaceName.setEditable(false);
        this.workingAreaPicker = new WorkingAreaPickerControllerImpl(() -> this.getWorkingcopy().getSite(), this.txtWorkingAreaLabel, this.txtWorkingArea, this.btnWorkingAreaFromView, this.btnWorkingAreaDialog, this.btnWorkingAreaHistory, this.btnWorkingAreaBookmarks, () -> {
            LabeledValue n = onlineServices.getActiveMapControl();
            return n == null ? null : (MapControl)n.getValue();
        }, () -> {
            List<OnlineLayer> selectedLayers = this.getLayersModel().getSelectedLayers();
            if (selectedLayers.isEmpty()) {
                return null;
            }
            return selectedLayers;
        });
        this.workingAreaPicker.addChangeListener(e -> {
            this.getWorkingcopy().setCurrentWorkingArea(this.workingAreaPicker.getWithoutAddHistory());
            this.doUpdateComponents();
        });
        this.addLayerToProjectController = new AddLayerToProjectController(this.rdbDontAddToProject, this.rdbAddLayerToView, this.rdbAddTableToProject, this.cboView, this.message);
        this.addLayerToProjectController.addChangeListener(e -> {
            this.message.clear();
            this.doUpdateComponents();
        });
        this.btnChangeViewProjection.addActionListener(e -> this.doChangeViewProjection());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)40, (int)25, (int)100);
        SwingUtilities.invokeLater(() -> this.message.clear());
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    private void doUpdateComponents() {
        this.message.clear();
        boolean isThereWorkingcopy = false;
        boolean isThereSelectedsLayers = false;
        boolean isThereWorkingArea = false;
        boolean enableAll = !this.isProcessing();
        this.workingcopyPicker.setEnabled(enableAll);
        if (enableAll) {
            OnlineWorkingcopy w = this.getWorkingcopy();
            boolean bl = isThereWorkingcopy = w != null;
            if (!isThereWorkingcopy) {
                this.message.message(enableAll, "_You_must_select_a_workingcopy");
            }
            boolean bl2 = enableAll = enableAll && isThereWorkingcopy;
        }
        if (enableAll) {
            boolean bl = isThereSelectedsLayers = !this.getLayersModel().isSelectionEmpty();
            if (!isThereSelectedsLayers) {
                this.message.message(enableAll, "_You_must_select_some_layer");
            }
            boolean bl3 = enableAll = isThereWorkingcopy && isThereSelectedsLayers;
        }
        if (enableAll) {
            WorkingArea workingArea = this.workingAreaPicker.getWithoutAddHistory();
            boolean bl = isThereWorkingArea = workingArea != null && workingArea.getValue() != null;
            if (!isThereWorkingArea) {
                this.message.message(enableAll, "_You_must_select_a_working_area");
            }
            enableAll = isThereWorkingcopy && isThereWorkingArea;
        }
        this.tblLayers.setEnabled(isThereWorkingcopy);
        this.txtWorkingAreaLabel.setEnabled(isThereWorkingcopy);
        this.txtWorkingArea.setEnabled(isThereWorkingcopy);
        this.btnWorkingAreaFromView.setEnabled(isThereWorkingcopy);
        this.btnWorkingAreaDialog.setEnabled(isThereSelectedsLayers && isThereWorkingcopy);
        this.addLayerToProjectController.setEnabled(this.getSelectedLayers());
        this.btnChangeViewProjection.setEnabled(this.getLayersProjection(this.getSelectedLayers()) != null);
        this.rdbDontAddToProject.setEnabled(enableAll);
        this.rdbAddLayerToView.setEnabled(enableAll);
        this.cboView.setEnabled(enableAll);
        this.rdbAddTableToProject.setEnabled(enableAll);
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enableAll);
            this.dialog.setButtonEnabled(2, enableAll);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspaceName);
        swingManager.translate(this.lblProjects);
        swingManager.translate(this.lblLayers);
        swingManager.translate(this.lblWorkingArea);
        swingManager.translate((AbstractButton)this.btnWorkingAreaFromView);
        swingManager.translate((AbstractButton)this.btnWorkingAreaDialog);
        swingManager.translate((AbstractButton)this.rdbDontAddToProject);
        swingManager.translate((AbstractButton)this.rdbAddLayerToView);
        swingManager.translate((AbstractButton)this.rdbAddTableToProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int actionPerformed() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineSwingServices services = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        OnlineWorkingcopy workingcopy = this.getWorkingcopy();
        if (workingcopy == null) {
            return 37;
        }
        WorkingArea workingArea = this.workingAreaPicker.get();
        if (workingArea == null) {
            return 8;
        }
        int maxFeaturesPerTile = OnlineLocator.getOnlineManager().getMaxFeaturesPerTile();
        int err = 0;
        SimpleTaskStatus status = this.getTaskStatus();
        this.setVisibleStatus(true);
        try {
            this.processing = true;
            this.doUpdateComponents();
            status.setTitle(i18n.getTranslation("_Downloading_layers"));
            LayersTableModel model = (LayersTableModel)this.tblLayers.getModel();
            List<OnlineLayer> selectedLayers = model.getSelectedLayers();
            if (!CollectionUtils.isEmpty(selectedLayers)) {
                status.setRangeOfValues(0L, (long)selectedLayers.size());
                status.setCurValue(0L);
                ArrayList<String> selectedEntityCodes = new ArrayList<String>();
                for (OnlineLayer layer : selectedLayers) {
                    status.incrementCurrentValue();
                    if (status.isCancellationRequested()) {
                        status.cancel();
                        throw new UserCancelTaskException();
                    }
                    status.message(i18n.getTranslation("_Adding_layer") + " " + layer.getName());
                    OnlineEntity entity = workingcopy.getEntity(layer.getName());
                    if (entity != null) {
                        workingcopy.removeEntity(entity);
                    }
                    String fieldForLabel = layer.getFeatureCodeFieldName();
                    workingcopy.addEntity(layer.getFeatureType(), layer.getName(), null, fieldForLabel, layer.getTitle(), layer.getPkName(), -1);
                    entity = workingcopy.getEntity(layer.getName());
                    selectedEntityCodes.add(entity.getEntityCode());
                }
                MutableObject msg = new MutableObject();
                if (!workingcopy.canDownload(msg, selectedEntityCodes)) {
                    ThreadSafeDialogsManager messageDialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    messageDialogs.messageDialog((String)msg.getValue(), i18n.getTranslation("_Downloading_layer"), 2);
                    this.setVisibleStatus(false);
                    int entity = 0;
                    return entity;
                }
                status.setRangeOfValues(0L, (long)selectedLayers.size());
                status.setCurValue(0L);
                for (OnlineLayer layer : selectedLayers) {
                    status.incrementCurrentValue();
                    status.message(i18n.getTranslation("_Downloading_layer") + " " + layer.getName());
                    if (status.isCancellationRequested()) {
                        throw new UserCancelTaskException();
                    }
                    err = workingcopy.download(layer.getName(), (Envelope)workingArea.getValue(), status);
                    if (err == 0) continue;
                    int n = 600;
                    return n;
                }
                for (OnlineLayer layer : selectedLayers) {
                    this.addLayerToProjectController.process(workingcopy, layer);
                }
            }
            this.setVisibleStatus(false);
            services.refreshDocuments();
            status.terminate();
        }
        catch (UserCancelTaskException ex) {
            LOGGER.info("Cancelled by user.");
            status.cancel();
            this.setVisibleStatus(false);
            err = 17;
        }
        catch (Exception ex) {
            LOGGER.info("Can't initialize workspace", (Throwable)ex);
            status.abort();
            err = 25;
        }
        finally {
            this.processing = false;
            this.doUpdateComponents();
        }
        return err;
    }

    public static void selfRegister() {
    }

    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return OnlineSwingCommons.loadImage(imageName);
    }

    private LayersTableModel getLayersModel() {
        return (LayersTableModel)this.tblLayers.getModel();
    }

    private SimpleTaskStatus getTaskStatus() {
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Create_workingcopy");
        taskStatus.setAutoremove(true);
        taskStatus.add();
        taskStatus.setIndeterminate();
        this.taskStatusController.bind((TaskStatus)taskStatus);
        return taskStatus;
    }

    public OnlineWorkingcopy getWorkingcopy() {
        OnlineWorkingcopy w = this.workingcopyPicker.get();
        return w;
    }

    public List<String> getSelectedLayerNames() {
        OnlineWorkingcopy w = this.getWorkingcopy();
        if (w == null) {
            return Collections.EMPTY_LIST;
        }
        LayersTableModel model = (LayersTableModel)this.tblLayers.getModel();
        List<OnlineLayer> selectedLayers = model.getSelectedLayers();
        if (CollectionUtils.isEmpty(selectedLayers)) {
            return Collections.EMPTY_LIST;
        }
        return selectedLayers.stream().map(t -> t.getName()).collect(Collectors.toList());
    }

    private void doChangeWorkingcopy() {
        OnlineWorkingcopy w = this.getWorkingcopy();
        if (w == null) {
            return;
        }
        w.reloadWorkspaceEntities();
        OnlineProject project = w.getProject();
        ArrayList<OnlineLayer> layers = new ArrayList<OnlineLayer>();
        boolean showHiddenLayers = w.isShowHiddenTables();
        for (OnlineLayer layer : project.layers()) {
            if (!showHiddenLayers && layer.isHidden() || !layer.isVectorial()) continue;
            layers.add(layer);
        }
        layers.sort((o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
        LayersTableModel model = new LayersTableModel(layers);
        model.addTableModelListener(e -> this.doUpdateComponents());
        this.txtWorkspaceName.setText(w.getLabel());
        this.tblLayers.setModel(model);
        this.workingAreaPicker.set(w.getCurrentWorkingArea());
        this.doUpdateComponents();
    }

    private List<OnlineLayer> getSelectedLayers() {
        LayersTableModel model = (LayersTableModel)this.tblLayers.getModel();
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        List<OnlineLayer> selectedLayers = model.getSelectedLayers();
        if (selectedLayers == null) {
            return Collections.EMPTY_LIST;
        }
        return selectedLayers;
    }

    private IProjection getLayersProjection(List<OnlineLayer> layers) {
        if (layers == null) {
            return null;
        }
        IProjection proj = null;
        for (OnlineLayer layer : layers) {
            IProjection curproj = layer.getProjection();
            if (proj == null) {
                proj = curproj;
                continue;
            }
            if (proj.equals(curproj)) continue;
            return null;
        }
        return proj;
    }

    private void doChangeViewProjection() {
        IProjection proj = this.getLayersProjection(this.getSelectedLayers());
        if (proj == null) {
            return;
        }
        OnlineSwingServices onlineServices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        LabeledValue labeledMapControl = onlineServices.getActiveMapControl();
        if (labeledMapControl == null) {
            return;
        }
        MapControl mapControl = (MapControl)labeledMapControl.getValue();
        if (mapControl == null) {
            return;
        }
        mapControl.setProjection(proj);
        this.doUpdateComponents();
    }

    public void setVisibleStatus(boolean visible) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.message.setVisible(visible);
        this.btnStatusCancel.setVisible(visible);
    }
}

