/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.initworkspace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class LayersTableModel
extends AbstractTableModel {
    private List<OnlineLayer> layers;
    private boolean[] selected;
    private final String[] columnNames;
    private final Class[] columnTypes;

    public LayersTableModel(List<OnlineLayer> layers) {
        this();
        this.layers = layers;
        this.selected = new boolean[this.layers.size()];
    }

    public LayersTableModel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.columnNames = new String[]{"", "id", i18n.getTranslation("_Name"), i18n.getTranslation("_Label"), i18n.getTranslation("_CRS"), i18n.getTranslation("_Mode")};
        this.columnTypes = new Class[]{Boolean.class, Integer.class, String.class, String.class, String.class, String.class};
        this.layers = null;
        this.selected = null;
    }

    public boolean isSelected(int rowIndex) {
        return this.selected[rowIndex];
    }

    @Override
    public int getRowCount() {
        if (this.layers == null) {
            return 0;
        }
        return this.layers.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.layers == null) {
            return null;
        }
        try {
            OnlineLayer layer = this.layers.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return this.selected[rowIndex];
                }
                case 1: {
                    return layer.getId();
                }
                case 2: {
                    return layer.getName();
                }
                case 3: {
                    return layer.getLabel();
                }
                case 4: {
                    return layer.getSRS();
                }
                case 5: {
                    return layer.isReadOnly() ? "R" : "RW";
                }
            }
            return null;
        }
        catch (Exception ex) {
            if (this.getColumnClass(columnIndex).isAssignableFrom(String.class)) {
                return "???";
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.selected == null || columnIndex != 0) {
            return;
        }
        this.selected[rowIndex] = BooleanUtils.toBoolean((String)Objects.toString(aValue));
        this.fireTableDataChanged();
    }

    private OnlineLayer get(int rowIndex) {
        return this.layers.get(rowIndex);
    }

    public boolean isSelectionEmpty() {
        if (this.selected == null) {
            return true;
        }
        for (boolean b : this.selected) {
            if (!b) continue;
            return false;
        }
        return true;
    }

    public List<OnlineLayer> getSelectedLayers() {
        if (this.layers == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<OnlineLayer> r = new ArrayList<OnlineLayer>();
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!this.isSelected(i)) continue;
            r.add(this.layers.get(i));
        }
        return r;
    }
}

