/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.initworkspace;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.downloader.swing.DownloaderConfigController;
import org.gvsig.downloader.swing.DownloaderSwingLocator;
import org.gvsig.downloader.swing.DownloaderSwingManager;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyDescriptor;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.online.swing.api.MessageStatus;
import org.gvsig.online.swing.api.OnlineJInitWorkingcopy;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.online.swing.impl.AddLayerToProjectController;
import org.gvsig.online.swing.impl.OnlineSwingCommons;
import org.gvsig.online.swing.impl.initworkspace.LayersTableModel;
import org.gvsig.online.swing.impl.initworkspace.OnlineJInitWorkingcopyView;
import org.gvsig.online.swing.impl.workingarea.WorkingAreaPickerControllerImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.TextFieldWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineJInitWorkingcopyImpl
extends OnlineJInitWorkingcopyView
implements Component,
OnlineJInitWorkingcopy {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineJInitWorkingcopyImpl.class);
    private Dialog dialog;
    private OnlineSite site;
    private FilePickerController workspaceFilePicker;
    private TextFieldWithHistoryAndBookmarkController siteURLController;
    private WorkingAreaPickerControllerImpl workingAreaPicker;
    private TaskStatusController taskStatusController;
    private MessageStatus message;
    private AddLayerToProjectController addLayerToProjectController;
    private DownloaderConfigController downloaderConfigController;
    private boolean showHiddenTables;

    public OnlineJInitWorkingcopyImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        OnlineSwingServices onlineServices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        OnlineManager onlineManager = OnlineLocator.getOnlineManager();
        DownloaderSwingManager downloaderSwingManager = DownloaderSwingLocator.getDownloaderSwingManager();
        this.message = OnlineSwingLocator.getOnlineSwingManager().createMessageStatus(this.lblStatusTitle, this.pbStatus, this.lblStatusMessages);
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblStatusTitle, this.lblStatusMessages, this.pbStatus, this.btnStatusCancel, null);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspaceFilePicker = toolsSwingManager.createFilePickerController((JTextComponent)this.txtWorkspaceFile, this.btnWorkspaceFile);
        this.workspaceFilePicker.addChangeListener(e -> {
            File file;
            if (StringUtils.isBlank((CharSequence)this.txtWorkspaceName.getText()) && (file = (File)this.workspaceFilePicker.get()) != null) {
                this.txtWorkspaceName.setText(H2SpatialUtils.removeH2FileNameExtension((String)file.getName()));
            }
            this.doUpdateComponents();
        });
        this.txtWorkspaceFile.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                OnlineJInitWorkingcopyImpl.this.doUpdateComponents();
            }
        });
        this.txtWorkspaceName.addActionListener(e -> this.doUpdateComponents());
        this.txtWorkspaceName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                OnlineJInitWorkingcopyImpl.this.doUpdateComponents();
            }
        });
        this.siteURLController = toolsSwingManager.createTextFieldWithHistoryAndBookmarkController("OnlineSiteURL", (JTextComponent)this.txtSiteURL, this.btnSiteURLRefresh, this.btnSiteURLHistory, this.btnSiteURLBookmarks);
        this.siteURLController.setEnabled(true);
        this.siteURLController.addActionListener(e -> this.doChangeSiteURL());
        this.cboProjects.addActionListener(e -> SwingUtilities.invokeLater(() -> this.doChangeProject((e.getModifiers() & 2) == 2)));
        this.workingAreaPicker = new WorkingAreaPickerControllerImpl(() -> this.getSite(), this.txtWorkingAreaLabel, this.txtWorkingArea, this.btnWorkingAreaFromView, this.btnWorkingAreaDialog, this.btnWorkingAreaHistory, this.btnWorkingAreaBookmarks, () -> {
            LabeledValue n = onlineServices.getActiveMapControl();
            return n == null ? null : (MapControl)n.getValue();
        }, () -> {
            List<OnlineLayer> selectedLayers = this.getLayersModel().getSelectedLayers();
            if (selectedLayers.isEmpty()) {
                return null;
            }
            return selectedLayers;
        });
        this.workingAreaPicker.addChangeListener(e -> this.doUpdateComponents());
        this.addLayerToProjectController = new AddLayerToProjectController(this.rdbDontAddToProject, this.rdbAddLayerToView, this.rdbAddTableToProject, this.cboView, this.message);
        this.addLayerToProjectController.addChangeListener(e -> {
            this.message.clear();
            this.doUpdateComponents();
        });
        this.btnChangeViewProjection.addActionListener(e -> this.doChangeViewProjection());
        this.downloaderConfigController = downloaderSwingManager.createDownloaderConfigController(() -> this.getSiteURLAsString(), this.btnDownloaderAddService, this.btnDownloaderAdmin);
        this.clearLayers();
        SwingUtilities.invokeLater(() -> {
            this.message.clear();
            this.doUpdateComponents();
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)100, (int)30, (int)162);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    private void doUpdateComponents() {
        this.message.clear();
        boolean enableAll = true;
        boolean isThereURL = false;
        boolean isThereAuth = false;
        boolean isThereSite = false;
        boolean isThereProject = false;
        boolean isThereDbfile = false;
        boolean isThereWsName = false;
        boolean isThereSelectedsLayers = false;
        boolean isThereWorkingArea = false;
        boolean bl = enableAll = !this.isProcessing();
        if (enableAll) {
            URL url = this.getSiteURL();
            boolean bl2 = isThereURL = url != null;
            if (!isThereURL) {
                if (StringUtils.isBlank((CharSequence)this.txtSiteURL.getText())) {
                    this.message.alert(enableAll, "_The_site_url_is_blank");
                } else {
                    this.message.alert(enableAll, "_Invalid_site_url");
                }
            }
            boolean bl3 = enableAll = enableAll && isThereURL;
        }
        if (enableAll) {
            isThereSite = this.hasSite();
            if (!isThereSite) {
                this.message.alert(enableAll, "_Select_a_valid_Online_url_and_authentication_mode");
            }
            boolean bl4 = enableAll = enableAll && isThereSite;
        }
        if (enableAll) {
            OnlineProject project = this.getProject();
            boolean bl5 = isThereProject = project != null;
            if (!isThereProject) {
                this.message.alert(enableAll, "_Select_a_Online_project");
            }
            boolean bl6 = enableAll = enableAll && isThereProject;
        }
        if (enableAll || isThereProject) {
            boolean bl7 = isThereSelectedsLayers = !this.getLayersModel().isSelectionEmpty();
            if (!isThereSelectedsLayers) {
                this.message.alert(enableAll, "_You_must_select_some_layer");
            }
            boolean bl8 = enableAll = enableAll && isThereURL && isThereSelectedsLayers;
        }
        if (enableAll || isThereProject) {
            WorkingArea workingArea = this.workingAreaPicker.getWithoutAddHistory();
            boolean bl9 = isThereWorkingArea = workingArea != null && workingArea.getValue() != null;
            if (!isThereWorkingArea) {
                this.message.alert(enableAll, "_You_must_select_a_working_area");
            }
            boolean bl10 = enableAll = enableAll && isThereURL && isThereWorkingArea;
        }
        if (enableAll) {
            File f = this.getWorkspaceFile();
            boolean bl11 = isThereDbfile = f != null;
            if (!isThereDbfile) {
                this.message.alert(enableAll, "_Selected_working_copy_file_is_not_valid");
            } else if ((f = H2SpatialUtils.normalizeH2File((File)f)).exists()) {
                this.message.alert(enableAll, "_Selected_working_copy_file_already_exists");
                isThereDbfile = false;
            }
            boolean bl12 = enableAll = enableAll && isThereDbfile;
        }
        if (enableAll) {
            String wsname = this.getWorkspaceName();
            isThereWsName = StringUtils.isNotBlank((CharSequence)wsname);
            if (!isThereWsName) {
                this.message.alert(enableAll, "_Need_a_working_copy_name");
            } else {
                OnlineManager manager = OnlineLocator.getOnlineManager();
                OnlineWorkingcopyDescriptor ws = manager.getWorkingcopyDescriptor(wsname);
                if (ws != null) {
                    this.message.alert(enableAll, "_A_working_copy_with_that_name_already_exists");
                    isThereWsName = false;
                }
            }
            enableAll = isThereURL && isThereWsName;
        }
        this.siteURLController.setEnabled(!this.isProcessing());
        this.downloaderConfigController.setEnabledAddService(isThereURL);
        this.cboProjects.setEnabled(isThereSite);
        this.workspaceFilePicker.setEnabled(isThereProject);
        this.chkCreateConnectionToDatabase.setEnabled(isThereProject && isThereDbfile);
        this.txtWorkspaceName.setEnabled(isThereProject && isThereDbfile);
        this.tblLayers.setEnabled(isThereURL && isThereProject);
        this.workingAreaPicker.setEnabled(isThereProject);
        this.workingAreaPicker.setWorkingAreaDialogEnabled(isThereSelectedsLayers);
        this.addLayerToProjectController.setEnabled(this.getSelectedLayers());
        this.btnChangeViewProjection.setEnabled(this.getLayersProjection(this.getSelectedLayers()) != null);
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enableAll);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.chkCreateConnectionToDatabase);
        swingManager.translate(this.lblWorkspaceName);
        swingManager.translate(this.lblSiteUrl);
        swingManager.translate(this.lblProjects);
        swingManager.translate(this.lblWorkspaceFile);
        swingManager.translate(this.lblLayers);
        swingManager.translate(this.lblWorkspaceFile);
        swingManager.translate(this.lblWorkingArea);
        swingManager.translate((AbstractButton)this.btnWorkingAreaFromView);
        swingManager.translate((AbstractButton)this.btnWorkingAreaDialog);
        swingManager.translate((AbstractButton)this.rdbDontAddToProject);
        swingManager.translate((AbstractButton)this.rdbAddLayerToView);
        swingManager.translate((AbstractButton)this.rdbAddTableToProject);
    }

    private URL getSiteURL() {
        if (this.siteURLController.isEnabled()) {
            URL url;
            String value = this.siteURLController.getText();
            DataTypesManager manager = ToolsLocator.getDataTypesManager();
            try {
                url = (URL)manager.coerce(16, (Object)value);
            }
            catch (CoercionException ex) {
                String s = value == null ? "null" : StringUtils.abbreviate((String)value, (int)100);
                LOGGER.warn("Can't coerce value (" + s + ") to " + "URL" + ".", (Throwable)ex);
                return null;
            }
            return url;
        }
        return null;
    }

    private String getSiteURLAsString() {
        URL url = this.getSiteURL();
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    private File getWorkspaceFile() {
        File file = (File)this.workspaceFilePicker.get();
        return file;
    }

    public int actionPerformed() {
        URL siteurl;
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineManager manager = OnlineLocator.getOnlineManager();
        OnlineProject theProject = this.getProject();
        WorkingArea workingArea = this.workingAreaPicker.get();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineSwingServices services = swingManager.getDefaultServices();
        if (theProject == null) {
            return 7;
        }
        if (workingArea == null) {
            return 8;
        }
        int err = 0;
        SimpleTaskStatus status = this.getTaskStatus();
        try {
            File file = this.getWorkspaceFile();
            if (file != null) {
                status.setTitle(i18n.getTranslation("_Initializing_workspace"));
                err = manager.initWorkingcopy(file, theProject, this.getWorkspaceName(), status);
                if (err == 0) {
                    OnlineWorkingcopy ws = manager.openWorkingcopy(file);
                    ws.setShowHiddenTables(this.showHiddenTables);
                    if (this.chkCreateConnectionToDatabase.isSelected()) {
                        ws.addToConnectionPool();
                    }
                    ws.download_config(true, status);
                    ws.download_resources(true, status);
                    ws.setCurrentWorkingArea(workingArea);
                    LayersTableModel model = (LayersTableModel)this.tblLayers.getModel();
                    List<OnlineLayer> selectedLayers = model.getSelectedLayers();
                    if (!CollectionUtils.isEmpty(selectedLayers)) {
                        status.setRangeOfValues(0L, (long)selectedLayers.size());
                        status.setCurValue(0L);
                        for (OnlineLayer layer : selectedLayers) {
                            status.incrementCurrentValue();
                            status.setTitle(i18n.getTranslation("_Adding_layer") + " " + layer.getName());
                            if (status.isCancellationRequested()) {
                                throw new UserCancelTaskException();
                            }
                            String fieldForLabel = layer.getFeatureCodeFieldName();
                            ws.addEntity(layer.getFeatureType(), layer.getName(), null, fieldForLabel, layer.getTitle(), layer.getPkName(), -1);
                        }
                        status.setRangeOfValues(0L, (long)selectedLayers.size());
                        status.setCurValue(0L);
                        for (OnlineLayer layer : selectedLayers) {
                            status.incrementCurrentValue();
                            status.setTitle(i18n.getTranslation("_Downloading_layer") + " " + layer.getName());
                            if (status.isCancellationRequested()) {
                                throw new UserCancelTaskException();
                            }
                            err = ws.download(layer.getName(), (Envelope)workingArea.getValue(), status);
                            if (err == 0) continue;
                        }
                        for (OnlineLayer layer : selectedLayers) {
                            this.addLayerToProjectController.process(ws, layer);
                        }
                    }
                }
            }
            status.terminate();
        }
        catch (UserCancelTaskException ex) {
            LOGGER.info("Cancelled by user.");
            status.cancel();
            err = 17;
        }
        catch (Exception ex) {
            LOGGER.info("Can't initialize workspace", (Throwable)ex);
            err = 25;
            status.abort();
        }
        if ((err == 0 || err == 17) && (siteurl = this.getSiteURL()) != null) {
            this.siteURLController.addHistory(siteurl.toString());
        }
        return err;
    }

    private OnlineSite createSite() {
        try {
            OnlineManager manager = OnlineLocator.getOnlineManager();
            URL url = this.getSiteURL();
            if (url != null) {
                return manager.connectSite(url);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Can't connect to site '" + this.txtSiteURL.getText() + "'", (Throwable)ex);
        }
        return null;
    }

    private OnlineSite getSite() {
        if (this.site == null) {
            this.site = this.createSite();
        }
        return this.site;
    }

    private boolean hasSite() {
        return this.site != null;
    }

    private OnlineProject getProject() {
        OnlineSite theSite = this.getSite();
        if (theSite == null) {
            return null;
        }
        LabeledValue item = (LabeledValue)this.cboProjects.getSelectedItem();
        if (item == null) {
            return null;
        }
        return theSite.getProject(((Integer)item.getValue()).intValue());
    }

    public String getWorkspaceName() {
        return this.txtWorkspaceName.getText();
    }

    public static void selfRegister() {
    }

    public boolean isProcessing() {
        return false;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return OnlineSwingCommons.loadImage(imageName);
    }

    private void doChangeSiteURL() {
        URL url = null;
        try {
            OnlineManager onlineManager = OnlineLocator.getOnlineManager();
            url = this.getSiteURL();
            this.site = onlineManager.connectSite(url);
            this.siteURLController.addHistory(url.toString());
            this.doFillProjects();
            this.doUpdateComponents();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't chage site url (" + url + ").", (Throwable)ex);
        }
    }

    private void doFillProjects() {
        OnlineSite theSite = this.getSite();
        if (theSite == null) {
            return;
        }
        ArrayList<LabeledValueImpl> projects = new ArrayList<LabeledValueImpl>();
        for (OnlineProject project : theSite.projects()) {
            projects.add(new LabeledValueImpl(project.getTitle(), (Object)project.getId()));
        }
        projects.sort((o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
        DefaultComboBoxModel<LabeledValue> model = new DefaultComboBoxModel<LabeledValue>();
        for (LabeledValue labeledValue : projects) {
            model.addElement(labeledValue);
        }
        this.cboProjects.setModel(model);
        this.cboProjects.setSelectedIndex(-1);
        this.workspaceFilePicker.set(null);
        this.txtWorkspaceName.setText("");
        this.clearLayers();
    }

    private void doChangeProject(final boolean showHiddenLayers) {
        final OnlineSite theSite = this.getSite();
        final LabeledValue selected = (LabeledValue)this.cboProjects.getSelectedItem();
        if (selected == null || theSite == null) {
            this.workspaceFilePicker.set(null);
            this.txtWorkspaceName.setText("");
            this.clearLayers();
            return;
        }
        this.cboProjects.setEnabled(false);
        SwingWorker<List<OnlineLayer>, String> worker = new SwingWorker<List<OnlineLayer>, String>(){

            @Override
            protected List<OnlineLayer> doInBackground() throws Exception {
                int projectId = (Integer)selected.getValue();
                OnlineProject project = theSite.getProject(projectId);
                ArrayList<OnlineLayer> layers = new ArrayList<OnlineLayer>();
                Iterable projectLayers = project.layers();
                for (OnlineLayer layer : projectLayers) {
                    OnlineJInitWorkingcopyImpl.this.message.message(layer.getName());
                    if (!showHiddenLayers && layer.isHidden() || !layer.isVectorial()) continue;
                    layers.add(layer);
                }
                layers.sort((o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
                return layers;
            }

            @Override
            protected void done() {
                try {
                    OnlineJInitWorkingcopyImpl.this.cboProjects.setEnabled(true);
                    OnlineJInitWorkingcopyImpl.this.message.clear();
                    List layers = (List)this.get();
                    LayersTableModel model = new LayersTableModel(layers);
                    model.addTableModelListener(e -> OnlineJInitWorkingcopyImpl.this.doUpdateComponents());
                    OnlineJInitWorkingcopyImpl.this.showHiddenTables = showHiddenLayers;
                    OnlineJInitWorkingcopyImpl.this.tblLayers.setModel(model);
                    OnlineJInitWorkingcopyImpl.this.doUpdateComponents();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        worker.execute();
    }

    private void clearLayers() {
        LayersTableModel model = new LayersTableModel();
        this.tblLayers.setModel(model);
    }

    private LayersTableModel getLayersModel() {
        return (LayersTableModel)this.tblLayers.getModel();
    }

    private SimpleTaskStatus getTaskStatus() {
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Create_workingcopy");
        taskStatus.setAutoremove(true);
        taskStatus.add();
        taskStatus.setIndeterminate();
        this.taskStatusController.bind((TaskStatus)taskStatus);
        return taskStatus;
    }

    public void setVisibleStatus(boolean visible) {
        if (OnlineSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    private List<OnlineLayer> getSelectedLayers() {
        try {
            LayersTableModel model = (LayersTableModel)this.tblLayers.getModel();
            if (model == null) {
                return Collections.EMPTY_LIST;
            }
            List<OnlineLayer> selectedLayers = model.getSelectedLayers();
            if (selectedLayers == null) {
                return Collections.EMPTY_LIST;
            }
            return selectedLayers;
        }
        catch (Exception ex) {
            return Collections.EMPTY_LIST;
        }
    }

    private IProjection getLayersProjection(List<OnlineLayer> layers) {
        if (layers == null) {
            return null;
        }
        IProjection proj = null;
        for (OnlineLayer layer : layers) {
            IProjection curproj = layer.getProjection();
            if (proj == null) {
                proj = curproj;
                continue;
            }
            if (proj.equals(curproj)) continue;
            return null;
        }
        return proj;
    }

    private void doChangeViewProjection() {
        IProjection proj = this.getLayersProjection(this.getSelectedLayers());
        if (proj == null) {
            return;
        }
        OnlineSwingServices onlineServices = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
        LabeledValue labeledMapControl = onlineServices.getActiveMapControl();
        if (labeledMapControl == null) {
            return;
        }
        MapControl mapControl = (MapControl)labeledMapControl.getValue();
        if (mapControl == null) {
            return;
        }
        mapControl.setProjection(proj);
        this.doUpdateComponents();
    }
}

