/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.registerWorkspace;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionDialog;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyDescriptor;
import org.gvsig.online.swing.api.OnlineJRegisterWorkspace;
import org.gvsig.online.swing.impl.OnlineSwingLibraryImpl;
import org.gvsig.online.swing.impl.OnlineSwingManagerImpl;
import org.gvsig.online.swing.impl.registerWorkspace.OnlineJRegisterWorkspaceView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.util.CompareUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineJRegisterWorkspaceImpl
extends OnlineJRegisterWorkspaceView
implements Component,
OnlineJRegisterWorkspace {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineJRegisterWorkspaceImpl.class);
    private Dialog dialog;

    public OnlineJRegisterWorkspaceImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        this.btnAdd.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemove.setCursor(Cursor.getPredefinedCursor(12));
        this.fillWorkspaces();
        this.lstWorkspaces.addListSelectionListener(e -> this.doUpdateEnableComponents());
        this.lstWorkspaces.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doWorkspaceSelected();
        });
        this.btnAdd.addActionListener(e -> {
            this.registerWorkspace();
            this.fillWorkspaces();
        });
        this.btnRemove.addActionListener(e -> {
            this.deregisterWorkspace();
            this.fillWorkspaces();
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)11, (int)60);
    }

    public void registerWorkspace() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            JDBCConnectionDialog connectionDialog = DALSwingLocator.getDataSwingManager().createJDBCConectionDialog();
            connectionDialog.showDialog();
            if (connectionDialog.isCanceled()) {
                return;
            }
            JDBCServerExplorerParameters serverExplorerParameters = connectionDialog.getServerExplorerParameters();
            DataServerExplorer serverExplorer = DALLocator.getDataManager().openServerExplorer(serverExplorerParameters.getProviderName(), (DataServerExplorerParameters)serverExplorerParameters);
            OnlineWorkingcopy ws = OnlineLocator.getOnlineManager().openWorkingcopy((JDBCServerExplorer)serverExplorer);
            if (ws == null) {
                ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(i18n.getTranslation("_Selected_connection_is_not_a_valid_workingcopy"), i18n.getTranslation("_Register_workingcopy"), 2);
                return;
            }
            OnlineLocator.getOnlineManager().registerWorkingcopy(ws);
            String url = ws.getExplorerParameters().getUrl();
            LOGGER.info("Register working copy '" + ws.getLabel() + "' (" + url + ")");
        }
        catch (Exception ex) {
            LOGGER.warn(i18n.getTranslation("_Cant_register_workingcopy"), (Throwable)ex);
            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(i18n.getTranslation("_Cant_register_workingcopy"), i18n.getTranslation("_Register_workingcopy"), 2);
        }
    }

    public void deregisterWorkspace() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        OnlineWorkingcopyDescriptor descriptor = (OnlineWorkingcopyDescriptor)this.lstWorkspaces.getSelectedValue();
        if (descriptor == null) {
            return;
        }
        String url = descriptor.getExplorerParameters().getUrl();
        String msg = i18n.getTranslation("_You_will_delete_from_the_registry_XXX", new String[]{descriptor.getLabel()}) + "\n\n(" + url + ")\n\n" + i18n.getTranslation("_Are_you_sure");
        int n = dialogs.confirmDialog(msg, i18n.getTranslation("_Working_copies"), 0, 3, "_Online_You_will_delete_from_the_registry");
        if (n == 0) {
            LOGGER.info("Desregister working copy '" + descriptor.getLabel() + "' (" + url + ")");
            OnlineLocator.getOnlineManager().deregisterWorkingcopy(descriptor.getCode());
        }
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateEnableComponents();
    }

    private void doUpdateEnableComponents() {
        if (this.lstWorkspaces.getSelectedIndex() != -1) {
            this.btnRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnAdd);
        swingManager.translate((AbstractButton)this.btnRemove);
        swingManager.translate((JComponent)this.lstWorkspaces);
    }

    private void fillWorkspaces() {
        int n = this.lstWorkspaces.getSelectedIndex();
        this.lstWorkspaces.setSelectionMode(0);
        this.lstWorkspaces.getSelectionModel().addListSelectionListener(e -> this.doUpdateEnableComponents());
        Map workspaces_map = OnlineLocator.getOnlineManager().getWorkingcopy();
        ArrayList workspaces = new ArrayList(workspaces_map.values());
        Collections.sort(workspaces, CompareUtils.EQUALS_IGNORECASE_COMPARATOR);
        DefaultListModel<OnlineWorkingcopyDescriptor> model = new DefaultListModel<OnlineWorkingcopyDescriptor>();
        for (OnlineWorkingcopyDescriptor workspace : workspaces) {
            model.addElement(workspace);
        }
        this.lstWorkspaces.setModel(model);
        this.lstWorkspaces.setCellRenderer(new DefaultListCellRenderer());
        try {
            if (n < 0) {
                n = 0;
            }
            if (n >= this.lstWorkspaces.getModel().getSize()) {
                n = this.lstWorkspaces.getModel().getSize() - 1;
            }
            this.lstWorkspaces.setSelectedIndex(n);
        }
        catch (Exception ex) {
            LOGGER.debug("", (Throwable)ex);
        }
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return OnlineSwingManagerImpl.loadImage(imageName);
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(OnlineSwingLibraryImpl.class, (String)"/org/gvsig/online/swing/impl/images", (String)"Online", (String[][])new String[][]{{"online", "online-workspace-add", "preferences"}, {"online", "online-workspace-remove", "preferences"}});
    }

    public boolean isProcessing() {
        return false;
    }

    private void doWorkspaceSelected() {
        OnlineWorkingcopyDescriptor descriptor = (OnlineWorkingcopyDescriptor)this.lstWorkspaces.getSelectedValue();
        if (descriptor == null) {
            return;
        }
        String url = descriptor.getExplorerParameters().getUrl();
        this.txtMsg.setText(url);
        this.txtMsg.setCaretPosition(0);
    }
}

