/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.simplesearch;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.online.swing.impl.simplesearch.OnlineFeatureStoreElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.task.SimpleTaskStatus;

public class OnlineFeatureAttributeElement
extends AbstractElement
implements Element.SimpleElement {
    final FeatureStore store;
    final FeatureAttributeDescriptor attrdesc;
    List<Element> values;
    boolean hasMoreValues;
    private final OnlineFeatureStoreElement parent;

    OnlineFeatureAttributeElement(OnlineFeatureStoreElement parent, FeatureStore store, FeatureAttributeDescriptor attrdesc) {
        this(parent, store, attrdesc, "featurestore-column", false);
    }

    OnlineFeatureAttributeElement(OnlineFeatureStoreElement parent, FeatureStore store, FeatureAttributeDescriptor attrdesc, String iconName) {
        this(parent, store, attrdesc, iconName, false);
    }

    OnlineFeatureAttributeElement(OnlineFeatureStoreElement parent, FeatureStore store, FeatureAttributeDescriptor attrdesc, boolean useHostVariable) {
        this(parent, store, attrdesc, null, useHostVariable);
    }

    OnlineFeatureAttributeElement(OnlineFeatureStoreElement parent, FeatureStore store, FeatureAttributeDescriptor attrdesc, String iconName, boolean useHostVariable) {
        super(attrdesc.getName(), (Object)OnlineFeatureAttributeElement.buildRenderedValueForAttribute((Element)parent, store, attrdesc, useHostVariable), iconName);
        this.parent = parent;
        this.store = store;
        this.attrdesc = attrdesc;
        this.hasMoreValues = false;
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        String theIconName = attrdesc.getDataType().getIconName();
        IconTheme.Icon theIcon = iconTheme.getThemeIcon(theIconName);
        if (theIcon != null && theIcon.getURL() != null) {
            this.icon = ToolsSwingLocator.getToolsSwingManager().createCompoundIcon(0, 1, 2, 1, new Icon[]{this.getIcon(), theIcon.getImageIcon()});
        }
    }

    private static String buildRenderedValueForAttribute(Element parent, FeatureStore store, FeatureAttributeDescriptor attrdesc, boolean useHostVariable) {
        boolean useFullyQualifiedNames = false;
        if (parent instanceof FeatureStoreElement) {
            useFullyQualifiedNames = ((FeatureStoreElement)parent).getUseFullyQualifiedNames();
        }
        String attrname = attrdesc.getName();
        String storename = store.getName();
        if (useHostVariable) {
            return ":" + OnlineFeatureAttributeElement.addQuotesIfNeeded(attrname);
        }
        if (useFullyQualifiedNames) {
            return OnlineFeatureAttributeElement.addQuotesIfNeeded(storename) + "." + OnlineFeatureAttributeElement.addQuotesIfNeeded(attrname);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)storename, (CharSequence)attrname)) {
            return OnlineFeatureAttributeElement.addQuotesIfNeeded(storename) + "." + OnlineFeatureAttributeElement.addQuotesIfNeeded(attrname);
        }
        return OnlineFeatureAttributeElement.addQuotesIfNeeded(attrname);
    }

    public Element getParent() {
        return this.parent;
    }

    public void reload() {
        this.values = null;
        this.hasMoreValues = false;
    }

    public boolean isEnabled() {
        return !this.getConfig().getPreferences().isSQLCompatible() || !this.attrdesc.isComputed();
    }

    public boolean hasMoreValues() {
        return this.hasMoreValues;
    }

    public List<Element> getValues() {
        if (this.values == null) {
            this.hasMoreValues = false;
            final List v = this.parent.getWorkingcopy().getValues(this.parent.getEntity(), this.attrdesc.getName(), SimpleTaskStatus.FAKE_STATUS);
            final ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
            this.values = new AbstractList<Element>(){

                @Override
                public Element get(int index) {
                    return manager.createConstantElement(v.get(index), Objects.toString(v.get(index), ""));
                }

                @Override
                public int size() {
                    return v.size();
                }
            };
        }
        return this.values;
    }

    public String getName() {
        return this.attrdesc.getName();
    }

    public String getLabel() {
        if (this.getConfig().getPreferences().getShowLabelsOfElements()) {
            if (!StringUtils.equals((CharSequence)this.attrdesc.getName(), (CharSequence)this.attrdesc.getLabel())) {
                return String.format("<html>%s<br><font size=\"2\"><i>(%s)</i></font></html>", this.attrdesc.getLocalizedLabel(), this.attrdesc.getName());
            }
            return String.format("<html>%s</html>", this.attrdesc.getLocalizedLabel());
        }
        return String.format("<html>%s</html>", this.attrdesc.getName());
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        html.append("<b>").append(this.attrdesc.getName()).append("</b><br>");
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.attrdesc.getName(), (CharSequence)this.attrdesc.getLabel())) {
            html.append(this.attrdesc.getLabel()).append("<br>\n");
        }
        html.append("<br>\n");
        html.append("<b>").append(i18n.getTranslation("_Source")).append("</b> ").append(this.store.getName()).append("<br>\n");
        html.append("<b>").append(i18n.getTranslation("_Name")).append("</b> ").append(this.getName()).append("<br>\n");
        html.append("<b>").append(i18n.getTranslation("_Label")).append("</b> ").append(this.attrdesc.getLocalizedLabel()).append("<br>\n");
        html.append("<b>").append(i18n.getTranslation("_Type")).append("</b> ").append(this.attrdesc.getDataTypeName()).append("<br>\n");
        if (!StringUtils.isBlank((CharSequence)this.attrdesc.getDescription()) && StringUtils.equalsAnyIgnoreCase((CharSequence)this.getName(), (CharSequence[])new CharSequence[]{this.attrdesc.getDescription()})) {
            html.append("<b>").append(i18n.getTranslation("_Description")).append("</b><br>\n");
            html.append(this.attrdesc.getDescription().replace("\n", "<br>")).append("<br>\n");
        }
        html.append("</html>\n");
        return html.toString();
    }

    public void used() {
        this.attrdesc.recentUsed();
    }

    private static String addQuotesIfNeeded(String fieldName) {
        if (!fieldName.matches("^[a-zA-Z][a-zA-Z0-9_]*")) {
            fieldName = '\"' + fieldName + '\"';
        }
        return fieldName;
    }
}

