/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.simplesearch;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretable.SimpleFeaturesTableModel;
import org.gvsig.online.swing.api.MessageStatus;
import org.gvsig.online.swing.api.OnlineJSimpleSearch;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.SimpleSearch;
import org.gvsig.online.swing.impl.simplesearch.OnlineFeatureStoreElement;
import org.gvsig.online.swing.impl.simplesearch.OnlineJSimpleSearchView;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineJSimpleSearchImpl
extends OnlineJSimpleSearchView
implements OnlineJSimpleSearch {
    public static final Logger LOGGER = LoggerFactory.getLogger(OnlineJSimpleSearchImpl.class);
    private ExpressionPickerController pickerFilter;
    private Dialog dialog;
    private final SimpleSearch simpleSearch;
    private MessageStatus message;

    public OnlineJSimpleSearchImpl(FeatureStore store, Arguments arguments) {
        this.simpleSearch = OnlineSwingLocator.getOnlineSwingManager().createSimpleSearch(store, (JComponent)this);
        this.initComponents();
    }

    private void initComponents() {
        this.message = OnlineSwingLocator.getOnlineSwingManager().createMessageStatus(this.lblStatusCaption, this.pbStatus, this.lblStatusMessages);
        this.translate();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.pickerFilter = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtFilter, this.btnFilter, this.btnFilterBookmarks, this.btnFilterHistory);
        this.pickerFilter.getConfig().removeAllSymbolTables();
        MutableSymbolTable symbolTable = ExpressionUtils.createSymbolTable();
        MutableSymbolTable onlineSymbolTable = ExpressionUtils.createEmptySymbolTable();
        onlineSymbolTable.addFunction(symbolTable.function("OR"));
        onlineSymbolTable.addFunction(symbolTable.function("AND"));
        onlineSymbolTable.addFunction(symbolTable.function("LIKE"));
        onlineSymbolTable.addFunction(symbolTable.function("ILIKE"));
        onlineSymbolTable.addFunction(symbolTable.function("="));
        onlineSymbolTable.addFunction(symbolTable.function(">="));
        onlineSymbolTable.addFunction(symbolTable.function(">"));
        onlineSymbolTable.addFunction(symbolTable.function("<="));
        onlineSymbolTable.addFunction(symbolTable.function("<"));
        onlineSymbolTable.addFunction(symbolTable.function("<>"));
        onlineSymbolTable.addFunction(symbolTable.function("NOT"));
        this.pickerFilter.getConfig().addSymbolTable((SymbolTable)onlineSymbolTable);
        dataSwingManager.configureExpressionBuilder(this.pickerFilter.getConfig(), this.simpleSearch.getFeatureStore());
        this.pickerFilter.getConfig().addElement((Element)new OnlineFeatureStoreElement(this.simpleSearch.getWorkingcopy(), this.simpleSearch.getFeatureStore()));
        this.pickerFilter.addChangeListener(e -> this.doUpdateComponents());
        if (!this.simpleSearch.isEmpty()) {
            SimpleFeaturesTableModel tableModel = dataSwingManager.createSimpleFeaturesTableModel(this.simpleSearch.getFeatureType(), null, null);
            this.tblSearchResult.setModel((TableModel)tableModel);
        }
        this.btnSearch.addActionListener(e -> this.doSearch());
        this.btnDownloadSelectAndZoom.addActionListener(e -> this.doDownloadAndZoom());
        this.btnSelectAndZoom.addActionListener(e -> this.doSelectAndZoom());
        this.lblStoreName.setText("");
        this.doUpdateComponents();
        SwingUtilities.invokeLater(() -> this.message.clear());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)40, (int)25, (int)100);
    }

    private void doUpdateComponents() {
        if (this.simpleSearch.isEmpty() || this.simpleSearch.isProcessing()) {
            this.pickerFilter.setEnabled(false);
            this.btnSearch.setEnabled(false);
            this.btnSelectAndZoom.setEnabled(false);
            this.btnDownloadSelectAndZoom.setEnabled(false);
            return;
        }
        this.pickerFilter.setEnabled(true);
        if (this.pickerFilter.isEmpty() || !this.pickerFilter.isValid()) {
            this.btnSearch.setEnabled(false);
            this.btnSelectAndZoom.setEnabled(false);
            this.btnDownloadSelectAndZoom.setEnabled(false);
            return;
        }
        this.btnSearch.setEnabled(true);
        if (!this.simpleSearch.isSearched()) {
            this.btnSelectAndZoom.setEnabled(false);
            this.btnDownloadSelectAndZoom.setEnabled(false);
            return;
        }
        this.btnSelectAndZoom.setEnabled(true);
        MutableObject msg = new MutableObject();
        if (!this.simpleSearch.canDownload(msg)) {
            this.btnDownloadSelectAndZoom.setEnabled(false);
            this.message.alert((String)msg.getValue());
            return;
        }
        this.btnDownloadSelectAndZoom.setEnabled(true);
    }

    public boolean isProcessing() {
        return this.simpleSearch.isProcessing();
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doSearch() {
        Expression filter = this.getFilter();
        this.simpleSearch.runSearchTask(filter, () -> {
            this.tblSearchResult.setModel(this.simpleSearch.createTableModel());
            this.doUpdateComponents();
        }, this.message);
    }

    private void doDownloadAndZoom() {
        SimpleFeaturesTableModel model = (SimpleFeaturesTableModel)this.tblSearchResult.getModel();
        int[] selectedRows = this.tblSearchResult.getSelectedRows();
        Expression filter = model.getFeaturesFilter(selectedRows);
        this.simpleSearch.runDownloadTask(filter, () -> this.simpleSearch.zoom(null), this.message);
    }

    private void doSelectAndZoom() {
        SimpleFeaturesTableModel model = (SimpleFeaturesTableModel)this.tblSearchResult.getModel();
        int[] selectedRows = this.tblSearchResult.getSelectedRows();
        Expression filter = model.getFeaturesFilter(selectedRows);
        this.simpleSearch.runCalculateEnvelopeTask(filter, () -> {
            this.simpleSearch.setSelection(filter);
            this.simpleSearch.zoom(null);
        }, this.message);
    }

    private Expression getFilter() {
        return this.pickerFilter.get();
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnSearch);
        swingManager.translate((AbstractButton)this.btnDownloadSelectAndZoom);
        swingManager.translate((AbstractButton)this.btnSelectAndZoom);
    }
}

