/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.simplesearch;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.MessageStatus;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.online.swing.api.SimpleSearch;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSearchImpl
implements SimpleSearch {
    public static final Logger LOGGER = LoggerFactory.getLogger(SimpleSearchImpl.class);
    private final OnlineWorkingcopy wc;
    private OnlineEntity entity;
    private FeatureType featureType;
    private FeaturePagingHelper feats;
    private Envelope fullEnv;
    private final FeatureStore store;
    private Expression lastFilter;
    private boolean processing;

    public SimpleSearchImpl(FeatureStore store) {
        this(store, null);
    }

    public SimpleSearchImpl(FeatureStore store, JComponent panel) {
        OnlineManager manager = OnlineLocator.getOnlineManager();
        this.store = store;
        DisposeUtils.bind((Disposable)this.store);
        this.wc = manager.getWorkingcopy(store);
        if (this.wc != null) {
            this.entity = this.wc.getEntity(store.getName());
            this.featureType = this.wc.getFeatureType(this.entity.getEntityName());
        }
        this.processing = false;
        if (panel != null) {
            panel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    SimpleSearchImpl.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.store);
        DisposeUtils.disposeQuietly((Disposable)this.wc);
        DisposeUtils.disposeQuietly((Disposable)this.feats);
    }

    public long count(Expression filter) {
        return this.count(filter, null);
    }

    public long count(Expression filter, SimpleTaskStatus status) {
        if (status == null) {
            status = SimpleTaskStatus.FAKE_STATUS;
        }
        long count = this.wc.simpleSearchCount(this.entity.getEntityName(), filter, status);
        return count;
    }

    public boolean areThereTooManyResults(Expression filter) {
        return this.areThereTooManyResults(filter, null);
    }

    public boolean areThereTooManyResults(Expression filter, SimpleTaskStatus status) {
        if (status == null) {
            status = SimpleTaskStatus.FAKE_STATUS;
        }
        int minResultForAlert = this.wc.getMinResultForAlert();
        return this.count(filter, status) > (long)minResultForAlert;
    }

    public List<Feature> search(Expression filter) {
        return this.search(filter, null);
    }

    public List<Feature> search(Expression filter, SimpleTaskStatus status) {
        if (status == null) {
            status = SimpleTaskStatus.FAKE_STATUS;
        }
        this.fullEnv = null;
        this.lastFilter = null;
        if (this.feats != null) {
            DisposeUtils.disposeQuietly((Disposable)this.feats);
            this.feats = null;
        }
        this.feats = this.wc.simpleSearch(this.entity.getEntityName(), filter, status);
        this.lastFilter = filter;
        return this.feats.asList();
    }

    public boolean isSearched() {
        return this.lastFilter != null;
    }

    public int download() {
        return this.download(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int download(Expression filter, SimpleTaskStatus status) {
        if (!this.isSearched()) {
            return 0;
        }
        if (status == null) {
            status = SimpleTaskStatus.FAKE_STATUS;
        }
        FeatureSet set = null;
        try {
            Iterator it;
            IProjection proj4326 = CRSFactory.getCRS((String)"EPSG:4326");
            final ICoordTrans ct = proj4326.getCT(this.entity.getCRSAsProjection());
            this.fullEnv = GeometryLocator.getGeometryManager().createEnvelope(0);
            if (filter == null) {
                it = this.feats.iterator();
            } else {
                set = this.feats.getFeatureStore().getFeatureSet(filter);
                it = set.fastIterator();
            }
            Iterator<Geometry> geoms = new Iterator<Geometry>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Geometry next() {
                    Geometry geom = ((Feature)it.next()).getDefaultGeometry();
                    geom.reProject(ct);
                    SimpleSearchImpl.this.fullEnv.add(geom);
                    return geom;
                }
            };
            int n = this.wc.download(this.entity.getEntityName(), (Iterator)geoms, status);
            SwingUtilities.invokeLater(() -> {
                this.setSelection(filter);
                OnlineSwingServices services = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
                services.refreshDocument(this.getFeatureStore());
            });
            int n2 = n;
            DisposeUtils.dispose((Disposable)set);
            return n2;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't download.", (Throwable)ex);
            int n = 25;
            return n;
        }
        finally {
            DisposeUtils.dispose(set);
        }
    }

    public OnlineWorkingcopy getWorkingcopy() {
        return this.wc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope getEnvelope(Expression filter, SimpleTaskStatus status) {
        if (this.fullEnv == null || filter != null) {
            FeatureSet set = null;
            try {
                Iterator it;
                I18nManager i18n = ToolsLocator.getI18nManager();
                IProjection proj4326 = CRSFactory.getCRS((String)"EPSG:4326");
                final ICoordTrans ct = proj4326.getCT(this.entity.getCRSAsProjection());
                this.fullEnv = GeometryLocator.getGeometryManager().createEnvelope(0);
                if (filter == null) {
                    it = this.feats.iterator();
                } else {
                    set = this.feats.getFeatureStore().getFeatureSet(filter);
                    it = set.fastIterator();
                }
                Iterator<Geometry> geoms = new Iterator<Geometry>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Geometry next() {
                        Geometry geom = ((Feature)it.next()).getDefaultGeometry();
                        geom.reProject(ct);
                        SimpleSearchImpl.this.fullEnv.add(geom);
                        return geom;
                    }
                };
                status.message(i18n.getTranslation("_Calculating_envelope"));
                status.setRangeOfValues(0L, this.feats.size64());
                while (geoms.hasNext()) {
                    status.incrementCurrentValue();
                    geoms.next();
                }
                DisposeUtils.dispose((Disposable)set);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't get envelope.", (Throwable)ex);
            }
            finally {
                DisposeUtils.dispose(set);
            }
        }
        return this.fullEnv;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean isEmpty() {
        return this.featureType == null;
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public TableModel createEmptyTableModel() {
        DataSwingManager swingManager = DALSwingLocator.getDataSwingManager();
        return swingManager.createSimpleFeaturesTableModel(this.getFeatureType(), null, null);
    }

    public TableModel createTableModel() {
        if (this.feats == null) {
            return this.createEmptyTableModel();
        }
        DataSwingManager swingManager = DALSwingLocator.getDataSwingManager();
        return swingManager.createSimpleFeaturesTableModel(this.getFeatureType(), null, this.feats.asList());
    }

    public void zoom(Expression filter) {
        this.zoom(filter, SimpleTaskStatus.FAKE_STATUS);
    }

    public void zoom(Expression filter, SimpleTaskStatus status) {
        Envelope env = this.getEnvelope(filter, status);
        if (env == null) {
            return;
        }
        try {
            OnlineSwingServices services = OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
            if (!env.isEmpty()) {
                services.zoomActiveViewToGeometry(env.getGeometry().buffer(100.0));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't zoom to results.", (Throwable)ex);
        }
    }

    public void setSelection() {
        FeatureSet set = null;
        try {
            set = this.getFeatureStore().getFeatureSet(this.lastFilter);
            this.getFeatureStore().setSelection(set);
        }
        catch (DataException ex) {
            LOGGER.warn("Can't set selection", (Throwable)ex);
        }
    }

    public void setSelection(Expression filter) {
        if (filter == null) {
            this.setSelection();
            return;
        }
        FeatureSet set = null;
        try {
            set = this.getFeatureStore().getFeatureSet(filter);
            this.getFeatureStore().setSelection(set);
        }
        catch (DataException ex) {
            LOGGER.warn("Can't set selection", (Throwable)ex);
        }
    }

    public Thread runSearchTask(Expression filter, Runnable postProcessingAction, MessageStatus message) {
        SimpleTaskStatus status = message.createTaskStatus("_Search");
        message.setVisible(true);
        message.clear();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        Thread task = new Thread(() -> {
            this.processing = true;
            try {
                int n;
                if (this.areThereTooManyResults(filter) && (n = dialogs.confirmDialog(i18n.getTranslation("_Search_returns_too_many_results") + "\n" + i18n.getTranslation("_Do_you_want_to_continue_anyway"), i18n.getTranslation("_Upload"), 0, 3)) != 0) {
                    return;
                }
                this.search(filter, status);
            }
            catch (Exception exception) {
            }
            finally {
                if (postProcessingAction != null) {
                    SwingUtilities.invokeLater(() -> postProcessingAction.run());
                }
                message.setVisible(false);
                this.processing = false;
            }
        }, "OnlineSimpleSearch");
        this.processing = true;
        task.start();
        return task;
    }

    public Thread runDownloadTask(Expression filter, Runnable postProcessingAction, MessageStatus message) {
        if (!this.isSearched()) {
            return null;
        }
        SimpleTaskStatus status = message.createTaskStatus("_Download");
        message.setVisible(true);
        message.clear();
        Thread task = new Thread(() -> {
            this.processing = true;
            try {
                this.download(filter, status);
            }
            catch (Exception exception) {
            }
            finally {
                if (postProcessingAction != null) {
                    SwingUtilities.invokeLater(() -> postProcessingAction.run());
                }
                message.setVisible(false);
                this.processing = false;
            }
        }, "OnlineSimpleSearchDownload");
        this.processing = true;
        task.start();
        return task;
    }

    public Thread runCalculateEnvelopeTask(Expression filter, Runnable postProcessingAction, MessageStatus message) {
        if (!this.isSearched()) {
            return null;
        }
        SimpleTaskStatus status = message.createTaskStatus("_Calculate_envelope");
        message.setVisible(true);
        message.clear();
        Thread task = new Thread(() -> {
            this.processing = true;
            try {
                this.getEnvelope(filter, status);
                message.clear();
            }
            catch (Exception exception) {
            }
            finally {
                if (postProcessingAction != null) {
                    SwingUtilities.invokeLater(() -> postProcessingAction.run());
                }
                message.setVisible(false);
                this.processing = false;
            }
        }, "OnlineSimpleSearchCalculateEnvelope");
        this.processing = true;
        task.start();
        return task;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean canDownload(MutableObject<String> message) {
        return this.getWorkingcopy().canDownload(message, Collections.singletonList(this.entity.getEntityCode()));
    }
}

