/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.swing.impl.workingarea;

import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.online.swing.impl.SelectAreaPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;

public class WorkingAreaPickerControllerImpl
extends AbstractPickerController<WorkingArea> {
    private final JTextComponent txtLabel;
    private final JTextComponent txtEnvelope;
    private final JButton btnWorkingAreaFromView;
    private final JButton btnWorkingAreaDialog;
    private final JButton btnHistory;
    private final JButton btnBookmarks;
    private final Supplier<MapControl> mapControl;
    private final Supplier<List<OnlineLayer>> layers;
    private final Supplier<OnlineSite> site;
    private WorkingArea workingArea;
    private static final String BOOKMARKSANDHISTORY_NAME = "WorkingAreaPickerController";
    private final Bookmarks bookmarks;
    private final History history;
    private final BookmarksController bookmarksController;
    private final HistoryController historyController;

    public WorkingAreaPickerControllerImpl(Supplier<OnlineSite> site, JTextComponent txtLabel, JTextComponent txtEnvelope, JButton btnWorkingAreaFromView, JButton btnWorkingAreaDialog, JButton btnHistory, JButton btnBookmarks, Supplier<MapControl> mapControl, Supplier<List<OnlineLayer>> layers) {
        this.mapControl = mapControl;
        this.txtLabel = txtLabel;
        this.site = site;
        this.layers = layers;
        this.txtEnvelope = txtEnvelope == null ? new JTextField() : txtEnvelope;
        this.txtEnvelope.setEditable(false);
        this.btnWorkingAreaFromView = btnWorkingAreaFromView == null ? new JButton() : btnWorkingAreaFromView;
        this.btnWorkingAreaDialog = btnWorkingAreaDialog;
        this.btnHistory = btnHistory == null ? new JButton() : btnHistory;
        this.btnBookmarks = btnBookmarks == null ? new JButton() : btnBookmarks;
        this.workingArea = OnlineLocator.getOnlineManager().createWorkingArea();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.setDefaultPopupMenu(this.txtLabel);
        toolsSwingManager.setDefaultPopupMenu(this.txtEnvelope);
        toolsSwingManager.addClearButton(this.txtLabel);
        toolsSwingManager.addClearButton(this.txtEnvelope, e -> {
            this.txtEnvelope.setText("");
            this.workingArea.setValue(null);
        });
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnWorkingAreaDialog, (String)"_Show_working_area_selector", (String)"picker-envelope-from-mapcontrol", e -> this.doShowWorkingAreaSelector(), null);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnWorkingAreaFromView, (String)"_Capture_the_view_area", (String)"picker-envelope-from-mapcontrol", e -> this.doSetEnvelopeFromMapControlEnvelope(), null);
        this.bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup(BOOKMARKSANDHISTORY_NAME);
        this.history = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup(BOOKMARKSANDHISTORY_NAME);
        this.bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(this.bookmarks, btnBookmarks);
        this.historyController = ToolsSwingLocator.getToolsSwingManager().createHistoryController(this.history, btnHistory);
        this.historyController.setFilter(null);
        ActionListener bookmarksAndHistoryListener = e -> {
            ActionEventWithCurrentValue event = (ActionEventWithCurrentValue)e;
            switch (event.getID()) {
                case 1002: {
                    event.setCurrentValue((Object)this.get());
                    break;
                }
                case 1001: {
                    this.set((WorkingArea)event.getCurrentValue());
                }
            }
        };
        this.historyController.addActionListener(bookmarksAndHistoryListener);
        this.bookmarksController.addActionListener(bookmarksAndHistoryListener);
    }

    private OnlineSite getSite() {
        if (this.site == null) {
            return null;
        }
        return this.site.get();
    }

    private MapControl getMapControl() {
        if (this.mapControl == null) {
            return null;
        }
        return this.mapControl.get();
    }

    private List<OnlineLayer> getLayers() {
        if (this.layers == null) {
            return null;
        }
        return this.layers.get();
    }

    protected void doSetEnvelopeFromMapControlEnvelope() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        MapControl theMapControl = this.getMapControl();
        if (!this.isEditable() || theMapControl == null) {
            return;
        }
        try {
            Envelope env = theMapControl.getViewPort().getEnvelope();
            if (env == null) {
                return;
            }
            Envelope theEnvelope = (Envelope)env.clone();
            if (StringUtils.isBlank((String)this.workingArea.getLabel())) {
                this.workingArea.setLabel(i18n.getTranslation("_Area") + " " + new Timestamp(System.currentTimeMillis()));
            }
            this.workingArea.setValue(theEnvelope);
            this.txtLabel.setText(this.workingArea.getLabel());
            if (theEnvelope != null) {
                this.txtEnvelope.setText(((Envelope)this.workingArea.getValue()).getGeometry().convertToWKTQuietly());
            }
            this.fireChangeEvent();
        }
        catch (Exception ex) {
            LOG.warn("Can't get envelope from mapcontrol.", (Throwable)ex);
        }
    }

    private void doShowWorkingAreaSelector() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        Envelope area = SelectAreaPanel.getWorkingArea(this.getSite(), this.getLayers());
        if (area != null) {
            this.workingArea.setValue(area);
            if (StringUtils.isBlank((String)this.workingArea.getLabel())) {
                this.workingArea.setLabel(i18n.getTranslation("_Area") + " " + new Timestamp(System.currentTimeMillis()));
            }
            this.txtLabel.setText(this.workingArea.getLabel());
            this.txtEnvelope.setText(((Envelope)this.workingArea.getValue()).getGeometry().convertToWKTQuietly());
            this.fireChangeEvent();
        }
    }

    public WorkingArea get() {
        this.workingArea.setLabel(StringUtils.defaultIfBlank((String)this.txtLabel.getText(), null));
        WorkingArea cloned = (WorkingArea)CloneableUtils.cloneQuietly((Cloneable)this.workingArea);
        this.history.add((Object)cloned);
        return cloned;
    }

    public WorkingArea getWithoutAddHistory() {
        if (this.workingArea == null) {
            return null;
        }
        this.workingArea.setLabel(StringUtils.defaultIfBlank((String)this.txtLabel.getText(), null));
        WorkingArea cloned = (WorkingArea)CloneableUtils.cloneQuietly((Cloneable)this.workingArea);
        return cloned;
    }

    public void set(WorkingArea workingArea) {
        this.workingArea = workingArea == null ? OnlineLocator.getOnlineManager().createWorkingArea() : (WorkingArea)CloneableUtils.cloneQuietly((Cloneable)workingArea);
        this.txtLabel.setText(this.workingArea.getLabel());
        if (this.workingArea.getValue() == null) {
            this.txtEnvelope.setText("");
        } else {
            this.txtEnvelope.setText(((Envelope)this.workingArea.getValue()).getGeometry().convertToWKTQuietly());
        }
    }

    public void coerceAndSet(Object value) {
        this.set((WorkingArea)value);
    }

    public void setEnabled(boolean enabled) {
        MapContext mapContext;
        Envelope env;
        MapControl theMapControl;
        this.txtLabel.setEditable(enabled);
        this.btnWorkingAreaDialog.setEnabled(enabled);
        this.btnWorkingAreaFromView.setEnabled(enabled);
        this.btnHistory.setEnabled(enabled);
        this.btnBookmarks.setEnabled(enabled);
        if (enabled && (theMapControl = this.mapControl.get()) != null && ((env = (mapContext = theMapControl.getMapContext()).getViewPort().getEnvelope()) == null || env.isEmpty() || env.isCollapsed())) {
            this.btnWorkingAreaFromView.setEnabled(false);
        }
    }

    public boolean isEnabled() {
        return this.btnWorkingAreaDialog.isEnabled();
    }

    public void setWorkingAreaDialogEnabled(boolean enabled) {
        this.btnWorkingAreaDialog.setEnabled(enabled);
    }
}

