/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal;

import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCCantFetchValueException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCDriverClassNotFoundException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.AbstractConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCConnectionBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCHelperBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverDumb;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.postgresql.dal.PostgreSQLBuilder;
import org.gvsig.postgresql.dal.PostgreSQLConnectionParameters;
import org.gvsig.postgresql.dal.PostgreSQLNewStoreParameters;
import org.gvsig.postgresql.dal.PostgreSQLServerExplorerParameters;
import org.gvsig.postgresql.dal.PostgreSQLStoreParameters;
import org.gvsig.postgresql.dal.operations.PostgreSQLOperationsFactory;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;

public class PostgreSQLHelper
extends JDBCHelperBase {
    public static final String POSTGRESQL_JDBC_DRIVER = "org.postgresql.Driver";
    public static final boolean USE_CONNECTIONS_POOL = true;
    private static Map<String, ConnectionProvider> connectionProviders = new HashMap<String, ConnectionProvider>();
    private ConnectionProvider connectionProvider = null;

    public static String getConnectionURL(PostgreSQLConnectionParameters params) {
        return PostgreSQLHelper.getConnectionURL(params.getHost(), params.getPort(), params.getDBName(), params.getUseSSL());
    }

    public static String getConnectionURL(String host, Integer port, String db, boolean useSSL) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Parameter 'host' can't be null.");
        }
        String connectionURL = "jdbc:postgresql://" + host;
        if (port != null) {
            connectionURL = connectionURL + ":" + port;
        }
        connectionURL = connectionURL + "/" + db;
        if (!useSSL) {
            connectionURL = connectionURL + "?sslmode=disable";
        }
        LOGGER.debug("connectionURL: {}", (Object)connectionURL);
        return connectionURL;
    }

    public PostgreSQLHelper(PostgreSQLConnectionParameters connectionParameters, ConnectionProvider connectionProvider) {
        super((JDBCConnectionParameters)connectionParameters);
        this.srssolver = new SRSSolverDumb((JDBCHelper)this);
        this.connectionProvider = connectionProvider;
    }

    public PostgreSQLHelper(JDBCConnectionParameters connectionParameters) {
        super(connectionParameters);
        this.srssolver = new SRSSolverBase((JDBCHelper)this);
    }

    protected void doDispose() throws BaseException {
        if (this.connectionProvider != null) {
            this.connectionProvider.dispose();
            this.connectionProvider = null;
        }
        super.doDispose();
    }

    private ConnectionProvider getConnectionProvider(JDBCConnectionParameters connectionParameters) {
        if (this.connectionProvider == null) {
            if (this.getConnectionParameters() == null) {
                return null;
            }
            String key = this.getConnectionProviderKey(connectionParameters);
            this.connectionProvider = connectionProviders.get(key);
            if (this.connectionProvider == null || ((PostgreSQLConnectionProvider)this.connectionProvider).isDisposed()) {
                this.connectionProvider = new PostgreSQLConnectionProvider(this.getConnectionParameters());
                connectionProviders.put(key, this.connectionProvider);
            } else {
                DisposeUtils.bind((Disposable)this.connectionProvider);
            }
        }
        return this.connectionProvider;
    }

    public synchronized JDBCConnection getConnection() throws AccessResourceException {
        try {
            PostgreSQLConnectionParameters connectionParameters = this.getConnectionParameters();
            JDBCConnection conn = (JDBCConnection)DataTransactionServices.getConnection((DataTransactionServices)this.getTransaction(), (String)this.getConnectionProviderKey(connectionParameters));
            if (conn != null) {
                return conn;
            }
            JDBCConnectionBase connection = new JDBCConnectionBase(this.getTransaction(), this.getConnectionProvider(connectionParameters).getConnection(), this.getConnectionProviderKey(connectionParameters));
            return connection;
        }
        catch (SQLException ex) {
            throw new AccessResourceException("PostgreSQL", (Throwable)ex);
        }
    }

    public PostgreSQLConnectionParameters getConnectionParameters() {
        return (PostgreSQLConnectionParameters)super.getConnectionParameters();
    }

    public String getConnectionURL() {
        return PostgreSQLHelper.getConnectionURL(this.getConnectionParameters());
    }

    protected String getResourceType() {
        return "PostgreSQL";
    }

    public String getProviderName() {
        return "PostgreSQL";
    }

    public JDBCSQLBuilderBase createSQLBuilder() {
        return new PostgreSQLBuilder((JDBCHelper)this);
    }

    public OperationsFactory getOperations() {
        if (this.operationsFactory == null) {
            this.operationsFactory = new PostgreSQLOperationsFactory((JDBCHelper)this);
        }
        return this.operationsFactory;
    }

    public GeometryExpressionBuilderHelper.GeometrySupportType getGeometrySupportType() {
        return GeometryExpressionBuilderHelper.GeometrySupportType.EWKB;
    }

    public boolean hasSpatialFunctions() {
        return true;
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubtype) {
        return true;
    }

    public String getQuoteForIdentifiers() {
        return "\"";
    }

    public boolean allowAutomaticValues() {
        return true;
    }

    public boolean supportOffsetInSelect() {
        return true;
    }

    public String getQuoteForStrings() {
        return "'";
    }

    public JDBCNewStoreParameters createNewStoreParameters() {
        return new PostgreSQLNewStoreParameters();
    }

    public JDBCStoreParameters createOpenStoreParameters() {
        return new PostgreSQLStoreParameters();
    }

    public JDBCServerExplorerParameters createServerExplorerParameters() {
        return new PostgreSQLServerExplorerParameters();
    }

    public void fetchFeature(FeatureProvider feature, ResultSet rs, FeatureAttributeDescriptor[] columns, String[] extraValueNames) throws DataException {
        try {
            Object value;
            int rsIndex = 1;
            for (FeatureAttributeDescriptor column : columns) {
                switch (column.getType()) {
                    case 66: {
                        value = this.getGeometryFromColumn(rs, rsIndex++);
                        if (value == null) break;
                        ((Geometry)value).setProjection(column.getSRS());
                        break;
                    }
                    case 12: {
                        value = rs.getBytes(rsIndex++);
                        break;
                    }
                    default: {
                        value = rs.getObject(rsIndex++);
                        if (value instanceof Blob) {
                            Blob blob = (Blob)value;
                            value = blob.getBytes(1L, (int)blob.length());
                            blob.free();
                            break;
                        }
                        if (!(value instanceof Clob)) break;
                        Clob clob = (Clob)value;
                        value = new String(IOUtils.toCharArray((Reader)clob.getCharacterStream()));
                        clob.free();
                    }
                }
                feature.set(column.getIndex(), value);
            }
            if (ArrayUtils.isNotEmpty((Object[])extraValueNames)) {
                feature.setExtraValueNames(extraValueNames);
                for (int index = 0; index < extraValueNames.length; ++index) {
                    if ((value = (Object)rs.getObject(rsIndex++)) instanceof Blob) {
                        Blob blob = (Blob)value;
                        value = blob.getBytes(0L, (int)blob.length());
                        blob.free();
                    }
                    feature.setExtraValue(index, value);
                }
            }
        }
        catch (Exception ex) {
            throw new JDBCCantFetchValueException((Throwable)ex);
        }
    }

    private static class PostgreSQLConnectionProvider
    extends AbstractConnectionProvider
    implements Disposable,
    ConnectionProvider {
        private static boolean needRegisterDriver = true;
        private BasicDataSource dataSource = null;
        private PostgreSQLConnectionParameters connectionParameters;

        public PostgreSQLConnectionProvider(PostgreSQLConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
            DisposeUtils.bind((Disposable)this);
        }

        public Connection getConnection() throws SQLException {
            Connection conn;
            if (this.dataSource == null) {
                this.dataSource = this.createDataSource();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("getConnection:\n" + this.getStatusInformation());
            }
            try {
                conn = this.dataSource.getConnection();
            }
            catch (Throwable ex) {
                LOGGER.debug("Error getting connection from pool.", ex);
                throw ex;
            }
            try {
                conn.setNetworkTimeout(null, this.connectionParameters.getNetworkTimeout());
            }
            catch (Throwable ex) {
                LOGGER.warn("Error setting the network timeout.", ex);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created connection: {}\n  NumActive: {}\n  NumIdle: {}", new Object[]{conn.hashCode(), this.dataSource.getNumActive(), this.dataSource.getNumIdle()});
            }
            LOGGER.debug("PostgreSQL JDBC Driver: 42.3.1");
            return conn;
        }

        public String getStatusInformation() {
            StringBuilder builder = new StringBuilder();
            if (this.dataSource == null) {
                builder.append("Not poolled connection:\n");
                builder.append("  Connection URL: '").append(this.connectionParameters.getUrl()).append("'\n");
            } else {
                builder.append("BasicDataSource pool status:\n");
                builder.append("  Connection URL: '").append(this.dataSource.getUrl()).append("'\n");
                if (this.dataSource.getInitialSize() > 0) {
                    builder.append("  InitialSize: ").append(this.dataSource.getInitialSize()).append(" (The initial number of connections that are created when the pool is started)\n");
                }
                if (this.dataSource.isPoolPreparedStatements()) {
                    builder.append("  PoolPreparedStatements: ").append(this.dataSource.isPoolPreparedStatements()).append("\n");
                    builder.append("  MaxOpenPreparedStatements: ").append(this.dataSource.getMaxOpenPreparedStatements()).append(" (The maximum number of open statements that can be allocated from the statement pool at the same time, or non-positive for no limit)\n");
                }
                builder.append("  MaxTotal: ").append(this.dataSource.getMaxTotal()).append(" (The maximum number of active connections that can be allocated from this pool at the same time)\n");
                builder.append("  MaxIdle: ").append(this.dataSource.getMaxIdle()).append(" (The maximum number of connections that can remain idle in the pool)\n");
                builder.append("  NumActive:").append(this.dataSource.getNumActive()).append(" (the current number of active connections)\n");
                builder.append("  NumIdle:").append(this.dataSource.getNumIdle()).append(" (the current number of idle connections)\n");
            }
            return builder.toString();
        }

        private BasicDataSource createDataSource() throws SQLException {
            if (!this.isRegistered()) {
                this.registerDriver();
            }
            PostgreSQLConnectionParameters params = this.connectionParameters;
            BasicDataSource ds = new BasicDataSource();
            ds.setMaxIdle(params.getMaxIdle());
            ds.setDriverClassName(params.getJDBCDriverClassName());
            if (params.getUseSSL()) {
                String s = BooleanUtils.toStringTrueFalse((boolean)params.getUseSSL());
                ds.addConnectionProperty("ssl", s);
            }
            if (!StringUtils.isEmpty((CharSequence)params.getUser())) {
                ds.setUsername(params.getUser());
            }
            if (!StringUtils.isEmpty((CharSequence)params.getPassword())) {
                ds.setPassword(params.getPassword());
            }
            ds.setUrl(params.getUrl());
            ds.setMinEvictableIdleTimeMillis(20000L);
            ds.setTimeBetweenEvictionRunsMillis(20000L);
            ds.setMinIdle(0);
            ds.setMaxWaitMillis(60000L);
            return ds;
        }

        private boolean isRegistered() {
            return needRegisterDriver;
        }

        public void registerDriver() throws SQLException {
            String className = this.connectionParameters.getJDBCDriverClassName();
            if (className == null) {
                return;
            }
            try {
                Class<?> theClass = Class.forName(className);
                if (theClass == null) {
                    throw new JDBCDriverClassNotFoundException("PostgreSQL", className);
                }
            }
            catch (Exception e) {
                throw new SQLException("Can't register JDBC driver '" + className + "'.", e);
            }
            needRegisterDriver = false;
        }

        public void dispose() {
            if (!DisposeUtils.release((Disposable)this)) {
                return;
            }
            if (this.dataSource != null) {
                try {
                    this.dataSource.close();
                }
                catch (SQLException ex) {
                    LOGGER.warn("Can't close BasicDataSource", (Throwable)ex);
                }
                this.dataSource = null;
            }
            this.connectionParameters = null;
        }

        public boolean isDisposed() {
            return this.dataSource == null;
        }

        public String getStatus() {
            if (this.dataSource == null) {
                return "Not polled";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Pool: ");
            builder.append(JDBCUtils.getHexId((Object)this.dataSource));
            builder.append(" Actives: ");
            builder.append(this.dataSource.getNumActive());
            builder.append("/");
            builder.append(this.dataSource.getMaxTotal());
            builder.append(" idle: ");
            builder.append(this.dataSource.getNumIdle());
            builder.append("/");
            builder.append(this.dataSource.getMinIdle());
            builder.append(":");
            builder.append(this.dataSource.getMaxIdle());
            return builder.toString();
        }
    }
}

