/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal;

import java.io.InputStream;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorerFactory;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.db.DBHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCLibrary;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCStoreProviderBase;
import org.gvsig.json.Json;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.postgresql.dal.PostgreSQLNewStoreParameters;
import org.gvsig.postgresql.dal.PostgreSQLServerExplorerFactory;
import org.gvsig.postgresql.dal.PostgreSQLServerExplorerParameters;
import org.gvsig.postgresql.dal.PostgreSQLStoreParameters;
import org.gvsig.postgresql.dal.PostgreSQLStoreProviderFactory;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLLibrary
extends AbstractLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLLibrary.class);
    public static final String NAME = "PostgreSQL";

    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(JDBCLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        LibraryException ex = null;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (Throwable th) {
            LOGGER.warn("Can't load PostgreSQL JDBC Driver.", th);
        }
        DBHelper.registerParametersDefinition((String)"PostgreSQLStoreParameters", PostgreSQLStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "PostgreSQLParameters.xml"));
        DBHelper.registerParametersDefinition((String)"PostgreSQLNewStoreParameters", PostgreSQLNewStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "PostgreSQLParameters.xml"));
        DBHelper.registerParametersDefinition((String)"PostgreSQLServerExplorerParameters", PostgreSQLServerExplorerParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "PostgreSQLParameters.xml"));
        try {
            DBHelper.registerMetadataDefinition((String)NAME, JDBCStoreProviderBase.class, (InputStream)dataman.getResourceAsStream((Object)this, "PostgreSQLMetadata.xml"));
        }
        catch (MetadataException e) {
            ex = new LibraryException(((Object)((Object)this)).getClass(), (ListBaseException)e);
        }
        if (!dataman.getStoreProviderRegister().exits(NAME)) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new PostgreSQLStoreProviderFactory());
        }
        if (!dataman.getServerExplorerRegister().exits(NAME)) {
            dataman.registerServerExplorerFactory((DataServerExplorerFactory)new PostgreSQLServerExplorerFactory());
        }
        if (!dataman.getServerExplorerRegister().exits("PostgreSQLExplorer")) {
            dataman.registerServerExplorerFactory((DataServerExplorerFactory)new PostgreSQLServerExplorerFactory("PostgreSQLExplorer"));
        }
        Json.registerSerializer(PostgreSQLServerExplorerParameters.class);
        if (ex != null) {
            throw ex;
        }
    }
}

