/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.exceptions.ConnectionErrorLayerException;
import org.gvsig.fmap.mapcontext.exceptions.DriverLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.NameLayerException;
import org.gvsig.fmap.mapcontext.exceptions.ProjectionLayerException;
import org.gvsig.fmap.mapcontext.exceptions.TypeLayerException;
import org.gvsig.fmap.mapcontext.exceptions.URLLayerException;
import org.gvsig.fmap.mapcontext.exceptions.UnsupportedVersionLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.WCSParamsPanel;
import org.gvsig.raster.wcs.app.wcsclient.layer.FLyrWCS;
import org.gvsig.raster.wcs.io.WCSServerExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSPropsDialog
extends JPanel
implements IWindow {
    private static final long serialVersionUID = 1L;
    JDialog dlg = null;
    private JPanel buttonsPanel = null;
    private FLyrRaster fLayer = null;
    boolean applied = false;
    private WindowInfo m_ViewInfo = null;
    private JButton btnApply = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private WCSParamsPanel wcsParamsTabbedPane;
    private CommandListener m_actionListener;
    private WCSServerExplorer explorer = null;
    private Logger logger = LoggerFactory.getLogger(WCSPropsDialog.class);

    public WCSPropsDialog(FLayer layer) {
        if (layer instanceof FLyrRaster) {
            this.initialize((FLyrRaster)layer);
        }
    }

    private void initialize(FLyrRaster layer) {
        this.setLayout(null);
        this.setFLayer(layer);
        this.wcsParamsTabbedPane = this.getParamsPanel(((FLyrWCS)layer).getProperties());
        this.wcsParamsTabbedPane.addWizardListener(new WizardListener(){

            public void wizardStateChanged(boolean finishable) {
                WCSPropsDialog.this.getBtnOk().setEnabled(finishable);
                WCSPropsDialog.this.getBtnApply().setEnabled(finishable);
            }

            public void error(Exception e) {
            }
        });
        this.add((Component)((Object)this.wcsParamsTabbedPane));
        this.add((Component)this.getButtonsPanel(), null);
    }

    public void setFLayer(FLyrRaster f) {
        this.fLayer = f;
    }

    public WCSParamsPanel getParamsPanel(HashMap info) {
        if (info != null) {
            block16: {
                try {
                    if (this.explorer != null) break block16;
                    this.explorer = ((FLyrWCS)this.fLayer).getExplorer();
                    try {
                        this.explorer.connect((ICancellable)new CancelTaskImpl());
                    }
                    catch (ConnectException e) {
                        RasterSwingLibrary.messageBoxError((String)"The connection cannot be established", (Object)this, (Exception)((Object)e));
                        return null;
                    }
                }
                catch (Exception e) {
                    this.explorer = null;
                    JOptionPane.showMessageDialog(null, "error_comunicacion_servidor", "Error", 0);
                }
            }
            try {
                String parameter;
                String time;
                WCSParamsPanel toc = new WCSParamsPanel();
                toc.setVisible(true);
                toc.setListenerSupport(new WizardListenerSupport());
                toc.setWizardData(this.explorer);
                toc.getLayerPanel().getLstCoverages().setListData(this.explorer.getCoverageList());
                String coverageName = (String)info.get("name");
                int index = toc.getLayerPanel().getCoverageIndex(coverageName);
                if (index != -1) {
                    toc.getLayerPanel().getLstCoverages().setSelectedIndex(index);
                }
                toc.refreshData(((FLyrWCS)this.fLayer).getParameters());
                index = toc.getFormatsPanel().getSRSIndex((String)info.get("crs"));
                if (index != -1) {
                    toc.getFormatsPanel().getLstCRSs().setSelectedIndex(index);
                }
                if ((index = toc.getFormatsPanel().getFormatIndex((String)info.get("format"))) != -1) {
                    toc.getFormatsPanel().getLstFormats().setSelectedIndex(index);
                }
                if ((time = (String)info.get("time")) != null && !time.equals("")) {
                    toc.getTimePanel().getLstSelectedTimes().setListData(time.split(","));
                }
                if ((parameter = (String)info.get("parameter")) != null && !parameter.equals("")) {
                    String[] s = parameter.split("=");
                    String pName = s[0];
                    String regexDouble = "-?[0-9]+(\\.[0-9]+)?";
                    String regexInterval = regexDouble + "/" + regexDouble;
                    String regexIntervalList = regexInterval + "(," + regexInterval + ")*";
                    if (s[1].matches(regexInterval)) {
                        toc.getParameterPanel().getJScrollPane5().setVisible(false);
                        toc.getParameterPanel().getSingleParamValuesList().setEnabled(false);
                    } else if (!s[1].matches(regexIntervalList)) {
                        toc.getParameterPanel().getJScrollPane5().setVisible(true);
                        toc.getParameterPanel().getSingleParamValuesList().setEnabled(true);
                        String[] pVals = s[1].split(",");
                        index = toc.getParameterPanel().getParamIndex(pName);
                        toc.getParameterPanel().getCmbParam().setSelectedIndex(index);
                        int[] indexes = new int[pVals.length];
                        for (int i = 0; i < pVals.length; ++i) {
                            indexes[i] = toc.getParameterPanel().getValueIndex(pVals[i]);
                        }
                        toc.getParameterPanel().getSingleParamValuesList().setSelectedIndices(indexes);
                    }
                }
                toc.refreshInfo();
                return toc;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "servidor_wcs_no_responde", "Error", 0);
                e.printStackTrace();
            }
        }
        return null;
    }

    public JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.m_actionListener = new CommandListener(this);
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setBounds(5, this.wcsParamsTabbedPane.getHeight(), 471, 40);
            this.buttonsPanel.setLayout(null);
            this.buttonsPanel.setName("buttonPanel");
            this.buttonsPanel.add((Component)this.getBtnOk(), null);
            this.buttonsPanel.add((Component)this.getBtnApply(), null);
            this.buttonsPanel.add((Component)this.getBtnCancel(), null);
        }
        return this.buttonsPanel;
    }

    public JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton("ok");
            this.btnOk.setText(PluginServices.getText((Object)this, (String)"ok"));
            this.btnOk.setActionCommand("OK");
            this.btnOk.addActionListener(this.m_actionListener);
            this.btnOk.setBounds(367, 9, 90, 25);
        }
        return this.btnOk;
    }

    public JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton("apply");
            this.btnApply.setText(PluginServices.getText((Object)this, (String)"apply"));
            this.btnApply.setEnabled(false);
            this.btnApply.setActionCommand("APPLY");
            this.btnApply.addActionListener(this.m_actionListener);
            this.btnApply.setBounds(267, 9, 90, 25);
        }
        return this.btnApply;
    }

    public JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton("cancel");
            this.btnCancel.setText(PluginServices.getText((Object)this, (String)"cancel"));
            this.btnCancel.setActionCommand("CANCEL");
            this.btnCancel.addActionListener(this.m_actionListener);
            this.btnCancel.setBounds(137, 9, 90, 25);
        }
        return this.btnCancel;
    }

    private FLayers mergeFLayers(FLayers group1, FLayers group2) {
        for (int i = 0; i < group2.getLayersCount(); ++i) {
            FLayer layer = group2.getLayer(i);
            if (group1.getLayer(layer.getName()) != null) continue;
            group1.addLayer(layer);
        }
        return group1;
    }

    public WindowInfo getWindowInfo() {
        if (this.m_ViewInfo == null) {
            this.m_ViewInfo = new WindowInfo(8);
            this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"fit_WCS_layer"));
            this.m_ViewInfo.setWidth(this.wcsParamsTabbedPane.getWidth() + 10);
            this.m_ViewInfo.setHeight(this.wcsParamsTabbedPane.getHeight() + 40);
        }
        return this.m_ViewInfo;
    }

    public void close() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class CommandListener
    implements ActionListener {
        public CommandListener(WCSPropsDialog tp) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "CANCEL") {
                WCSPropsDialog.this.close();
            } else {
                ((FLyrWCS)WCSPropsDialog.this.fLayer).getParameters().setFormat(WCSPropsDialog.this.wcsParamsTabbedPane.getFormat());
                try {
                    ((FLyrWCS)WCSPropsDialog.this.fLayer).getParameters().setSRS(WCSPropsDialog.this.wcsParamsTabbedPane.getSRS());
                    ((FLyrWCS)WCSPropsDialog.this.fLayer).getParameters().setCoverageName(WCSPropsDialog.this.wcsParamsTabbedPane.getLayerPanel().getSelectedCoverageName());
                    FLayers parent = WCSPropsDialog.this.fLayer.getParentLayer();
                    MapControl mapCtrl = null;
                    IWindow[] w = PluginServices.getMDIManager().getAllWindows();
                    for (int i = 0; i < w.length; ++i) {
                        MapContext mapContext;
                        if (!(w[i] instanceof AbstractViewPanel) || (mapContext = ((AbstractViewPanel)w[i]).getMapControl().getMapContext()) != WCSPropsDialog.this.fLayer.getMapContext()) continue;
                        mapCtrl = ((AbstractViewPanel)w[i]).getMapControl();
                    }
                    if (parent != null) {
                        FLayer layer = WCSPropsDialog.this.wcsParamsTabbedPane.getLayer();
                        if (layer == null) {
                            return;
                        }
                        mapCtrl.getMapContext().getLayers().replaceLayer(WCSPropsDialog.this.fLayer.getName(), layer);
                    } else {
                        mapCtrl.getMapContext().getLayers().replaceLayer(WCSPropsDialog.this.fLayer.getName(), WCSPropsDialog.this.wcsParamsTabbedPane.getLayer());
                    }
                    mapCtrl.getMapContext().invalidate();
                    WCSPropsDialog.this.applied = true;
                    WCSPropsDialog.this.getBtnApply().setEnabled(!WCSPropsDialog.this.applied);
                    if (e.getActionCommand() == "OK") {
                        WCSPropsDialog.this.close();
                    }
                }
                catch (ConnectionErrorLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (DriverLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (LegendLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (NameLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (ProjectionLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (TypeLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (UnsupportedVersionLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (URLLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (LoadLayerException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (InitializeException e1) {
                    WCSPropsDialog.this.logger.info("", (Throwable)e1);
                }
            }
        }
    }
}

