/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.raster.wcs.io.WCSLayerNode;
import org.gvsig.raster.wcs.io.WCSServerExplorer;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor3 = "\"#FBFFE1\"";
    private final String service_title = PluginServices.getText((Object)this, (String)"service_info");
    private final String server = PluginServices.getText((Object)this, (String)"server");
    private final String server_type = PluginServices.getText((Object)this, (String)"server_type");
    private final String server_abstract = PluginServices.getText((Object)this, (String)"server_abstract");
    private final String server_title = PluginServices.getText((Object)this, (String)"server_title");
    private final String layers_title = PluginServices.getText((Object)this, (String)"selected_layers");
    private final String layer_title = PluginServices.getText((Object)this, (String)"layer_title");
    private final String layer_abstract = PluginServices.getText((Object)this, (String)"layer_abstract");
    private final String selected_parameters = PluginServices.getText((Object)this, (String)"selected_parameters");
    private final String time_title = PluginServices.getText((Object)this, (String)"time");
    private final String format_title = PluginServices.getText((Object)this, (String)"format");
    private final String srs_title = "CRS";
    private final String properties = PluginServices.getText((Object)this, (String)"properties");
    private final String layer_name = PluginServices.getText((Object)this, (String)"name");
    private JEditorPane editor = null;

    public InfoPanel() {
        this.setLayout(new BorderLayout());
        JScrollPane src = new JScrollPane();
        src.setViewportView(this.getEditor());
        this.add((Component)src, "Center");
    }

    private JEditorPane getEditor() {
        if (this.editor == null) {
            this.editor = new JEditorPane();
            this.editor.setEditable(false);
        }
        return this.editor;
    }

    public void refresh(WCSServerExplorer dataSource, WCSLayerNode layer, String time, String format, String crs, String parameters) {
        String server_text = dataSource.getHost();
        String server_type_text = dataSource.getServerType();
        String server_title_text = dataSource.getTitle();
        String server_abstract_text = dataSource.getAbstract();
        String font = "Arial";
        if (server_text == null) {
            server_text = "-";
        }
        if (server_type_text == null) {
            server_type_text = "-";
        }
        if (server_title_text == null) {
            server_title_text = "-";
        }
        if (server_abstract_text == null) {
            server_abstract_text = "-";
        }
        if (format == null) {
            format = PluginServices.getText((Object)this, (String)"none_selected");
        }
        if (crs == null) {
            crs = PluginServices.getText((Object)this, (String)"none_selected");
        }
        String layers_html = "";
        if (layer != null) {
            String layer_name_text = layer.getName();
            String time_text = time == null ? PluginServices.getText((Object)this, (String)"not_available") : time;
            String layer_abstract_text = layer.getDescription();
            String layer_title_text = layer.getTitle();
            if (layer_name_text == null) {
                layer_name_text = "-";
            }
            if (time_text == null) {
                time_text = "-";
            }
            if (layer_abstract_text == null) {
                layer_abstract_text = "-";
            }
            if (layer_title_text == null) {
                layer_title_text = "-";
            }
            String layer_html = "  <tr valign=\"top\">     <td bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"Arial\" size=\"3\" align=\"right\"><b>" + this.layer_name + "</b></font></td>" + "     <td bgcolor=" + "\"#FEEDD6\"" + "><font face=\"Arial\" size=\"3\">" + layer_name_text + "</font></td>" + "  </tr>" + "  <tr valign=\"top\">" + "     <td width=\"119\" height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"Arial\" size=\"3\"><b>" + this.layer_title + "</b></font></td>" + "     <td width=\"322\" height=\"18\" bgcolor=" + "\"#EAEAEA\"" + "><font face=\"Arial\" size=\"3\">" + layer_title_text + "</font></td>" + "  </tr>" + "  <tr valign=\"top\">" + "     <td bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"Arial\" size=\"3\" align=\"right\"><b>" + this.layer_abstract + "</b></font></td>" + "     <td bgcolor=" + "\"#FEEDD6\"" + "><font face=\"Arial\" size=\"3\">" + layer_abstract_text + "</font></td>" + "  </tr>" + "  <tr valign=\"top\">" + "     <td bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"Arial\" size=\"3\" align=\"right\"><b>" + this.time_title + "</b></font></td>" + "     <td bgcolor=" + "\"#EAEAEA\"" + "><font face=\"Arial\" size=\"3\">" + time_text + "</font></td>" + "  </tr>" + "  <tr>" + "  </tr>";
            layers_html = layers_html + layer_html;
        }
        if (!layers_html.equals("")) {
            layers_html = "  <tr valign=\"top\" bgcolor=\"#FFFFFF\">    <td width=\"92\" height=\"18\" bgcolor=\"#FBFFE1\" colspan=\"2\"><font face=\"" + font + "\" size=\"4\"><b>" + this.layers_title + "</font></b></td>" + "  </tr>" + layers_html;
        }
        String parameter_html = "";
        if (parameters != null) {
            boolean swap = false;
            String[] myParameters = parameters.split("&");
            for (int i = 0; i < myParameters.length; ++i) {
                String color = swap ? "\"#FEEDD6\"" : "\"#EAEAEA\"";
                String[] parameter = myParameters[i].split("=");
                parameter_html = parameter_html + "  <tr valign=\"top\" bgcolor=" + color + ">" + "    <td width=\"120\" height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><b>" + parameter[0] + "</b></td>" + "    <td width=\"322\" height=\"18\">" + parameter[1] + "</td>" + "  </tr>";
                swap = !swap;
            }
            parameter_html = parameter_html + "  <tr>  </tr>";
        }
        if (!parameter_html.equals("")) {
            parameter_html = "  <tr valign=\"top\">    <td width=\"92\" height=\"18\" bgcolor=\"#FBFFE1\" colspan=\"2\"><font face=\"" + font + "\" size=\"4\"><b>" + this.selected_parameters + "</font></b></td>" + "  </tr>" + parameter_html;
        }
        String format_html = "  <tr valign=\"top\" bgcolor=\"#FFFFFF\">    <td width=\"92\" height=\"18\" bgcolor=\"#FBFFE1\" colspan=\"2\"><font face=\"" + font + "\" size=\"4\"><b>" + this.properties + "</font></b></td>" + "  </tr>" + "  <tr valign=\"top\" bgcolor=" + "\"#FEEDD6\"" + ">" + "    <td height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\"><b>" + this.format_title + "</b></font></td>" + "    <td><font face=\"" + font + "\" size=\"3\"><font face=\"" + font + "\" size=\"3\">" + format + "</font></td>" + "  </tr>" + "  <tr valign=\"top\" bgcolor=" + "\"#EAEAEA\"" + ">" + "    <td height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\"><b>" + "CRS" + "</font></b></td>" + "    <td><font face=\"" + font + "\" size=\"3\">" + crs + "</font></td>" + "  </tr>";
        String html = "<html><body><table align=\"center\" width=\"437\" height=\"156\" border=\"0\" cellpadding=\"4\" cellspacing=\"4\">  <tr valign=\"top\" bgcolor=\"#FFFFFF\">    <td width=\"92\" height=\"18\" bgcolor=\"#FBFFE1\" colspan=\"2\"><font face=\"" + font + "\" size=\"4\"><b>" + this.service_title + "</font></b></td>" + "  </tr>" + "  <tr valign=\"top\" bgcolor=" + "\"#FEEDD6\"" + ">" + "    <td width=\"92\" height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\"><b>" + this.server + "</font></b></td>" + "    <td width=\"268\"><font face=\"" + font + "\" size=\"3\">" + server_text + "</font></td>" + "  </tr>" + "  <tr valign=\"top\" bgcolor=" + "\"#EAEAEA\"" + ">" + "    <td height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\"><b>" + this.server_type + "</b></font></td>" + "    <td><font face=\"" + font + "\" size=\"3\">" + server_type_text + "</font></td>" + "  </tr>" + "  <tr valign=\"top\" bgcolor=" + "\"#FEEDD6\"" + ">" + "    <td height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\"><b>" + this.server_title + "</b></font></td>" + "    <td><font face=\"" + font + "\" size=\"3\"><font face=\"" + font + "\" size=\"3\">" + server_title_text + "</font></td>" + "  </tr>" + "  <tr valign=\"top\" bgcolor=" + "\"#EAEAEA\"" + ">" + "    <td height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\"><b>" + this.server_abstract + "</font></b></td>" + "    <td><font face=\"" + font + "\" size=\"3\">" + server_abstract_text + "</font></td>" + "  </tr>" + "  <tr>" + "  </tr>" + layers_html + parameter_html + format_html + "</table>" + "</body>" + "</html>";
        this.getEditor().setContentType("text/html");
        this.getEditor().setText(html);
    }
}

