/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.panel;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.raster.wcs.io.WCSLayerNode;

public class LayerTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public boolean showLayerNames = false;

    public LayerTree() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        this.setCellRenderer(new MyRenderer());
    }

    public static String format(String message, int lineLength) {
        if (message.length() <= lineLength) {
            return message;
        }
        String[] lines = message.split("\n");
        String theMessage = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.length() < lineLength) {
                theMessage = theMessage + line + "\n";
                continue;
            }
            String[] chunks = line.split(" ");
            String newLine = "";
            for (int j = 0; j < chunks.length; ++j) {
                int currentLength = newLine.length();
                chunks[j] = chunks[j].trim();
                if (chunks[j].length() == 0) continue;
                if (currentLength + chunks[j].length() + " ".length() <= lineLength) {
                    newLine = newLine + chunks[j] + " ";
                    continue;
                }
                newLine = newLine + "\n" + chunks[j] + " ";
                theMessage = theMessage + newLine;
                newLine = "";
            }
        }
        return theMessage;
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent((JComponent)this);
        return tip;
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof WCSLayerNode) {
                String myAbstract;
                WCSLayerNode layer = (WCSLayerNode)value;
                String myLatLonTxt = layer.getLatLonBox();
                if (myLatLonTxt == null) {
                    myLatLonTxt = "-";
                }
                myAbstract = (myAbstract = layer.getAbstract()) == null ? "-" : LayerTree.format(myAbstract.trim(), 100);
                String text = PluginServices.getText((Object)this, (String)"abstract") + ":\n" + myAbstract + "\n\n" + PluginServices.getText((Object)this, (String)"covered_extension") + ":\n" + myLatLonTxt;
                this.setToolTipText(text);
                if (!(LayerTree.this.showLayerNames || layer.getName() == null && layer.getName() != "")) {
                    text = layer.toString();
                    text = text.substring(text.indexOf(93) + 2, text.length());
                    this.setText(text);
                }
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

