/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.controls.dnd.JDnDList;
import org.gvsig.gui.beans.controls.dnd.JDnDListModel;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.WCSParamsPanel;
import org.gvsig.raster.wcs.io.FMapWCSParameter;

public class ParameterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbParam = null;
    private JDnDList lstParamValues = null;
    private JScrollPane jScrollPane5 = null;
    private WCSParamsPanel parent = null;

    public ParameterPanel() {
        this.init();
    }

    public void setWCSParamsPanel(WCSParamsPanel parent) {
        this.parent = parent;
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"seleccionar_parametros"), 0, 0, null, null));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridx = 0;
        this.add((Component)this.getCmbParam(), gridBagConstraints1);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridx = 1;
        this.add((Component)this.getJScrollPane5(), gridBagConstraints1);
    }

    public JComboBox getCmbParam() {
        if (this.cmbParam == null) {
            this.cmbParam = new JComboBox();
            this.cmbParam.setEditable(false);
            this.cmbParam.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FMapWCSParameter p = (FMapWCSParameter)ParameterPanel.this.cmbParam.getSelectedItem();
                    if (p != null) {
                        ParameterPanel.this.getSingleParamValuesList().setListData(p.getValueList().toArray());
                    }
                    ParameterPanel.this.parent.fireWizardComplete(ParameterPanel.this.parent.isCorrectlyConfigured());
                }
            });
        }
        return this.cmbParam;
    }

    public JScrollPane getJScrollPane5() {
        if (this.jScrollPane5 == null) {
            this.jScrollPane5 = new JScrollPane();
            this.jScrollPane5.setViewportView((Component)this.getSingleParamValuesList());
        }
        return this.jScrollPane5;
    }

    public JDnDList getSingleParamValuesList() {
        if (this.lstParamValues == null) {
            this.lstParamValues = new JDnDList();
            this.lstParamValues.setModel((ListModel)new JDnDListModel());
            this.lstParamValues.setSelectionMode(2);
            this.lstParamValues.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ParameterPanel.this.parent.fireWizardComplete(ParameterPanel.this.parent.isCorrectlyConfigured());
                }
            });
        }
        return this.lstParamValues;
    }

    public int getParamIndex(String nParam) {
        for (int i = 0; i < this.getCmbParam().getModel().getSize(); ++i) {
            if (!nParam.equals(((FMapWCSParameter)this.getCmbParam().getItemAt(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    public int getValueIndex(String valor) {
        for (int i = 0; i < this.getSingleParamValuesList().getModel().getSize(); ++i) {
            if (!valor.equals(this.getSingleParamValuesList().getModel().getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String getParameterString() {
        FMapWCSParameter p = (FMapWCSParameter)this.getCmbParam().getSelectedItem();
        if (p == null) {
            return null;
        }
        if (p.getType() == 0) {
            Object[] v = this.getSingleParamValuesList().getSelectedValues();
            if (p != null && v.length > 0) {
                String s = p.getName() + "=" + (String)v[0];
                for (int i = 1; i < v.length; ++i) {
                    s = s + "," + v[i];
                }
                return s;
            }
        }
        return null;
    }
}

