/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.panel;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.FormatPanel;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.InfoPanel;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.LayerPanel;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.ParameterPanel;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.TimePanel;
import org.gvsig.raster.wcs.app.wcsclient.layer.FLyrWCS;
import org.gvsig.raster.wcs.io.FMapWCSParameter;
import org.gvsig.raster.wcs.io.WCSDataParameters;
import org.gvsig.raster.wcs.io.WCSLayerNode;
import org.gvsig.raster.wcs.io.WCSServerExplorer;

public class WCSParamsPanel
extends WizardPanel {
    private static final long serialVersionUID = 1L;
    public static Preferences fPrefs = Preferences.userRoot().node("gvsig.wcs-wizard");
    protected WCSServerExplorer explorer = null;
    private LayerPanel layerPanel = null;
    private InfoPanel infoPanel = null;
    private FormatPanel formatsPanel = null;
    private TimePanel timesPanel = null;
    private ParameterPanel parameterPanel = null;
    private int indTime;
    private int indParameter;
    private WizardListenerSupport listenerSupport;
    private JTabbedPane jTabbedPane = null;
    private boolean lastCached = false;

    public WCSParamsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setVisible(false);
        this.setBounds(0, 0, 510, 427);
        this.add(this.getJTabbedPane(), null);
    }

    public void fireWizardComplete(boolean b) {
        this.listenerSupport.callStateChanged(b);
        this.callStateChanged(b);
    }

    public FLayer getLayer() throws InitializeException {
        return this.getLayer(this.lastCached);
    }

    public FLayer getLayer(boolean cached) throws InitializeException {
        URI hostURI;
        WCSDataParameters par;
        this.lastCached = cached;
        FLyrWCS layer = new FLyrWCS();
        WCSDataParameters parameters = par = (WCSDataParameters)this.explorer.getStoredParameters();
        if (cached) {
            DataManager manager = DALLocator.getDataManager();
            TileDataParameters tileParams = null;
            try {
                tileParams = (TileDataParameters)manager.createStoreParameters("Tile Store");
            }
            catch (ProviderNotRegisteredException e) {
                throw new InitializeException(e.getMessage(), (Throwable)e);
            }
            tileParams.setDataParameters((DataParameters)par);
            parameters = tileParams;
        }
        String host = this.explorer.getHost();
        try {
            hostURI = new URI(host);
        }
        catch (URISyntaxException e1) {
            throw new InitializeException((Throwable)e1);
        }
        par.setURI(hostURI);
        par.setSRS(this.getSRS());
        par.setFormat(this.getFormat());
        par.setCoverageName(this.getLayerPanel().getSelectedCoverageName());
        par.setExtent(this.getExtent());
        par.setTime(this.getTimePanel().getTime());
        par.setParameter(this.getParameterPanel().getParameterString());
        String cName = this.getLayerPanel().getSelectedCoverageName();
        WCSLayerNode lNode = this.explorer.getCoverageByName(cName);
        par.setMaxResolution(lNode.getMaxRes());
        par.setOnlineResources(this.explorer.getOnlineResources());
        try {
            layer.setParameters((DataStoreParameters)parameters);
            layer.setExplorer(this.explorer);
            layer.setFullExtent(this.getExtent());
            layer.setName(this.getLayerName());
        }
        catch (InitializeException e) {
            String msg = this.getDriverExceptionMessage(e);
            if (msg != null && !msg.equals("")) {
                JOptionPane.showMessageDialog((Component)((Object)this), msg, Messages.getText((String)"Error"), 0);
                return null;
            }
            throw e;
        }
        return layer;
    }

    private String getDriverExceptionMessage(InitializeException e) {
        Throwable ex = e;
        int MAX_DEEP = 10;
        for (int deep = 0; deep < 10; ++deep) {
            Throwable t = null;
            if (ex instanceof RasterDriverException) {
                return ex.getMessage();
            }
            if (ex instanceof InitializeException) {
                t = ex.getCause();
            } else if (ex instanceof InvocationTargetException) {
                t = ((InvocationTargetException)ex).getTargetException();
            }
            if (t == null) {
                return null;
            }
            ex = t;
        }
        return null;
    }

    public void refreshData(WCSDataParameters par) {
        String coverageName = this.getLayerPanel().getSelectedInListCoverageName();
        if (coverageName == null && par != null) {
            coverageName = par.getCoverageName();
        }
        this.cleanupWizard();
        if (coverageName != null) {
            int i;
            WCSLayerNode lyr = this.explorer.getCoverageByName(coverageName);
            this.getLayerPanel().getTxtName().setText(lyr.getTitle());
            this.getFormatsPanel().getLstCRSs().clearSelection();
            this.getFormatsPanel().getLstCRSs().setListData(lyr.getSRSs().toArray());
            this.getFormatsPanel().getLstFormats().clearSelection();
            this.getFormatsPanel().getLstFormats().setListData(lyr.getFormats().toArray());
            boolean b = lyr.getInterpolationMethods() != null;
            this.getFormatsPanel().getCmbInterpolationMethods().removeAllItems();
            if (b) {
                ArrayList im = lyr.getInterpolationMethods();
                for (i = 0; i < im.size(); ++i) {
                    this.getFormatsPanel().getCmbInterpolationMethods().addItem(im.get(i));
                }
            }
            this.getFormatsPanel().getChkUseInterpolationMethod().setEnabled(b);
            this.getFormatsPanel().getCmbInterpolationMethods().setEnabled(b);
            this.getTimePanel().getLstTimes().removeAll();
            ArrayList list = lyr.getTimePositions();
            boolean bl = b = list != null && !list.isEmpty();
            if (b) {
                this.getTimePanel().getLstTimes().setListData(list.toArray());
            }
            this.jTabbedPane.setEnabledAt(this.indTime, b);
            this.getParameterPanel().getCmbParam().removeAllItems();
            list = lyr.getParameterList();
            boolean bl2 = b = list != null && !list.isEmpty();
            if (b) {
                for (i = 0; i < list.size(); ++i) {
                    this.getParameterPanel().getCmbParam().addItem(list.get(i));
                }
                this.getParameterPanel().getSingleParamValuesList().setListData(((FMapWCSParameter)this.getParameterPanel().getCmbParam().getSelectedItem()).getValueList().toArray());
            }
            this.jTabbedPane.setEnabledAt(this.indParameter, b);
            this.fireWizardComplete(this.isCorrectlyConfigured());
        }
    }

    public void cleanupWizard() {
        Object[] nada = new Object[]{};
        this.getFormatsPanel().getLstCRSs().clearSelection();
        this.getFormatsPanel().getLstCRSs().setListData(nada);
        this.getFormatsPanel().getLstFormats().clearSelection();
        this.getFormatsPanel().getLstFormats().setListData(nada);
        this.getTimePanel().getLstTimes().clearSelection();
        this.getTimePanel().getLstTimes().setListData(nada);
        this.getTimePanel().getLstSelectedTimes().clearSelection();
        this.getTimePanel().getLstSelectedTimes().setListData(nada);
        this.getParameterPanel().getCmbParam().removeAllItems();
        this.getParameterPanel().getSingleParamValuesList().setVisible(true);
        this.getParameterPanel().getSingleParamValuesList().clearSelection();
        this.getParameterPanel().getSingleParamValuesList().setListData(nada);
    }

    public void refreshInfo() {
        FMapWCSParameter p = (FMapWCSParameter)this.getParameterPanel().getCmbParam().getSelectedItem();
        String pString = p != null && this.getParameterPanel().getParameterString() != null ? p.toString() + "=" + this.getParameterPanel().getParameterString().split("=")[1] : null;
        this.infoPanel.refresh(this.explorer, (WCSLayerNode)this.getLayerPanel().getLstCoverages().getSelectedValue(), this.getTimePanel().getTime(), this.getFormat(), this.getSRS(), pString);
    }

    public void setListenerSupport(WizardListenerSupport support) {
        this.listenerSupport = support;
    }

    public void setWizardData(WCSServerExplorer data) {
        this.explorer = data;
        this.getLayerPanel().getLstCoverages().setListData(data.getCoverageList());
        this.refreshInfo();
    }

    public JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setBounds(4, 4, 502, 415);
            InfoPanel ip = this.getInfoPanel();
            ip.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    WCSParamsPanel.this.refreshInfo();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"info"), null, ip, null);
            LayerPanel lp = this.getLayerPanel();
            lp.setWCSParamsPanel(this);
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"coverage"), null, lp, null);
            FormatPanel fp = this.getFormatsPanel();
            fp.setWCSParamsPanel(this);
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"format"), null, fp, null);
            TimePanel tp = this.getTimePanel();
            tp.setWCSParamsPanel(this);
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"time"), null, tp, null);
            this.indTime = this.jTabbedPane.getTabCount() - 1;
            this.jTabbedPane.setEnabledAt(this.indTime, false);
            ParameterPanel pp = this.getParameterPanel();
            pp.setWCSParamsPanel(this);
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"parameters"), null, pp, null);
            this.indParameter = this.jTabbedPane.getTabCount() - 1;
            this.jTabbedPane.setEnabledAt(this.indParameter, false);
        }
        return this.jTabbedPane;
    }

    public InfoPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new InfoPanel();
        }
        return this.infoPanel;
    }

    public TimePanel getTimePanel() {
        if (this.timesPanel == null) {
            this.timesPanel = new TimePanel();
        }
        return this.timesPanel;
    }

    public FormatPanel getFormatsPanel() {
        if (this.formatsPanel == null) {
            this.formatsPanel = new FormatPanel();
        }
        return this.formatsPanel;
    }

    public ParameterPanel getParameterPanel() {
        if (this.parameterPanel == null) {
            this.parameterPanel = new ParameterPanel();
        }
        return this.parameterPanel;
    }

    public LayerPanel getLayerPanel() {
        if (this.layerPanel == null) {
            this.layerPanel = new LayerPanel();
        }
        return this.layerPanel;
    }

    public void avanzaTab() {
        int currentPage = this.currentPage();
        int nPages = this.getNumTabs();
        if (nPages - 1 > currentPage) {
            this.getJTabbedPane().setSelectedIndex(this.nextEnabledPage());
        }
    }

    public void retrocedeTab() {
        this.getJTabbedPane().setSelectedIndex(this.previousEnabledPage());
    }

    public int currentPage() {
        return this.getJTabbedPane().getSelectedIndex();
    }

    public int getNumTabs() {
        return this.getJTabbedPane().getTabCount();
    }

    public int previousEnabledPage() {
        int currentPage = this.currentPage();
        int j = 0;
        if (currentPage == 0) {
            j = -1;
        }
        for (int i = currentPage - 1; i > -1; --i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            j = i;
            break;
        }
        return j;
    }

    public int nextEnabledPage() {
        int nPages;
        int currentPage = this.currentPage();
        if (currentPage == (nPages = this.getNumTabs())) {
            return -1;
        }
        for (int i = currentPage + 1; i < nPages; ++i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            return i;
        }
        return -1;
    }

    public void initWizard() {
    }

    public void execute() {
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }

    public WCSServerExplorer getExplorer() {
        return this.explorer;
    }

    public Rectangle2D getExtent() {
        String cName = this.getLayerPanel().getSelectedCoverageName();
        if (cName != null) {
            return this.explorer.getCoverageByName(cName).getExtent(this.getSRS());
        }
        return null;
    }

    public String getLayerName() {
        return this.getLayerPanel().getTxtName().getText();
    }

    public String getSRS() {
        return (String)this.getFormatsPanel().getLstCRSs().getSelectedValue();
    }

    public String getFormat() {
        return (String)this.getFormatsPanel().getLstFormats().getSelectedValue();
    }

    public boolean isCorrectlyConfigured() {
        if (this.getLayerPanel().getSelectedCoverageName() == null) {
            return false;
        }
        if (this.getTimePanel().timeRequired() && this.getTimePanel().getTime() == null) {
            return false;
        }
        if (this.getSRS() == null) {
            return false;
        }
        return this.getFormat() != null;
    }
}

