/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.datalocator;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.datalocator.gui.DataSelectionPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;

public class DataLocatorExtension
extends Extension {
    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-locator-by-attribute", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        IWindow wi;
        if ("view-navigation-locator-by-attribute".equalsIgnoreCase(actionCommand) && (wi = ApplicationLocator.getManager().getActiveWindow()) instanceof IView) {
            MapContext mapContext = ((IView)wi).getMapControl().getMapContext();
            DataSelectionPanel selpan = new DataSelectionPanel(mapContext);
            ApplicationLocator.getManager().getUIManager().addWindow((IWindow)selpan);
        }
    }

    public boolean isEnabled() {
        IWindow wi = PluginServices.getMDIManager().getActiveWindow();
        if (!(wi instanceof IView)) {
            return false;
        }
        MapContext mapContext = ((IView)wi).getMapControl().getMapContext();
        List<FLyrVect> vects = DataLocatorExtension.getVectorLayers(mapContext.getLayers());
        return vects.size() > 0;
    }

    public boolean isVisible() {
        IWindow wi = PluginServices.getMDIManager().getActiveWindow();
        return wi instanceof IView;
    }

    public static List<FLyrVect> getVectorLayers(FLayers layers) {
        ArrayList<FLyrVect> resp = new ArrayList<FLyrVect>();
        int len = layers.getLayersCount();
        for (int i = 0; i < len; ++i) {
            if (layers.getLayer(i) instanceof FLyrVect) {
                resp.add((FLyrVect)layers.getLayer(i));
                continue;
            }
            if (!(layers.getLayer(i) instanceof FLayers)) continue;
            List<FLyrVect> added = DataLocatorExtension.getVectorLayers((FLayers)layers.getLayer(i));
            resp.addAll(added);
        }
        return resp;
    }
}

