/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.datalocator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.datalocator.DataLocatorExtension;
import org.gvsig.datalocator.gui.FieldsComboItem;
import org.gvsig.datalocator.gui.LayersComboItem;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.strategies.SelectedZoomVisitor;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSelectionPanel
extends JPanel
implements IWindow,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DataSelectionPanel.class);
    private JComboBox layerComboBox = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JComboBox fieldValueComboBox = null;
    private JLabel jLabel2 = null;
    private JComboBox fieldNameComboBox = null;
    private WindowInfo viewInfo = null;
    private JButton goButton = null;
    private JButton closeButton = null;
    private FLayer layerToZoom = null;
    private int fieldToZoomIndex = 0;
    private Object itemToZoom = null;
    private MapContext mapCtxt = null;
    private JPanel jPanelButtons = null;

    public DataSelectionPanel(MapContext mapContext) {
        this.mapCtxt = mapContext;
        this.initialize();
    }

    private void initialize() {
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.setSize(275, 90);
        this.jLabel.setText(PluginServices.getText((Object)this, (String)"Capa") + ":");
        this.jLabel1.setText(PluginServices.getText((Object)this, (String)"Campo") + ":");
        this.jLabel2.setText(PluginServices.getText((Object)this, (String)"Valor") + ":");
        GridBagLayout gbl = new GridBagLayout();
        JPanel centerPanelGrid = new JPanel(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 21;
        c.insets = new Insets(3, 3, 3, 3);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        centerPanelGrid.add((Component)this.jLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        centerPanelGrid.add((Component)this.jLabel1, c);
        c.gridx = 0;
        c.gridy = 2;
        centerPanelGrid.add((Component)this.jLabel2, c);
        c.anchor = 10;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        centerPanelGrid.add((Component)this.getLayersComboBox(), c);
        c.gridx = 1;
        c.gridy = 1;
        centerPanelGrid.add((Component)this.getFieldsComboBox(), c);
        c.gridx = 1;
        c.gridy = 2;
        centerPanelGrid.add((Component)this.getValuesComboBox(), c);
        this.add((Component)centerPanelGrid, "Center");
        this.jPanelButtons = new JPanel();
        FlowLayout flowLayor = new FlowLayout(2);
        this.jPanelButtons.setLayout(flowLayor);
        this.jPanelButtons.add((Component)this.getGoButton(), null);
        this.jPanelButtons.add((Component)this.getCloseButton(), null);
        this.add((Component)this.jPanelButtons, "South");
    }

    private FeatureAttributeDescriptor[] getFields(FLyrVect vect) {
        try {
            FeatureStore featureStore = vect.getFeatureStore();
            FeatureType fty = featureStore.getDefaultFeatureType();
            FeatureAttributeDescriptor[] atts = fty.getAttributeDescriptors();
            return atts;
        }
        catch (DataException e) {
            logger.error("While getting field names.", (Throwable)e);
            return new FeatureAttributeDescriptor[0];
        }
    }

    private Object[] getNewValues(FLyrVect vlayer, String fname) {
        if (vlayer == null || fname == null) {
            return new Object[0];
        }
        FeatureSet set = null;
        try {
            FeatureStore featureStore = vlayer.getFeatureStore();
            FeatureQuery query = featureStore.createFeatureQuery();
            ValueEvaluator myEvaluator = new ValueEvaluator(fname);
            query.setFilter((Evaluator)myEvaluator);
            query.setAttributeNames(new String[]{fname});
            set = featureStore.getFeatureSet(query);
            TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Number && o2 instanceof Number) {
                        if (((Number)o1).doubleValue() < ((Number)o2).doubleValue()) {
                            return -1;
                        }
                        if (((Number)o1).doubleValue() > ((Number)o2).doubleValue()) {
                            return 1;
                        }
                    } else {
                        if (o1 instanceof String && o2 instanceof String) {
                            Collator collator = Collator.getInstance();
                            collator.setStrength(0);
                            return collator.compare((String)o1, (String)o2);
                        }
                        if (o1 instanceof Date && o2 instanceof Date) {
                            return ((Date)o1).compareTo((Date)o2);
                        }
                    }
                    return 0;
                }
            });
            DisposableIterator diter = set.fastIterator();
            Feature feat = null;
            while (diter.hasNext()) {
                feat = (Feature)diter.next();
                treeSet.add(feat.get(fname));
            }
            diter.dispose();
            return treeSet.toArray();
        }
        catch (DataException e) {
            logger.error("While getting sample values.", (Throwable)e);
            return new Object[0];
        }
    }

    public WindowInfo getWindowInfo() {
        if (this.viewInfo == null) {
            this.viewInfo = new WindowInfo(8);
            this.viewInfo.setTitle(PluginServices.getText((Object)this, (String)"Localizador_por_atributo"));
            this.viewInfo.setHeight(this.getHeight());
            this.viewInfo.setWidth(this.getWidth());
        }
        return this.viewInfo;
    }

    private JComboBox getLayersComboBox() {
        if (this.layerComboBox == null) {
            this.layerComboBox = new JComboBox();
            List<FLyrVect> vs = DataLocatorExtension.getVectorLayers(this.mapCtxt.getLayers());
            LayersComboItem[] items = new LayersComboItem[vs.size()];
            for (int i = 0; i < vs.size(); ++i) {
                items[i] = new LayersComboItem(vs.get(i));
            }
            DefaultComboBoxModel<LayersComboItem> defaultModel = new DefaultComboBoxModel<LayersComboItem>(items);
            this.layerComboBox.setModel(defaultModel);
            this.layerComboBox.addActionListener(this);
            if (items.length > 0) {
                this.layerComboBox.setSelectedIndex(0);
            }
        }
        return this.layerComboBox;
    }

    private JComboBox getFieldsComboBox() {
        if (this.fieldNameComboBox == null) {
            this.fieldNameComboBox = new JComboBox();
            this.fieldNameComboBox.addActionListener(this);
            this.fieldNameComboBox.setEnabled(false);
        }
        return this.fieldNameComboBox;
    }

    private JComboBox getValuesComboBox() {
        if (this.fieldValueComboBox == null) {
            this.fieldValueComboBox = new JComboBox();
            this.fieldValueComboBox.addActionListener(this);
            this.fieldValueComboBox.setEnabled(false);
        }
        return this.fieldValueComboBox;
    }

    private JButton getGoButton() {
        if (this.goButton == null) {
            this.goButton = new JButton();
            this.goButton.setPreferredSize(new Dimension(80, 23));
            this.goButton.setText(PluginServices.getText((Object)this, (String)"_Go"));
            this.goButton.addActionListener(this);
        }
        return this.goButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setPreferredSize(new Dimension(80, 23));
            this.closeButton.setText(PluginServices.getText((Object)this, (String)"_Close"));
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.getLayersComboBox()) {
            FeatureAttributeDescriptor[] atts;
            LayersComboItem litem = (LayersComboItem)this.getLayersComboBox().getSelectedItem();
            if (litem != null && (atts = this.getFields(litem.getLayer())).length > 0) {
                this.getFieldsComboBox().setEnabled(true);
                this.getFieldsComboBox().removeAllItems();
                for (int i = 0; i < atts.length; ++i) {
                    if (atts[i].getType() == 66) continue;
                    this.getFieldsComboBox().addItem(new FieldsComboItem(atts[i]));
                }
                this.getFieldsComboBox().setSelectedIndex(0);
                return;
            }
            this.getFieldsComboBox().setEnabled(false);
            this.getValuesComboBox().setEnabled(false);
            return;
        }
        if (src == this.getFieldsComboBox()) {
            Object[] vals;
            LayersComboItem litem = (LayersComboItem)this.getLayersComboBox().getSelectedItem();
            FieldsComboItem fatt = (FieldsComboItem)this.getFieldsComboBox().getSelectedItem();
            if (litem != null && fatt != null && (vals = this.getNewValues(litem.getLayer(), fatt.toString())).length > 0) {
                this.getValuesComboBox().setEnabled(true);
                this.getValuesComboBox().removeAllItems();
                DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(vals);
                this.getValuesComboBox().setModel(model);
                this.getValuesComboBox().setSelectedIndex(0);
                this.getGoButton().setEnabled(true);
                return;
            }
            this.getValuesComboBox().setEnabled(false);
            this.getGoButton().setEnabled(false);
            return;
        }
        if (src == this.getValuesComboBox()) {
            return;
        }
        if (src == this.getCloseButton()) {
            ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            return;
        }
        if (src == this.getGoButton()) {
            LayersComboItem litem = (LayersComboItem)this.getLayersComboBox().getSelectedItem();
            FieldsComboItem fatt = (FieldsComboItem)this.getFieldsComboBox().getSelectedItem();
            Object value = this.getValuesComboBox().getSelectedItem();
            if (litem == null || fatt == null || value == null) {
                return;
            }
            FLyrVect lyr = litem.getLayer();
            FeatureSet featureSet = null;
            Object diter = null;
            try {
                FeatureStore featureStore = lyr.getFeatureStore();
                FeatureQuery query = featureStore.createFeatureQuery();
                ValueEvaluator myEvaluator = new ValueEvaluator(fatt.toString(), value, fatt.getType());
                query.setFilter((Evaluator)myEvaluator);
                String geoname = featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
                query.setAttributeNames(new String[]{fatt.toString(), geoname});
                featureSet = featureStore.getFeatureSet(query);
                SelectedZoomVisitor visitor = new SelectedZoomVisitor();
                featureSet.accept((Visitor)visitor);
                Envelope env_data = visitor.getSelectBound();
                if (env_data != null) {
                    if (lyr.getCoordTrans() != null) {
                        env_data = env_data.convert(lyr.getCoordTrans());
                    }
                    this.mapCtxt.getViewPort().setEnvelope(env_data);
                }
            }
            catch (Exception exc) {
                logger.error("While zooming to value", (Throwable)exc);
            }
            return;
        }
    }

    class ValueEvaluator
    implements Evaluator {
        private String fieldName = null;
        private Object value = null;
        private EvaluatorFieldsInfo info = null;
        private boolean nonnull = true;
        private DataType dataType = null;

        public ValueEvaluator(String name) {
            this.fieldName = name;
            this.info = new EvaluatorFieldsInfo();
            this.info.addFieldValue(name);
            this.nonnull = true;
        }

        public ValueEvaluator(String name, Object val, DataType dtype) {
            this.fieldName = name;
            this.info = new EvaluatorFieldsInfo();
            this.info.addFieldValue(name);
            this.value = val;
            this.nonnull = false;
            this.dataType = dtype;
        }

        public Object evaluate(EvaluatorData data) throws EvaluatorException {
            Object obj = data.getDataValue(this.fieldName);
            if (this.nonnull) {
                if (obj == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return this.value == null && obj == null || this.value != null && obj != null && this.value.equals(obj);
        }

        public String getSQL() {
            String resp = null;
            if (this.nonnull) {
                resp = this.fieldName + " is not null";
            } else if (this.value == null) {
                resp = this.fieldName + " is null";
            } else {
                String quote = this.dataType.isNumeric() ? "" : "'";
                resp = this.fieldName + " = " + quote + this.value.toString() + quote;
            }
            return resp;
        }

        public String getDescription() {
            return "Evaluates if a field is not null";
        }

        public EvaluatorFieldsInfo getFieldsInfo() {
            return this.info;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }
}

