/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.swing.impl.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.raster.wmts.ogc.struct.WMTSStyle;
import org.gvsig.raster.wmts.swing.impl.wizard.WMTSParamsPanel;

class StyleTreeModel
implements TreeModel {
    private String root = null;
    private ArrayList<WMTSParamsPanel.LayerUI> layers = new ArrayList();

    public StyleTreeModel(String root) {
        this.root = root;
    }

    public WMTSParamsPanel.LayerUI getLayer(String layerName) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (this.layers.get((int)i).theme.getLayer().getTitle().compareTo(layerName) != 0) continue;
            return this.layers.get(i);
        }
        return null;
    }

    public boolean isSelected(WMTSStyle style) {
        for (int i = 0; i < this.layers.size(); ++i) {
            WMTSParamsPanel.LayerUI layerUI = this.layers.get(i);
            if (layerUI.styleSelected != style) continue;
            return true;
        }
        return false;
    }

    public Vector<String> getStyleSelectionTitles() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.layers.size(); ++i) {
            WMTSParamsPanel.LayerUI layer = this.layers.get(i);
            WMTSStyle sty = layer.styleSelected;
            if (sty == null) {
                v.add("");
                continue;
            }
            v.add(sty.getIdentifier());
        }
        return v;
    }

    public void setStylesSelection(Vector styleNames) {
        for (int i = 0; i < this.layers.size(); ++i) {
            WMTSParamsPanel.LayerUI layer = this.layers.get(i);
            for (int j = 0; j < layer.theme.getLayer().getStyle().size(); ++j) {
                WMTSStyle sty = (WMTSStyle)layer.theme.getLayer().getStyle().get(j);
                if (sty.getIdentifier().compareTo((String)styleNames.get(i)) != 0) continue;
                layer.styleSelected = sty;
            }
        }
    }

    public boolean addLayerBranch(WMTSParamsPanel.LayerUI node) {
        this.layers.add(node);
        for (int i = 0; i < this.layers.size(); ++i) {
            List sty;
            if (this.layers.get((int)i).styleSelected != null || (sty = this.layers.get((int)i).theme.getLayer().getStyle()) == null || sty.size() <= 0 || sty.get(0) == null) continue;
            this.layers.get((int)i).styleSelected = (WMTSStyle)sty.get(0);
        }
        return node.theme.getLayer().getStyle() != null && node.theme.getLayer().getStyle().size() != 0;
    }

    protected void setSelectedLeaf(TreePath selectionPath) {
        Object[] objects;
        Object item;
        if (selectionPath != null && this.isLeaf(item = (objects = selectionPath.getPath())[objects.length - 1])) {
            WMTSParamsPanel.LayerUI layer = (WMTSParamsPanel.LayerUI)objects[objects.length - 2];
            WMTSStyle style = (WMTSStyle)item;
            for (int j = 0; j < layer.theme.getLayer().getStyle().size(); ++j) {
                WMTSStyle sty = (WMTSStyle)layer.theme.getLayer().getStyle().get(j);
                if (!sty.getIdentifier().equals(style.getIdentifier())) continue;
                layer.styleSelected = sty;
            }
        }
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof WMTSParamsPanel.LayerUI) {
            return ((WMTSParamsPanel.LayerUI)parent).theme.getLayer().getStyle().size();
        }
        if (parent instanceof WMTSStyle) {
            return 0;
        }
        return this.layers.size();
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof WMTSStyle;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof WMTSStyle) {
            return null;
        }
        if (parent instanceof WMTSParamsPanel.LayerUI) {
            return ((WMTSParamsPanel.LayerUI)parent).theme.getLayer().getStyle().get(index);
        }
        return this.layers.get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof WMTSParamsPanel.LayerUI && child instanceof WMTSStyle) {
            List listStyle = ((WMTSParamsPanel.LayerUI)parent).theme.getLayer().getStyle();
            for (int i = 0; i < listStyle.size(); ++i) {
                WMTSStyle sty = (WMTSStyle)listStyle.get(i);
                if (!sty.equals(child)) continue;
                return i;
            }
        }
        if (child instanceof WMTSParamsPanel.LayerUI) {
            for (int i = 0; i < this.layers.size(); ++i) {
                WMTSParamsPanel.LayerUI layerUI = this.layers.get(i);
                if (!layerUI.equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Object getRoot() {
        return this.root;
    }
}

