/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.swing.impl.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.controls.dnd.JDnDListModel;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSServerExplorer;
import org.gvsig.raster.wmts.ogc.struct.WMTSStyle;
import org.gvsig.raster.wmts.ogc.struct.WMTSTheme;
import org.gvsig.raster.wmts.swing.WMTSWizardListener;
import org.gvsig.raster.wmts.swing.WmtsGUI;
import org.gvsig.raster.wmts.swing.impl.panel.dimension.DimensionPanel;
import org.gvsig.raster.wmts.swing.impl.panel.format.IFormatsPanel;
import org.gvsig.raster.wmts.swing.impl.panel.layer.ILayerPanel;
import org.gvsig.raster.wmts.swing.impl.panel.layer.LayerList;
import org.gvsig.raster.wmts.swing.impl.panel.layer.LayerTree;
import org.gvsig.raster.wmts.swing.impl.wizard.InfoPanel;
import org.gvsig.raster.wmts.swing.impl.wizard.LayerTreeModel;
import org.gvsig.raster.wmts.swing.impl.wizard.StyleTree;
import org.gvsig.raster.wmts.swing.impl.wizard.StyleTreeModel;
import org.gvsig.raster.wmts.swing.impl.wizard.StylesPanel;
import org.gvsig.raster.wmts.swing.impl.wizard.WMTSParametersListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSParamsPanel
extends WmtsGUI
implements ActionListener,
ItemListener,
KeyListener,
ListSelectionListener,
MouseListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private InfoPanel tabInfo = null;
    private ILayerPanel layerPanel = null;
    private StylesPanel tabStyle = null;
    private IFormatsPanel formatsPanel = null;
    private DimensionPanel dimensionPanel = null;
    private ArrayList<TreePath> selectedPaths = new ArrayList();
    private WMTSWizardListener listenerSupport = null;
    private JTabbedPane jTabbedPane = null;
    protected WMTSServerExplorer explorer = null;
    public static Preferences fPrefs = Preferences.userRoot().node("gvsig.wmts-wizard");
    private boolean deleteCache = false;
    private HashMap<Object, Integer> tabsIndexes = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(WMTSParamsPanel.class);
    private Supplier<MapContext> mapContext;

    public JComponent getComponent() {
        return this;
    }

    public WMTSParamsPanel() {
        this(null);
    }

    public WMTSParamsPanel(Supplier<MapContext> mapContext) {
        this.mapContext = mapContext;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.add(this.getJTabbedPane(), "Center");
    }

    public JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setBounds(4, 4, 502, 415);
            InfoPanel ip = this.getTabInfo();
            ip.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    WMTSParamsPanel.this.refreshInfoPanel();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            this.jTabbedPane.addTab(Messages.getText((String)"info"), null, ip, null);
            this.jTabbedPane.addTab(Messages.getText((String)"capas"), null, this.getLayerPanel(), null);
            this.jTabbedPane.addTab(Messages.getText((String)"estilos"), null, (Component)((Object)this.getTabStyle()), null);
            this.jTabbedPane.addTab(Messages.getText((String)"dimensions"), null, this.getJPanelDimension(), null);
            this.jTabbedPane.addTab(Messages.getText((String)"formatos"), null, this.getJPanelFormatsAndSrs(), null);
            this.tabsIndexes.clear();
            this.tabsIndexes.put(ip, 0);
            this.tabsIndexes.put(this.getLayerPanel(), 1);
            this.tabsIndexes.put((Object)this.getTabStyle(), 2);
            this.tabsIndexes.put(this.getJPanelDimension(), 3);
            this.tabsIndexes.put(this.getJPanelFormatsAndSrs(), 4);
            this.jTabbedPane.setEnabledAt(2, false);
            this.jTabbedPane.setEnabledAt(3, false);
            this.jTabbedPane.setEnabledAt(4, false);
        }
        return this.jTabbedPane;
    }

    private InfoPanel getTabInfo() {
        if (this.tabInfo == null) {
            this.tabInfo = new InfoPanel();
        }
        return this.tabInfo;
    }

    private ILayerPanel getLayerPanel() {
        if (this.layerPanel == null) {
            this.layerPanel = new ILayerPanel();
            this.layerPanel.getLstSelectedLayers().addMouseListener(this);
            this.layerPanel.getLstSelectedLayers().addListSelectionListener(this);
            this.layerPanel.getChkExtendedNames().addItemListener(this);
            this.layerPanel.getBtnAdd().addActionListener(this);
            this.layerPanel.getBtnDel().addActionListener(this);
            this.layerPanel.getBtnDown().addActionListener(this);
            this.layerPanel.getBtnUp().addActionListener(this);
            this.layerPanel.getChkExtendedNames().addActionListener(this);
            this.layerPanel.getTreeLayers().addMouseListener(this);
            this.layerPanel.getTreeLayers().addTreeSelectionListener(this);
            this.layerPanel.getLayerListViewSelection().addActionListener(this);
            this.layerPanel.getThemesViewSelection().addActionListener(this);
        }
        return this.layerPanel;
    }

    private StylesPanel getTabStyle() {
        if (this.tabStyle == null) {
            this.tabStyle = new StylesPanel();
            this.tabStyle.setEnabled(false);
            this.tabStyle.addListener(value -> this.fireWizardComplete());
            this.tabStyle.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    WMTSParamsPanel.this.refreshStyleTree();
                }
            });
        }
        return this.tabStyle;
    }

    private IFormatsPanel getJPanelFormatsAndSrs() {
        if (this.formatsPanel == null) {
            this.formatsPanel = new IFormatsPanel(this.mapContext);
            this.formatsPanel.getLstImageFormats().addListSelectionListener(this);
            this.formatsPanel.getLstInfoFormats().addListSelectionListener(this);
            this.formatsPanel.getLstSRSs().addListSelectionListener(this);
            this.formatsPanel.getChkTransparency().addItemListener(this);
        }
        return this.formatsPanel;
    }

    private DimensionPanel getJPanelDimension() {
        if (this.dimensionPanel == null) {
            this.dimensionPanel = new DimensionPanel();
        }
        return this.dimensionPanel;
    }

    private void fireWizardComplete() {
        this.listenerSupport.correctlyConfiguredEvent(this.isCorrectlyConfigured());
    }

    public void setListenerSupport(WMTSWizardListener support) {
        this.listenerSupport = support;
    }

    public int getSRSIndex(String crs) {
        String crsitem;
        int i;
        if (crs == null) {
            return -1;
        }
        crs = crs.toUpperCase();
        ListModel model = this.getLstSRSs().getModel();
        for (i = 0; i < model.getSize(); ++i) {
            crsitem = model.getElementAt(i).toString().toUpperCase();
            if (!crs.equalsIgnoreCase(crsitem)) continue;
            return i;
        }
        for (i = 0; i < model.getSize(); ++i) {
            crsitem = model.getElementAt(i).toString().toUpperCase();
            if (crs.startsWith("EPSG:") && crsitem.startsWith("URN:OGC:DEF:CRS:EPSG:")) {
                crsitem = "EPSG:" + crsitem.substring(crsitem.lastIndexOf(":") + 1);
            }
            if (!crs.equalsIgnoreCase(crsitem)) continue;
            return i;
        }
        return -1;
    }

    public int getImageFormatIndex(String format) {
        for (int i = 0; i < this.getImageFormats().getModel().getSize(); ++i) {
            if (format == null || format.compareTo(this.getImageFormats().getModel().getElementAt(i).toString()) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getInfoFormatIndex(String format) {
        for (int i = 0; i < this.getInfoFormats().getModel().getSize(); ++i) {
            if (format == null || format.compareTo(this.getInfoFormats().getModel().getElementAt(i).toString()) != 0) continue;
            return i;
        }
        return -1;
    }

    public void updateSelectedInfo(HashMap<String, Object> info) {
        String infoFormat;
        String imageFormat;
        this.setVisible(true);
        String selectedLayer = (String)info.get("selectedLayer");
        this.setSelectedLayer(selectedLayer);
        String srs = (String)info.get("srs");
        int index = this.getSRSIndex(srs);
        if (index != -1) {
            this.getLstSRSs().setSelectedIndex(index);
        }
        if ((index = this.getImageFormatIndex(imageFormat = (String)info.get("imageformat"))) != -1) {
            this.getImageFormats().setSelectedIndex(index);
        }
        if ((index = this.getInfoFormatIndex(infoFormat = (String)info.get("infoformat"))) != -1) {
            this.getInfoFormats().setSelectedIndex(index);
        }
        this.refreshInfoPanel();
    }

    private void setSelectedLayer(String name) {
        LayerTreeModel treeModel = (LayerTreeModel)this.getLayerPanel().getTreeLayers().getModel();
        WMTSTheme theme = (WMTSTheme)treeModel.getNodeByName(name);
        JDnDListModel modelo = (JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel();
        modelo.addElement(0, (Object)new LayerUI(theme));
        this.getLayerPanel().getLstSelectedLayers().setSelectedIndex(0);
        this.refreshSelectedLayerData();
    }

    public LayerTree getLayerStructure() {
        return this.layerPanel.getTreeLayers();
    }

    public Vector getStyleTitles() {
        return this.getTabStyle().getStyleTree().getStyleSelectionTitles();
    }

    public Vector getSelectedLayersVector() {
        JDnDListModel mod = (JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel();
        Vector<Object> lyrs = new Vector<Object>();
        for (int i = 0; i < mod.getSize(); ++i) {
            lyrs.add(mod.getElementAt(i));
        }
        return lyrs;
    }

    public StyleTree getStyleTree() {
        return this.getTabStyle().getStyleTree();
    }

    public LayerUI[] selectedLayersToArray() {
        JDnDListModel modelo = (JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel();
        ArrayList elements = modelo.getElements();
        LayerUI[] layers = elements.toArray(new LayerUI[0]);
        return layers;
    }

    public JList getLstSRSs() {
        return this.getJPanelFormatsAndSrs().getLstSRSs();
    }

    public JList getImageFormats() {
        return this.getJPanelFormatsAndSrs().getLstImageFormats();
    }

    public JList getInfoFormats() {
        return this.getJPanelFormatsAndSrs().getLstInfoFormats();
    }

    public boolean isCorrectlyConfigured() {
        this.repaint();
        Object[] values = this.getLayerPanel().getLstSelectedLayers().getSelectedValues();
        this.getLayerPanel().getBtnDel().setEnabled(values != null && values.length > 0);
        return ArrayUtils.isNotEmpty((Object[])values);
    }

    public void addLayer() {
        boolean alguno = false;
        TreePath[] selecciones = this.getLayerPanel().getTreeLayers().getSelectionPaths();
        if (selecciones == null) {
            return;
        }
        try {
            LayerUI[] infos = this.selectedLayersToArray();
            JDnDListModel modelo = (JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel();
            modelo.delIndices(new int[infos.length]);
            this.layerPanel.getLstSelectedLayers().clearSelection();
            this.selectedPaths.clear();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.warn("Can't clear the selection of layers", (Throwable)ex);
        }
        for (int i = 0; i < selecciones.length && i < 1; ++i) {
            if (!(selecciones[i].getLastPathComponent() instanceof WMTSTheme)) continue;
            this.selectedPaths.add(selecciones[i]);
            WMTSTheme nodo = (WMTSTheme)selecciones[i].getLastPathComponent();
            if (nodo.getTitle() == null || nodo.getTitle().equals("")) continue;
            JDnDListModel modelo = (JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel();
            if (this.getLayerPanel().getThemesViewSelection().isSelected() && nodo.getLayerRef().isEmpty()) {
                JOptionPane.showOptionDialog((Component)((Object)this), Messages.getText((String)"theme_without_reference"), Messages.getText((String)"confirmacion"), 0, 1, null, new Object[]{Messages.getText((String)"accept")}, Messages.getText((String)"accept"));
                return;
            }
            if (modelo.addElement(0, (Object)new LayerUI(nodo))) {
                alguno = true;
            }
            this.getLayerPanel().getLstSelectedLayers().setSelectedIndex(0);
        }
        if (alguno) {
            this.refreshSelectedLayerData();
        }
        this.refreshInfoPanel();
        this.fireWizardComplete();
        this.listenerSupport.addLayerEvent();
    }

    private void delLayer() {
        int[] indices = this.getLayerPanel().getLstSelectedLayers().getSelectedIndices();
        ArrayList<LayerUI> removeList = new ArrayList<LayerUI>();
        LayerUI[] infos = this.selectedLayersToArray();
        JDnDListModel modelo = (JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel();
        for (int i = 0; i < indices.length; ++i) {
            removeList.add(infos[indices[i]]);
        }
        modelo.delIndices(indices);
        this.layerPanel.getLstSelectedLayers().clearSelection();
        for (int i = removeList.size() - 1; i >= 0; --i) {
            WMTSTheme elemento = ((LayerUI)removeList.get((int)i)).theme;
            for (int j = 0; j < this.selectedPaths.size(); ++j) {
                TreePath path = this.selectedPaths.get(j);
                WMTSTheme last = (WMTSTheme)path.getLastPathComponent();
                if (last.getTitle().compareTo(elemento.getTitle()) != 0) continue;
                this.selectedPaths.remove(path);
            }
        }
        this.refreshSelectedLayerData();
        this.refreshInfoPanel();
        this.fireWizardComplete();
        this.listenerSupport.removeLayerEvent();
    }

    public void refreshSelectedLayerData() {
        this.refreshSRS();
        this.refreshImageFormats();
        this.refreshInfoFormats();
        this.getLayerPanel().getLstSelectedLayers().repaint();
        this.refreshStyleTree();
        this.refreshDimension();
    }

    public void refreshInfoPanel() {
        this.getTabInfo().refresh(this.explorer, this.getSelectedLayersVector(), this.getStyleTitles(), this.getSelectedImageFormat(), this.getSelectedSRS());
    }

    private void refreshStyleTree() {
        int s;
        StyleTreeModel model = new StyleTreeModel(Messages.getText((String)"selected_layers"));
        int tabIndex = this.tabsIndexes.get((Object)this.getTabStyle());
        this.jTabbedPane.setEnabledAt(tabIndex, false);
        Object[] selectedValues = this.getLayerPanel().getLstSelectedLayers().getSelectedValues();
        if (selectedValues != null && selectedValues.length == 1 && (s = this.getJPanelFormatsAndSrs().getLstSRSs().getSelectedIndex()) != -1) {
            ((LayerUI)selectedValues[0]).srsFormatSelected = s;
        }
        ListModel listModel = this.getLayerPanel().getLstSelectedLayers().getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            LayerUI layerUI = (LayerUI)listModel.getElementAt(i);
            if (!model.addLayerBranch(layerUI)) continue;
            this.jTabbedPane.setEnabledAt(tabIndex, true);
        }
        this.getStyleTree().setModel(model);
        this.getStyleTree().expandAll();
        this.getStyleTree().repaint();
    }

    private void refreshImageFormats() {
        Object[] selectedValues = this.getLayerPanel().getLstSelectedLayers().getSelectedValues();
        int tabIndex = this.tabsIndexes.get(this.getJPanelFormatsAndSrs());
        this.jTabbedPane.setEnabledAt(tabIndex, false);
        if ((selectedValues == null || selectedValues.length == 0) && this.getImageFormats().getModel() != null && this.getImageFormats().getModel() instanceof WMTSParametersListModel) {
            ((WMTSParametersListModel)this.getImageFormats().getModel()).removeAllItems();
        }
        if (selectedValues != null && selectedValues.length >= 1) {
            List formats = ((LayerUI)selectedValues[0]).theme.getLayer().getFormat();
            WMTSParametersListModel model = new WMTSParametersListModel(formats);
            this.getImageFormats().setModel(model);
            this.getImageFormats().setSelectedIndex(((LayerUI)selectedValues[0]).imageFormatSelected);
            this.jTabbedPane.setEnabledAt(tabIndex, true);
        }
    }

    private void refreshInfoFormats() {
        Object[] selectedValues = this.getLayerPanel().getLstSelectedLayers().getSelectedValues();
        if ((selectedValues == null || selectedValues.length == 0) && this.getInfoFormats().getModel() != null && this.getInfoFormats().getModel() instanceof WMTSParametersListModel) {
            ((WMTSParametersListModel)this.getInfoFormats().getModel()).removeAllItems();
        }
        if (selectedValues != null && selectedValues.length == 1) {
            List formats = ((LayerUI)selectedValues[0]).theme.getLayer().getInfoFormat();
            WMTSParametersListModel model = new WMTSParametersListModel(formats);
            this.getInfoFormats().setModel(model);
            this.getInfoFormats().setSelectedIndex(((LayerUI)selectedValues[0]).infoFormatSelected);
        }
    }

    private void refreshSRS() {
        Object[] selectedValues = this.getLayerPanel().getLstSelectedLayers().getSelectedValues();
        if ((selectedValues == null || selectedValues.length == 0) && this.getLstSRSs().getModel() != null && this.getLstSRSs().getModel() instanceof WMTSParametersListModel) {
            ((WMTSParametersListModel)this.getLstSRSs().getModel()).removeAllItems();
        }
        if (selectedValues != null && selectedValues.length == 1) {
            List formats = ((LayerUI)selectedValues[0]).theme.getLayer().getSrsList();
            WMTSParametersListModel model = new WMTSParametersListModel(formats);
            this.getLstSRSs().setModel(model);
            this.getLstSRSs().setSelectedIndex(((LayerUI)selectedValues[0]).srsFormatSelected);
        }
    }

    private void refreshDimension() {
        Object[] selectedValues = this.getLayerPanel().getLstSelectedLayers().getSelectedValues();
        int tabIndex = this.tabsIndexes.get(this.getJPanelDimension());
        this.jTabbedPane.setEnabledAt(tabIndex, false);
        if (selectedValues != null && selectedValues.length >= 1) {
            List dimensions = ((LayerUI)selectedValues[0]).theme.getLayer().getDimensions();
            if (CollectionUtils.isEmpty((Collection)dimensions)) {
                return;
            }
            this.jTabbedPane.setEnabledAt(tabIndex, true);
            this.getJPanelDimension().setDimensions(dimensions);
        }
    }

    public void setWizardData(WMTSServerExplorer data) {
        this.explorer = data;
        ((JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel()).clear();
        this.layerPanel.getLstSelectedLayers().repaint();
        this.getLayerPanel().getTreeLayers().setModel(new LayerTreeModel(this.explorer.getOGCClient().getLayerListAsThemes()));
        this.refreshInfoPanel();
    }

    public String getLayersQuery() {
        ArrayList elements = ((JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel()).getElements();
        LayerUI[] layers = elements.toArray(new LayerUI[0]);
        String layersQuery = layers[layers.length - 1].theme.getTitle();
        for (int i = layers.length - 2; i >= 0; --i) {
            layersQuery = layersQuery + "," + layers[i].theme.getTitle();
        }
        return layersQuery;
    }

    public void setNextTab() {
        int currentPage = this.currentPage();
        int nPages = this.getNumTabs();
        if (nPages - 1 > currentPage) {
            this.getJTabbedPane().setSelectedIndex(this.nextEnabledPage());
        }
    }

    public void setPreviousTab() {
        this.getJTabbedPane().setSelectedIndex(this.previousEnabledPage());
    }

    public int currentPage() {
        return this.getJTabbedPane().getSelectedIndex();
    }

    public int getNumTabs() {
        return this.getJTabbedPane().getTabCount();
    }

    public int previousEnabledPage() {
        int currentPage = this.currentPage();
        int j = 0;
        if (currentPage == 0) {
            j = -1;
        }
        for (int i = currentPage - 1; i > -1; --i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            j = i;
            break;
        }
        return j;
    }

    public int nextEnabledPage() {
        int nPages;
        int currentPage = this.currentPage();
        if (currentPage == (nPages = this.getNumTabs())) {
            return -1;
        }
        for (int i = currentPage + 1; i < nPages; ++i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            return i;
        }
        return -1;
    }

    public void setTransparent(boolean b) {
        this.getJPanelFormatsAndSrs().getChkTransparency().setSelected(b);
    }

    public RasterDataParameters[] getDataParameters() {
        ListModel model = this.getLayerPanel().getLstSelectedLayers().getModel();
        RasterDataParameters[] paramList = new RasterDataParameters[model.getSize()];
        for (int i = 0; i < model.getSize(); ++i) {
            DataParameters p;
            WMTSTheme theme = ((LayerUI)model.getElementAt((int)i)).theme;
            DataStoreParameters parameters = this.explorer.getStoredParameters();
            WMTSDataParameters par = null;
            if (parameters instanceof WMTSDataParameters) {
                par = (WMTSDataParameters)parameters;
            }
            if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMTSDataParameters) {
                par = (WMTSDataParameters)p;
            }
            String host = this.explorer.getHost();
            try {
                par.setURI(new URI(host));
            }
            catch (URISyntaxException e) {
                logger.warn("Can't create URI from " + host, (Throwable)e);
            }
            par.setImageFormat(this.getSelectedImageFormat());
            par.setInfoFormat(this.getSelectedInfoFormat());
            par.setSRS(this.getSelectedSRS());
            par.setLayer(theme.getLayer());
            par.setDimension(this.getSelectedDimension());
            par.setDimensionSelectedValue(this.getSelectedValueForDimension());
            WMTSStyle style = this.getSelectedStyle(theme.getLayer().getTitle());
            if (style != null) {
                par.setStyle(style);
            }
            paramList[i] = (RasterDataParameters)parameters;
        }
        return paramList;
    }

    private String getSelectedValueForDimension() {
        return this.getJPanelDimension().getSelectedValuePanel().getSelectedValue().getText();
    }

    private String getSelectedDimension() {
        return this.getJPanelDimension().getDimensionPanel().getSelectedDimension();
    }

    public String getSelectedSRS() {
        return (String)this.getJPanelFormatsAndSrs().getLstSRSs().getSelectedValue();
    }

    private String getSelectedImageFormat() {
        return (String)this.getJPanelFormatsAndSrs().getLstImageFormats().getSelectedValue();
    }

    private String getSelectedInfoFormat() {
        return (String)this.getJPanelFormatsAndSrs().getLstInfoFormats().getSelectedValue();
    }

    private WMTSStyle getSelectedStyle(String layerName) {
        return this.getStyleTree().getSelectedStyle(layerName);
    }

    public void initWizard() {
    }

    public void execute() {
    }

    protected boolean nodeSelected(TreePath[] selection, WMTSTheme node) {
        for (TreePath selection1 : selection) {
            Object[] components;
            for (Object component : components = selection1.getPath()) {
                if (!(component instanceof WMTSTheme) || ((WMTSTheme)component).getTitle().compareTo(node.getTitle()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<TreePath> getSelectedPaths() {
        return this.selectedPaths;
    }

    public LayerTree getJustTreeLayer() {
        return this.getLayerPanel().getTreeLayers();
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }

    public WMTSServerExplorer getExplorer() {
        return this.explorer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDnDListModel m;
        int index;
        int[] selectedIndices;
        LayerList list;
        if (e.getSource() == this.getLayerPanel().getBtnDown()) {
            list = this.getLayerPanel().getLstSelectedLayers();
            selectedIndices = list.getSelectedIndices();
            index = list.getSelectedIndex();
            if (selectedIndices != null && selectedIndices.length == 1 && index < this.getLayerPanel().getLstSelectedLayers().getModel().getSize() - 1) {
                m = (JDnDListModel)list.getModel();
                m.itemsMoved(index + 1, new int[]{index});
                list.setSelectedIndex(index + 1);
            }
        }
        if (e.getSource() == this.getLayerPanel().getBtnUp()) {
            list = this.getLayerPanel().getLstSelectedLayers();
            selectedIndices = list.getSelectedIndices();
            index = list.getSelectedIndex();
            if (selectedIndices != null && selectedIndices.length == 1 && index > 0) {
                m = (JDnDListModel)list.getModel();
                m.itemsMoved(index - 1, new int[]{index});
                list.setSelectedIndex(index - 1);
            }
        }
        if (e.getSource() == this.getLayerPanel().getBtnAdd()) {
            this.addLayer();
        }
        if (e.getSource() == this.getLayerPanel().getBtnDel()) {
            this.delLayer();
        }
        if (e.getSource() == this.getLayerPanel().getChkExtendedNames()) {
            fPrefs.putBoolean("show_layer_names", this.getLayerPanel().getChkExtendedNames().isSelected());
        }
        if (e.getSource() == this.getLayerPanel().getLayerListViewSelection()) {
            ((JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel()).clear();
            this.layerPanel.getLstSelectedLayers().repaint();
            this.getLayerPanel().getTreeLayers().setModel(new LayerTreeModel(this.explorer.getOGCClient().getLayerListAsThemes()));
            this.refreshInfoPanel();
        }
        if (e.getSource() == this.getLayerPanel().getThemesViewSelection()) {
            if (this.explorer.getOGCClient().getThemes().hasThemes()) {
                ((JDnDListModel)this.getLayerPanel().getLstSelectedLayers().getModel()).clear();
                this.layerPanel.getLstSelectedLayers().repaint();
                this.getLayerPanel().getTreeLayers().setModel(new LayerTreeModel(this.explorer.getOGCClient().getThemes()));
                this.refreshInfoPanel();
            } else {
                this.getLayerPanel().getLayerListViewSelection().setSelected(true);
                JOptionPane.showOptionDialog((Component)((Object)this), Messages.getText((String)"view_not_disposable"), Messages.getText((String)"confirmacion"), 0, 1, null, new Object[]{Messages.getText((String)"accept")}, Messages.getText((String)"accept"));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getLayerPanel().getChkExtendedNames()) {
            boolean b;
            this.getLayerPanel().getTreeLayers().showLayerNames = b = this.getLayerPanel().getChkExtendedNames().isSelected();
            this.getLayerPanel().getTreeLayers().repaint();
            this.getLayerPanel().getLstSelectedLayers().showLayerNames = b;
            this.getLayerPanel().getLstSelectedLayers().repaint();
            this.getStyleTree().showLayerNames = b;
        }
        if (e.getSource() == this.getJPanelFormatsAndSrs().getChkTransparency()) {
            this.fireWizardComplete();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fireWizardComplete();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.getLayerPanel().getTreeLayers() && e.getClickCount() == 2) {
            this.addLayer();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.getLayerPanel().getLstSelectedLayers()) {
            this.refreshSelectedLayerData();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() == this.getLayerPanel().getTreeLayers()) {
            boolean isGetMapable = false;
            TreePath[] selecciones = this.getLayerPanel().getTreeLayers().getSelectionPaths();
            if (selecciones != null) {
                for (int i = 0; i < selecciones.length && !isGetMapable; ++i) {
                    if (!(selecciones[i].getLastPathComponent() instanceof WMTSTheme)) continue;
                    WMTSTheme layer = (WMTSTheme)selecciones[i].getLastPathComponent();
                    isGetMapable = layer.getChildCount() == 0 || layer.getTitle() != null;
                }
            }
            this.getLayerPanel().getBtnAdd().setEnabled(isGetMapable);
            this.fireWizardComplete();
        }
    }

    public void setDeleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
    }

    public boolean getDeleteCache() {
        return this.deleteCache;
    }

    public void addChangeTabListener(MouseAdapter eventMouse) {
        this.getJTabbedPane().addMouseListener(eventMouse);
    }

    class LayerUI {
        public WMTSTheme theme = null;
        public int imageFormatSelected = 0;
        public int infoFormatSelected = 0;
        public int srsFormatSelected = 0;
        public WMTSStyle styleSelected = null;

        public LayerUI(WMTSTheme theme) {
            this.theme = theme;
        }

        public String toString() {
            return this.theme.toString();
        }
    }
}

